/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.resourceid.ResourceUrn;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.model.GuiEditable;
import be.iminds.ilabt.jfed.rspec.model.LinkSetting;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.model.RspecLink;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.parser.ExtraXml;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXLinkSetting;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecInterface;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.util.common.CollectionsUtil;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FXRspecLink
implements ListChangeListener<FXRspecInterface>,
RspecLink {
    private static final Logger LOG = LoggerFactory.getLogger(FXRspecLink.class);
    @GuiEditable(nullable=false, clazz=String.class, guiName="ID", guiHelp="Unique name for this link")
    protected final List<ExtraXml> extraXml = new ArrayList<ExtraXml>();
    private final StringProperty clientId = new SimpleStringProperty();
    private final StringProperty sharedLanName = new SimpleStringProperty();
    private final BooleanProperty vlanTaggingTagPresent = new SimpleBooleanProperty(false);
    private final BooleanProperty vlanTaggingEnabled = new SimpleBooleanProperty(false);
    private final ObjectProperty<Integer> vlanTag = new SimpleObjectProperty();
    private final BooleanProperty noMacLearningTagPresent = new SimpleBooleanProperty(false);
    private final BooleanProperty noMacLearningEnabled = new SimpleBooleanProperty(false);
    private final StringProperty noMacLearningValueString = new SimpleStringProperty(null);
    private final ObjectProperty<Boolean> linkMultiplexing = new SimpleObjectProperty(null);
    private final ObjectProperty<Boolean> bestEffort = new SimpleObjectProperty(null);
    private final ObjectProperty<Boolean> interswitchDisallow = new SimpleObjectProperty(null);
    private final ObservableList<String> autoSharedLanNames = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    private final ObjectProperty<GeniUrn> sliverId = new SimpleObjectProperty();
    @Nonnull
    private final FXModelRspec modelRspec;
    @GuiEditable(nullable=false, clazz=ListProperty.class, listClass=String.class, guiName="Component Manager URN(s)", guiHelp="URN(s) of the component manager(s) for this link")
    private final ObservableList<GeniUrn> componentManagerUrns = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    @GuiEditable(nullable=false, clazz=ListProperty.class, listClass=String.class, guiName="Link Type(s)", guiHelp="Link type name(s)")
    private final ObservableList<String> linkTypes = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    private final ObservableList<FXRspecInterface> interfaces = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    private final IntegerProperty activeLinkSettingsCount = new SimpleIntegerProperty();
    private final ReadOnlyBooleanWrapper impaired = new ReadOnlyBooleanWrapper();
    private final ChangeListener<Boolean> linkSettingsListener = (observableValue, oldValue, newValue) -> {
        if (Objects.equals(newValue, oldValue)) {
            return;
        }
        if (newValue.booleanValue()) {
            this.activeLinkSettingsCount.set(this.activeLinkSettingsCount.get() + 1);
        } else {
            this.activeLinkSettingsCount.set(this.activeLinkSettingsCount.get() + 1);
        }
    };
    @GuiEditable(nullable=false, clazz=ListProperty.class, listClass=FXLinkSetting.class, guiName="Link Setting", guiHelp="Bandwidth, latency and loss settings for each one-directional link")
    private final ObservableList<FXLinkSetting> linkSettings = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());

    FXRspecLink(@Nonnull FXModelRspec modelRspec, @Nullable String clientId, @Nullable String addDefaultLinkType) {
        this.linkSettings.addListener(change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    for (FXLinkSetting ls : change.getAddedSubList()) {
                        if (ls.isActive()) {
                            this.activeLinkSettingsCount.set(this.activeLinkSettingsCount.get() + 1);
                        }
                        ls.activeProperty().addListener(this.linkSettingsListener);
                    }
                    continue;
                }
                if (!change.wasRemoved()) continue;
                for (FXLinkSetting ls : change.getRemoved()) {
                    ls.activeProperty().removeListener(this.linkSettingsListener);
                    if (!ls.isActive()) continue;
                    this.activeLinkSettingsCount.set(this.activeLinkSettingsCount.get() - 1);
                }
            }
        });
        this.impaired.bind((ObservableValue)Bindings.greaterThan((ObservableNumberValue)this.activeLinkSettingsCount, (int)0));
        this.modelRspec = modelRspec;
        this.clientId.setValue(clientId);
        this.interfaces.addListener((ListChangeListener)this);
        if (addDefaultLinkType != null) {
            this.linkTypes.add((Object)addDefaultLinkType);
        }
    }

    public FXRspecLink(@Nonnull FXModelRspec newModelRspec, @Nonnull RspecLink other, @Nonnull RspecNode.InterfaceCopyMethod interfaceCopyMethod) {
        this(newModelRspec, other.getClientId(), null);
        this.extraXml.addAll(other.getExtraXml());
        this.setSliverId(other.getSliverId());
        this.componentManagerUrns.addAll((Collection)other.getComponentManagerUrns());
        this.linkTypes.addAll((Collection)other.getLinkTypes());
        this.vlanTaggingEnabled.setValue(Boolean.valueOf(other.isVlanTaggingEnabled()));
        this.vlanTaggingTagPresent.setValue(Boolean.valueOf(other.hasVlanTaggingTag()));
        this.vlanTag.setValue((Object)other.getVlanTag());
        this.noMacLearningEnabled.setValue(Boolean.valueOf(other.isNoMacLearning()));
        this.noMacLearningTagPresent.setValue(Boolean.valueOf(other.hasNoMacLearningTag()));
        this.noMacLearningValueString.setValue(other.getNoMacLeaningValueString());
        this.bestEffort.setValue(other.hasBestEffortTag() ? Boolean.valueOf(other.isBestEffortEnabled()) : null);
        this.linkMultiplexing.setValue(other.hasLinkMultiplexingTag() ? Boolean.valueOf(other.isLinkMultiplexingEnabled()) : null);
        this.interswitchDisallow.setValue(other.hasInterswitchDisallowTag() ? Boolean.valueOf(other.isInterswitchDisallowed()) : null);
        this.sharedLanName.setValue(other.getSharedLan());
        this.autoSharedLanNames.setAll((Collection)other.getAutoShareLanNames());
        if (Objects.equals(interfaceCopyMethod, RspecNode.InterfaceCopyMethod.CREATE_NEW_INTERFACE)) {
            this.copyInterfaces(other);
        }
        if (Objects.equals(interfaceCopyMethod, RspecNode.InterfaceCopyMethod.STEAL_INTERFACE)) {
            this.stealInterfaces(other);
        }
        if (interfaceCopyMethod.equals((Object)RspecNode.InterfaceCopyMethod.CREATE_NEW_INTERFACE) || interfaceCopyMethod.equals((Object)RspecNode.InterfaceCopyMethod.STEAL_INTERFACE)) {
            this.initializeMissingLinkSettings();
            for (LinkSetting otherLinkSetting : other.getLinkSettings()) {
                FXLinkSetting linkSetting = this.getLinkSettingByClientIds(otherLinkSetting.getFromIface().getClientId(), otherLinkSetting.getToIface().getClientId());
                assert (linkSetting != null) : "no linksetting for from=" + otherLinkSetting.getFromIface().getClientId() + " to=" + otherLinkSetting.getToIface().getClientId();
                if (linkSetting == null) continue;
                linkSetting.setSameAs(otherLinkSetting);
            }
            assert (other.getLinkSettings().size() == this.linkSettings.size());
        }
    }

    public void copyInterfaces(@Nonnull RspecLink rspecLink) {
        for (RspecInterface rspecInterface : rspecLink.getInterfaces()) {
            FXRspecInterface res = rspecLink.getRspec() == this.getRspec() ? new FXRspecInterface((FXRspecNode)rspecInterface.getNode(), this, FXRspecNode.generateNewInterfaceId(rspecInterface)) : new FXRspecInterface(this, rspecInterface.getClientId());
            res.overwritePropertiesWith(rspecInterface, true);
        }
    }

    public void stealInterfaces(@Nonnull RspecLink rspecLink) {
        ArrayList origIfaces = new ArrayList(rspecLink.getInterfaces());
        for (RspecInterface rspecInterface : origIfaces) {
            rspecInterface.moveToLink((RspecLink)this);
        }
    }

    public void overwritePropertiesWith(@Nonnull RspecLink other, boolean overwriteWithNull) {
        assert (Objects.equals(this.getClientId(), other.getClientId())) : "Expected other link to have clientId " + this.getClientId() + ", but got " + other.getClientId();
        if (overwriteWithNull) {
            this.sliverId.set((Object)other.getSliverId());
            this.componentManagerUrns.setAll((Collection)other.getComponentManagerUrns());
            this.linkTypes.setAll((Collection)other.getLinkTypes());
            for (LinkSetting ls : other.getLinkSettings()) {
                FXLinkSetting thisls = this.getLinkSettingByClientIds(ls.getFromIface().getClientId(), ls.getToIface().getClientId());
                if (thisls == null) continue;
                thisls.setSameAs(ls);
            }
            this.extraXml.clear();
            this.extraXml.addAll(other.getExtraXml());
        } else {
            if (other.getSliverId() != null) {
                this.sliverId.set((Object)other.getSliverId());
            }
            for (LinkSetting ls : other.getLinkSettings()) {
                if (!ls.isActive()) continue;
                FXLinkSetting ols = this.getLinkSettingByClientIds(ls.getFromIface().getClientId(), ls.getToIface().getClientId());
                if (ols != null) {
                    ols.setSameAs(ls);
                    continue;
                }
                FXRspecInterface fromIface = this.getInterfaceByClientId(ls.getFromIface().getUniqueId());
                FXRspecInterface toIface = this.getInterfaceByUniqueId(ls.getToIface().getUniqueId());
                if (fromIface == null || toIface == null) continue;
                FXLinkSetting newLs = this.getLinkSetting(fromIface, toIface);
                assert (newLs != null) : "link settings not found for " + ls.getFromIface().getClientId() + " " + ls.getToIface().getClientId();
                if (newLs == null) continue;
                newLs.setSameAs(ls);
            }
            FXRspecLink.addMissing(this.componentManagerUrns, other.getComponentManagerUrns());
            FXRspecLink.addMissing(this.linkTypes, other.getLinkTypes());
            FXRspecLink.addMissing(this.extraXml, other.getExtraXml());
        }
    }

    private static <T> void addMissing(@Nonnull List<T> target, @Nonnull List<T> other) {
        for (T o : other) {
            if (target.contains(o)) continue;
            target.add(o);
        }
    }

    public void onChanged(ListChangeListener.Change<? extends FXRspecInterface> change) {
        while (change.next()) {
            if (change.wasRemoved()) {
                this.linkSettings.removeIf(ls -> change.getRemoved().contains(ls.getFromIface()) || change.getRemoved().contains(ls.getToIface()));
            }
            if (!change.wasAdded()) continue;
            for (FXRspecInterface iface : this.interfaces) {
                if (change.getAddedSubList().contains(iface)) continue;
                for (FXRspecInterface newIface : change.getAddedSubList()) {
                    this.linkSettings.addAll((Object[])new FXLinkSetting[]{new FXLinkSetting(iface, newIface), new FXLinkSetting(newIface, iface)});
                }
            }
            for (FXRspecInterface iface : change.getAddedSubList()) {
                for (FXRspecInterface iface2 : change.getAddedSubList()) {
                    if (iface == iface2) continue;
                    this.linkSettings.addAll((Object[])new FXLinkSetting[]{new FXLinkSetting(iface, iface2)});
                }
            }
        }
        Collections.sort(this.linkSettings);
    }

    @Nonnull
    public FXModelRspec getRspec() {
        return this.modelRspec;
    }

    @Nonnull
    public String getUniqueId() {
        return BasicStringRspec.makeUniqueLinkId((String)((String)this.clientId.get()), null, this.getComponentManagerUrnStrings());
    }

    public String getPreStitchingUniqueId() {
        HashSet<String> componentManagerIds = new HashSet<String>();
        for (RspecInterface iface : this.interfaces) {
            componentManagerIds.add(iface.getNode().getComponentManagerId().toString());
        }
        return BasicStringRspec.makeUniqueLinkId((String)((String)this.clientId.get()), null, componentManagerIds);
    }

    @Nonnull
    public List<String> getComponentManagerUrnStrings() {
        return this.componentManagerUrns.stream().filter(Objects::nonNull).map(ResourceUrn::getValue).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    public String getClientId() {
        return (String)this.clientId.get();
    }

    public void setClientId(@Nullable String value) {
        this.clientId.set((Object)value);
    }

    public StringProperty clientIdProperty() {
        return this.clientId;
    }

    @Nonnull
    public ObservableList<GeniUrn> getComponentManagerUrns() {
        return this.componentManagerUrns;
    }

    @Nonnull
    public ObservableList<String> getLinkTypes() {
        return this.linkTypes;
    }

    @Nonnull
    public ObservableList<FXLinkSetting> getLinkSettings() {
        return this.linkSettings;
    }

    @Nullable
    public FXLinkSetting getLinkSetting(@Nonnull RspecInterface fromIface, @Nonnull RspecInterface toIface) {
        assert (fromIface.getRspec() == this.getRspec());
        assert (toIface.getRspec() == this.getRspec());
        assert (fromIface instanceof FXRspecInterface && this.interfaces.contains((Object)fromIface));
        assert (toIface instanceof FXRspecInterface && this.interfaces.contains((Object)toIface));
        for (FXLinkSetting ls : this.linkSettings) {
            if (ls.getFromIface() != fromIface || ls.getToIface() != toIface) continue;
            return ls;
        }
        return null;
    }

    @Nullable
    public FXLinkSetting getLinkSettingByUniqueIds(@Nonnull String fromIfaceName, @Nonnull String toIfaceName) {
        for (FXLinkSetting ls : this.linkSettings) {
            if (!Objects.equals(ls.getFromIface().getUniqueId(), fromIfaceName) || !Objects.equals(ls.getToIface().getUniqueId(), toIfaceName)) continue;
            return ls;
        }
        return null;
    }

    @Nullable
    public FXLinkSetting getLinkSettingByClientIds(@Nonnull String fromIfaceName, @Nonnull String toIfaceName) {
        for (FXLinkSetting ls : this.linkSettings) {
            if (!Objects.equals(ls.getFromIface().getClientId(), fromIfaceName) || !Objects.equals(ls.getToIface().getClientId(), toIfaceName)) continue;
            return ls;
        }
        return null;
    }

    private void initializeMissingLinkSettings() {
        for (FXRspecInterface fromIface : this.interfaces) {
            for (FXRspecInterface toIface : this.interfaces) {
                if (fromIface == toIface || this.getLinkSetting(fromIface, toIface) != null) continue;
                this.linkSettings.add((Object)new FXLinkSetting(fromIface, toIface));
            }
        }
    }

    public boolean isImpaired() {
        return this.impaired.get();
    }

    public ReadOnlyBooleanProperty impairedProperty() {
        return this.impaired.getReadOnlyProperty();
    }

    @Nonnull
    public ObservableList<FXRspecInterface> getInterfaces() {
        return this.interfaces;
    }

    protected boolean addInterface(@Nonnull RspecInterface iface) {
        assert (iface instanceof FXRspecInterface);
        return this.interfaces.add((Object)((FXRspecInterface)iface));
    }

    protected boolean removeInterface(@Nonnull RspecInterface iface) {
        assert (iface instanceof FXRspecInterface);
        assert (this.interfaces.contains((Object)iface));
        LOG.trace("Removing {} from {}", (Object)iface.getUniqueId(), (Object)iface.getUniqueId());
        return this.interfaces.remove((Object)iface);
    }

    @Nullable
    public FXRspecInterface getInterfaceForNode(@Nonnull RspecNode node) {
        for (FXRspecInterface iface : this.interfaces) {
            if (iface.getNode() != node) continue;
            return iface;
        }
        return null;
    }

    @Nullable
    public FXRspecInterface getInterfaceByClientId(@Nonnull String clientId) {
        for (FXRspecInterface iface : this.interfaces) {
            if (!Objects.equals(iface.getClientId(), clientId)) continue;
            return iface;
        }
        return null;
    }

    @Nullable
    public FXRspecInterface getInterfaceByUniqueId(@Nonnull String uniqueId) {
        for (FXRspecInterface iface : this.interfaces) {
            if (!Objects.equals(iface.getUniqueId(), uniqueId)) continue;
            return iface;
        }
        return null;
    }

    @Nullable
    public GeniUrn getSliverId() {
        return (GeniUrn)this.sliverId.get();
    }

    public void setSliverId(@Nullable String sliverId) {
        if (sliverId == null) {
            this.sliverId.set(null);
            return;
        }
        GeniUrn geniUrn = GeniUrn.parse((String)sliverId);
        if (geniUrn != null) {
            this.sliverId.set((Object)geniUrn);
        } else {
            LOG.warn("Could not set sliverId to {} as it is not a valid URN!", (Object)sliverId);
            this.sliverId.set(null);
        }
    }

    @Nonnull
    public ObjectProperty<GeniUrn> sliverIdProperty() {
        return this.sliverId;
    }

    public void setSliverId(@Nullable GeniUrn sliverId) {
        this.sliverId.set((Object)sliverId);
    }

    public String toString() {
        return "RspecLink{id=" + this.clientId + ", rspec=" + this.modelRspec + ", componentManagerUrns=" + this.componentManagerUrns + ", linkSettings=" + this.linkSettings + ", interfaces=" + this.interfaces + "}";
    }

    @Nonnull
    public List<ExtraXml> getExtraXml() {
        return this.extraXml;
    }

    public boolean isStitched(@Nullable TestbedInfoSource testbedInfoSource) {
        if (this.getComponentManagerUrns().size() < 2) {
            return false;
        }
        if (this.getLinkTypes().size() > 1 || this.getLinkTypes().size() == 1 && !((String)this.getLinkTypes().get(0)).equalsIgnoreCase("lan") && !((String)this.getLinkTypes().get(0)).equalsIgnoreCase("vlan")) {
            return false;
        }
        if (testbedInfoSource == null) {
            return true;
        }
        Server firstServer = null;
        for (GeniUrn urn : this.getComponentManagerUrns()) {
            if (urn == null) {
                LOG.warn("One of the component manager urns is null!");
                continue;
            }
            Server server = testbedInfoSource.getByUrn(urn, TestbedInfoSource.SubAuthMatchAllowed.ALLOW_TOPLEVEL, TestbedInfoSource.SubAuthMatchPreference.PREFER_TOPLEVEL);
            if (server == null) {
                LOG.warn("Authority not found for " + urn + " during stitch check -> falling back to assuming link is stitched");
                return true;
            }
            if (firstServer == null) {
                firstServer = server;
                continue;
            }
            if (Objects.equals(firstServer.getDefaultComponentManagerUrn(), server.getDefaultComponentManagerUrn())) continue;
            return true;
        }
        return false;
    }

    void updateComponentManagerUrns() {
        this.componentManagerUrns.clear();
        for (RspecInterface iface : this.interfaces) {
            if (iface.getNode().getComponentManagerId() == null) {
                LOG.warn("The node " + iface.getNode().getUniqueId() + " has ComponentManagerId=null");
                continue;
            }
            if (this.componentManagerUrns.contains((Object)iface.getNode().getComponentManagerId())) continue;
            this.componentManagerUrns.add((Object)iface.getNode().getComponentManagerId());
        }
    }

    @Nullable
    public String getSharedLan() {
        return (String)this.sharedLanName.get();
    }

    public void setSharedLan(@Nullable String sharedLanName) {
        this.sharedLanName.setValue(sharedLanName);
    }

    public StringProperty sharedLanProperty() {
        return this.sharedLanName;
    }

    public boolean isVlanTaggingEnabled() {
        return this.vlanTaggingTagPresent.getValue() != false ? this.vlanTaggingEnabled.getValue() : false;
    }

    public boolean hasVlanTaggingTag() {
        return this.vlanTaggingTagPresent.getValue();
    }

    public void setVlanTagging(@Nullable Boolean value) {
        if (value == null) {
            this.vlanTaggingTagPresent.setValue(Boolean.valueOf(false));
            this.vlanTaggingEnabled.setValue(Boolean.valueOf(false));
        } else {
            this.vlanTaggingTagPresent.setValue(Boolean.valueOf(true));
            this.vlanTaggingEnabled.setValue(value);
        }
    }

    @Nullable
    public Integer getVlanTag() {
        return (Integer)this.vlanTag.get();
    }

    public ObjectProperty<Integer> vlanTagProperty() {
        return this.vlanTag;
    }

    public void setVlanTag(@Nullable Integer vlanTag) {
        this.vlanTag.set((Object)vlanTag);
    }

    public boolean isNoMacLearning() {
        return this.noMacLearningTagPresent.getValue() != false ? this.noMacLearningEnabled.getValue() : false;
    }

    public boolean hasNoMacLearningTag() {
        return this.noMacLearningTagPresent.getValue();
    }

    public void setNoMacLearning(@Nullable Boolean value) {
        if (value == null) {
            this.noMacLearningTagPresent.setValue(Boolean.valueOf(false));
            this.noMacLearningEnabled.setValue(Boolean.valueOf(false));
            this.noMacLearningValueString.set(null);
        } else {
            this.noMacLearningTagPresent.setValue(Boolean.valueOf(true));
            this.noMacLearningEnabled.setValue(value);
            this.noMacLearningValueString.set((Object)("" + value));
        }
    }

    @Nullable
    public String getNoMacLeaningValueString() {
        if (!this.noMacLearningTagPresent.getValue().booleanValue()) {
            return null;
        }
        return this.noMacLearningValueString.getValue();
    }

    public void setNoMacLearning(@Nullable String value) {
        Boolean enabled = TextUtil.stringToBoolean((String)value);
        if (enabled == null) {
            this.noMacLearningTagPresent.setValue(Boolean.valueOf(false));
            this.noMacLearningEnabled.setValue(Boolean.valueOf(false));
            this.noMacLearningValueString.set(null);
        } else {
            this.noMacLearningTagPresent.setValue(Boolean.valueOf(true));
            this.noMacLearningEnabled.setValue(enabled);
            this.noMacLearningValueString.set((Object)value);
        }
    }

    public boolean isBestEffortEnabled() {
        return this.bestEffort.get() != null ? (Boolean)this.bestEffort.get() : false;
    }

    public boolean hasBestEffortTag() {
        return this.bestEffort.get() != null;
    }

    public void setBestEffort(@Nullable Boolean value) {
        this.bestEffort.set((Object)value);
    }

    public boolean isLinkMultiplexingEnabled() {
        return this.linkMultiplexing.get() != null ? (Boolean)this.linkMultiplexing.get() : false;
    }

    public boolean hasLinkMultiplexingTag() {
        return this.linkMultiplexing.get() != null;
    }

    public void setLinkMultiplexing(@Nullable Boolean value) {
        this.linkMultiplexing.set((Object)value);
    }

    public boolean hasAutoShareLan() {
        return !this.autoSharedLanNames.isEmpty();
    }

    @Nonnull
    public ObservableList<String> getAutoShareLanNames() {
        return this.autoSharedLanNames;
    }

    public boolean isInterswitchDisallowed() {
        return Objects.equals(this.interswitchDisallow.get(), Boolean.TRUE);
    }

    public boolean hasInterswitchDisallowTag() {
        return this.interswitchDisallow.get() != null;
    }

    public void setInterswitchDisallow(@Nullable Boolean value) {
        this.interswitchDisallow.setValue((Object)value);
    }
}

