/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl;

import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.model.AnsibleService;
import be.iminds.ilabt.jfed.rspec.model.DiskImage;
import be.iminds.ilabt.jfed.rspec.model.ExecuteService;
import be.iminds.ilabt.jfed.rspec.model.HardwareType;
import be.iminds.ilabt.jfed.rspec.model.InstallService;
import be.iminds.ilabt.jfed.rspec.model.LoginService;
import be.iminds.ilabt.jfed.rspec.model.NodeLocation;
import be.iminds.ilabt.jfed.rspec.model.ProxyService;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.SliverType;
import be.iminds.ilabt.jfed.rspec.model.SliverTypeBuilder;
import be.iminds.ilabt.jfed.rspec.model.WebVncService;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicRspecNode;
import be.iminds.ilabt.jfed.rspec.parser.ExtraXml;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXExecuteService;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXInstallService;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecInterface;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecLink;
import be.iminds.ilabt.jfed.util.common.CollectionsUtil;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FXRspecNode
implements RspecNode {
    private static final Logger LOG = LoggerFactory.getLogger(FXRspecNode.class);
    protected final FXModelRspec modelRspec;
    protected final StringProperty clientId = new SimpleStringProperty();
    protected final ReadOnlyStringWrapper uniqueClientId = new ReadOnlyStringWrapper();
    protected final DoubleProperty editorX = new SimpleDoubleProperty(-1.0);
    protected final DoubleProperty editorY = new SimpleDoubleProperty(-1.0);
    protected final DoubleProperty flackEditorX = new SimpleDoubleProperty(-1.0);
    protected final DoubleProperty flackEditorY = new SimpleDoubleProperty(-1.0);
    protected final ObservableList<HardwareType> hardwareTypes = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    protected final ObjectProperty<Boolean> exclusive = new SimpleObjectProperty(null);
    protected final BooleanProperty hasRoutableControlIp = new SimpleBooleanProperty(false);
    protected final ObjectProperty<Boolean> available = new SimpleObjectProperty(null);
    protected final ObservableList<SliverType> sliverTypes = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    protected final ObjectProperty<GeniUrn> componentManagerId = new SimpleObjectProperty();
    protected final ObjectProperty<GeniUrn> componentId = new SimpleObjectProperty();
    protected final StringProperty componentName = new SimpleStringProperty();
    protected final ObjectProperty<GeniUrn> sliverId = new SimpleObjectProperty();
    protected final StringProperty hostName = new SimpleStringProperty();
    protected final ObservableList<FXExecuteService> executeServices = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    protected final ObservableList<FXInstallService> installServices = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    protected final ObservableList<LoginService> loginServices = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    protected final ObservableList<ProxyService> proxyServices = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    protected final ObservableList<WebVncService> webVncServices = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    protected final ObservableList<AnsibleService> ansibleServices = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    protected final ObservableList<String> ansibleGroups = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    private final ObjectProperty<NodeLocation> location = new SimpleObjectProperty();
    protected final ObservableList<FXRspecInterface> interfaces = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    protected final StringProperty resourceClassId = new SimpleStringProperty();
    protected final ObservableList<String> leaseIdRefs = FXCollections.observableList((List)CollectionsUtil.nullForbiddingArrayList());
    protected final List<ExtraXml> extraXml = new ArrayList<ExtraXml>();
    protected final List<ExtraXml> extraServicesXmls = new ArrayList<ExtraXml>();
    private final Set<RspecNode.EmptyTag> emptyTags = new HashSet<RspecNode.EmptyTag>();

    private FXRspecNode() {
        this.componentManagerIdProperty().addListener(observable -> {
            for (FXRspecInterface iface : this.interfaces) {
                if (!iface.isLinkBound()) continue;
                iface.getLink().updateComponentManagerUrns();
            }
        });
        InvalidationListener l = observable -> this.uniqueClientId.setValue(this.getUniqueId());
        this.clientId.addListener(l);
        this.componentId.addListener(l);
        this.componentManagerId.addListener(l);
        this.modelRspec = null;
    }

    FXRspecNode(FXModelRspec modelRspec, String clientId) {
        this.componentManagerIdProperty().addListener(observable -> {
            for (FXRspecInterface iface : this.interfaces) {
                if (!iface.isLinkBound()) continue;
                iface.getLink().updateComponentManagerUrns();
            }
        });
        InvalidationListener l = observable -> this.uniqueClientId.setValue(this.getUniqueId());
        this.clientId.addListener(l);
        this.componentId.addListener(l);
        this.componentManagerId.addListener(l);
        this.clientId.setValue(clientId);
        this.modelRspec = modelRspec;
    }

    FXRspecNode(FXModelRspec newModelRspec, RspecNode rspecNode, RspecNode.InterfaceCopyMethod interfaceCopyMethod) {
        this.componentManagerIdProperty().addListener(observable -> {
            for (FXRspecInterface iface : this.interfaces) {
                if (!iface.isLinkBound()) continue;
                iface.getLink().updateComponentManagerUrns();
            }
        });
        InvalidationListener l = observable -> this.uniqueClientId.setValue(this.getUniqueId());
        this.clientId.addListener(l);
        this.componentId.addListener(l);
        this.componentManagerId.addListener(l);
        this.modelRspec = newModelRspec;
        this.clientId.set((Object)rspecNode.getClientId());
        this.editorX.set(rspecNode.getEditorX());
        this.editorY.set(rspecNode.getEditorY());
        this.flackEditorX.set(rspecNode.getFlackEditorX());
        this.flackEditorY.set(rspecNode.getFlackEditorY());
        this.componentId.set((Object)rspecNode.getComponentId());
        this.componentManagerId.set((Object)rspecNode.getComponentManagerId());
        this.componentName.set((Object)rspecNode.getComponentName());
        this.sliverId.set((Object)rspecNode.getSliverId());
        this.exclusive.set((Object)rspecNode.getExclusive());
        this.available.set((Object)rspecNode.getAvailable());
        this.hardwareTypes.addAll((Collection)rspecNode.getHardwareTypes());
        this.hostName.set((Object)rspecNode.getHostName());
        this.leaseIdRefs.setAll((Collection)rspecNode.getLeaseIdRefs());
        this.location.set((Object)rspecNode.getLocation());
        this.loginServices.addAll((Collection)rspecNode.getLoginServices());
        this.proxyServices.addAll((Collection)rspecNode.getProxyServices());
        this.webVncServices.addAll((Collection)rspecNode.getWebVncServices());
        this.ansibleServices.addAll((Collection)rspecNode.getAnsibleServices());
        this.ansibleGroups.addAll((Collection)rspecNode.getAnsibleGroups());
        this.sliverTypes.setAll((Collection)rspecNode.getSliverTypes());
        this.hasRoutableControlIp.set(rspecNode.getRoutableControlIp());
        this.emptyTags.addAll(rspecNode.getEmptyTags());
        this.extraServicesXmls.addAll(rspecNode.getExtraServicesXml());
        this.extraXml.addAll(rspecNode.getExtraXml());
        if (rspecNode instanceof FXRspecNode) {
            FXRspecNode fxRspecNode = (FXRspecNode)rspecNode;
            this.executeServices.addAll(fxRspecNode.getExecuteServices());
            this.installServices.addAll(fxRspecNode.getInstallServices());
            this.resourceClassId.set((Object)fxRspecNode.getResourceClassId());
        } else {
            for (ExecuteService e : rspecNode.getExecuteServices()) {
                this.executeServices.add((Object)new FXExecuteService(e));
            }
            for (InstallService i : rspecNode.getInstallServices()) {
                this.installServices.add((Object)new FXInstallService(i));
            }
        }
        if (Objects.equals(interfaceCopyMethod, RspecNode.InterfaceCopyMethod.CREATE_NEW_INTERFACE)) {
            this.copyInterfaces(rspecNode);
        }
        if (Objects.equals(interfaceCopyMethod, RspecNode.InterfaceCopyMethod.STEAL_INTERFACE)) {
            this.stealInterfaces(rspecNode);
        }
    }

    public void overwritePropertiesWith(RspecNode otherNode, boolean overwriteWithNull) {
        assert (Objects.equals(this.getUniqueId(), otherNode.getUniqueId()));
        if (overwriteWithNull) {
            this.componentId.set((Object)otherNode.getComponentId());
            this.componentManagerId.set((Object)otherNode.getComponentManagerId());
            this.editorX.set(otherNode.getEditorX());
            this.editorY.set(otherNode.getEditorY());
            this.flackEditorX.set(otherNode.getFlackEditorX());
            this.flackEditorY.set(otherNode.getFlackEditorY());
            this.componentName.set((Object)otherNode.getComponentName());
            this.sliverId.set((Object)otherNode.getSliverId());
            this.exclusive.set((Object)otherNode.getExclusive());
            this.available.set((Object)otherNode.getAvailable());
            this.hostName.set((Object)otherNode.getHostName());
            this.location.set((Object)otherNode.getLocation());
            this.leaseIdRefs.setAll((Collection)otherNode.getLeaseIdRefs());
            this.setExecuteServices(otherNode.getExecuteServices());
            this.hardwareTypes.setAll((Collection)otherNode.getHardwareTypes());
            this.setInstallServices(otherNode.getInstallServices());
            this.loginServices.setAll((Collection)otherNode.getLoginServices());
            this.proxyServices.setAll((Collection)otherNode.getProxyServices());
            this.webVncServices.setAll((Collection)otherNode.getWebVncServices());
            this.ansibleServices.setAll((Collection)otherNode.getAnsibleServices());
            this.ansibleGroups.setAll((Collection)otherNode.getAnsibleGroups());
            this.sliverTypes.setAll((Collection)otherNode.getSliverTypes());
            this.extraXml.clear();
            this.extraXml.addAll(otherNode.getExtraXml());
            this.extraServicesXmls.clear();
            this.extraServicesXmls.addAll(otherNode.getExtraServicesXml());
        } else {
            if (otherNode.getComponentId() != null) {
                this.componentId.set((Object)otherNode.getComponentId());
            }
            if (otherNode.getComponentManagerId() != null) {
                this.componentManagerId.set((Object)otherNode.getComponentManagerId());
            }
            if (otherNode.getEditorX() >= 0.0) {
                this.editorX.set(otherNode.getEditorX());
            }
            if (otherNode.getEditorY() >= 0.0) {
                this.editorY.set(otherNode.getEditorY());
            }
            if (otherNode.getFlackEditorX() >= 0.0) {
                this.flackEditorX.set(otherNode.getFlackEditorX());
            }
            if (otherNode.getFlackEditorY() >= 0.0) {
                this.flackEditorY.set(otherNode.getFlackEditorY());
            }
            if (otherNode.getComponentName() != null) {
                this.componentName.set((Object)otherNode.getComponentName());
            }
            if (otherNode.getSliverId() != null) {
                this.sliverId.set((Object)otherNode.getSliverId());
            }
            if (otherNode.getExclusive() != null) {
                this.exclusive.set((Object)otherNode.getExclusive());
            }
            if (otherNode.getAvailable() != null) {
                this.available.set((Object)otherNode.getAvailable());
            }
            if (otherNode.getHostName() != null) {
                this.hostName.set((Object)otherNode.getHostName());
            }
            if (otherNode.getLocation() != null) {
                this.location.set((Object)otherNode.getLocation());
            }
            FXRspecNode.addMissingExecuteServices(this.executeServices, otherNode.getExecuteServices());
            FXRspecNode.addMissing(this.hardwareTypes, otherNode.getHardwareTypes());
            FXRspecNode.addMissingInstallServices(this.installServices, otherNode.getInstallServices());
            FXRspecNode.addMissing(this.loginServices, otherNode.getLoginServices());
            FXRspecNode.addMissing(this.proxyServices, otherNode.getProxyServices());
            FXRspecNode.addMissing(this.webVncServices, otherNode.getWebVncServices());
            FXRspecNode.addMissing(this.ansibleServices, otherNode.getAnsibleServices());
            FXRspecNode.addMissing(this.sliverTypes, otherNode.getSliverTypes());
            FXRspecNode.addMissing(this.extraXml, otherNode.getExtraXml());
            FXRspecNode.addMissing(this.extraServicesXmls, otherNode.getExtraServicesXml());
        }
    }

    private static <T> void addMissing(List<T> target, List<? extends T> other) {
        for (T o : other) {
            if (target.contains(o)) continue;
            target.add(o);
        }
    }

    private static void addMissingExecuteServices(List<FXExecuteService> target, List<? extends ExecuteService> other) {
        for (ExecuteService executeService : other) {
            if (target.contains(executeService)) continue;
            if (executeService instanceof FXExecuteService) {
                target.add((FXExecuteService)executeService);
                continue;
            }
            target.add(new FXExecuteService(executeService));
        }
    }

    private static void addMissingInstallServices(List<FXInstallService> target, List<? extends InstallService> other) {
        for (InstallService installService : other) {
            if (target.contains(installService)) continue;
            if (installService instanceof FXInstallService) {
                target.add((FXInstallService)installService);
                continue;
            }
            target.add(new FXInstallService(installService));
        }
    }

    static String generateNewInterfaceId(RspecInterface rspecInterface) {
        return BasicRspecNode.generateNewInterfaceId((RspecInterface)rspecInterface);
    }

    public void copyInterfaces(RspecNode rspecNode) {
        for (RspecInterface rspecInterface : rspecNode.getInterfaces()) {
            FXRspecInterface res = rspecNode.getRspec() == this.getRspec() ? (rspecInterface.isLinkBound() ? new FXRspecInterface(this, (FXRspecLink)rspecInterface.getLink(), FXRspecNode.generateNewInterfaceId(rspecInterface)) : new FXRspecInterface(this, FXRspecNode.generateNewInterfaceId(rspecInterface))) : new FXRspecInterface(this, rspecInterface.getClientId());
            String clientId = res.getClientId();
            res.overwritePropertiesWith(rspecInterface, true);
            res.setClientId(clientId);
        }
    }

    public void stealInterfaces(RspecNode rspecNode) {
        ArrayList origIfaces = new ArrayList(rspecNode.getInterfaces());
        for (RspecInterface rspecInterface : origIfaces) {
            rspecInterface.moveToNode((RspecNode)this);
        }
    }

    public FXModelRspec getRspec() {
        return this.modelRspec;
    }

    @Nonnull
    public String getUniqueId() {
        return BasicStringRspec.makeUniqueNodeId((String)((String)this.clientId.get()), (String)(this.componentId.get() == null ? null : ((GeniUrn)this.componentId.get()).getValue()), this.componentManagerId.get() == null ? null : ((GeniUrn)this.componentManagerId.get()).getValue());
    }

    public ReadOnlyStringProperty uniqueIdProperty() {
        return this.uniqueClientId.getReadOnlyProperty();
    }

    @Nullable
    public String getClientId() {
        return (String)this.clientId.get();
    }

    public void setClientId(String value) {
        this.clientId.set((Object)value);
    }

    public StringProperty clientIdProperty() {
        return this.clientId;
    }

    public double getEditorX() {
        return this.editorX.get();
    }

    public void setEditorX(double value) {
        this.editorX.set(value);
    }

    public DoubleProperty editorXProperty() {
        return this.editorX;
    }

    public double getEditorY() {
        return this.editorY.get();
    }

    public void setEditorY(double value) {
        this.editorY.set(value);
    }

    public DoubleProperty editorYProperty() {
        return this.editorY;
    }

    public double getFlackEditorX() {
        return this.flackEditorX.get();
    }

    public void setFlackEditorX(double flackEditorX) {
        this.flackEditorX.set(flackEditorX);
    }

    public DoubleProperty flackEditorXProperty() {
        return this.flackEditorX;
    }

    public double getFlackEditorY() {
        return this.flackEditorY.get();
    }

    public void setFlackEditorY(double flackEditorY) {
        this.flackEditorY.set(flackEditorY);
    }

    public DoubleProperty flackEditorYProperty() {
        return this.flackEditorY;
    }

    public ObservableList<HardwareType> getHardwareTypes() {
        return this.hardwareTypes;
    }

    @Nullable
    public Boolean getExclusive() {
        return (Boolean)this.exclusive.get();
    }

    public void setExclusive(Boolean value) {
        this.exclusive.set((Object)value);
    }

    public ObjectProperty<Boolean> exclusiveProperty() {
        return this.exclusive;
    }

    @Nullable
    public Boolean getAvailable() {
        return (Boolean)this.available.get();
    }

    public ObjectProperty<Boolean> availableProperty() {
        return this.available;
    }

    public void setAvailable(Boolean available) {
        this.available.set((Object)available);
    }

    public void setSliverTypeName(String name) {
        assert (this.sliverTypes.size() <= 1);
        SliverTypeBuilder builder = this.sliverTypes.size() == 1 ? new SliverTypeBuilder((SliverType)this.sliverTypes.get(0)).name(name) : new SliverTypeBuilder(name);
        this.sliverTypes.setAll((Object[])new SliverType[]{builder.build()});
    }

    public void setSliverTypeDiskImage(@Nullable String diskImageName) {
        if (this.sliverTypes.size() > 1) {
            throw new RuntimeException("The caller did expected this RSpec to have exactly one sliver types. (probably because expected this to be a request rspec). But this has " + this.sliverTypes.size() + " sliver types.");
        }
        assert (this.sliverTypes.size() == 1);
        SliverTypeBuilder builder = new SliverTypeBuilder((SliverType)this.sliverTypes.get(0));
        ArrayList<DiskImage> diskImageList = new ArrayList<DiskImage>();
        if (diskImageName != null) {
            diskImageList.add(new DiskImage(diskImageName));
        }
        builder.setDiskImages(diskImageList);
        this.sliverTypes.setAll((Object[])new SliverType[]{builder.build()});
    }

    public void setSliverTypeFlavor(@Nullable String flavor) {
        if (this.sliverTypes.size() > 1) {
            throw new RuntimeException("The caller did expected this RSpec to have exactly one sliver types. (probably because expected this to be a request rspec). But this has " + this.sliverTypes.size() + " sliver types.");
        }
        assert (this.sliverTypes.size() == 1);
        SliverTypeBuilder builder = new SliverTypeBuilder((SliverType)this.sliverTypes.get(0));
        ArrayList<String> flavors = new ArrayList<String>();
        if (flavor != null) {
            flavors.add(flavor);
        }
        builder.setFlavors(flavors);
        this.sliverTypes.setAll((Object[])new SliverType[]{builder.build()});
    }

    @Nullable
    public String getSliverTypeName() {
        if (this.sliverTypes.size() > 1) {
            throw new RuntimeException("The caller did not expect this RSpec to have multiple sliver types. (it probably expected this to be a request rspec, which does indeed not have multiple sliver_type's)");
        }
        if (this.sliverTypes.isEmpty()) {
            return null;
        }
        return ((SliverType)this.sliverTypes.get(0)).getName();
    }

    public SliverType getSliverType() {
        if (this.sliverTypes.isEmpty()) {
            return null;
        }
        if (this.sliverTypes.size() > 1) {
            throw new RuntimeException("The caller did not expect this RSpec to have multiple sliver types. (it probably expected this to be a request rspec, which does indeed not have multiple sliver_type's)");
        }
        return (SliverType)this.sliverTypes.get(0);
    }

    public void setSliverType(@Nullable SliverType singleType) {
        if (singleType == null) {
            this.sliverTypes.clear();
        } else {
            this.sliverTypes.setAll((Object[])new SliverType[]{singleType});
        }
    }

    @Nullable
    public String getOsImageUrn() {
        if (this.sliverTypes.size() > 1) {
            throw new RuntimeException("The getOsImageUrn convenience method does not support multiple sliver_types");
        }
        if (this.sliverTypes.isEmpty()) {
            return null;
        }
        SliverType sliverType = (SliverType)this.sliverTypes.get(0);
        if (sliverType.getDiskImages().size() > 1) {
            throw new RuntimeException("The getOsImageUrn convenience method does not support multiple disk_images in the sliver_type");
        }
        if (sliverType.getDiskImages().isEmpty()) {
            return null;
        }
        return ((DiskImage)sliverType.getDiskImages().get(0)).getName();
    }

    public ObservableList<SliverType> getSliverTypes() {
        return this.sliverTypes;
    }

    @Nullable
    public NodeLocation getLocation() {
        return (NodeLocation)this.location.get();
    }

    public void setLocation(NodeLocation value) {
        this.location.set((Object)value);
    }

    public ObjectProperty<NodeLocation> locationProperty() {
        return this.location;
    }

    @Nullable
    public GeniUrn getComponentManagerId() {
        return (GeniUrn)this.componentManagerId.get();
    }

    public void setComponentManagerId(GeniUrn value) {
        this.componentManagerId.set((Object)value);
    }

    public void setComponentManagerId(String value) {
        if (value == null) {
            this.componentManagerId.set(null);
            return;
        }
        GeniUrn geniUrn = GeniUrn.parse((String)value);
        if (geniUrn != null) {
            this.componentManagerId.set((Object)geniUrn);
        } else {
            LOG.warn("Could not set componentManagerId to {} as it is not a valid URN!", (Object)value);
            this.componentManagerId.set(null);
        }
    }

    public ObjectProperty<GeniUrn> componentManagerIdProperty() {
        return this.componentManagerId;
    }

    @Nullable
    public GeniUrn getComponentId() {
        return (GeniUrn)this.componentId.get();
    }

    public void setComponentId(GeniUrn value) {
        this.componentId.set((Object)value);
    }

    public void setComponentId(String value) {
        if (value == null) {
            this.componentId.set(null);
            return;
        }
        GeniUrn geniUrn = GeniUrn.parse((String)value);
        if (geniUrn != null) {
            this.componentId.set((Object)geniUrn);
        } else {
            LOG.warn("Could not set componentId to {} as it is not a valid URN!", (Object)value);
            this.componentId.set(null);
        }
    }

    public ObjectProperty<GeniUrn> componentIdProperty() {
        return this.componentId;
    }

    @Nullable
    public String getComponentName() {
        return (String)this.componentName.get();
    }

    public void setComponentName(String value) {
        this.componentName.set((Object)value);
    }

    @Nullable
    public GeniUrn getSliverId() {
        return (GeniUrn)this.sliverId.get();
    }

    public void setSliverId(String sliverId) {
        if (sliverId == null) {
            this.sliverId.set(null);
            return;
        }
        GeniUrn geniUrn = GeniUrn.parse((String)sliverId);
        if (geniUrn != null) {
            this.sliverId.set((Object)geniUrn);
        } else {
            LOG.warn("Could not set sliverId to {} as it is not a valid URN!", (Object)sliverId);
            this.sliverId.set(null);
        }
    }

    public void setSliverId(GeniUrn sliverId) {
        this.sliverId.set((Object)sliverId);
    }

    public ObjectProperty<GeniUrn> sliverIdProperty() {
        return this.sliverId;
    }

    public boolean getRoutableControlIp() {
        return this.hasRoutableControlIp.getValue();
    }

    public void setRoutableControlIp(boolean hasRoutableControlIp) {
        this.hasRoutableControlIp.setValue(Boolean.valueOf(hasRoutableControlIp));
    }

    public BooleanProperty hasRoutableControlIpProperty() {
        return this.hasRoutableControlIp;
    }

    public StringProperty componentNameProperty() {
        return this.componentName;
    }

    @Nullable
    public String getHostName() {
        return (String)this.hostName.get();
    }

    public void setHostName(String value) {
        this.hostName.set((Object)value);
    }

    public StringProperty hostNameProperty() {
        return this.hostName;
    }

    public String getResourceClassId() {
        return (String)this.resourceClassId.get();
    }

    public StringProperty resourceClassIdProperty() {
        return this.resourceClassId;
    }

    public void setResourceClassId(String resourceClassId) {
        this.resourceClassId.set((Object)resourceClassId);
    }

    @Nonnull
    public List<FXExecuteService> getExecuteServices() {
        return this.executeServices;
    }

    public void setExecuteServices(@Nonnull List<? extends ExecuteService> value) {
        this.executeServices.clear();
        for (ExecuteService executeService : value) {
            this.executeServices.add((Object)new FXExecuteService(executeService));
        }
    }

    @Nonnull
    public List<FXInstallService> getInstallServices() {
        return this.installServices;
    }

    public void setInstallServices(@Nonnull List<? extends InstallService> value) {
        this.installServices.clear();
        for (InstallService installService : value) {
            this.installServices.add((Object)new FXInstallService(installService));
        }
    }

    public void addExecuteService(ExecuteService executeService) {
        if (executeService instanceof FXExecuteService) {
            this.executeServices.add((Object)((FXExecuteService)executeService));
        } else {
            this.executeServices.add((Object)new FXExecuteService(executeService));
        }
    }

    public void addInstallService(InstallService installService) {
        if (installService instanceof FXInstallService) {
            this.installServices.add((Object)((FXInstallService)installService));
        } else {
            this.installServices.add((Object)new FXInstallService(installService));
        }
    }

    @Nonnull
    public ObservableList<LoginService> getLoginServices() {
        return this.loginServices;
    }

    public void setLoginServices(List<LoginService> value) {
        this.loginServices.setAll(value);
    }

    @Nonnull
    public ObservableList<ProxyService> getProxyServices() {
        return this.proxyServices;
    }

    public void setProxyServices(List<ProxyService> value) {
        this.proxyServices.setAll(value);
    }

    @Nonnull
    public ObservableList<WebVncService> getWebVncServices() {
        return this.webVncServices;
    }

    public void setWebVncServices(List<WebVncService> value) {
        this.webVncServices.setAll(value);
    }

    public List<? extends AnsibleService> getAnsibleServices() {
        return this.ansibleServices;
    }

    public void setAnsibleServices(List<? extends AnsibleService> value) {
        this.ansibleServices.setAll(value);
    }

    public void addAnsibleService(AnsibleService as) {
        this.ansibleServices.add((Object)as);
    }

    public ObservableList<String> getAnsibleGroups() {
        return this.ansibleGroups;
    }

    public ObservableList<FXRspecInterface> getInterfaces() {
        return this.interfaces;
    }

    @Nullable
    public FXRspecInterface getInterfaceByClientId(String clientId) {
        for (FXRspecInterface iface : this.interfaces) {
            if (!Objects.equals(iface.getClientId(), clientId)) continue;
            return iface;
        }
        return null;
    }

    @Nullable
    public FXRspecInterface getInterfaceByUniqueId(String uniqueId) {
        for (FXRspecInterface iface : this.interfaces) {
            if (!Objects.equals(iface.getUniqueId(), uniqueId)) continue;
            return iface;
        }
        return null;
    }

    protected boolean addInterface(RspecInterface iface) {
        assert (iface instanceof FXRspecInterface);
        return this.interfaces.add((Object)((FXRspecInterface)iface));
    }

    protected boolean removeInterface(RspecInterface iface) {
        assert (iface instanceof FXRspecInterface);
        return this.interfaces.remove((Object)iface);
    }

    @Nonnull
    public List<FXRspecLink> getLinks() {
        ArrayList<FXRspecLink> res = new ArrayList<FXRspecLink>();
        for (FXRspecInterface iface : this.interfaces) {
            if (!iface.isLinkBound()) continue;
            res.add(iface.getLink());
        }
        return Collections.unmodifiableList(res);
    }

    public List<String> getLeaseIdRefs() {
        return this.leaseIdRefs;
    }

    public void addLeaseIdRef(String leaseIdRef) {
        this.leaseIdRefs.add((Object)leaseIdRef);
    }

    @Nonnull
    public List<ExtraXml> getExtraXml() {
        return this.extraXml;
    }

    @Nonnull
    public List<ExtraXml> getExtraServicesXml() {
        return this.extraServicesXmls;
    }

    public void addEmptyTag(RspecNode.EmptyTag e) {
        this.emptyTags.add(e);
    }

    public boolean hasEmptyTag(RspecNode.EmptyTag e) {
        return this.emptyTags.contains(e);
    }

    public Collection<RspecNode.EmptyTag> getEmptyTags() {
        return this.emptyTags;
    }

    public String toString() {
        return "RspecNode{id=" + this.clientId + ", editorX=" + this.editorX + ", editorY=" + this.editorY + ", flackEditorX=" + this.flackEditorX + ", flackEditorY=" + this.flackEditorY + ", hardwareTypes=" + this.hardwareTypes + ", exclusive=" + this.exclusive + ", available=" + this.available + ", sliverTypes=" + this.sliverTypes + ", componentManagerId=" + this.componentManagerId + ", componentId=" + this.componentId + ", componentName=" + this.componentName + ", executeServices=" + this.executeServices + ", installServices=" + this.installServices + ", interfaces=" + this.interfaces + "}";
    }
}

