/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.client;

import be.iminds.ilabt.jfed.fedmon.webapi.client.TestInstanceFilter;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.http.client.utils.URIBuilder;

public class ExtendedTestInstanceFilter
extends TestInstanceFilter {
    protected final Optional<Boolean> needsToRun;
    protected final Optional<Boolean> hasActiveTasks;

    public ExtendedTestInstanceFilter(int testInstanceId) {
        super(testInstanceId);
        this.needsToRun = Optional.empty();
        this.hasActiveTasks = Optional.empty();
    }

    public ExtendedTestInstanceFilter(List<Integer> testInstanceIds) {
        super(testInstanceIds);
        this.needsToRun = Optional.empty();
        this.hasActiveTasks = Optional.empty();
    }

    public ExtendedTestInstanceFilter(List<String> versionName, List<String> testInstanceName, List<String> testDefinitionName, List<Integer> testInstanceId, List<String> testbedCategory, List<String> testbedGeniName, List<String> testbedName, List<String> testbedUrns, Optional<Boolean> disabled) {
        super(versionName, testInstanceName, testDefinitionName, testInstanceId, testbedCategory, testbedGeniName, testbedName, testbedUrns, disabled);
        this.needsToRun = Optional.empty();
        this.hasActiveTasks = Optional.empty();
    }

    public ExtendedTestInstanceFilter(String versionNameArgString, String testInstanceNameArgString, String testDefinitionNameArgString, String testInstanceIdArgString, String testbedCategoryArgString, String testbedGeniNameArgString, String testbedNameArgString, String testbedUrnsArgString, Optional<Boolean> disabled) {
        super(versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnsArgString, disabled);
        this.needsToRun = Optional.empty();
        this.hasActiveTasks = Optional.empty();
    }

    public ExtendedTestInstanceFilter(List<String> versionName, List<String> testInstanceName, List<String> testDefinitionName, List<Integer> testInstanceId, List<String> testbedCategory, List<String> testbedGeniName, List<String> testbedName, List<String> testbedUrns, Optional<Boolean> disabled, Optional<Boolean> needsToRun, Optional<Boolean> hasActiveTasks) {
        super(versionName, testInstanceName, testDefinitionName, testInstanceId, testbedCategory, testbedGeniName, testbedName, testbedUrns, disabled);
        this.needsToRun = needsToRun;
        this.hasActiveTasks = hasActiveTasks;
    }

    public ExtendedTestInstanceFilter(String versionNameArgString, String testInstanceNameArgString, String testDefinitionNameArgString, String testInstanceIdArgString, String testbedCategoryArgString, String testbedGeniNameArgString, String testbedNameArgString, String testbedUrnsArgString, Optional<Boolean> disabled, Optional<Boolean> needsToRun, Optional<Boolean> hasActiveTasks) {
        super(versionNameArgString, testInstanceNameArgString, testDefinitionNameArgString, testInstanceIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedNameArgString, testbedUrnsArgString, disabled);
        this.needsToRun = needsToRun;
        this.hasActiveTasks = hasActiveTasks;
    }

    public ExtendedTestInstanceFilter(ExtendedTestInstanceFilter testInstanceFilter) {
        super(testInstanceFilter);
        this.needsToRun = testInstanceFilter.getNeedsToRun();
        this.hasActiveTasks = testInstanceFilter.getHasActiveTasks();
    }

    public ExtendedTestInstanceFilter(TestInstanceFilter testInstanceFilter, Optional<Boolean> needsToRun, Optional<Boolean> hasActiveTasks) {
        super(testInstanceFilter);
        this.needsToRun = needsToRun;
        this.hasActiveTasks = hasActiveTasks;
    }

    public Optional<Boolean> getHasActiveTasks() {
        return this.hasActiveTasks;
    }

    public Optional<Boolean> getNeedsToRun() {
        return this.needsToRun;
    }

    public boolean hasActiveTasksFilter() {
        return this.hasActiveTasks != null && this.hasActiveTasks.isPresent();
    }

    public boolean hasNeedsToRunFilter() {
        return this.needsToRun != null && this.needsToRun.isPresent();
    }

    @Override
    @Nonnull
    public URIBuilder addToUriParameters(@Nonnull URIBuilder builder) {
        builder = super.addToUriParameters(builder);
        if (this.hasActiveTasksFilter()) {
            builder = builder.addParameter("activeTasks", "" + this.hasActiveTasks.get());
        }
        if (this.hasNeedsToRunFilter()) {
            builder = builder.addParameter("nextrun", "" + this.needsToRun.get());
        }
        return builder;
    }
}

