#!/bin/sh

# First a serious hack: This first part runs differently in sh and in python:
#     - In python, it's just ignored (2 string that are concatted)
#     - In sh, '''\' is seen as literal \. That is the argument to "true", and "true" just does nothing, ignoring its argument

# This hack allows sh to find a specific version of python and then exec that python with the script and its arguments
"true" '''\'

if which python2 >/dev/null 2>&1; then
    PYTHON_EXE=$(which python2)
#     echo "Using ${PYTHON_EXE}"
    exec "${PYTHON_EXE}" "$0" "$@"
elif which python >/dev/null 2>&1; then
     PYTHON_EXE=$(which python)
#      echo "Using ${PYTHON_EXE}"
     exec "${PYTHON_EXE}" "$0" "$@"
elif which python3 >/dev/null 2>&1; then
     PYTHON_EXE=$(which python3)
#      echo "Using ${PYTHON_EXE}"
     exec "${PYTHON_EXE}" "$0" "$@"
else
     echo 'python not found'
     exit 127
fi
'''


import signal
import socket
import sys
import time

host = "0.0.0.0"
port = 8105
buffer = 102400

s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
s.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
s.bind((host, port))
s.listen(5)  # max backlog of connections


def sigint_and_hup_handler(sig, frame):
    global s
    print('SIGINT or SIGHUP received: exiting')
    try:
        s.close()
    finally:
        sys.exit(0)


signal.signal(signal.SIGINT, sigint_and_hup_handler)
signal.signal(signal.SIGHUP, sigint_and_hup_handler)

while 1:
    other = 'unknown'
    total_bytes = 0

    con, addr = s.accept()

    start = time.time()

    data = con.recv(1500)
    if data:
        header = ''
        for c in data.decode():
            if c == '\n':
                break
            else:
                header += c
        other = header
        print("Starting speed test with {}...".format(other))

        while 1:
            data = con.recv(1500)
            if not data: break
            total_bytes += len(data)
            if b'**END**' in data: break

    end = time.time()

    total_mb = total_bytes / (1024.0*1024.0)
    total_time_s =  end - start
    rate_mbps = (total_bytes*8.0 / total_time_s) / 1000000.0

    msg = '{}'.format(rate_mbps)
    con.send(msg.encode("utf-8"))

    print("Recv: from={} total={}MB rate={}Mbit/s time={}s\n"
          .format(other, total_mb, rate_mbps, total_time_s))

    con.close()
