/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.rrd.replay;

import be.iminds.ilabt.jfed.fedmon.rrd.base.TestInstanceRrd;
import be.iminds.ilabt.jfed.fedmon.rrd.replay.DbInfo;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplayTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ReplayTask.class);
    private final TestInstance ti;
    private final TestDefinition td;
    private final List<TestInstanceRrd> rrds;
    private final FedmonWebApiClient fedmonWebApiClient;
    private final DbInfo dbInfo;
    private final boolean replayForDisabled;
    private final boolean enableAfterwards;
    private final boolean replayDisable;
    private final boolean disableFirst;

    public ReplayTask(TestInstance ti, TestDefinition td, List<TestInstanceRrd> rrds, FedmonWebApiClient fedmonWebApiClient, DbInfo dbInfo, boolean replayForDisabled, boolean enableAfterwards, boolean replayDisable, boolean disableFirst) {
        this.td = td;
        this.ti = ti;
        this.rrds = rrds;
        this.fedmonWebApiClient = fedmonWebApiClient;
        this.dbInfo = dbInfo;
        this.replayForDisabled = replayForDisabled;
        this.enableAfterwards = enableAfterwards;
        this.replayDisable = replayDisable;
        this.disableFirst = disableFirst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block55: {
            try {
                Statement updateStatement;
                Statement insertStatement;
                boolean wasEnabledAtStart;
                Boolean res = this.ti.getBooleanParameterOrDefault("rrd_enabled", this.td);
                if (res == null || !res.booleanValue()) {
                    wasEnabledAtStart = false;
                    if (this.replayForDisabled) {
                        LOG.warn("Test Instance " + this.ti.getId() + " is not enabled. Will continue anyway.");
                    } else {
                        LOG.warn("Test Instance " + this.ti.getId() + " is not enabled. Skipping replay.");
                    }
                } else {
                    wasEnabledAtStart = true;
                }
                if (wasEnabledAtStart && this.disableFirst) {
                    Connection con = this.dbInfo.getConnection();
                    insertStatement = con.createStatement();
                    try {
                        insertStatement.execute("INSERT INTO parameterinstances (testinstanceid, parametername, parametervalue) VALUES (" + this.ti.getId() + ", 'rrd_enabled', 'false')");
                        LOG.debug("disabled RRD for instance " + this.ti.getId() + "  (with INSERT)");
                    }
                    catch (SQLException e) {
                        LOG.warn("Error disabling RRD for test instance " + this.ti.getId() + ". INSERT failed: probably already explicitly enabled or disabled. ", (Throwable)e);
                        updateStatement = con.createStatement();
                        try {
                            updateStatement.execute("UPDATE parameterinstances SET parametervalue = 'false' WHERE parametername = 'rrd_enabled' AND testinstanceid=" + this.ti.getId());
                            LOG.debug("disabled RRD for instance " + this.ti.getId() + "  (with UPDATE)");
                        }
                        catch (SQLException e2) {
                            LOG.error("Error disabling RRD for test instance " + this.ti.getId() + " (UPDATE failed)", (Throwable)e2);
                        }
                        finally {
                            if (updateStatement != null) {
                                updateStatement.close();
                            }
                        }
                    }
                    finally {
                        if (insertStatement != null) {
                            insertStatement.close();
                        }
                        if (con != null) {
                            con.close();
                        }
                    }
                }
                if (!this.replayDisable && (wasEnabledAtStart || this.replayForDisabled)) {
                    long dbStartTimeMs;
                    long startTime = System.currentTimeMillis();
                    for (TestInstanceRrd rrd : this.rrds) {
                        try {
                            if (!rrd.exists()) {
                                rrd.create();
                            }
                            rrd.setDisableInsertDebug(true);
                        }
                        catch (Throwable e) {
                            LOG.error("Problem with RRD create", e);
                        }
                    }
                    Class.forName("org.postgresql.Driver");
                    LOG.debug("Accessing DB");
                    Date now = new Date();
                    Result prevResult = null;
                    long skippedResult = 0L;
                    long resultsInsertedTotal = 0L;
                    long resultsInsertedCount = 0L;
                    long resultsInsertedEmptyCount = 0L;
                    long testResultsCount = 0L;
                    Connection con = this.dbInfo.getConnection();
                    PreparedStatement resStatement = con.prepareStatement("SELECT resultid,timestamp,summary FROM results WHERE testinstanceid = ? AND timestamp > ? ORDER BY timestamp ASC");
                    resStatement.setInt(1, (Integer)this.ti.getId());
                    resStatement.setTimestamp(2, new Timestamp(now.getTime() - TimeUnit.DAYS.toMillis(366L)));
                    ResultSet resResultSet = resStatement.executeQuery();
                    LOG.debug("... still working. DB answered, will process results.");
                    long dbReportTimeMs = dbStartTimeMs = System.currentTimeMillis();
                    PreparedStatement subresStatement = con.prepareStatement("SELECT returnname,returnvalue FROM subresults WHERE resultid = ?");
                    while (resResultSet.next()) {
                        long resultId = resResultSet.getInt(1);
                        Timestamp timestamp = resResultSet.getTimestamp(2);
                        String summaryStr = resResultSet.getString(3);
                        Result.ResultStatus summary = Result.ResultStatus.SUCCESS;
                        if (summaryStr != null) {
                            try {
                                summary = Result.ResultStatus.valueOf((String)summaryStr);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                        subresStatement.setLong(1, resultId);
                        ResultSet subresResultSet = subresStatement.executeQuery();
                        HashMap<String, String> subresults = new HashMap<String, String>();
                        if (testResultsCount < 10L) {
                            LOG.debug("Read result id=" + resultId + " timestamp=" + RFC3339Util.dateToRFC3339String((Date)timestamp));
                        }
                        while (subresResultSet.next()) {
                            String subresName = subresResultSet.getString(1);
                            String subresVal = subresResultSet.getString(2);
                            subresults.put(subresName, subresVal);
                            if (testResultsCount >= 10L) continue;
                            LOG.debug("   added sub result " + subresName + "=" + subresVal);
                        }
                        Result tr = ((ResultBuilder)new ResultBuilder().setId((Object)resultId)).setCreated(new Timestamp(((Date)timestamp).getTime())).setExpire(new Timestamp(now.getTime())).setSummary(summary).setResults(subresults).setTestInstance(this.ti).create();
                        ++testResultsCount;
                        if (prevResult != null && tr.getCreated().getTime() / 1000L == prevResult.getCreated().getTime() / 1000L) {
                            if (skippedResult < 10L) {
                                LOG.warn("Skipped result for result " + resultId + " ti " + this.ti.getId() + " @ " + timestamp);
                            }
                            ++skippedResult;
                            prevResult = tr;
                            continue;
                        }
                        long nowMs = System.currentTimeMillis();
                        if (nowMs - dbReportTimeMs > 5000L) {
                            LOG.debug("... still working. Processed " + testResultsCount + " results already. Working for " + (nowMs - dbStartTimeMs) + " ms. Skipped " + skippedResult + " duplicate results.");
                            dbReportTimeMs = nowMs;
                        }
                        for (TestInstanceRrd rrd : this.rrds) {
                            if (rrd.getRrdStartTime().after(tr.getCreated())) {
                                if (skippedResult < 10L) {
                                    LOG.warn("Skipped due to too early result for result " + resultId + " ti " + this.ti.getId() + " @ " + timestamp + "  rrdStart=" + rrd.getRrdStartTime());
                                }
                                ++skippedResult;
                                prevResult = tr;
                                continue;
                            }
                            int insertCount = rrd.insert(tr);
                            resultsInsertedTotal += (long)insertCount;
                            if (insertCount == 0) {
                                ++resultsInsertedEmptyCount;
                            }
                            ++resultsInsertedCount;
                        }
                        prevResult = tr;
                    }
                    con.close();
                    LOG.debug("Finished DB access. Processed " + testResultsCount + " results. Skipped " + skippedResult + " results due to duplicate times. (diff=" + (testResultsCount - skippedResult) + ")\nInserted " + resultsInsertedTotal + " entries in RRD in " + resultsInsertedCount + " steps, of which " + resultsInsertedEmptyCount + " steps inserted no data.");
                    for (TestInstanceRrd rrd : this.rrds) {
                        try {
                            rrd.copyToRealFile();
                        }
                        catch (Throwable e) {
                            LOG.error("Problem with RRD copyToRealFile", e);
                        }
                    }
                    long stopTime = System.currentTimeMillis();
                    LOG.debug("Handled RRD in " + (stopTime - startTime) + " ms.");
                }
                if (!this.enableAfterwards || !this.disableFirst && wasEnabledAtStart) break block55;
                Connection con = this.dbInfo.getConnection();
                insertStatement = con.createStatement();
                try {
                    insertStatement.execute("INSERT INTO parameterinstances (testinstanceid, parametername, parametervalue) VALUES (" + this.ti.getId() + ", 'rrd_enabled', 'true')");
                    LOG.debug("enabled RRD for instance " + this.ti.getId() + "  (with INSERT)");
                }
                catch (SQLException e) {
                    LOG.warn("Error enabling RRD for test instance " + this.ti.getId() + ". INSERT failed: probably already explicitly enabled of disabled. ", (Throwable)e);
                    updateStatement = con.createStatement();
                    try {
                        updateStatement.execute("UPDATE parameterinstances SET parametervalue = 'true' WHERE parametername = 'rrd_enabled' AND testinstanceid=" + this.ti.getId());
                        LOG.debug("enabled RRD for instance " + this.ti.getId() + "  (with UPDATE)");
                    }
                    catch (SQLException e2) {
                        LOG.error("Error enabling RRD for test instance " + this.ti.getId() + " (UPDATE failed)", (Throwable)e2);
                    }
                    finally {
                        if (updateStatement != null) {
                            updateStatement.close();
                        }
                    }
                }
                finally {
                    if (insertStatement != null) {
                        insertStatement.close();
                    }
                    if (con != null) {
                        con.close();
                    }
                }
            }
            catch (Throwable t) {
                LOG.error("There was an uncaught error in ReplayTask", t);
                System.err.println("ERROR: There was an uncaught error in ReplayTask:");
                t.printStackTrace();
            }
        }
    }
}

