/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.testing.tests.highlevel;

import be.iminds.ilabt.jfed.call_log_output.LogOutput;
import be.iminds.ilabt.jfed.espec.model.AnsiblePlaybookSpec;
import be.iminds.ilabt.jfed.espec.model.DirSpec;
import be.iminds.ilabt.jfed.espec.model.ExecuteSpec;
import be.iminds.ilabt.jfed.espec.model.FileSource;
import be.iminds.ilabt.jfed.espec.model.RspecSpec;
import be.iminds.ilabt.jfed.espec.model.UploadLikeSpec;
import be.iminds.ilabt.jfed.espec.util.ESpecLogListener;
import be.iminds.ilabt.jfed.espec.util.LimitedLiveLog;
import be.iminds.ilabt.jfed.espec.util.UploadProgressTracker;
import be.iminds.ilabt.jfed.experiment.setup.config.ESpecLogStorageDetails;
import be.iminds.ilabt.jfed.testing.base.ApiTestResult;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ESpecLogToTestMethodResult
implements ESpecLogListener {
    private Instant start;
    private Instant stop;
    @Nonnull
    private final List<ESpecLogStorageDetails> logStorageList;
    @Nonnull
    private final String name;
    @Nonnull
    private String uniqueEspecId = "";
    @Nonnull
    private final String description;
    @Nonnull
    private final List<LogOutput.LogEntry> logEntries = new ArrayList<LogOutput.LogEntry>();
    @Nonnull
    private LogOutput.TestResultState finalState = LogOutput.TestResultState.SUCCESS;
    @Nonnull
    private List<ApiTestResult.ApiTestMethodResult.FedmonResultExtra> fedmonResultExtras = new ArrayList<ApiTestResult.ApiTestMethodResult.FedmonResultExtra>();
    private final Map<Long, LimitedLiveLog> tmpLogs = new HashMap<Long, LimitedLiveLog>();

    public ESpecLogToTestMethodResult(@Nonnull String name, @Nonnull String description, @Nullable List<ESpecLogStorageDetails> logStorageList) {
        this.name = name;
        this.description = description;
        this.logStorageList = logStorageList == null ? Collections.emptyList() : logStorageList;
    }

    public void setUniqueEspecId(@Nonnull String uniqueEspecId) {
        this.uniqueEspecId = uniqueEspecId;
    }

    private void logInstant() {
        if (this.start == null) {
            this.start = Instant.now();
        }
        this.stop = Instant.now();
    }

    public ApiTestResult.ApiTestMethodResult getLogAsTestMethodResult() {
        long durationMs = this.start == null || this.stop == null ? 0L : this.stop.toEpochMilli() - this.start.toEpochMilli();
        ApiTestResult.ApiTestMethodResult res = new ApiTestResult.ApiTestMethodResult(this.name, this.description, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), this.logEntries, Collections.emptyList(), null, this.finalState == null ? LogOutput.TestResultState.SKIPPED : this.finalState, durationMs, this.start == null ? 0L : this.start.toEpochMilli(), this.stop == null ? 0L : this.stop.toEpochMilli());
        return res;
    }

    public void errorNonFatal(@Nullable String val) {
        this.finalState = LogOutput.TestResultState.FAILED;
        this.logEntries.add(new LogOutput.LogEntry(LogOutput.LogLineType.ERROR, val));
    }

    public void note(String val) {
        this.logEntries.add(new LogOutput.LogEntry(LogOutput.LogLineType.NOTE, val));
    }

    public void addExtraResult(@Nonnull ApiTestResult.ApiTestMethodResult.FedmonResultExtra extra) {
        this.fedmonResultExtras.add(extra);
    }

    public void addExtraResult(@Nonnull ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder extra) {
        this.addExtraResult(extra.create());
    }

    @Nonnull
    public List<ApiTestResult.ApiTestMethodResult.FedmonResultExtra> getFedmonResultExtras() {
        return Collections.unmodifiableList(this.fedmonResultExtras);
    }

    public void onPreFileLoad() {
        this.note("ExperimentSpecification: Start loading files.");
    }

    public void onPostFileLoad(@Nonnull FileSource fileSource, boolean isFast, long byteSize, @Nonnull ESpecLogListener.ESpecStepStatus status) {
        if (status.isFailure()) {
            this.errorNonFatal("ExperimentSpecification: Failed to load file \"" + fileSource.getBasename() + "\"");
        } else if (!isFast) {
            this.note("ExperimentSpecification: Successfully loaded file \"" + fileSource.getBasename() + "\" (" + byteSize + " byte)");
        }
    }

    public void onPostFileLoadAll(boolean success) {
        if (!success) {
            this.errorNonFatal("ExperimentSpecification: Failed to load all files.");
        } else {
            this.note("ExperimentSpecification: Successfully finished loading files.");
        }
    }

    public void onPreRSpec() {
        this.note("ExperimentSpecification: Start Provisioning RSpec.");
    }

    public void onRequestRSpecKnown(@Nonnull RspecSpec rspecSpec, @Nonnull String requestRspec) {
        this.note("ExperimentSpecification: onRequestRSpecKnown length=" + requestRspec.length());
    }

    public void onPostRSpec(@Nonnull RspecSpec rspec, @Nonnull ESpecLogListener.ESpecStepStatus status) {
    }

    public void onPostRspecAll(boolean success, @Nonnull List<String> allNodeClientIds) {
        if (!success) {
            this.errorNonFatal("ExperimentSpecification: Failed to Provision RSpec");
        } else {
            this.note("ExperimentSpecification: Successfully Provisioned RSpec with nodes " + allNodeClientIds.stream().collect(Collectors.joining()));
        }
    }

    public void onPreDir() {
        this.logInstant();
        this.note("ExperimentSpecification: Start dir setup.");
    }

    public void onPreDirNode(@Nonnull String nodeClientId) {
        this.logInstant();
    }

    public void onPreDir(long logEventId, @Nonnull DirSpec dir, @Nonnull String fullPath, @Nonnull String nodeClientId) {
        this.logInstant();
    }

    public void onPostDir(long logEventId, @Nonnull DirSpec dir, @Nonnull String fullPath, @Nonnull String nodeClientId, @Nonnull ESpecLogListener.ESpecStepStatus status) {
        if (status.isFailure()) {
            this.errorNonFatal("ExperimentSpecification: (on \"" + nodeClientId + "\") Failed to setup dir at \"" + fullPath + "\"");
        } else {
            this.note("ExperimentSpecification: (on \"" + nodeClientId + "\") Successfully setup dir at \"" + fullPath + "\"");
        }
    }

    public void onPostDirNode(@Nonnull String nodeClientId, boolean success) {
        this.logInstant();
    }

    public void onPostDirAll(boolean success) {
        this.logInstant();
        if (!success) {
            this.errorNonFatal("ExperimentSpecification: Failed to setup dirs");
        } else {
            this.note("ExperimentSpecification: Successfully setup dirs");
        }
    }

    public void onPreUpload() {
        this.logInstant();
        this.note("ExperimentSpecification: Start upload(s).");
    }

    public void onPreUploadNode(@Nonnull String nodeClientId) {
        this.logInstant();
    }

    public void onPreUpload(long logEventId, @Nonnull UploadLikeSpec uploadSpec, @Nonnull String fullPath, @Nonnull String nodeClientId, @Nonnull UploadProgressTracker uploadProgressTracker) {
        this.logInstant();
    }

    public void onPostUpload(long logEventId, @Nonnull UploadLikeSpec uploadSpec, @Nonnull String fullPath, @Nonnull String nodeClientId, @Nonnull ESpecLogListener.ESpecStepStatus status) {
        this.logInstant();
        if (status.isFailure()) {
            this.errorNonFatal("ExperimentSpecification: (on \"" + nodeClientId + "\") Failed to upload file \"" + uploadSpec.getDesc() + "\" at \"" + fullPath + "\"");
        } else {
            this.note("ExperimentSpecification: (on \"" + nodeClientId + "\") Successfully uploaded file \"" + uploadSpec.getDesc() + "\" at \"" + fullPath + "\"");
        }
    }

    public void onPostUploadNode(@Nonnull String nodeClientId, boolean success) {
        this.logInstant();
    }

    public void onPostUploadAll(boolean success) {
        this.logInstant();
        if (!success) {
            this.errorNonFatal("ExperimentSpecification: Failed to upload at least one file to one node");
        } else {
            this.note("ExperimentSpecification: Successfully uploaded files");
        }
    }

    public void onPreExecute() {
        this.logInstant();
        this.note("ExperimentSpecification: Start execute(s).");
    }

    public void onPreExecute(long logEventId, @Nonnull ExecuteSpec executeSpec, @Nonnull String fullExecutablePath, @Nullable String fullLogPath, @Nonnull String nodeClientId, @Nonnull LimitedLiveLog currentLog) {
        this.logInstant();
        this.tmpLogs.put(logEventId, currentLog);
    }

    public void onPostExecute(long logEventId, @Nonnull ExecuteSpec executeSpec, @Nonnull String fullPath, @Nullable String remoteLogPath, @Nonnull String nodeClientId, int exitStatus, @Nonnull ESpecLogListener.ESpecStepStatus status) {
        this.logInstant();
        if (status.isFailure()) {
            this.errorNonFatal("ExperimentSpecification: (on \"" + nodeClientId + "\") Failed to execute script \"" + executeSpec.getDesc() + "\" at \"" + fullPath + "\" exitStatus=" + exitStatus);
        } else {
            this.note("ExperimentSpecification: (on \"" + nodeClientId + "\") Successfully executed script \"" + executeSpec.getDesc() + "\" at \"" + fullPath + "\" exitStatus=" + exitStatus);
        }
        if (status.isFailure() || this.mustKeepLog(executeSpec, nodeClientId)) {
            this.keepLog(logEventId, executeSpec, nodeClientId, fullPath, remoteLogPath, this.tmpLogs.get(logEventId));
        }
        this.tmpLogs.remove(logEventId);
    }

    public void onPostExecuteStepAll(@Nonnull ExecuteSpec executeSpec, boolean success) {
        this.logInstant();
        if (!success) {
            this.errorNonFatal("ExperimentSpecification: Failed to execute script \"" + executeSpec.getDesc() + "\" on at least one node");
        } else {
            this.note("ExperimentSpecification: Successfully executed script \"" + executeSpec.getDesc() + "\" on all nodes");
        }
    }

    public void onPostExecuteAll(boolean success) {
        this.logInstant();
        if (!success) {
            this.errorNonFatal("ExperimentSpecification: Failed to execute at least one script on at least one node");
        } else {
            this.note("ExperimentSpecification: Successfully executed all scripts");
        }
        this.tmpLogs.clear();
    }

    public void onPreAnsible() {
        this.logInstant();
        this.note("ExperimentSpecification: Start ansible(s).");
    }

    public void onPreAnsiblePlaybook(long logEventId, @Nonnull AnsiblePlaybookSpec ansiblePlaybookSpec, @Nonnull String fullPlaybookPath, @Nullable String fullLogPath, @Nonnull String nodeClientId, @Nonnull LimitedLiveLog currentLog) {
        this.logInstant();
    }

    public void onPostAnsiblePlaybook(long logEventId, @Nonnull AnsiblePlaybookSpec ansiblePlaybookSpec, @Nonnull String fullPath, @Nonnull String remoteLogPath, @Nonnull String nodeClientId, @Nonnull ESpecLogListener.ESpecStepStatus status) {
        this.logInstant();
        if (status.isFailure()) {
            this.errorNonFatal("ExperimentSpecification: (on \"" + nodeClientId + "\") Failed to execute ansible playbook \"" + ansiblePlaybookSpec.getDesc() + "\" at \"" + fullPath + "\"");
        } else {
            this.note("ExperimentSpecification: (on \"" + nodeClientId + "\") Successfully executed ansible playbook \"" + ansiblePlaybookSpec.getDesc() + "\" at \"" + fullPath + "\"");
        }
    }

    public void onPostAnsibleAll(boolean success) {
        this.logInstant();
        if (!success) {
            this.errorNonFatal("ExperimentSpecification: Failed to ansible at least one script on at least one node");
        } else {
            this.note("ExperimentSpecification: Successfully ansibled all scripts");
        }
    }

    @Nullable
    private ESpecLogStorageDetails findLogStorageDetails(@Nonnull ExecuteSpec executeSpec, @Nonnull String nodeClientId) {
        for (ESpecLogStorageDetails logStorage : this.logStorageList) {
            if (logStorage.getPath() != null && executeSpec.getPath() != null && !executeSpec.getPath().equals(logStorage.getPath()) || logStorage.getNodeClientId() != null && !nodeClientId.equals(logStorage.getNodeClientId())) continue;
            return logStorage;
        }
        return null;
    }

    private boolean mustKeepLog(@Nonnull ExecuteSpec executeSpec, @Nonnull String nodeClientId) {
        ESpecLogStorageDetails logStorage = this.findLogStorageDetails(executeSpec, nodeClientId);
        if (logStorage == null) {
            return false;
        }
        return logStorage.isStoreInFile() || logStorage.isStoreInLog();
    }

    private void keepLog(long logEventId, @Nonnull ExecuteSpec executeSpec, @Nonnull String nodeClientId, @Nonnull String fullExecutablePath, @Nullable String fullLogPath, @Nonnull LimitedLiveLog currentLog) {
        boolean addInline;
        ESpecLogStorageDetails logStorage;
        Object useablePath = executeSpec.getPath();
        if (useablePath == null) {
            Object object = useablePath = fullLogPath == null ? null : fullLogPath.replaceAll(".*/", "");
        }
        if (useablePath == null) {
            useablePath = fullExecutablePath.replaceAll(".*/", "");
        }
        if (useablePath == null) {
            useablePath = "unknown-" + logEventId;
        }
        boolean addSeperate = (logStorage = this.findLogStorageDetails(executeSpec, nodeClientId)) != null && logStorage.isStoreInFile();
        boolean bl = addInline = logStorage != null && logStorage.isStoreInLog();
        if (!addSeperate && !addInline) {
            addSeperate = true;
        }
        if (addSeperate) {
            this.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey("log" + this.uniqueEspecId + "-" + (String)useablePath + "-" + nodeClientId).setValue((Object)currentLog.getText()).setLarge(true).setHttpMediaTypeToXml());
            this.logEntries.add(new LogOutput.LogEntry(LogOutput.LogLineType.NOTE, "Log content for " + (String)useablePath + " @ " + nodeClientId + " has been stored. See \"log-" + (String)useablePath + "-" + nodeClientId + "\""));
        }
        if (addInline) {
            String logText = currentLog.getText();
            this.logEntries.add(new LogOutput.LogEntry(LogOutput.LogLineType.NOTE, "Log content for " + (String)useablePath + " @ " + nodeClientId + " (" + logText.length() + " chars):\n\n" + logText, true));
        }
    }
}

