/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.testing.tests.highlevel;

import be.iminds.ilabt.jfed.espec.bundle.BundleFetcher;
import be.iminds.ilabt.jfed.espec.bundle.ESpecBundle;
import be.iminds.ilabt.jfed.espec.filefetcher.FileFetcher;
import be.iminds.ilabt.jfed.espec.model.ExperimentSpecification;
import be.iminds.ilabt.jfed.espec.model.RspecSpec;
import be.iminds.ilabt.jfed.espec.parser.ExperimentSpecificationParser;
import be.iminds.ilabt.jfed.espec.util.ESpecLogListener;
import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experiment.ExperimentControllerFactory;
import be.iminds.ilabt.jfed.experiment.ExperimentState;
import be.iminds.ilabt.jfed.experiment.setup.ExperimentSetupHelper;
import be.iminds.ilabt.jfed.experiment.setup.config.ESpec;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedExperimenterGuiConfigProvider;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfigImpl;
import be.iminds.ilabt.jfed.experimenter_gui.config.UserInfoProvider;
import be.iminds.ilabt.jfed.experimenter_gui.config.util.GuiConfigRSpecGenerator;
import be.iminds.ilabt.jfed.experimenter_gui.config.util.GuiConfigStitchingTestRSpecGenerator;
import be.iminds.ilabt.jfed.experimenter_gui.config.util.TestbedNodesMapsFetcher;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.git.GitAuthPreferences;
import be.iminds.ilabt.jfed.git.SingleSshGitAuthPreferences;
import be.iminds.ilabt.jfed.highlevel.HighLevelModule;
import be.iminds.ilabt.jfed.highlevel.LowLevelModule;
import be.iminds.ilabt.jfed.highlevel.SfaOnlyExperimentModule;
import be.iminds.ilabt.jfed.highlevel.jobs.report.JobReport;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AutomaticUserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedCorePreferences;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.generator.RSpecGenerator;
import be.iminds.ilabt.jfed.rspec.generator.RSpecGeneratorFactory;
import be.iminds.ilabt.jfed.rspec.generator.StitchingTestRSpecGenerator;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.rspec_source.ImmutableRequestRspecSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.ManifestRspecSource;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.ApiTestConfigEditor;
import be.iminds.ilabt.jfed.testing.base.ApiTestMetaData;
import be.iminds.ilabt.jfed.testing.base.ApiTestResult;
import be.iminds.ilabt.jfed.testing.base.JsonTestConfigEditor;
import be.iminds.ilabt.jfed.testing.shared.CommonAMTest;
import be.iminds.ilabt.jfed.testing.shared.NodeLoginTestStep;
import be.iminds.ilabt.jfed.testing.shared.Proxy;
import be.iminds.ilabt.jfed.testing.tests.highlevel.AbstractHLTest;
import be.iminds.ilabt.jfed.testing.tests.highlevel.ESpecLogToTestMethodResult;
import be.iminds.ilabt.jfed.testing.tests.highlevel.config.ESpecTestConfig;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.lib.ConnectivityDetector;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import com.google.inject.util.Modules;
import io.dropwizard.jackson.Jackson;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.slf4j.LoggerFactory;

public class ESpecTest
extends AbstractHLTest<ESpecTestConfig> {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(ESpecTest.class);
    @Nonnull
    private final Server userAuthorityServer;
    @Nonnull
    private final TestbedInfoSource testbedInfoSource;
    @Nonnull
    private final AuthorityFinder authorityFinder;
    @Nonnull
    private final Injector originalInjector;
    @Nonnull
    private final JFedCorePreferences configJFedPreferences;
    @Nonnull
    private final Injector configInjector;
    private final ESpecLogToTestMethodResult eSpecLogHandler;
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();
    private static final ApiTestMetaData metadata = new ApiTestMetaData<ESpecTestConfig>(){

        @Nonnull
        public String getTestDescription() {
            return "A test using the jFed GUI Editor logic. This will reserve resources, test login, and delete them again.";
        }

        @Nonnull
        public Class<ESpecTestConfig> getConfigClass() {
            return ESpecTestConfig.class;
        }

        @Nonnull
        public ESpecTestConfig parseApiTestConfig(@Nonnull String apiTestConfigString) {
            try {
                return (ESpecTestConfig)MAPPER.readValue(apiTestConfigString, ESpecTestConfig.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Invalid Test config", e);
            }
        }

        @Nonnull
        public ApiTestConfigEditor<ESpecTestConfig> getApiTestConfigEditor() {
            return new JsonTestConfigEditor(ESpecTestConfig.class);
        }
    };
    private JFedGuiConfig cachedGuiConfig = null;
    private GeniUrn sliceUrn;
    private int maxNodeNameLength = 5;
    private List<Server> serversInRspec;
    public String sliceName;
    private String project;
    private Experiment experiment;
    private boolean notEnoughResourcesDetected = false;
    private ExperimentController experimentController;
    private boolean waitForExperimentIsOver = false;
    private boolean deleted = false;
    String manifestRspecString;
    boolean validManifest;
    private ESpecBundle eSpecBundle;
    private ExperimentSpecification eSpec;
    private UserAndSliceApiWrapper userAndSliceApiWrapper;
    NodeLoginTestStep nodeLoginTestStep;

    @Inject
    public ESpecTest(@Nonnull Injector originalInjector, @Nonnull Logger logger, @Nullable TargetAuthority testedAuthority, @Nonnull GeniUserProvider geniUserProvider, @Nonnull ESpecTestConfig testConfig) {
        super(logger, testedAuthority, geniUserProvider, testConfig);
        this.originalInjector = originalInjector;
        this.configJFedPreferences = this.setupPreferences();
        this.configInjector = this.createInjector(this.configJFedPreferences);
        this.testbedInfoSource = (TestbedInfoSource)this.configInjector.getInstance(TestbedInfoSource.class);
        this.authorityFinder = (AuthorityFinder)this.configInjector.getInstance(AuthorityFinder.class);
        if (this.user == null) {
            throw new IllegalStateException("User is null");
        }
        Server uas = this.user.getUserAuthorityServer();
        if (uas == null) {
            throw new IllegalStateException("User has no Authority Server");
        }
        this.userAuthorityServer = uas;
        this.eSpecLogHandler = new ESpecLogToTestMethodResult("Experiment Specification", "Logging of ESpec execution", testConfig.getESpec().getLogStorage());
    }

    public static ApiTestMetaData getMetaData() {
        return metadata;
    }

    private JFedGuiConfig getGuiConfig() {
        if (this.cachedGuiConfig != null) {
            return this.cachedGuiConfig;
        }
        ConnectivityDetector connectivityDetector = (ConnectivityDetector)this.configInjector.getInstance(ConnectivityDetector.class);
        UserInfoProvider userInfoProvider = (UserInfoProvider)this.configInjector.getInstance(UserInfoProvider.class);
        URL webApiUrl = (URL)this.configInjector.getInstance(Key.get(URL.class, (Annotation)Names.named((String)"noClientAuthWebApiUrl")));
        FedmonWebApiClient fedmonWebApiClient = (FedmonWebApiClient)this.configInjector.getInstance(FedmonWebApiClient.class);
        if (this.geniUserProvider == null) {
            throw new NullPointerException("geniUserProvider may not be null");
        }
        JFedExperimenterGuiConfigProvider jFedExperimenterGuiConfigProvider = new JFedExperimenterGuiConfigProvider(this.geniUserProvider, (JFedPreferences)this.configJFedPreferences, connectivityDetector, userInfoProvider, webApiUrl, this.logger, false);
        TestbedNodesMapsFetcher testbedNodesMapsFetcher = new TestbedNodesMapsFetcher(connectivityDetector);
        this.cachedGuiConfig = new JFedGuiConfigImpl(this.testbedInfoSource, this.authorityFinder, jFedExperimenterGuiConfigProvider, testbedNodesMapsFetcher, fedmonWebApiClient);
        return this.cachedGuiConfig;
    }

    private RSpecGeneratorFactory getRSpecGeneratorFactory() {
        return new RSpecGeneratorFactory(){

            @Nonnull
            public RSpecGenerator createRSpecGenerator() {
                return new GuiConfigRSpecGenerator(ESpecTest.this.getGuiConfig(), ESpecTest.this.authorityFinder, ESpecTest.this.testbedInfoSource);
            }

            @Nonnull
            public StitchingTestRSpecGenerator createStitchingTestRSpecGenerator() {
                return new GuiConfigStitchingTestRSpecGenerator(ESpecTest.this.getGuiConfig(), ESpecTest.this.authorityFinder, ESpecTest.this.testbedInfoSource);
            }
        };
    }

    private JFedCorePreferences setupPreferences() {
        JFedCorePreferences newJFedPreferences;
        JFedPreferences basePrefs = (JFedPreferences)this.originalInjector.getInstance(JFedPreferences.class);
        JFedCorePreferences jFedCorePreferences = newJFedPreferences = basePrefs instanceof JFedCorePreferences ? ((JFedCorePreferences)basePrefs).makeNoSaveCopy() : null;
        if (newJFedPreferences != null) {
            if (((ESpecTestConfig)this.getTestConfig()).getAmConnectionProxy().getMode().equals((Object)Proxy.ProxyMode.MANUAL)) {
                throw new RuntimeException("Option amConnectionProxy.mode == " + Proxy.ProxyMode.MANUAL + " is not supported");
            }
            newJFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_JFED, ((ESpecTestConfig)this.getTestConfig()).getAmConnectionProxy().getMode().equals((Object)Proxy.ProxyMode.USER_AUTHORITY) ? "ALWAYS" : "NEVER");
            LOG.debug("Set usage of \"call\" proxy to: " + newJFedPreferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_JFED));
        }
        return newJFedPreferences;
    }

    private Injector createInjector(JFedCorePreferences configPreferences) {
        ArrayList<Object> minimalModules = new ArrayList<Object>();
        minimalModules.add(new LowLevelModule());
        minimalModules.add(new HighLevelModule());
        minimalModules.add(new SfaOnlyExperimentModule());
        minimalModules.add(binder -> binder.bind(GeniUserProvider.class).toInstance((Object)this.geniUserProvider));
        minimalModules.add(binder -> binder.bind(JFedPreferences.class).toInstance((Object)configPreferences));
        minimalModules.add(binder -> binder.bind(JFedCorePreferences.class).toInstance((Object)configPreferences));
        AbstractModule loggerOverride = new AbstractModule(){

            protected void configure() {
                this.bind(Logger.class).toInstance((Object)ESpecTest.this.getLogger());
                if (!(ESpecTest.this.getLogger() instanceof JavaFXLogger)) {
                    throw new RuntimeException("Expected getLogger() to be a JavaFXLogger.");
                }
                this.bind(JavaFXLogger.class).toInstance((Object)((JavaFXLogger)ESpecTest.this.getLogger()));
            }
        };
        Injector resInjector = Guice.createInjector((Module[])new Module[]{Modules.override(minimalModules).with(new Module[]{loggerOverride})});
        this.assertNotNull(resInjector);
        LOG.debug("Created injector");
        Logger injectorLogger = (Logger)resInjector.getInstance(Logger.class);
        if (this.getLogger() != injectorLogger) {
            this.errorFatal("Invalid logger in injector");
        } else {
            LOG.debug("Logger OK");
        }
        JFedPreferences injectorPreferences = (JFedPreferences)resInjector.getInstance(JFedPreferences.class);
        if (configPreferences != injectorPreferences) {
            this.errorFatal("Invalid JFedPreferences in injector");
        } else {
            LOG.debug("JFedPreferences OK");
        }
        return resInjector;
    }

    public void setUp() throws Exception {
        this.assertNotNull(this.geniUserProvider, "No user specified for test");
        this.assertNotNull(this.user, "No user specified for test");
        this.assertNotNull(this.getTestedAuthority(), "No target server specified for test");
        this.assertNotNull(this.getTestConfig(), "no test config");
        this.assertTrue(((ESpecTestConfig)this.getTestConfig()).isValid(), "Test config is not valid");
        this.assertTrue(((ESpecTestConfig)this.getTestConfig()).getProvision().isEnabled(), "A disabled provision step is currently not supported.");
    }

    @ApiTest.Test(groups={"init"})
    public void getEspec() throws GeniUrn.GeniUrnParseException, IOException, ExperimentSpecificationParser.ExperimentSpecificationParseException, ESpecBundle.ESpecBundleInitException, InterruptedException {
        ESpec eConfig = ((ESpecTestConfig)this.getTestConfig()).getESpec();
        this.assertNotNull(eConfig.getProvidedContentSource());
        switch (eConfig.getSource()) {
            case PROVIDE_ARCHIVE_FILE: {
                this.eSpecBundle = BundleFetcher.fetchArchiveFile((String)eConfig.getProvidedContentSource());
                break;
            }
            case PROVIDE_DIR: {
                this.eSpecBundle = BundleFetcher.fetchDir((String)eConfig.getProvidedContentSource());
                break;
            }
            case PROVIDE_ARCHIVE_URL: {
                this.eSpecBundle = BundleFetcher.fetchArchiveUrl((String)eConfig.getProvidedContentSource());
                break;
            }
            case PROVIDE_GIT_REPO_DIR: {
                this.eSpecBundle = BundleFetcher.fetchGitRepoDir((String)eConfig.getProvidedContentSource());
                break;
            }
            case DIRECT: {
                this.eSpecBundle = BundleFetcher.fromDirect((String)eConfig.getProvidedContentSource());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported espec.source: " + eConfig.getSource().name());
            }
        }
        this.assertNotNull(this.eSpecBundle);
        this.currentTestResult.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey("experiment-specification.yaml").setValue((Object)this.eSpecBundle.getExperimentSpecificationYml()).setLarge(true).setHttpMediaTypeToXml());
        ExperimentSpecificationParser parser = new ExperimentSpecificationParser();
        this.eSpec = parser.parse(this.eSpecBundle.getExperimentSpecificationYml());
        String userPem = this.user == null || this.user.getPrivateKey() == null ? null : new String(KeyUtil.privateKeyToAnyPem((PrivateKey)this.user.getPrivateKey()));
        String requestRspec = new String(new FileFetcher(((RspecSpec)this.eSpec.getRspecs().get(0)).getSource(), this.eSpecBundle, this.getRSpecGeneratorFactory(), (GitAuthPreferences)new SingleSshGitAuthPreferences(userPem)).fetchBytes(), StandardCharsets.UTF_8);
        ImmutableRequestRspecSource requestRspecSource = new ImmutableRequestRspecSource(requestRspec, ModelRspecType.BASIC);
        this.serversInRspec = requestRspecSource.getAllComponentManagerUrns().stream().map(serverUrn -> this.authorityFinder.findByUrn(serverUrn, AuthorityFinder.Purpose.REQUEST_RSPEC)).collect(Collectors.toList());
        this.maxNodeNameLength = requestRspecSource.getBasicNodeInfo().stream().map(BasicStringRspec.BasicNodeInfo::getClientId).filter(Objects::nonNull).mapToInt(String::length).max().orElse(5);
        this.currentTestResult.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey("rspec").setValue((Object)requestRspec).setLarge(true).setHttpMediaTypeToXml());
    }

    public AutomaticUserAndSliceApiWrapper.AutomaticUserAndSliceApiWrapperFactory getAutomaticUserAndSliceApiWrapperFactory() {
        return (AutomaticUserAndSliceApiWrapper.AutomaticUserAndSliceApiWrapperFactory)this.configInjector.getInstance(AutomaticUserAndSliceApiWrapper.BasicAutomaticUserAndSliceApiWrapperFactory.class);
    }

    @ApiTest.Test(hardDepends={"getEspec"}, groups={"init"})
    public void findProject() {
        this.assertNotNull(this.user);
        this.userAndSliceApiWrapper = this.getAutomaticUserAndSliceApiWrapperFactory().create();
        switch (((ESpecTestConfig)this.getTestConfig()).getSlice().getProjectSource()) {
            case NONE: {
                this.project = null;
                break;
            }
            case PROVIDED: {
                this.project = ((ESpecTestConfig)this.getTestConfig()).getSlice().getProject();
                break;
            }
            case AUTO: {
                this.project = CommonAMTest.findProject((ApiTest)this, (Logger)this.getLogger(), (String)this.project, (GeniUser)this.user, (GeniUrn)this.user.getUserUrn(), (UserAndSliceApiWrapper)this.userAndSliceApiWrapper, (boolean)true);
            }
        }
        if (this.project != null) {
            this.note("Will use project: \"" + this.project + "\"");
        } else {
            this.assertFalse(((ESpecTestConfig)this.getTestConfig()).getSlice().getFailIfNoProject(), "Empty project is not allowed by config");
            this.note("Will NOT use a project");
        }
    }

    @ApiTest.Test(hardDepends={"getEspec", "findProject"}, groups={"init"})
    public void createExperiment() throws NoSuchAlgorithmException {
        this.assertNotNull(this.user);
        this.sliceName = CommonAMTest.createSliceName((ApiTest)this, (Server)this.userAuthorityServer, (List)ApiInfo.getDefaultComponentManagerForEach(this.serversInRspec), (String)"g", (int)this.maxNodeNameLength, null);
        this.note("Will create slice \"" + this.sliceName + "\"");
        Instant requestedEndTime = Instant.now().plus(((ESpecTestConfig)this.getTestConfig()).getSlice().getExpireTimeMin(), ChronoUnit.MINUTES);
        this.note("Created slice (and slivers) will expire at " + requestedEndTime);
        this.nodeLoginTestStep = new NodeLoginTestStep((ApiTest)this, ((ESpecTestConfig)this.getTestConfig()).generateNodeLoginTestStepConfig(this.geniUserProvider));
        List<String> sshKeys = Collections.singletonList(this.nodeLoginTestStep.getSshKeyHelper().getSshPublicKeyString());
        UserSpec userSpec = new UserSpec(this.user.getUserUrnString(), sshKeys);
        List<UserSpec> userSpecs = Collections.singletonList(userSpec);
        String userPem = this.user == null || this.user.getPrivateKey() == null ? null : new String(KeyUtil.privateKeyToAnyPem((PrivateKey)this.user.getPrivateKey()));
        Service scs = ExperimentSetupHelper.findScsFromString((String)((ESpecTestConfig)this.getTestConfig()).getProvision().getScs(), (TestbedInfoSource)this.testbedInfoSource);
        this.experiment = new Experiment(null, this.sliceName, this.project, Collections.emptyList(), this.eSpecBundle, null, requestedEndTime, userSpecs, false, this.getRSpecGeneratorFactory(), (GitAuthPreferences)new SingleSshGitAuthPreferences(userPem), false, scs);
        this.experiment.addESpecLogListener((ESpecLogListener)this.eSpecLogHandler);
        this.experiment.getLogEntries().addListener(change -> {
            while (change.next()) {
                if (!change.wasAdded()) continue;
                change.getAddedSubList().forEach(arg_0 -> ((ApiTestResult.ApiTestMethodResult)this.currentTestResult).addLogLine(arg_0));
            }
        });
    }

    @ApiTest.Test(hardDepends={"createExperiment"}, groups={"run"})
    public void runExperiment() {
        long now;
        this.assertTrue(((ESpecTestConfig)this.getTestConfig()).getProvision().isEnabled(), "A disabled provision step is currently not supported.");
        this.notEnoughResourcesDetected = false;
        ExperimentControllerFactory experimentControllerFactory = (ExperimentControllerFactory)this.configInjector.getInstance(ExperimentControllerFactory.class);
        this.assertNotNull(experimentControllerFactory);
        this.experimentController = experimentControllerFactory.createExperimentController(this.experiment);
        this.assertNotNull(this.experimentController);
        this.experimentController.start();
        this.note("Started experimentController. ExperimentState is now " + this.experiment.getExperimentState());
        long maxTimeToWaitForReadyInMinutes = 0L;
        long extraWaitTimeInSeconds = 0L;
        if (!((ESpecTestConfig)this.getTestConfig()).getWaitForReady().isEnabled()) {
            this.waitForExperimentIsOver = true;
        }
        if (((ESpecTestConfig)this.getTestConfig()).getWaitForReady().getMaxTimeMin() > maxTimeToWaitForReadyInMinutes) {
            maxTimeToWaitForReadyInMinutes = ((ESpecTestConfig)this.getTestConfig()).getWaitForReady().getMaxTimeMin();
        }
        if (((ESpecTestConfig)this.getTestConfig()).getWaitForReady().getExtraWaitTimeSeconds() > extraWaitTimeInSeconds) {
            extraWaitTimeInSeconds = ((ESpecTestConfig)this.getTestConfig()).getWaitForReady().getExtraWaitTimeSeconds();
        }
        if (maxTimeToWaitForReadyInMinutes > 0L) {
            this.note("Starting to wait for experiment(s) to become ready at " + new Date() + " (max wait is " + maxTimeToWaitForReadyInMinutes + " minutes)");
        } else {
            this.note("Will not wait for experiment(s) to become ready.");
        }
        long start = now = System.currentTimeMillis();
        long deadline = now + maxTimeToWaitForReadyInMinutes * 60L * 1000L;
        boolean allDone = false;
        boolean sawFailure = false;
        while (now < deadline && !allDone && !sawFailure) {
            if (!this.waitForExperimentIsOver) {
                this.assertTrue(((ESpecTestConfig)this.getTestConfig()).getWaitForReady().isEnabled(), "bug in runExperiment step code.");
                this.note("Current ExperimentState=" + this.experiment.getExperimentState());
                if (this.experiment.getSliceUrn() != null) {
                    this.sliceUrn = this.experiment.getSliceUrn();
                }
                if (this.experiment.getExperimentState() == ExperimentState.READY) {
                    this.note("Ready, because ExperimentState is READY");
                    this.waitForExperimentIsOver = true;
                }
                if (this.experiment.getExperimentState().isTerminated()) {
                    this.waitForExperimentIsOver = true;
                    sawFailure = true;
                    this.errorNonFatal("Failure, because ExperimentState is terminated");
                }
                if (!this.experiment.getExperimentState().isActiveState()) {
                    this.waitForExperimentIsOver = true;
                    sawFailure = true;
                    this.errorNonFatal(String.format("Failure, because Experiment is not active state, but in %s", this.experiment.getExperimentState().toString()));
                }
            }
            if (!(allDone = this.waitForExperimentIsOver) && !sawFailure) {
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            now = System.currentTimeMillis();
        }
        long stop = now;
        this.addEmbeddedResult((Collection<JobReport>)this.experiment.getJobReports());
        this.currentTestResult.addEmbedded(this.eSpecLogHandler.getLogAsTestMethodResult());
        this.eSpecLogHandler.getFedmonResultExtras().forEach(arg_0 -> ((ApiTestResult.ApiTestMethodResult)this.currentTestResult).addExtraResult(arg_0));
        if (maxTimeToWaitForReadyInMinutes > 0L) {
            double waitTimeMinutes = (stop - start) / 60000L;
            this.note("Stopped waiting for experiment(s) to become ready at " + new Date() + " (Waited " + waitTimeMinutes + " minutes)");
        }
        if (extraWaitTimeInSeconds > 0L) {
            this.note("Waiting " + extraWaitTimeInSeconds + " extra seconds before continuing. (due to resource.waitForReady.extraWaitTimeSeconds option)");
            try {
                Thread.sleep(extraWaitTimeInSeconds * 1000L);
            }
            catch (InterruptedException e) {
                this.warn("Extra waiting time was interrupted. This should not happen.", e);
            }
        }
        if (sawFailure) {
            this.errorFatal("One or more experiments have failed.");
        }
        if (!allDone) {
            this.errorFatal("One or more experiments did not become ready by the deadline.");
        }
    }

    public boolean isValidGeniRspec(String rspec) {
        return new BasicStringRspec(rspec).isValidRspec();
    }

    @ApiTest.Test(hardDepends={"runExperiment"}, groups={"run"})
    public void checkManifest() throws JFedException, IOException {
        if (this.notEnoughResourcesDetected) {
            this.warn("Test skipped because not enough free resources detected while tying to create the sliver(s)");
            return;
        }
        Slice slice = this.experiment.getSliceOrNull();
        this.assertNotNull(slice, "experiment slice should not be null");
        ManifestRspecSource manifestRspecSource = slice.getManifestRspec();
        this.assertNotNull(manifestRspecSource, "experiment slice manifestRspecSource should not be null");
        this.manifestRspecString = manifestRspecSource.getRspecXmlString();
        this.assertNotNull(this.manifestRspecString, "experiment slice manifestRspecSource getRspecXmlString should not be null");
        String userPem = this.user == null || this.user.getPrivateKey() == null ? null : new String(KeyUtil.privateKeyToAnyPem((PrivateKey)this.user.getPrivateKey()));
        String requestRspec = new String(new FileFetcher(((RspecSpec)this.eSpec.getRspecs().get(0)).getSource(), this.eSpecBundle, this.getRSpecGeneratorFactory(), (GitAuthPreferences)new SingleSshGitAuthPreferences(userPem)).fetchBytes(), StandardCharsets.UTF_8);
        boolean validRequest = this.isValidGeniRspec(requestRspec);
        this.validManifest = this.isValidGeniRspec(this.manifestRspecString);
        if (requestRspec != null && validRequest && this.validManifest) {
            this.setErrorsNotFatal();
            this.assertTrue(CommonAMTest.sameNodesInRequestAndManifest((ApiTest)this, (String)requestRspec, (String)this.manifestRspecString));
            this.setErrorsFatal();
        }
        if (this.validManifest) {
            boolean foundNodeLogin = this.nodeLoginTestStep.parseSshInfoFromGeni3ManifestRspec(this.manifestRspecString, null, null);
            if (foundNodeLogin) {
                this.note("Successfully found node login in manifest");
            } else {
                this.note("Did not find node login info in manifest");
            }
            if (((ESpecTestConfig)this.getTestConfig()).getWaitForReady().getSkipFinalManifestCheck()) {
                this.nodeLoginTestStep.checkManifestCorrectness(this.manifestRspecString, this.testedAuthority);
            }
        }
    }

    @ApiTest.Test(softDepends={"runExperiment", "checkManifest"}, hardDepends={"getEspec", "createExperiment"}, groups={"cleanup", "run"})
    public void deleteExperiment() {
        if (((ESpecTestConfig)this.getTestConfig()).getCleanup().isEnabled()) {
            this.note("Will call experimentController.stop();");
            this.experimentController.stop();
        } else {
            this.note("Experiment Cleanup disabled");
            this.deleted = true;
        }
        long maxTimeToWaitForDeleteInMinutes = 0L;
        if (((ESpecTestConfig)this.getTestConfig()).getCleanup().getMaxWaitTimeMinutes() > maxTimeToWaitForDeleteInMinutes) {
            maxTimeToWaitForDeleteInMinutes = ((ESpecTestConfig)this.getTestConfig()).getCleanup().getMaxWaitTimeMinutes();
        }
        this.note("Will wait until experiment is terminated");
        long now = System.currentTimeMillis();
        long deadline = now + maxTimeToWaitForDeleteInMinutes * 60L * 1000L;
        boolean allDeleted = false;
        while (now < deadline && !this.deleted) {
            if (!this.deleted) {
                this.note("Current ExperimentState=" + this.experiment.getExperimentState());
                if (this.experiment.getExperimentState() == ExperimentState.EMPTY || this.experiment.getExperimentState() == ExperimentState.EXPIRED || this.experiment.getExperimentState() == ExperimentState.FAILED) {
                    this.note("Experiment was terminated");
                    this.deleted = true;
                }
            }
            if (!this.deleted) {
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            now = System.currentTimeMillis();
        }
        if (!this.deleted) {
            this.errorFatal("Experiment(s) did not terminate within " + maxTimeToWaitForDeleteInMinutes + " minutes. Gave up waiting for it.");
        } else {
            this.note("All experiments deleted");
        }
    }
}

