/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.commandline;

import be.iminds.ilabt.jfed.lib.CorePreferencesModule;
import be.iminds.ilabt.jfed.lib.PostLoginCoreModule;
import be.iminds.ilabt.jfed.lib.PreLoginCoreModule;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.module.BasicTestbedInfoModule;
import be.iminds.ilabt.jfed.module.JFedWebApiClientModule;
import be.iminds.ilabt.jfed.ui.commandline.BaseCliContextFileUserModule;
import be.iminds.ilabt.jfed.ui.commandline.BaseCliKeyCertUserModule;
import be.iminds.ilabt.jfed.ui.commandline.ContextFile;
import be.iminds.ilabt.jfed.ui.commandline.TestTargetFromContextFileModule;
import be.iminds.ilabt.jfed.ui.commandline.UncaughtCliExceptionLogger;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseCli {
    private static final Logger LOG = LoggerFactory.getLogger(BaseCli.class);
    protected AbstractModule authoritiesModule;
    protected AbstractModule preferencesModule;
    protected AbstractModule userModule;
    protected AbstractModule testTargetModule;

    public BaseCli(PrintStream err) {
        Thread.setDefaultUncaughtExceptionHandler(UncaughtCliExceptionLogger.getInstance(err));
    }

    public Injector getInjector(PrintStream err, AbstractModule ... extraModules) {
        return this.getInjector(err::println, extraModules);
    }

    public Injector getInjector(Consumer<String> err, AbstractModule ... extraModules) {
        assert (this.userModule != null);
        assert (this.authoritiesModule != null);
        if (this.userModule == null) {
            throw new RuntimeException("Bug in CLI implementation: userModule was not initialised.");
        }
        if (this.authoritiesModule == null) {
            throw new RuntimeException("Bug in CLI implementation: authoritiesModule was not initialised.");
        }
        if (this.preferencesModule == null) {
            this.preferencesModule = new CorePreferencesModule();
        }
        ArrayList<AbstractModule> mods = new ArrayList<AbstractModule>();
        mods.addAll(Arrays.asList(extraModules));
        mods.addAll(Arrays.asList(this.userModule, this.authoritiesModule, new PreLoginCoreModule(), new PostLoginCoreModule(), this.preferencesModule, new JFedWebApiClientModule()));
        String highLevelModuleClassname = "be.iminds.ilabt.jfed.highlevel.HighLevelModule";
        String sfaOnlyExperimentModuleClassname = "be.iminds.ilabt.jfed.highlevel.SfaOnlyExperimentModule";
        try {
            Class<?> highLevelModuleClass = Class.forName(highLevelModuleClassname);
            AbstractModule highLevelModule = (AbstractModule)highLevelModuleClass.newInstance();
            Class<?> sfaOnlyExperimentModuleClass = Class.forName(sfaOnlyExperimentModuleClassname);
            AbstractModule sfaOnlyExperimentModule = (AbstractModule)sfaOnlyExperimentModuleClass.newInstance();
            if (highLevelModule != null && sfaOnlyExperimentModule != null) {
                LOG.debug("Adding HighLevelModule to injector");
                mods.add(highLevelModule);
                LOG.debug("Adding SfaOnlyExperimentModule to injector");
                mods.add(sfaOnlyExperimentModule);
            }
        }
        catch (ClassNotFoundException e) {
            LOG.debug("HighLevelModule and/or SfaOnlyExperimentModule is not available: will not be added to injector");
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.warn("Unexpected exception while loading HighLevelModule or SfaOnlyExperimentModule. Will try to continue without them.", (Throwable)e);
        }
        if (this.testTargetModule != null) {
            mods.add(this.testTargetModule);
        }
        try {
            Injector injector = Guice.createInjector(mods);
            return injector;
        }
        catch (AssertionError | Exception e) {
            this.handleInjectException((Throwable)e, err);
            return null;
        }
    }

    public void handleInjectException(Throwable e, PrintStream err) {
        this.handleInjectException(e, err::println);
    }

    public void handleInjectException(Throwable e, Consumer<String> err) {
        for (Throwable curEx = e; curEx != null; curEx = curEx.getCause()) {
            if (curEx instanceof CliArgumentException) {
                err.accept("FATAL argument error: " + curEx.getMessage());
            }
            if (!(curEx instanceof ContextFile.ContextFileException)) continue;
            err.accept("FATAL context file error: " + curEx.getMessage());
        }
        err.accept("Fatal error (see message above), cannot continue.");
        try {
            LOG.error("Error creating injector", e);
        }
        catch (Exception ee) {
            LOG.error("Error creating injector, and additionally, an error processing the exception stacktrace. ", (Throwable)ee);
        }
    }

    public void initTestTargetFromContextFileModule(CommandLine line, PrintStream out, PrintStream err, InputStream in) throws CliArgumentException {
        try {
            this.testTargetModule = BaseCli.getTestTargetFromContextFileModule(line, out, err, in);
        }
        catch (CliArgumentException e) {
            LOG.debug("Got CliArgumentException", (Throwable)e);
            throw e;
        }
        catch (FileNotFoundException e) {
            LOG.debug("Got FileNotFoundException", (Throwable)e);
            throw new CliArgumentException("context file not found", e);
        }
        catch (IOException e) {
            LOG.debug("Got FileNotFoundException", (Throwable)e);
            throw new CliArgumentException("Error reading context file", e);
        }
    }

    public void initAuthoritiesModule(@Nullable CommandLine line) {
        String testbedsFilename = line == null ? null : line.getOptionValue("authorities-file");
        BasicTestbedInfoModule basicTestbedInfoModule = new BasicTestbedInfoModule();
        if (testbedsFilename != null) {
            this.preferencesModule = new CorePreferencesModule(testbedsFilename);
        }
        this.authoritiesModule = basicTestbedInfoModule;
    }

    public void initUserModule(CommandLine line, PrintStream out, PrintStream err, InputStream in) throws IOException, CliArgumentException {
        try {
            ArrayList<String> pemFilenames = new ArrayList<String>();
            if (line.getOptionValue("cert-and-key-file") != null) {
                pemFilenames.add(line.getOptionValue("cert-and-key-file"));
            }
            if (line.getOptionValue("key-file") != null) {
                pemFilenames.add(line.getOptionValue("key-file"));
            }
            if (line.getOptionValue("cert-file") != null) {
                pemFilenames.add(line.getOptionValue("cert-file"));
            }
            this.initUserModule(pemFilenames, line.getOptionValue("context-file"), line.getOptionValue("private-key-password"), line.hasOption("interactive"), in);
        }
        catch (CliArgumentException e) {
            err.println(e.getMessage());
            throw e;
        }
    }

    public Module initUserModule(@Nonnull List<String> pemFilenames, @Nullable String contextFilename, @Nullable String privateKeyPassword, boolean interactive, @Nullable InputStream in) throws IOException, CliArgumentException {
        if (in == null) {
            interactive = false;
        }
        if (contextFilename != null && !pemFilenames.isEmpty()) {
            throw new CliArgumentException("--context-file cannot be combined with -p (--cert-and-key-file)");
        }
        if (contextFilename == null && pemFilenames.isEmpty()) {
            throw new CliArgumentException("Either specify --cert-and-key-file (-p) or --context-file (-c) (exactly one).");
        }
        if (contextFilename == null) {
            boolean asked = false;
            Object usedServer = null;
            Object pemKeyCert = null;
            StringBuilder pem = new StringBuilder();
            for (String pemFilename : pemFilenames) {
                pem.append(IOUtils.fileToString((String)pemFilename)).append("\n");
            }
            boolean hasPassword = KeyUtil.isPemPrivateKeyEncrypted((String)pem.toString());
            char[] pass = null;
            if (hasPassword) {
                if (privateKeyPassword != null) {
                    pass = privateKeyPassword.toCharArray();
                } else {
                    if (!interactive) {
                        throw new CliArgumentException("FATAL: Not in interactive mode, so password cannot be requested.");
                    }
                    pass = IOUtils.askCommandLinePassword((String)"Private key password", (InputStream)in);
                }
            }
            this.userModule = new BaseCliKeyCertUserModule(pem.toString(), pass, new File(pemFilenames.get(0)), new File(pemFilenames.get(0)));
        } else {
            File contextFile = new File(contextFilename);
            if (!contextFile.exists()) {
                throw new FileNotFoundException("Cannot find Context properties file: " + contextFilename);
            }
            Properties contextFileProperties = new Properties();
            contextFileProperties.load(new FileInputStream(contextFile));
            this.userModule = new BaseCliContextFileUserModule(contextFileProperties);
        }
        assert (this.userModule != null);
        return this.userModule;
    }

    public static boolean checkUser(GeniUser user, CommandLine line, PrintStream out, PrintStream err, InputStream in) {
        return BaseCli.checkUser(user, err::println);
    }

    public static boolean checkUser(GeniUser user, Consumer<String> errOut) {
        List clientCertificateChain = user.getClientCertificateChain();
        int i = 0;
        for (X509Certificate c : clientCertificateChain) {
            try {
                c.checkValidity(new Date());
            }
            catch (CertificateExpiredException e) {
                errOut.accept("\nFATAL: Certificate " + i + " (of " + clientCertificateChain.size() + ") in the user certificate chain has expired. NotAfter=" + c.getNotAfter() + " now=" + new Date() + "\nCannot continue, exiting...");
                return false;
            }
            catch (CertificateNotYetValidException e) {
                errOut.accept("\nFATAL: Certificate " + i + " (of " + clientCertificateChain.size() + ") in the user certificate chain is not yet valid. NotBefore=" + c.getNotBefore() + " now=" + new Date() + "\nCannot continue, exiting...");
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void addUserConfig(Options options, String contextFileHelp, boolean addBackwardCompatibleOptions) {
        options.addOption(Option.builder((String)"p").longOpt("cert-and-key-file").desc("The file containing the user certificate and private key (both in PEM format)").hasArg().argName("FILE").build());
        if (addBackwardCompatibleOptions) {
            options.addOption("k", "key-file", true, "alias for --cert-and-key-file   (Only present for backward compatibility. Might be removed in future versions)");
        }
        options.addOption(Option.builder((String)"c").longOpt("context-file").desc(contextFileHelp).hasArg().argName("FILE").build());
        options.addOption(Option.builder((String)"P").longOpt("privkey-pass").desc("The password of the private key. Only used if private key is password protected. Default: interactively ask password when needed.").hasArg().argName("PASSWORD").build());
    }

    public static void addAuthoritiesConfig(Options options) {
        options.addOption(Option.builder().longOpt("authorities-file").desc("The xml file containing the list of known authorities. Default: choose automatically").hasArg().argName("AUTHORITIES XML FILE").build());
        options.addOption(Option.builder().longOpt("clearinghouse").desc("Fetch certificates etc from geni clearinghouse first").build());
    }

    public static TestTargetFromContextFileModule getTestTargetFromContextFileModule(CommandLine line, PrintStream out, PrintStream err, InputStream in) throws CliArgumentException, IOException {
        String testContextFilename = line.getOptionValue("context-file");
        if (testContextFilename == null || testContextFilename.isEmpty()) {
            throw new CliArgumentException("--context-file not specified");
        }
        File testContextFile = new File(testContextFilename);
        if (!testContextFile.exists()) {
            throw new FileNotFoundException("Cannot find Context properties file: " + testContextFilename);
        }
        Properties contextFileProperties = new Properties();
        contextFileProperties.load(new FileInputStream(testContextFile));
        return new TestTargetFromContextFileModule(contextFileProperties);
    }

    public static class CliArgumentException
    extends Exception {
        public CliArgumentException() {
        }

        public CliArgumentException(String message) {
            super(message);
        }

        public CliArgumentException(String message, Throwable cause) {
            super(message, cause);
        }

        public CliArgumentException(Throwable cause) {
            super(cause);
        }

        public CliArgumentException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }
}

