/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.commandline;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.ui.commandline.ContextFile;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseCliContextFileUserModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(BaseCliContextFileUserModule.class);
    private final Properties contextFileProperties;

    public BaseCliContextFileUserModule(Properties contextFileProperties) {
        this.contextFileProperties = contextFileProperties;
    }

    protected void configure() {
        this.bind(Properties.class).annotatedWith((Annotation)Names.named((String)"contextFileProperties")).toInstance((Object)this.contextFileProperties);
        this.bind(ContextFile.class);
    }

    @Provides
    public GeniUser provideGeniUser(ContextFile contextFile) {
        try {
            return contextFile.getUser();
        }
        catch (ContextFile.ContextFileException e) {
            throw new RuntimeException("Error getting user from context file", e);
        }
    }

    @Provides
    @Named(value="userServer")
    public Server provideUserAuthority(GeniUser geniUser) {
        return geniUser.getUserAuthorityServer();
    }

    @Provides
    public GeniUserProvider provideGeniUserProvider(final GeniUser geniUser) {
        return new GeniUserProvider(){

            @Nonnull
            public GeniUser getLoggedInGeniUser() {
                return geniUser;
            }

            public boolean isUserLoggedIn() {
                return geniUser != null;
            }
        };
    }
}

