/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.commandline;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserFactory;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.lowlevel.userloginmodel.InvalidLoginException;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseCliKeyCertUserModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(BaseCliKeyCertUserModule.class);
    private final String keyCertContent;
    private final char[] keyPass;
    private final File certificateKeyFile;
    private final File privateKeyFile;

    public BaseCliKeyCertUserModule(@Nonnull String keyCertContent, @Nullable char[] keyPass, @Nonnull File certificateKeyFile, @Nonnull File privateKeyFile) {
        this.keyCertContent = keyCertContent;
        this.keyPass = keyPass;
        this.certificateKeyFile = certificateKeyFile;
        this.privateKeyFile = privateKeyFile;
    }

    @Provides
    @Singleton
    public GeniUser getGeniUser(GeniUserFactory geniUserFactory) {
        try {
            return geniUserFactory.createGeniUser(this.keyCertContent, this.keyPass, this.certificateKeyFile, this.privateKeyFile);
        }
        catch (InvalidLoginException e) {
            LOG.error("Could not login the user", (Throwable)e);
            return null;
        }
    }

    @Provides
    @Singleton
    @Named(value="userUrn")
    public GeniUrn getUserUrn(GeniUser geniUser) {
        if (geniUser != null) {
            return geniUser.getUserUrn();
        }
        return null;
    }

    @Provides
    @Named(value="userServer")
    public Server provideGeniUserServer(GeniUser geniUser) {
        if (geniUser != null) {
            return geniUser.getUserAuthorityServer();
        }
        return null;
    }

    @Provides
    public GeniUserProvider provideGeniUserProvider(final GeniUser geniUser) {
        return new GeniUserProvider(){

            @Nonnull
            public GeniUser getLoggedInGeniUser() {
                return geniUser;
            }

            public boolean isUserLoggedIn() {
                return geniUser != null;
            }
        };
    }

    protected void configure() {
    }
}

