/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.commandline;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.lib.RetrySettings;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserFactory;
import be.iminds.ilabt.jfed.lowlevel.userloginmodel.InvalidLoginException;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextFile {
    private static final Logger LOG = LoggerFactory.getLogger(ContextFile.class);
    private final Properties prop;
    private final TestbedInfoSource testbedInfoSource;
    private final AuthorityFinder authorityFinder;

    @Inject
    public ContextFile(@Named(value="contextFileProperties") Properties prop, TestbedInfoSource testbedInfoSource, AuthorityFinder authorityFinder) {
        this.prop = prop;
        this.testbedInfoSource = testbedInfoSource;
        this.authorityFinder = authorityFinder;
        LOG.debug("ContextFile has TestbedInfoSource with " + testbedInfoSource.getServers().size() + " entries");
    }

    public GeniUser getUser() throws ContextFileException {
        return this.getUser("");
    }

    public GeniUser getUser(String userSuffix) throws ContextFileException {
        assert (userSuffix != null);
        String passwordFilename = this.prop.getProperty("passwordFilename" + userSuffix);
        String userUrnString = this.prop.getProperty("userUrn" + userSuffix);
        String pemKeyAndCertFilename = this.prop.getProperty("pemKeyAndCertFilename" + userSuffix);
        String userAuthorityUrnString = this.prop.getProperty("userAuthorityUrn" + userSuffix);
        if (passwordFilename != null) {
            passwordFilename = passwordFilename.trim();
        }
        if (userUrnString != null) {
            userUrnString = userUrnString.trim();
        }
        if (pemKeyAndCertFilename != null) {
            pemKeyAndCertFilename = pemKeyAndCertFilename.trim();
        }
        if (userAuthorityUrnString != null) {
            userAuthorityUrnString = userAuthorityUrnString.trim();
        }
        String password = null;
        if (passwordFilename != null && !passwordFilename.isEmpty()) {
            try {
                password = IOUtils.fileToString((String)passwordFilename).replaceAll("\n", "");
                assert (password != null);
            }
            catch (IOException e) {
                throw new ContextFileException("Error reading password from file \"" + passwordFilename + "\"", e);
            }
        }
        if (pemKeyAndCertFilename == null || pemKeyAndCertFilename.isEmpty()) {
            throw new ContextFileException("property \"pemKeyAndCertFilename" + userSuffix + "\" is missing");
        }
        try {
            GeniUserFactory geniUserFactory = new GeniUserFactory(this.authorityFinder);
            GeniUser geniUser = geniUserFactory.createGeniUser(new File(pemKeyAndCertFilename), password == null ? null : password.toCharArray());
            if (userUrnString != null && !geniUser.getUserUrnString().equals(userUrnString)) {
                throw new ContextFileException("provided user urn does not match URN in PEM: \"" + userUrnString + "\" != \"" + geniUser.getUserUrnString() + "\". Tip: don't provide the option \"userUrn" + userSuffix + "\" (it is optional)");
            }
            if (userAuthorityUrnString != null && geniUser.getUserAuthorityServer() != null && geniUser.getUserAuthorityServer().getDefaultComponentManagerUrn() != null && !geniUser.getUserAuthorityServer().getDefaultComponentManagerUrn().equals(userAuthorityUrnString)) {
                throw new ContextFileException("provided userAuthorityUrn does not match URN in PEM: \"" + userAuthorityUrnString + "\" != \"" + geniUser.getUserAuthorityServer().getDefaultComponentManagerUrn() + "\". Tip: don't provide the option \"userAuthorityUrn" + userSuffix + "\" (it is optional)");
            }
            return geniUser;
        }
        catch (InvalidLoginException e) {
            throw new ContextFileException("Could not login with provided info", e);
        }
    }

    public TargetAuthority getTestedAuthority() throws ContextFileException {
        Server sfaAuthorityForRspec;
        GeniUrn testedAggregateManagerUrnForRspec;
        GeniUrn testedAggregateManagerUrnToConnect;
        GeniUrn testedAggregateManagerUrn;
        String testedAggregateManagerUrnString = this.prop.getProperty("testedAggregateManagerUrn");
        String testedAggregateManagerUrnToConnectString = this.prop.getProperty("testedAggregateManagerUrnToConnect");
        String testedAggregateManagerUrnForRspecString = this.prop.getProperty("testedAggregateManagerUrnForRspec");
        if (testedAggregateManagerUrnString != null) {
            testedAggregateManagerUrnString = testedAggregateManagerUrnString.trim();
        }
        if (testedAggregateManagerUrnToConnectString != null) {
            testedAggregateManagerUrnToConnectString = testedAggregateManagerUrnToConnectString.trim();
        }
        if (testedAggregateManagerUrnForRspecString != null) {
            testedAggregateManagerUrnForRspecString = testedAggregateManagerUrnForRspecString.trim();
        }
        if ((testedAggregateManagerUrnString == null || testedAggregateManagerUrnString.isEmpty()) && (testedAggregateManagerUrnToConnectString == null || testedAggregateManagerUrnToConnectString.isEmpty())) {
            throw new ContextFileException("property \"testedAggregateManagerUrn\" or \"testedAggregateManagerUrnToConnect\" is missing");
        }
        if ((testedAggregateManagerUrnString == null || testedAggregateManagerUrnString.isEmpty()) && (testedAggregateManagerUrnForRspecString == null || testedAggregateManagerUrnForRspecString.isEmpty())) {
            throw new ContextFileException("property \"testedAggregateManagerUrn\" or \"testedAggregateManagerUrnForRspec\" is missing");
        }
        try {
            testedAggregateManagerUrn = testedAggregateManagerUrnString != null ? new GeniUrn(testedAggregateManagerUrnString) : null;
        }
        catch (GeniUrn.GeniUrnParseException e) {
            throw new ContextFileException("testedAggregateManagerUrn is not valid: \"" + testedAggregateManagerUrnString + "\"", e);
        }
        try {
            testedAggregateManagerUrnToConnect = testedAggregateManagerUrnToConnectString != null ? new GeniUrn(testedAggregateManagerUrnToConnectString) : null;
        }
        catch (GeniUrn.GeniUrnParseException e) {
            throw new ContextFileException("testedAggregateManagerToConnectUrn is not valid: \"" + testedAggregateManagerUrnToConnectString + "\"", e);
        }
        try {
            testedAggregateManagerUrnForRspec = testedAggregateManagerUrnForRspecString != null ? new GeniUrn(testedAggregateManagerUrnForRspecString) : null;
        }
        catch (GeniUrn.GeniUrnParseException e) {
            throw new ContextFileException("testedAggregateManagerForRspecUrn is not valid: \"" + testedAggregateManagerUrnForRspecString + "\"", e);
        }
        if (testedAggregateManagerUrnToConnect != null && testedAggregateManagerUrnForRspec != null && testedAggregateManagerUrn != null) {
            LOG.warn("having 3 testedAggregateManagerUrn options in the context file makes no sense. testedAggregateManagerUrn will be ignored.");
        }
        Server sfaAuthorityToConnect = testedAggregateManagerUrnToConnect != null ? this.testbedInfoSource.getByUrnExact(testedAggregateManagerUrnToConnect) : this.authorityFinder.findByUrn(testedAggregateManagerUrn, AuthorityFinder.Purpose.CREATE_SLIVER);
        Server server = sfaAuthorityForRspec = testedAggregateManagerUrnForRspec != null ? this.testbedInfoSource.getByUrnExact(testedAggregateManagerUrnForRspec) : this.authorityFinder.findByUrn(testedAggregateManagerUrn, AuthorityFinder.Purpose.REQUEST_RSPEC);
        if (sfaAuthorityToConnect == null && testedAggregateManagerUrnToConnect != null) {
            throw new ContextFileException("testedAggregateManagerUrnToConnect \"" + testedAggregateManagerUrnToConnectString + "\" is not a known authority");
        }
        if (sfaAuthorityToConnect == null && testedAggregateManagerUrnToConnect == null) {
            throw new ContextFileException("testedAggregateManagerUrn \"" + testedAggregateManagerUrnString + "\" is not a known authority");
        }
        if (sfaAuthorityForRspec == null && testedAggregateManagerUrnForRspec != null) {
            throw new ContextFileException("testedAggregateManagerUrnForRspec \"" + testedAggregateManagerUrnForRspecString + "\" is not a known authority");
        }
        if (sfaAuthorityForRspec == null && testedAggregateManagerUrnForRspec == null) {
            throw new ContextFileException("testedAggregateManagerUrn \"" + testedAggregateManagerUrnString + "\" is not a known authority");
        }
        TargetAuthority res = new TargetAuthority(testedAggregateManagerUrn, sfaAuthorityForRspec, sfaAuthorityToConnect);
        return res;
    }

    public Properties getProperties() {
        return this.prop;
    }

    public void setTimeoutAndBusyHandlingFromProperties(JFedPreferences jFedPreferences) {
        String timeoutMsBeforeRetry = this.prop.getProperty("timoutRetryIntervalMs", "5000");
        String timeoutMaxRetries = this.prop.getProperty("timoutRetryMaxCount", "3");
        String busyMsBeforeRetry = this.prop.getProperty("busyRetryIntervalMs", "5000");
        String busyMaxRetries = this.prop.getProperty("busyRetryMaxCount", "24");
        String possibleTemporaryErrorMsBeforeRetry = this.prop.getProperty("possibleTemporaryErrorMsBeforeRetry", "1000");
        String possibleTemporaryErrorMaxRetries = this.prop.getProperty("possibleTemporaryErrorMaxRetries", "1");
        jFedPreferences.setRetrySettings(new RetrySettings(Integer.parseInt(timeoutMaxRetries), Long.parseLong(timeoutMsBeforeRetry), Integer.parseInt(busyMaxRetries), Long.parseLong(busyMsBeforeRetry), Integer.parseInt(possibleTemporaryErrorMaxRetries), Long.parseLong(possibleTemporaryErrorMsBeforeRetry)));
    }

    public class ContextFileException
    extends Exception {
        public ContextFileException() {
        }

        public ContextFileException(String message) {
            super(message);
        }

        public ContextFileException(String message, Throwable cause) {
            super(message, cause);
        }

        public ContextFileException(Throwable cause) {
            super(cause);
        }
    }
}

