function switchVisibility(obj) {
    var el = document.getElementById(obj);
    if (typeof el !== 'undefined' && el !== null) {
        if ( el.style.display != "none" ) {
            el.style.display = 'none';
            return false;
        } else {
            el.style.display = 'block';
            return true;
        }
    }
    return false;
}

function setVisibility(obj, visible) {
    var el = document.getElementById(obj);
    if (typeof el !== 'undefined' && el !== null) {
        if (!visible) {
            el.style.display = 'none';
        } else {
            el.style.display = 'block';
        }
    }
}

function switchRevealClassActive(obj) {
    var el = document.getElementById(obj);
    if (typeof el !== 'undefined' && el !== null) {
        var newActive = ! el.classList.contains("reveal-active");
        // el.classList.toggle("reveal", !newActive);
        el.classList.toggle("reveal-active", newActive);
        return newActive;
    }
    return false;
}
function setRevealClassActive(obj, active) {
    var el = document.getElementById(obj);
    if (typeof el !== 'undefined' && el !== null) {
        // el.classList.toggle("reveal", !active);
        el.classList.toggle("reveal-active", active);
    }
}

function switchClassVisibility(className) {
    var elList = document.getElementsByClassName(className);
    var i;
    for (i = 0; i < elList.length; i++) {
        var el = elList[i];
        if ( el.style.display != "none" ) {
            el.style.display = 'none';
        } else {
            el.style.display = 'block';
        }
    }
}

function formatXmlDiv(sourceId, targetId) {
    var sourceEl = document.getElementById(sourceId);
    var targetEl = document.getElementById(targetId);

    if (typeof sourceEl !== 'undefined' && sourceEl !== null &&
        typeof targetEl !== 'undefined' && targetEl !== null &&
        targetEl.textContent === 'loading...') {
        targetEl.textContent = "prettifying...";
        targetEl.textContent = vkbeautify.xml(sourceEl.textContent);
    }
}

function isRspec(toTest) {
    //a bit simple. but good enough
    var header = toTest.substring(0, 50);
    return header.includes('<rspec');
}

function getEmbeddedRspec(base) {
    var objectsToSearch = [ base ];
    while (objectsToSearch.length > 0) {
        var cur = objectsToSearch.shift();

        if (typeof cur === 'string') {
            if (isRspec(cur))
                return cur;
        } else if (typeof cur === 'object') {
            if (Array.isArray(cur)) {
                for (var i = 0; i < cur.length; i++) {
                    objectsToSearch.push(cur[i]);
                }
            } else {
                //assume it's an object
                for (var property in cur) {
                    if (cur.hasOwnProperty(property)) {
                        objectsToSearch.push(cur[property]);
                    }
                }
            }
        }
    }

    return null;
}
function getEmbeddedRspecDiv(sourceId, targetId) {
    var sourceEl = document.getElementById(sourceId);
    var targetEl = document.getElementById(targetId);

    if (typeof sourceEl !== 'undefined' && sourceEl !== null &&
        typeof targetEl !== 'undefined' && targetEl !== null &&
        targetEl.textContent === 'loading...') {
        targetEl.textContent = "searching...";
        var sourceObj = JSON.parse(sourceEl.textContent);
        var rspec = getEmbeddedRspec(sourceObj);

        targetEl.textContent = rspec;
    }
}
function formatEmbeddedRspecDiv(sourceId, targetId) {
    var sourceEl = document.getElementById(sourceId);
    var targetEl = document.getElementById(targetId);

    if (typeof sourceEl !== 'undefined' && sourceEl !== null &&
        typeof targetEl !== 'undefined' && targetEl !== null &&
        targetEl.textContent === 'loading...') {
        targetEl.textContent = "searching...";
        var sourceObj = JSON.parse(sourceEl.textContent);
        var rspec = getEmbeddedRspec(sourceObj);

        targetEl.textContent = "prettifying...";
        targetEl.textContent = vkbeautify.xml(rspec);
    }
}

function formatQuotedStringAsXmlDiv(sourceId, targetId) {
    var sourceEl = document.getElementById(sourceId);
    var targetEl = document.getElementById(targetId);

    if (typeof sourceEl !== 'undefined' && sourceEl !== null &&
        typeof targetEl !== 'undefined' && targetEl !== null &&
        targetEl.textContent === 'loading...') {
        // type: string
        var input = sourceEl.textContent;

        if (input.startsWith('"') && input.endsWith('"')) {
            input = input.substring(1, input.size() - 1);
        }
        targetEl.textContent = "prettifying...";
        targetEl.textContent = vkbeautify.xml(input);
    }
}

/** returns base64 encoded and zlib'ed RSpec */
function getCompressedRSpec(base) {
    var objectsToSearch = [ base ];
    while (objectsToSearch.length > 0) {
        var cur = objectsToSearch.shift();

        if (typeof cur === 'string') {
            //if all we find is a string, use it.
            return cur;
        } else if (typeof cur === 'object') {
            if (Array.isArray(cur)) {
                //ignore list content unless it is an object
                for (var i = 0; i < cur.length; i++) {
                    if (typeof cur[i] === 'object') {
                        objectsToSearch.push(cur[i]);
                    }
                }
            } else {
                //assume it's an object
                for (var property in cur) {
                    if (cur.hasOwnProperty(property)) {
                        if (property.includes('rspec') && typeof cur[property] === 'string') {
                            //embedded RSpec
                            // objectsToSearch.push(cur[property]);
                            return cur[property];
                        }
                    }
                }
            }
        }
    }

    return null;
}

/** write progress and errors to targetEl as well*/
function getCompressedRSpecAndDecompress(base, sourceId, targetEl) {
    var compressedRspec = getCompressedRSpec(base);

    if (compressedRspec === null) {
        targetEl.textContent = "ERROR finding compressed RSpec: " + err;
        console.log("ERROR Finding compressed RSpec in " + sourceId);
        return null;
    }

    try {
        targetEl.textContent = "de-base64-ing...";
        var encodedBase64In = compressedRspec.trim().replace(/\n/g, '');
        console.log("Base64 encoded input first 4 chars: "+encodedBase64In.slice(0, 4));
        var binData = base64js.toByteArray(encodedBase64In);
        // console.log("Base64 decoded output type: "+typeof(binData));
        console.log("Base64 decoded output first 4 bytes: "+binData[0]+" "+binData[1]+" "+binData[2]+" "+binData[3]);
    } catch(err) {
        targetEl.textContent = "ERROR de-base64-ing: "+err;
        console.log("ERROR de-base64-ing from "+sourceId);
        // throw err;
        return null;
    }

    try {
        targetEl.textContent = "inflating...";
        var inflater = new Zlib.Inflate(binData);
        var uint8array = inflater.decompress();

        // targetEl.textContent = new TextDecoder("utf-8").decode(uint8array);
        return new TextDecoder("utf-8").decode(uint8array);

        // //var data = pako.inflate(binData);
        // //Convert gunzipped byteArray back to ascii string:
        // //targetEl.textContent = String.fromCharCode.apply(null, new Uint16Array(data));
    } catch(err) {
        targetEl.textContent = "ERROR inflating: "+err;
        console.log("ERROR inflating from "+sourceId+" -> first byte (typically 120): "+binData[0]);
        // throw err;
        return null;
    }
}

function formatCompressedXmlDiv(sourceId, targetId) {
    var sourceEl = document.getElementById(sourceId);
    var targetEl = document.getElementById(targetId);

    if (typeof sourceEl !== 'undefined' && sourceEl !== null &&
        typeof targetEl !== 'undefined' && targetEl !== null &&
        targetEl.textContent === 'loading...') {

        var sourceObj = sourceEl.textContent.trim();
        if (sourceObj.startsWith('{') || sourceObj.startsWith('[')) {
            sourceObj = JSON.parse(sourceEl.textContent);
        }
        var rawDecompressed = getCompressedRSpecAndDecompress(sourceObj, sourceId, targetEl);

        try {
            targetEl.textContent = "prettifying...";
            targetEl.textContent = vkbeautify.xml(rawDecompressed);
        } catch(err) {
            targetEl.textContent = "ERROR while prettifying";
            console.log("ERROR while prettifying from "+sourceId);
            throw err;
        }
    }
}
function decompressedDiv(sourceId, targetId) {
    var sourceEl = document.getElementById(sourceId);
    var targetEl = document.getElementById(targetId);

    if (typeof sourceEl !== 'undefined' && sourceEl !== null &&
        typeof targetEl !== 'undefined' && targetEl !== null &&
        targetEl.textContent === 'loading...') {

        var sourceObj = sourceEl.textContent.trim();
        if (sourceObj.startsWith('{') || sourceObj.startsWith('[')) {
            sourceObj = JSON.parse(sourceEl.textContent);
        }
        var rawDecompressed = getCompressedRSpecAndDecompress(sourceObj, sourceId, targetEl);
        targetEl.textContent = rawDecompressed;
    }
}

function copyDiv(sourceId, targetId) {
    var sourceEl = document.getElementById(sourceId);
    var targetEl = document.getElementById(targetId);

    if (typeof sourceEl !== 'undefined' && sourceEl !== null &&
        typeof targetEl !== 'undefined' && targetEl !== null &&
        targetEl.textContent === 'loading...') {
        targetEl.textContent = "copying...";
        targetEl.textContent = sourceEl.textContent;
    }
}
// function formatJsonDiv(sourceId, targetId) {
//
// }

