/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOmittingSerializationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOmittingSerializationUtil.class);

    private DefaultOmittingSerializationUtil() {
    }

    private static void iterateSubMaps(Map<String, ?> source, BiConsumer<String, Map<String, ?>> action) {
        source.entrySet().stream().filter(e -> e.getValue() instanceof Map).forEach(e -> action.accept((String)e.getKey(), (Map)e.getValue()));
    }

    private static void iterateSubList(Map<String, ?> source, BiConsumer<String, List<?>> action) {
        source.entrySet().stream().filter(e -> e.getValue() instanceof List).forEach(e -> action.accept((String)e.getKey(), (List)e.getValue()));
    }

    private static void iterateNonCollections(Map<String, ?> source, BiConsumer<String, Object> action) {
        source.entrySet().stream().filter(e -> !(e.getValue() instanceof Map) && !(e.getValue() instanceof List)).forEach(e -> action.accept((String)e.getKey(), e.getValue()));
    }

    private static void iterateSubMaps(List<?> source, BiConsumer<Integer, Map<String, ?>> action) {
        for (int i = 0; i < source.size(); ++i) {
            Object item = source.get(i);
            if (!(item instanceof Map)) continue;
            action.accept(i, (Map)item);
        }
    }

    private static void iterateSubList(List<?> source, BiConsumer<Integer, List<?>> action) {
        for (int i = 0; i < source.size(); ++i) {
            Object item = source.get(i);
            if (!(item instanceof List)) continue;
            action.accept(i, (List)item);
        }
    }

    private static void iterateNonCollections(List<?> source, BiConsumer<Integer, Object> action) {
        for (int i = 0; i < source.size(); ++i) {
            Object item = source.get(i);
            if (item instanceof Map || item instanceof List) continue;
            action.accept(i, item);
        }
    }

    private static Map<String, Object> deepCopy(Map<String, ?> source) {
        LinkedList<CopyJob> jobs = new LinkedList<CopyJob>();
        HashMap<String, Object> res = new HashMap<String, Object>();
        CopyMapJob job = new CopyMapJob(source, res);
        jobs.push(job);
        while (!jobs.isEmpty()) {
            ((CopyJob)jobs.pop()).run(jobs);
        }
        return res;
    }

    private static List<Keys> getNestedKeys(Map<String, ?> source) {
        ArrayList<Keys> res = new ArrayList<Keys>();
        LinkedList<KeyIterateJob> jobs = new LinkedList<KeyIterateJob>();
        KeyIterateJob job = new KeyIterateJob(source, new Keys(Collections.emptyList()), res, jobs);
        jobs.push(job);
        while (!jobs.isEmpty()) {
            ((KeyIterateJob)jobs.pop()).run();
        }
        return res;
    }

    @Nullable
    private static Object getByNestedKey(Map<String, ?> source, Keys keys) {
        LOG.debug("getByNestedKey(?, " + keys + ")");
        Map<String, Object> curPos = source;
        for (Object k : keys.keys) {
            if (curPos instanceof Map) {
                curPos = curPos.get((String)k);
                continue;
            }
            if (curPos instanceof List) {
                List l;
                int index = (Integer)k;
                if (index >= (l = (List)((Object)curPos)).size()) {
                    return null;
                }
                curPos = l.get((Integer)k);
                continue;
            }
            return null;
        }
        return curPos;
    }

    private static void removeByKey(Map<String, ?> target, Keys keys) {
        List list;
        int index;
        LOG.debug("removeByKey(?, " + keys + ")");
        Map<String, Object> curPos = target;
        assert (keys.keys.size() > 0);
        LinkedList<Object> firstKeys = new LinkedList<Object>(keys.keys);
        Object lastKey = firstKeys.removeLast();
        for (Object e : firstKeys) {
            if (curPos instanceof Map) {
                curPos = curPos.get((String)e);
                continue;
            }
            if (curPos instanceof List) {
                List l2;
                int index2 = (Integer)e;
                if (index2 >= (l2 = (List)((Object)curPos)).size()) {
                    return;
                }
                curPos = l2.get(index2);
                continue;
            }
            return;
        }
        if (curPos instanceof Map) {
            curPos.remove((String)lastKey);
        } else if (curPos instanceof List && (index = ((Integer)lastKey).intValue()) < (list = (List)((Object)curPos)).size()) {
            list.remove(index);
        }
    }

    private static boolean removeByKeyIfEmpty(Map<String, ?> target, Keys keys) {
        LOG.debug("removeByKeyIfEmpty(?, " + keys + ")");
        Map<String, Object> curPos = target;
        assert (keys.keys.size() > 0);
        for (Object k : keys.keys) {
            if (curPos instanceof Map) {
                Map<String, ?> m = curPos;
                Object newCurPos = m.get((String)k);
                if (newCurPos instanceof Map && ((Map)newCurPos).isEmpty()) {
                    m.remove(k);
                    LOG.debug("removeByKeyIfEmpty removes " + k);
                    return true;
                }
                if (newCurPos instanceof List && ((List)newCurPos).isEmpty()) {
                    m.remove(k);
                    LOG.debug("removeByKeyIfEmpty removes " + k);
                    return true;
                }
                curPos = newCurPos;
                continue;
            }
            if (curPos instanceof List) {
                List l;
                int index = (Integer)k;
                if (index >= (l = (List)((Object)curPos)).size()) {
                    return false;
                }
                Object newCurPos = l.get(index);
                if (newCurPos instanceof Map && ((Map)newCurPos).isEmpty()) {
                    l.remove(index);
                    LOG.debug("removeByKeyIfEmpty removes " + index);
                    return true;
                }
                if (newCurPos instanceof List && ((List)newCurPos).isEmpty()) {
                    l.remove(index);
                    LOG.debug("removeByKeyIfEmpty removes " + index);
                    return true;
                }
                curPos = newCurPos;
                continue;
            }
            return false;
        }
        return false;
    }

    public static Map<String, ?> omitDefault(Map<String, ?> target, Map<String, ?> defaults) {
        Map<String, Object> res = DefaultOmittingSerializationUtil.deepCopy(target);
        LOG.debug("target=" + DefaultOmittingSerializationUtil.debugPrint(target));
        LOG.debug("defaults=" + DefaultOmittingSerializationUtil.debugPrint(defaults));
        if (!DefaultOmittingSerializationUtil.debugPrint(target).equals(DefaultOmittingSerializationUtil.debugPrint(res))) {
            LOG.error("deepCopy differs!");
            LOG.debug("target=" + DefaultOmittingSerializationUtil.debugPrint(target));
            LOG.debug("deepCopy=" + DefaultOmittingSerializationUtil.debugPrint(res));
        }
        List<Keys> keysList = Collections.unmodifiableList(DefaultOmittingSerializationUtil.getNestedKeys(target));
        LOG.debug("keysList=" + keysList);
        List<Keys> keysToRemove = new ArrayList();
        for (Keys keys : keysList) {
            Object targetVal = DefaultOmittingSerializationUtil.getByNestedKey(target, keys);
            Object defaultVal = DefaultOmittingSerializationUtil.getByNestedKey(defaults, keys);
            if (defaultVal != targetVal) continue;
            keysToRemove.add(keys);
        }
        keysToRemove = Collections.unmodifiableList(keysToRemove);
        LOG.debug("keysToRemove=" + keysToRemove);
        for (Keys keys : keysToRemove) {
            DefaultOmittingSerializationUtil.removeByKey(res, keys);
        }
        boolean hasChanged = true;
        while (hasChanged) {
            hasChanged = false;
            for (Keys keys : keysList) {
                hasChanged |= DefaultOmittingSerializationUtil.removeByKeyIfEmpty(res, keys);
            }
            LOG.debug("removeByKeyIfEmpty hasChanged=" + hasChanged);
        }
        LOG.debug("res=" + DefaultOmittingSerializationUtil.debugPrint(res));
        return res;
    }

    private static String debugPrint(Object o) {
        try {
            return new ObjectMapper().writerWithDefaultPrettyPrinter().withFeatures(new SerializationFeature[]{SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS}).writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static class CopyMapJob
    implements CopyJob {
        private final Map<String, ?> source;
        private final Map<String, Object> target;

        public CopyMapJob(Map<String, ?> source, Map<String, Object> target) {
            this.source = source;
            this.target = target;
        }

        @Override
        public void run(Deque<CopyJob> jobs) {
            DefaultOmittingSerializationUtil.iterateNonCollections(this.source, (key, v) -> this.target.put((String)key, v));
            DefaultOmittingSerializationUtil.iterateSubMaps(this.source, (key, v) -> {
                HashMap<String, Object> copy = new HashMap<String, Object>((Map<String, Object>)v);
                this.target.put((String)key, copy);
                jobs.push(new CopyMapJob((Map<String, ?>)v, (Map<String, Object>)copy));
            });
            DefaultOmittingSerializationUtil.iterateSubList(this.source, (key, v) -> {
                ArrayList<Object> copy = new ArrayList<Object>((Collection<Object>)v);
                this.target.put((String)key, copy);
                jobs.push(new CopyListJob((List<?>)v, (List<Object>)copy));
            });
        }
    }

    private static interface CopyJob {
        public void run(Deque<CopyJob> var1);
    }

    private static class KeyIterateJob
    implements Runnable {
        private final Object collection;
        private final Keys curKeys;
        private final List<Keys> resultKeys;
        private final Collection<KeyIterateJob> jobs;

        public KeyIterateJob(Object collection, Keys curKeys, List<Keys> resultKeys, Collection<KeyIterateJob> jobs) {
            this.collection = collection;
            this.curKeys = curKeys;
            this.resultKeys = resultKeys;
            this.jobs = jobs;
        }

        @Override
        public void run() {
            if (this.collection instanceof Map) {
                Map m = (Map)this.collection;
                if (m.isEmpty()) {
                    this.resultKeys.add(this.curKeys);
                } else {
                    DefaultOmittingSerializationUtil.iterateNonCollections(m, (k, v) -> this.resultKeys.add(new Keys(this.curKeys, k)));
                    DefaultOmittingSerializationUtil.iterateSubMaps(m, (k, v) -> this.jobs.add(new KeyIterateJob(v, new Keys(this.curKeys, k), this.resultKeys, this.jobs)));
                    DefaultOmittingSerializationUtil.iterateSubList(m, (k, v) -> this.jobs.add(new KeyIterateJob(v, new Keys(this.curKeys, k), this.resultKeys, this.jobs)));
                }
            }
            if (this.collection instanceof List) {
                List l = (List)this.collection;
                if (l.isEmpty()) {
                    this.resultKeys.add(this.curKeys);
                } else {
                    DefaultOmittingSerializationUtil.iterateNonCollections(l, (k, v) -> this.resultKeys.add(new Keys(this.curKeys, k)));
                    DefaultOmittingSerializationUtil.iterateSubMaps(l, (k, v) -> this.jobs.add(new KeyIterateJob(v, new Keys(this.curKeys, k), this.resultKeys, this.jobs)));
                    DefaultOmittingSerializationUtil.iterateSubList(l, (k, v) -> this.jobs.add(new KeyIterateJob(v, new Keys(this.curKeys, k), this.resultKeys, this.jobs)));
                }
            }
        }
    }

    private static class Keys {
        List<Object> keys;

        public Keys(List<Object> keys) {
            this.keys = new ArrayList<Object>(keys);
        }

        public Keys(Keys base, Object sub) {
            this.keys = new ArrayList<Object>(base.keys);
            this.keys.add(sub);
        }

        public String toString() {
            return "Keys{" + this.keys.stream().map(Object::toString).collect(Collectors.joining(", ")) + "}";
        }
    }

    private static class CopyListJob
    implements CopyJob {
        private final List<?> source;
        private final List<Object> target;

        public CopyListJob(List<?> source, List<Object> target) {
            this.source = source;
            this.target = target;
        }

        @Override
        public void run(Deque<CopyJob> jobs) {
            DefaultOmittingSerializationUtil.iterateNonCollections(this.source, (index, v) -> this.target.set((int)index, v));
            DefaultOmittingSerializationUtil.iterateSubMaps(this.source, (index, v) -> {
                HashMap<String, Object> copy = new HashMap<String, Object>((Map<String, Object>)v);
                this.target.set((int)index, copy);
                jobs.push(new CopyMapJob((Map<String, ?>)v, (Map<String, Object>)copy));
            });
            DefaultOmittingSerializationUtil.iterateSubList(this.source, (index, v) -> {
                ArrayList<Object> copy = new ArrayList<Object>((Collection<Object>)v);
                this.target.set((int)index, copy);
                jobs.push(new CopyListJob((List<?>)v, (List<Object>)copy));
            });
        }
    }
}

