/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.authority;

import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClientConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClientDirect;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClientPropertiesConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Federation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Organisation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServiceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedCategory;
import be.iminds.ilabt.jfed.lowlevel.authority.StoredTestbedInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.BasicTestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.lib.ConnectivityDetector;
import be.iminds.ilabt.jfed.util.library.JFedTrustStore;
import be.iminds.ilabt.jfed.util.library.JFedUtils;
import com.google.inject.name.Named;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JFedTestbedInfoSource
implements Provider<TestbedInfoSource> {
    private static final Logger LOG = LoggerFactory.getLogger(JFedTestbedInfoSource.class);
    private static final File cachedTestbedsFile = JFedTestbedInfoSource.getCachedTestbedsFile();
    private static final File extraTestbedsDir = JFedTestbedInfoSource.getExtraTestbedsDir();
    private static final File overwriteTestbedsDir = JFedTestbedInfoSource.getOverwriteTestbedsDir();
    @Nonnull
    private final String userPreference;
    @Nonnull
    private final ConnectivityDetector connectivityDetector;
    @Nonnull
    private final URL webApiUrl;
    @Nullable
    private final be.iminds.ilabt.jfed.log.Logger logger;
    private static int extraTestbedUniqueId = 43210;

    @Inject
    public JFedTestbedInfoSource(@Nonnull JFedPreferences jFedPreferences, @Nonnull ConnectivityDetector connectivityDetector, @Nonnull @Named(value="noClientAuthWebApiUrl") URL webApiUrl, @Nullable be.iminds.ilabt.jfed.log.Logger logger) {
        String pref = jFedPreferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_TESTBEDS_JSON_SOURCE);
        this.userPreference = pref == null ? "AUTO" : pref;
        this.connectivityDetector = connectivityDetector;
        this.webApiUrl = webApiUrl;
        this.logger = logger;
    }

    @Nullable
    public static File getCachedTestbedsFile() {
        String userDataDir = JFedUtils.getUserDataDirectory();
        if (userDataDir == null) {
            return null;
        }
        return new File(userDataDir, "testbeds_cache.json");
    }

    @Nullable
    public static File getExtraTestbedsDir() {
        String userDataDir = JFedUtils.getUserDataDirectory();
        if (userDataDir == null) {
            return null;
        }
        return new File(userDataDir, "extra_testbeds");
    }

    @Nullable
    public static File getOverwriteTestbedsDir() {
        String userDataDir = JFedUtils.getUserDataDirectory();
        if (userDataDir == null) {
            return null;
        }
        return new File(userDataDir, "overwrite_testbeds");
    }

    @Nonnull
    public static List<File> getExtraTestbedFiles() {
        if (!extraTestbedsDir.exists() || !extraTestbedsDir.isDirectory()) {
            return Collections.emptyList();
        }
        File[] extraFiles = extraTestbedsDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".json"));
        return extraFiles == null ? Collections.emptyList() : Arrays.asList(extraFiles);
    }

    @Nonnull
    public static List<File> getOverwriteTestbedFiles() {
        if (!overwriteTestbedsDir.exists() || !overwriteTestbedsDir.isDirectory()) {
            return Collections.emptyList();
        }
        File[] overwriteFiles = overwriteTestbedsDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".json"));
        return overwriteFiles == null ? Collections.emptyList() : Arrays.asList(overwriteFiles);
    }

    private FedmonWebApiClient getFedmonWebApiClient(URL url) throws Exception {
        Properties fedmonWebApiClientConfigProperties = new Properties();
        fedmonWebApiClientConfigProperties.setProperty("webapi_client_url_read_base", url.toExternalForm());
        fedmonWebApiClientConfigProperties.setProperty("webapi_client_url_write_base", "https://localhost/");
        JFedTrustStore bootstrapTrustStore = new JFedTrustStore();
        FedmonWebApiClientPropertiesConfig fedmonWebApiClientConfig = new FedmonWebApiClientPropertiesConfig(fedmonWebApiClientConfigProperties, bootstrapTrustStore, null, null, this.logger);
        FedmonWebApiClientDirect fedmonWebApiClient = new FedmonWebApiClientDirect((FedmonWebApiClientConfig)fedmonWebApiClientConfig);
        return fedmonWebApiClient;
    }

    private List<Testbed> getTestbedsUsingUrl(URL url) throws Exception {
        List testbeds;
        FedmonWebApiClient fedmonWebApiClient = this.getFedmonWebApiClient(url);
        try {
            testbeds = fedmonWebApiClient.getAll(Testbed.class, true);
        }
        catch (FedmonWebApiClient.FedmonWebApiClientException e) {
            throw new RuntimeException("Failed to fetch Testbed info from server", e);
        }
        return testbeds;
    }

    public TestbedInfoSource get() {
        List testbedCategories;
        List organisations;
        List federations;
        List<Testbed> testbeds;
        boolean tryBuiltIn;
        block53: {
            String altUrl = null;
            String filename = null;
            boolean builtinOnly = false;
            boolean cacheOnly = false;
            assert (this.userPreference != null);
            String testbedsSourcePref = this.userPreference;
            if (!testbedsSourcePref.equalsIgnoreCase("AUTO") && !testbedsSourcePref.equalsIgnoreCase("DEFAULT")) {
                LOG.debug("Skipping default testbedInfo method, and using user specified method: \"" + this.userPreference + "\"");
                if (testbedsSourcePref.equalsIgnoreCase("BUILTIN")) {
                    builtinOnly = true;
                } else if (testbedsSourcePref.equalsIgnoreCase("CACHE")) {
                    cacheOnly = true;
                } else if (testbedsSourcePref.startsWith("file:")) {
                    filename = testbedsSourcePref.substring(5);
                } else {
                    altUrl = testbedsSourcePref;
                }
            }
            boolean tryFile = !builtinOnly && !cacheOnly && filename != null;
            boolean tryUrl = !builtinOnly && !cacheOnly;
            tryBuiltIn = true;
            boolean tryCache = true;
            testbeds = null;
            if (tryFile) {
                File userFile = new File(filename);
                try {
                    testbeds = StoredTestbedInfo.load(userFile);
                    if (testbeds == null) {
                        LOG.error("Something went wrong while trying to read testbedInfo at " + userFile);
                        testbeds = null;
                    } else {
                        LOG.debug("Successfully read testbedInfo at " + userFile);
                    }
                }
                catch (AssertionError | Exception e) {
                    LOG.error("Something went wrong while trying to read testbedInfo at " + userFile, (Throwable)e);
                    testbeds = null;
                }
            }
            federations = Collections.emptyList();
            organisations = Collections.emptyList();
            testbedCategories = Collections.emptyList();
            if (testbeds == null && tryUrl) {
                if (!this.connectivityDetector.isNoInternet()) {
                    boolean urlSuccess;
                    try {
                        try {
                            URL url = altUrl != null ? new URL(altUrl) : this.webApiUrl;
                            testbeds = this.getTestbedsUsingUrl(url);
                            urlSuccess = testbeds != null;
                            try {
                                FedmonWebApiClient fedmonWebApiClient = this.getFedmonWebApiClient(url);
                                federations = fedmonWebApiClient.getAll(Federation.class, false);
                                organisations = fedmonWebApiClient.getAll(Organisation.class, false);
                                testbedCategories = fedmonWebApiClient.getAll(TestbedCategory.class, false);
                            }
                            catch (Exception e) {
                                LOG.error("Error while fetching additional testbed information (will be ignored)", (Throwable)e);
                            }
                        }
                        catch (MalformedURLException e) {
                            LOG.error("Invalid URL for testbedInfoSource", (Throwable)e);
                            urlSuccess = false;
                        }
                    }
                    catch (AssertionError e) {
                        LOG.error("Something went wrong while trying to fetch Fed4Fire testbedInfo: ", (Throwable)((Object)e));
                        urlSuccess = false;
                        testbeds = null;
                    }
                    catch (Exception e) {
                        LOG.error("Something went wrong while trying to fetch Fed4Fire testbedInfo: ", (Throwable)e);
                        urlSuccess = false;
                        testbeds = null;
                    }
                    if (!urlSuccess) {
                        if (altUrl == null) {
                            LOG.warn("Something went wrong trying to load the default testbedInfo URL");
                        } else {
                            LOG.warn("Something went wrong trying to load testbedInfo from " + altUrl);
                        }
                        LOG.debug("Will use cache and builtin as backup");
                        tryBuiltIn = true;
                        tryCache = true;
                    }
                } else {
                    LOG.debug("Not trying to get testbedInfo from URL, because connectivityDetector detected no internet connection");
                }
            }
            if (testbeds == null && tryCache) {
                if (cachedTestbedsFile != null && cachedTestbedsFile.exists()) {
                    try {
                        testbeds = StoredTestbedInfo.load(cachedTestbedsFile);
                        if (testbeds == null) {
                            LOG.error("Something went wrong while trying to read testbedInfo at " + cachedTestbedsFile);
                            testbeds = null;
                            break block53;
                        }
                        LOG.debug("Successfully read testbedInfo from cache at " + cachedTestbedsFile);
                    }
                    catch (AssertionError | Exception e) {
                        LOG.error("Something went wrong while trying to read testbedInfo at " + cachedTestbedsFile, (Throwable)e);
                        testbeds = null;
                    }
                } else {
                    LOG.debug("No cached testbeds file. " + cachedTestbedsFile);
                }
            }
        }
        if (testbeds == null && tryBuiltIn) {
            try {
                InputStream is = JFedTestbedInfoSource.class.getResourceAsStream("testbeds.json");
                testbeds = StoredTestbedInfo.load(is);
            }
            catch (AssertionError | Exception e) {
                LOG.error("Something went wrong while using Builtin testbeds: ", (Throwable)e);
                testbeds = null;
            }
        }
        if (testbeds != null) {
            boolean exists;
            for (File extraFile : JFedTestbedInfoSource.getExtraTestbedFiles()) {
                try {
                    List<Testbed> extraTestbeds = StoredTestbedInfo.load(extraFile);
                    if (extraTestbeds == null) continue;
                    for (Testbed et : extraTestbeds) {
                        exists = false;
                        for (Testbed existing : testbeds) {
                            if (Objects.equals(existing.getId(), et.getId())) {
                                LOG.debug("A testbed with ID \"" + (String)et.getId() + "\" is already in the list. Will ignore the one in extra file " + extraFile.getName());
                                exists = true;
                            }
                            if (existing.getDefaultComponentManagerUrn() == null || et.getDefaultComponentManagerUrn() == null || !Objects.equals(existing.getDefaultComponentManagerUrn(), et.getDefaultComponentManagerUrn())) continue;
                            exists = true;
                            LOG.debug("A testbed with URN \"" + et.getDefaultComponentManagerUrn() + "\" is already in the list. Will ignore the one in extra file " + extraFile.getName());
                        }
                        if (exists) {
                            LOG.debug("Not adding testbed \"" + (String)et.getId() + "\" because it already exists.");
                            continue;
                        }
                        LOG.debug("Adding non-existing testbed \"" + (String)et.getId() + "\" specified in extra file " + extraFile.getName());
                        testbeds.add(JFedTestbedInfoSource.giveUniqueId(et, testbeds));
                    }
                }
                catch (AssertionError | Exception e) {
                    LOG.error("Something went wrong while trying to read extra testbeds from " + extraFile, (Throwable)e);
                }
            }
            for (File overwriteFile : JFedTestbedInfoSource.getOverwriteTestbedFiles()) {
                try {
                    List<Testbed> overwriteTestbeds = StoredTestbedInfo.load(overwriteFile);
                    if (overwriteTestbeds == null) continue;
                    for (Testbed ot : overwriteTestbeds) {
                        exists = false;
                        ListIterator<Testbed> it = testbeds.listIterator();
                        while (it.hasNext()) {
                            Testbed existing;
                            existing = it.next();
                            boolean overwrite = false;
                            if (Objects.equals(existing.getId(), ot.getId())) {
                                LOG.debug("A testbed with ID \"" + (String)ot.getId() + "\" is already in the list. Will overwrite with the one in overwrite file " + overwriteFile.getName());
                                exists = true;
                                overwrite = true;
                            }
                            if (existing.getDefaultComponentManagerUrn() != null && ot.getDefaultComponentManagerUrn() != null && Objects.equals(existing.getDefaultComponentManagerUrn(), ot.getDefaultComponentManagerUrn())) {
                                exists = true;
                                overwrite = true;
                                LOG.debug("A testbed with URN \"" + ot.getDefaultComponentManagerUrn() + "\" is already in the list. Will overwrite with the one in overwrite file " + overwriteFile.getName());
                            }
                            if (!overwrite) continue;
                            it.set(ot);
                        }
                        if (exists) continue;
                        LOG.debug("Adding non-existing testbed \"" + (String)ot.getId() + "\" specified in overwrite file " + overwriteFile.getName());
                        testbeds.add(JFedTestbedInfoSource.giveUniqueId(ot, testbeds));
                    }
                }
                catch (AssertionError | Exception e) {
                    LOG.error("Something went wrong while trying to read overwrite testbeds from " + overwriteFile, (Throwable)e);
                }
            }
        } else {
            LOG.warn("Will ignore extra and overwrite testbeds, because no testbeds could be found.");
        }
        if (testbeds != null) {
            BasicTestbedInfoSource testbedInfoSource = BasicTestbedInfoSource.createFromTestbeds(testbeds, federations, organisations, testbedCategories);
            LOG.info("jFed initialised TestbedInfoSource with " + testbedInfoSource.getTestbeds().size() + " testbeds and " + testbedInfoSource.getServers().size() + " servers.");
            this.saveCacheInBackground((TestbedInfoSource)testbedInfoSource, cachedTestbedsFile);
            return testbedInfoSource;
        }
        LOG.error("No method to get testbed info worked!");
        return null;
    }

    private static Testbed giveUniqueId(Testbed orig, List<Testbed> existing) {
        TestbedBuilder res = new TestbedBuilder(orig);
        if (res.getId() == null) {
            res.setId((Object)("testbed" + extraTestbedUniqueId++));
        }
        ArrayList servers = new ArrayList(res.getServers());
        res.setServers(null);
        for (Server server : servers) {
            ServerBuilder serverBuilder = new ServerBuilder(server);
            res.addServerBuilder(serverBuilder);
            if (serverBuilder.getId() == null) {
                serverBuilder.setId((Object)extraTestbedUniqueId++);
            }
            serverBuilder.setServices(null);
            if (server.getServices() == null) continue;
            ArrayList services = new ArrayList(server.getServices());
            for (Service service : services) {
                ServiceBuilder serviceBuilder = new ServiceBuilder(service);
                serverBuilder.addServiceBuilder(serviceBuilder);
                if (serviceBuilder.getId() != null) continue;
                serviceBuilder.setId((Object)extraTestbedUniqueId++);
            }
        }
        return res.create();
    }

    private void saveCacheInBackground(TestbedInfoSource testbedInfoSource, File targetFile) {
        Runnable r = () -> {
            try {
                this.save(testbedInfoSource, targetFile);
            }
            catch (AssertionError | Exception e) {
                LOG.error("Something went wrong while trying to write testbeds to cache " + targetFile, (Throwable)e);
            }
        };
        new Thread(r).start();
    }

    public void save(TestbedInfoSource testbedInfoSource, File targetFile) {
        LOG.info("Saving jFed authority list to file \"" + targetFile + "\"");
        StoredTestbedInfo.saveIgnoringErrors(targetFile, testbedInfoSource);
    }

    public static class OfflineException
    extends Exception {
        public OfflineException() {
        }

        public OfflineException(String message) {
            super(message);
        }

        public OfflineException(String message, Throwable cause) {
            super(message, cause);
        }

        public OfflineException(Throwable cause) {
            super(cause);
        }

        public OfflineException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }
}

