/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.config;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfigImpl;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.tasks.FedmonResultsTask;
import be.iminds.ilabt.jfed.highlevel.tasks.GetAdvertisementTask;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.FXPlatformUtil;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.rspec_source.AdvertisementRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AdvertisementFetchManager {
    private static final Logger LOG = LoggerFactory.getLogger(AdvertisementFetchManager.class);
    private static final double PROGRESS_FETCH_REQUESTED = -1.0;
    private static final double PROGRESS_FETCH_COMPLETE = 0.0;
    private static final double PROGRESS_PARSE_COMPLETE = 0.95;
    private final HighLevelTaskFactory hltf;
    private final JFedGuiConfigImpl config;
    private final SfaModel sfaModel;
    private final Map<Server, AvailableResources> availableResources;
    private final Map<Server, AllResources> allResources;
    private Map<GeniUrn, Result> fedmonResults;

    @Inject
    public AdvertisementFetchManager(JFedGuiConfigImpl config, HighLevelTaskFactory hltf, SfaModel sfaModel) {
        this.config = config;
        this.hltf = hltf;
        this.sfaModel = sfaModel;
        this.availableResources = new HashMap<Server, AvailableResources>();
        this.allResources = new HashMap<Server, AllResources>();
    }

    public boolean mustCallFedmon(Server server) {
        return server.hasFlag(Server.Flag.fedmonHasNodeAvailabilityDetails);
    }

    public FedmonResultsTask getFedmonResultsTask(GeniUrn testbedUrn) {
        if (testbedUrn.getEncodedTopLevelAuthority().contains("wilab")) {
            return this.hltf.getFedmonResults(testbedUrn.getValue(), "autosensortest");
        }
        return this.hltf.getFedmonResults(testbedUrn.getValue(), "autonodelogin");
    }

    @Nullable
    public TaskExecution<FedmonResultsTask> callFedmonIfNeeded(Server server) {
        if (this.mustCallFedmon(server)) {
            LOG.debug("Fetching fedmon results.");
            FedmonResultsTask fedmonNodeStatusTask = this.getFedmonResultsTask(server.getDefaultComponentManagerAsGeniUrn());
            fedmonNodeStatusTask.addCallback((task, taskEx, state) -> FXPlatformUtil.runLaterOrNowOnFXThread(() -> {
                this.storeFedmonResults(server, fedmonNodeStatusTask.getResults());
                if (this.fedmonResults != null && !this.fedmonResults.isEmpty()) {
                    this.config.setFedmonNodeTestInfo((Integer)server.getId(), this.fedmonResults);
                }
                this.getAllResources(server).updateComponentIds();
            }));
            TaskExecution taskExecution2 = this.hltf.submitTask((Task)fedmonNodeStatusTask);
            return taskExecution2;
        }
        return null;
    }

    private void storeFedmonResults(@Nonnull Server server, @Nullable List<Result> testResults) {
        if (this.fedmonResults == null) {
            this.fedmonResults = new ConcurrentHashMap<GeniUrn, Result>();
        }
        if (testResults != null) {
            if (!testResults.isEmpty()) {
                for (Result testResult : testResults) {
                    assert (testResult != null);
                    if (testResult.getStringSubResult("fixed_node_urn") != null) {
                        GeniUrn nodeUrn = GeniUrn.parse((String)testResult.getStringSubResult("fixed_node_urn"));
                        if (nodeUrn != null) {
                            assert (testResult != null);
                            this.fedmonResults.put(nodeUrn, testResult);
                            continue;
                        }
                        LOG.warn("Invalid node urn in fedmon reply: \"" + testResult.getStringSubResult("fixed_node_urn") + "\"");
                        continue;
                    }
                    LOG.warn("Node without urn in fedmon reply id=" + testResult.getId());
                }
            } else {
                LOG.warn("Fedmon Status task has empty results");
            }
        } else {
            LOG.warn("Fedmon Status task has null results");
        }
    }

    public AvailableResources getAvailableResources(Server server) {
        AvailableResources res = this.availableResources.get(server);
        if (res == null) {
            AvailableResources newRes;
            res = newRes = new AvailableResources(server);
            this.availableResources.put(server, newRes);
            res.advertisementRspecSourceProperty().addListener(observable -> {
                if (newRes.getAdvertisementRspecSource() != null) {
                    this.config.availableAdvertisementByServerId.computeIfAbsent((Integer)server.getId(), key -> new SimpleObjectProperty()).setValue((Object)newRes.getAdvertisementRspecSource());
                    this.config.anyAdvertisementByServerId.computeIfAbsent((Integer)server.getId(), key -> new SimpleObjectProperty()).setValue((Object)newRes.getAdvertisementRspecSource());
                }
            });
        }
        assert (res != null);
        return res;
    }

    public AllResources getAllResources(Server server) {
        assert (server != null);
        AllResources res = this.allResources.get(server);
        if (res == null) {
            AllResources newRes;
            res = newRes = new AllResources(server);
            this.allResources.put(server, newRes);
            res.advertisementRspecSourceProperty().addListener(observable -> {
                if (newRes.getAdvertisementRspecSource() != null) {
                    this.config.allAdvertisementByServerId.computeIfAbsent((Integer)server.getId(), key -> new SimpleObjectProperty()).setValue((Object)newRes.getAdvertisementRspecSource());
                    this.config.anyAdvertisementByServerId.computeIfAbsent((Integer)server.getId(), key -> new SimpleObjectProperty()).setValue((Object)newRes.getAdvertisementRspecSource());
                }
            });
        }
        assert (res != null);
        return res;
    }

    public class AvailableResources
    extends Resources {
        public AvailableResources(Server server) {
            super(server);
        }

        @Override
        public GetAdvertisementTask getAdvertisementTask() {
            return AdvertisementFetchManager.this.hltf.getAvailableAdvertisement(this.server);
        }

        @Override
        public AdvertisementRspecSource getAdvertisementRspecSource() {
            return AdvertisementFetchManager.this.sfaModel.getAvailableAdvertisementRspec(this.server);
        }

        @Override
        public ObjectProperty<AdvertisementRspecSource> advertisementRspecSourceProperty() {
            return AdvertisementFetchManager.this.sfaModel.availableAdvertisementRspecProperty(this.server);
        }

        @Override
        public boolean mustRemoveUnavailable() {
            return true;
        }

        @Override
        public boolean mustCallListResources() {
            return !this.server.hasFlag(Server.Flag.fedmonHasNodeAvailabilityDetails);
        }
    }

    public class AllResources
    extends Resources {
        public AllResources(Server server) {
            super(server);
        }

        @Override
        public GetAdvertisementTask getAdvertisementTask() {
            return AdvertisementFetchManager.this.hltf.getAllAdvertisement(this.server);
        }

        @Override
        public AdvertisementRspecSource getAdvertisementRspecSource() {
            return AdvertisementFetchManager.this.sfaModel.getAllAdvertisementRspec(this.server);
        }

        @Override
        public ObjectProperty<AdvertisementRspecSource> advertisementRspecSourceProperty() {
            return AdvertisementFetchManager.this.sfaModel.allAdvertisementRspecProperty(this.server);
        }

        @Override
        public boolean mustRemoveUnavailable() {
            return false;
        }

        @Override
        public boolean mustCallListResources() {
            return true;
        }
    }

    public abstract class Resources {
        protected final Server server;
        private final ObjectProperty<RefreshAdvertisementTask> currentRefreshAdvertisementTask = new SimpleObjectProperty();

        public Resources(Server server) {
            assert (server != null);
            this.server = server;
        }

        public abstract GetAdvertisementTask getAdvertisementTask();

        public abstract AdvertisementRspecSource getAdvertisementRspecSource();

        public abstract ObjectProperty<AdvertisementRspecSource> advertisementRspecSourceProperty();

        public abstract boolean mustRemoveUnavailable();

        public boolean isComponentIdsAvailable() {
            return !AdvertisementFetchManager.this.config.getComponentInfo(this.server, this instanceof AllResources ? JFedGuiConfig.Scope.ALL : JFedGuiConfig.Scope.AVAILABLE_ONLY, null).isEmpty();
        }

        public RefreshAdvertisementTask refreshAdvertisement() {
            LOG.debug("Called refreshAdvertisement(" + this.server.getId() + ")");
            if (this.currentRefreshAdvertisementTask.get() == null) {
                this.currentRefreshAdvertisementTask.set((Object)new RefreshAdvertisementTask());
                new Thread((Runnable)this.currentRefreshAdvertisementTask.get()).start();
            }
            return (RefreshAdvertisementTask)((Object)this.currentRefreshAdvertisementTask.get());
        }

        public abstract boolean mustCallListResources();

        public RefreshAdvertisementTask getCurrentRefreshAdvertisementTask() {
            return (RefreshAdvertisementTask)((Object)this.currentRefreshAdvertisementTask.get());
        }

        public ObjectProperty<RefreshAdvertisementTask> currentRefreshAdvertisementTaskProperty() {
            return this.currentRefreshAdvertisementTask;
        }

        public void updateComponentIds() {
            assert (Platform.isFxApplicationThread());
            if (this.getAdvertisementRspecSource() == null || this.getAdvertisementRspecSource().getModelRspec(ModelRspecType.FX, new ProgressHandler[0]) == null) {
                LOG.info("No advertisement node-info available for testbed {}.", (Object)this.server.getName());
                return;
            }
            FXModelRspec modelRspec = (FXModelRspec)this.getAdvertisementRspecSource().getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
            if (modelRspec == null) {
                throw new IllegalStateException("modelRspec should not be null");
            }
            ArrayList nodes = new ArrayList(modelRspec.getNodes());
            ListIterator it = nodes.listIterator();
            while (it.hasNext()) {
                FXRspecNode node = (FXRspecNode)it.next();
                if (node == null || node.getComponentId() == null) {
                    LOG.warn("Item in received node list has no component_id. Will be ignored!");
                    it.remove();
                    continue;
                }
                if (node.getComponentName() == null) {
                    node.setComponentName(node.getComponentId().toString());
                }
                if (!Objects.equals(node.getAvailable(), Boolean.FALSE) || !this.mustRemoveUnavailable()) continue;
                it.remove();
            }
            LOG.debug("Added {} nodes to the list of testbed {}", (Object)modelRspec.getNodes().size(), (Object)this.server.getName());
            AdvertisementFetchManager.this.config.setAdvertisementRspec((Integer)this.server.getId(), this instanceof AvailableResources, (ModelRspec)modelRspec, new Date());
        }

        public class RefreshAdvertisementTask
        extends javafx.concurrent.Task<Void> {
            protected Void call() throws Exception {
                GetAdvertisementTask fetchAdvertisementTask = Resources.this.mustCallListResources() ? Resources.this.getAdvertisementTask() : null;
                TaskExecution taskExecution = fetchAdvertisementTask != null ? AdvertisementFetchManager.this.hltf.submitTask((Task)fetchAdvertisementTask) : null;
                this.updateProgress(-1.0, 1.0);
                FedmonResultsTask fedmonNodeStatusTask = null;
                TaskExecution taskExecution2 = null;
                if (AdvertisementFetchManager.this.mustCallFedmon(Resources.this.server)) {
                    LOG.debug("Fetching fedmon results.");
                    fedmonNodeStatusTask = AdvertisementFetchManager.this.getFedmonResultsTask(Resources.this.server.getDefaultComponentManagerAsGeniUrn());
                    taskExecution2 = AdvertisementFetchManager.this.hltf.submitTask((Task)fedmonNodeStatusTask);
                }
                while (taskExecution != null && !taskExecution.isCompleted() || taskExecution2 != null && !taskExecution2.isCompleted()) {
                    Thread.sleep(100L);
                }
                assert (taskExecution == null || taskExecution.isCompleted());
                assert (taskExecution2 == null || taskExecution2.isCompleted());
                if (taskExecution != null && taskExecution.getState() != TaskExecution.TaskState.SUCCESS) {
                    throw new JFedHighLevelException("Unexpected state for getAdvertisement task: " + taskExecution.getState(), taskExecution.getException());
                }
                while (taskExecution != null && Resources.this.getAdvertisementRspecSource() == null) {
                    Thread.sleep(100L);
                }
                this.updateProgress(0.0, 1.0);
                assert (taskExecution == null || Resources.this.getAdvertisementRspecSource() != null);
                if (taskExecution != null) {
                    ProgressHandler parserProgressHandler = (progress, totalWork) -> this.updateProgress(0.0 + 0.95 * (progress / totalWork), 1.0);
                    Resources.this.getAdvertisementRspecSource().getImmutableModelRspec(new ProgressHandler[]{parserProgressHandler});
                }
                if (fedmonNodeStatusTask != null) {
                    assert (taskExecution2 != null);
                    if (taskExecution2.getState() != TaskExecution.TaskState.SUCCESS) {
                        LOG.warn("Fedmon Status task status is " + taskExecution2.getState());
                    }
                    AdvertisementFetchManager.this.storeFedmonResults(Resources.this.server, fedmonNodeStatusTask.getResults());
                }
                this.updateProgress(0.95, 1.0);
                return null;
            }

            protected void scheduled() {
                this.updateProgress(0L, 1L);
            }

            protected void succeeded() {
                if (AdvertisementFetchManager.this.fedmonResults != null && !AdvertisementFetchManager.this.fedmonResults.isEmpty()) {
                    FXPlatformUtil.runLaterOrNowOnFXThread(() -> AdvertisementFetchManager.this.config.setFedmonNodeTestInfo((Integer)Resources.this.server.getId(), AdvertisementFetchManager.this.fedmonResults));
                }
                Resources.this.updateComponentIds();
            }

            protected void done() {
                FXPlatformUtil.runLaterOrNowOnFXThread(() -> Resources.this.currentRefreshAdvertisementTask.set(null));
            }
        }
    }
}

