/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.config;

import be.iminds.ilabt.jfed.experimenter_gui.config.ImageMap;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedExperimenterGuiConfigProvider;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.config.TestbedSiteInfo;
import be.iminds.ilabt.jfed.experimenter_gui.config.util.TestbedNodesMapParseException;
import be.iminds.ilabt.jfed.experimenter_gui.config.util.TestbedNodesMapsFetcher;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.AdvertisementCounts;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GtsConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.JFedExperimenterGuiConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.MaintenanceInfo;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClassBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpseBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TriggeredMessage;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.resourceid.ResourceUrn;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec.model.DiskImage;
import be.iminds.ilabt.jfed.rspec.model.DiskImageList;
import be.iminds.ilabt.jfed.rspec.model.HardwareType;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.NodeLocation;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.SliverType;
import be.iminds.ilabt.jfed.rspec.rspec_source.AdvertisementRspecSource;
import be.iminds.ilabt.jfed.rspec.statistics.RSpecStatistics;
import be.iminds.ilabt.jfed.rspec.statistics.RspecStatisticsMaker;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.Pair;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.google.common.collect.ImmutableSet;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.paint.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JFedGuiConfigImpl
implements JFedGuiConfig {
    private static final Logger LOG = LoggerFactory.getLogger(JFedGuiConfigImpl.class);
    private final TestbedInfoSource testbedInfoSource;
    private final AuthorityFinder authorityFinder;
    private final JFedExperimenterGuiConfig jFedExperimenterGuiConfig;
    private final FedmonWebApiClient fedmonWebApiClient;
    private Instant lastServerGlimpseRefresh;
    private final Map<String, ResourceClass> resourceClassById;
    private final Map<JFedGuiConfig.ResourceType, List<ResourceClass>> resourceClassesByType;
    private final Map<String, Integer> randomByResourceClassId;
    private final List<Server> bindableServers;
    private final List<Server> serversInVisibleResources;
    private final List<Server> hiddenServers;
    private final List<TriggeredMessage> triggeredMessages;
    private final Map<AdvertisementInfoSourceId, AdvertisementInfo> advertisementInfoById = new HashMap<AdvertisementInfoSourceId, AdvertisementInfo>();
    private final Map<Integer, AdvertisementProperties> advertisementPropertiesByServerId = new HashMap<Integer, AdvertisementProperties>();
    Map<Integer, ObjectProperty<AdvertisementRspecSource>> availableAdvertisementByServerId;
    Map<Integer, ObjectProperty<AdvertisementRspecSource>> allAdvertisementByServerId;
    Map<Integer, ObjectProperty<AdvertisementRspecSource>> anyAdvertisementByServerId;
    private final HashMap<Integer, ImageMap<GeniUrn>> imageMapByServerId;
    private final HashMap<Integer, ServerGlimpse> serverGlimpseByServerId;
    private final List<Resource> allResources;
    private final Map<Integer, List<Resource>> resourcesByServerId;
    private final Map<Pair<Integer, String>, List<Resource>> resourcesByServerIdAndSliverName;
    private final ResourceClass otherServerResourceClass;
    private static final Random rand = new Random();
    private static final ImmutableSet<String> HARDWARE_TYPE_NAMES_SUBSTRING_BLACKLIST = ImmutableSet.of((Object)"80211", (Object)"flex900", (Object)"xcvr2450", (Object)"delay", (Object)"interconnect", (Object)"ipv4", (Object[])new String[]{"lan", "switch"});
    private static final ImmutableSet<String> HARDWARE_TYPE_NAMES_BLACKLIST = ImmutableSet.of((Object)"pc");

    @Inject
    public JFedGuiConfigImpl(TestbedInfoSource testbedInfoSource, AuthorityFinder authorityFinder, JFedExperimenterGuiConfigProvider jFedExperimenterGuiConfigProvider, TestbedNodesMapsFetcher testbedNodesMapsFetcher, FedmonWebApiClient fedmonWebApiClient) {
        LOG.debug("Initialising JFedGuiConfigImpl");
        this.testbedInfoSource = testbedInfoSource;
        this.authorityFinder = authorityFinder;
        this.jFedExperimenterGuiConfig = jFedExperimenterGuiConfigProvider.get();
        this.fedmonWebApiClient = fedmonWebApiClient;
        assert (testbedInfoSource != null);
        assert (this.jFedExperimenterGuiConfig != null);
        this.resourceClassById = JFedGuiConfigImpl.link(testbedInfoSource, this.jFedExperimenterGuiConfig.getResourceClasses());
        this.otherServerResourceClass = JFedGuiConfigImpl.generateOtherServerResourceClass(testbedInfoSource, this.resourceClassById.values());
        this.resourceClassById.put((String)this.otherServerResourceClass.getId(), this.otherServerResourceClass);
        this.resourceClassesByType = new EnumMap<JFedGuiConfig.ResourceType, List<ResourceClass>>(JFedGuiConfig.ResourceType.class);
        this.allResources = new ArrayList<Resource>();
        this.resourcesByServerId = new HashMap<Integer, List<Resource>>();
        this.resourcesByServerIdAndSliverName = new HashMap<Pair<Integer, String>, List<Resource>>();
        for (ResourceClass resourceClass : this.resourceClassById.values()) {
            JFedGuiConfig.ResourceType resourceType = this.getResourceType(resourceClass);
            List resourceClasses = this.resourceClassesByType.computeIfAbsent(resourceType, key -> new ArrayList());
            resourceClasses.add(resourceClass);
            for (Resource resource : resourceClass.getResources()) {
                Server server = resource.getServer();
                String sliverType = resource.getSliverType();
                if (server == null || server.getId() == null) continue;
                this.allResources.add(resource);
                this.resourcesByServerId.computeIfAbsent((Integer)server.getId(), key -> new ArrayList()).add(resource);
                if (sliverType == null) continue;
                this.resourcesByServerIdAndSliverName.computeIfAbsent((Pair<Integer, String>)new Pair((Object)((Integer)server.getId()), (Object)sliverType), key -> new ArrayList()).add(resource);
            }
        }
        this.bindableServers = this.getFullServers(this.jFedExperimenterGuiConfig.getBindableServers());
        this.hiddenServers = this.getFullServers(this.jFedExperimenterGuiConfig.getHideServers());
        this.triggeredMessages = this.jFedExperimenterGuiConfig.getTriggeredMessages() == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList(this.jFedExperimenterGuiConfig.getTriggeredMessages()));
        TreeSet<Server> serversInVisibleResourcesTmp = new TreeSet<Server>(Comparator.comparing(PrimaryIdObject::getId, Comparator.nullsLast(Comparator.naturalOrder())));
        for (ResourceClass resourceClass : this.resourceClassById.values()) {
            assert (resourceClass.getResources() != null);
            if (resourceClass.getResources() == null) continue;
            for (Resource resource : resourceClass.getResources()) {
                Server server = resource.getServer();
                if (server == null) continue;
                if (resourceClass.getVisibleInToolbox().booleanValue()) {
                    serversInVisibleResourcesTmp.add(server);
                }
                if (resource.getSliverType() != null) {
                    this.getAdvertisementInfo(server, AdvertisementInfoSourceType.ResourceClass).addSliverTypeName(resource.getSliverType());
                }
                if (resource.getHardwareType() != null) {
                    this.getAdvertisementInfo(server, AdvertisementInfoSourceType.ResourceClass).addHardwareTypeName(resource.getHardwareType(), null);
                }
                if (resource.getDiskImage() == null) continue;
                DiskImage thisDiskImage = resource.getDiskImage().startsWith("http") ? new DiskImage(null, resource.getDiskImage(), null, null, null, null) : new DiskImage(resource.getDiskImage());
                this.getAdvertisementInfo(server, AdvertisementInfoSourceType.ResourceClass).addDiskImage(thisDiskImage);
                if (resource.getSliverType() == null) continue;
                this.getAdvertisementInfo(server, AdvertisementInfoSourceType.ResourceClass).addDiskImage(resource.getSliverType(), thisDiskImage);
            }
        }
        this.serversInVisibleResources = Collections.unmodifiableList(new ArrayList<Server>(serversInVisibleResourcesTmp));
        this.availableAdvertisementByServerId = new HashMap<Integer, ObjectProperty<AdvertisementRspecSource>>();
        this.allAdvertisementByServerId = new HashMap<Integer, ObjectProperty<AdvertisementRspecSource>>();
        this.anyAdvertisementByServerId = new HashMap<Integer, ObjectProperty<AdvertisementRspecSource>>();
        this.imageMapByServerId = new HashMap();
        if (testbedNodesMapsFetcher != null) {
            CompletableFuture completableFuture = new CompletableFuture();
            CompletableFuture.runAsync(() -> {
                try {
                    cf.complete(testbedNodesMapsFetcher.call());
                }
                catch (TestbedNodesMapParseException e) {
                    cf.completeExceptionally(e);
                }
            });
            ((CompletableFuture)completableFuture.thenAccept(map -> {
                for (Map.Entry nodesMapEntry : map.entrySet()) {
                    GeniUrn urn = (GeniUrn)nodesMapEntry.getKey();
                    Server server = authorityFinder.findByAnyUrn(urn, AuthorityFinder.Purpose.REQUEST_RSPEC);
                    if (server != null) {
                        this.imageMapByServerId.put((Integer)server.getId(), (ImageMap)nodesMapEntry.getValue());
                        continue;
                    }
                    LOG.info("Received nodes map of unknown testbed '{}'", nodesMapEntry.getKey());
                }
            })).exceptionally(throwable -> {
                LOG.error("Could not process map of testbeds", throwable);
                return null;
            });
        }
        this.serverGlimpseByServerId = new HashMap();
        this.refreshServerGlimpses();
        this.randomByResourceClassId = new HashMap<String, Integer>();
        this.initResourceClassAdvertisementInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshServerGlimpsesIfNeeded() {
        try {
            boolean mustRefresh = false;
            JFedGuiConfigImpl jFedGuiConfigImpl = this;
            synchronized (jFedGuiConfigImpl) {
                if (this.lastServerGlimpseRefresh != null && this.lastServerGlimpseRefresh.isBefore(Instant.now().minus(10L, ChronoUnit.MINUTES))) {
                    this.lastServerGlimpseRefresh = null;
                    mustRefresh = true;
                }
            }
            if (mustRefresh) {
                LOG.debug("Need to fetch new ServerGlimpses");
                this.refreshServerGlimpses();
            }
        }
        catch (Throwable e) {
            LOG.error("Problem in refreshServerGlimpsesIfNeeded() will be ignored", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceRefreshServerGlimpses() {
        try {
            JFedGuiConfigImpl jFedGuiConfigImpl = this;
            synchronized (jFedGuiConfigImpl) {
                this.lastServerGlimpseRefresh = null;
            }
            LOG.debug("Force fetch new ServerGlimpses");
            this.refreshServerGlimpses();
        }
        catch (Throwable e) {
            LOG.error("Problem in forceRefreshServerGlimpses() will be ignored", e);
        }
    }

    private void refreshServerGlimpses() {
        if (this.fedmonWebApiClient != null) {
            CompletableFuture.supplyAsync(() -> {
                try {
                    return this.fedmonWebApiClient.getAll(ServerGlimpse.class);
                }
                catch (FedmonWebApiClient.FedmonWebApiClientException e) {
                    LOG.error("Error fetching all ServerGlimpse", (Throwable)e);
                    return Collections.emptyList();
                }
            }).thenAccept(serverGlimpseList -> Platform.runLater(() -> {
                LOG.info("Received ServerGlimpse list with {} ServerGlimpses", (Object)serverGlimpseList.size());
                int nonNullCount = 0;
                int nullCount = 0;
                int failCount = 0;
                for (ServerGlimpse serverGlimpse : serverGlimpseList) {
                    if (serverGlimpse.getServerId() != null) {
                        try {
                            this.serverGlimpseByServerId.put(serverGlimpse.getServerId(), serverGlimpse);
                            this.setServerGlimpse(serverGlimpse.getServerId(), serverGlimpse);
                            ++nonNullCount;
                        }
                        catch (Throwable e) {
                            LOG.error("Exception while processing received ServerGlimpse", e);
                            ++failCount;
                        }
                        continue;
                    }
                    LOG.info("Received ServerGlimpse without server: {} ", (Object)serverGlimpse);
                    ++nullCount;
                }
                LOG.info("Processed ServerGlimpse list with {} nonNull ServerGlimpses, {} exceptions and {} nulls", new Object[]{nonNullCount, failCount, nullCount});
                JFedGuiConfigImpl jFedGuiConfigImpl = this;
                synchronized (jFedGuiConfigImpl) {
                    this.lastServerGlimpseRefresh = Instant.now();
                }
            }));
        }
    }

    @Nonnull
    private static ResourceClass generateOtherServerResourceClass(@Nonnull TestbedInfoSource testbedInfoSource, @Nonnull Collection<ResourceClass> resourceClasses) {
        ResourceClassBuilder res = new ResourceClassBuilder();
        HashSet<Integer> serverIds = new HashSet<Integer>();
        for (ResourceClass rc : resourceClasses) {
            for (Resource r : rc.getResources()) {
                if (r.getServerId() == null) continue;
                serverIds.add(r.getServerId());
            }
        }
        AtomicInteger fakeId = new AtomicInteger(10000);
        List otherServersResources = testbedInfoSource.getServers().stream().filter(s -> s.getId() != null).filter(s -> !serverIds.contains(s.getId())).map(s -> {
            ResourceBuilder newResource = new ResourceBuilder();
            newResource.setId((Object)fakeId.getAndIncrement());
            newResource.setServer(s);
            newResource.setAllowDiskImage(Boolean.valueOf(true));
            newResource.setAllowFixedNodeAssignment(Boolean.valueOf(true));
            newResource.setAllowHardwareType(Boolean.valueOf(true));
            newResource.setAllowModifyExclusive(Boolean.valueOf(true));
            newResource.setRequireDiskImage(Boolean.valueOf(false));
            newResource.setRequireFixedNodeAssignment(Boolean.valueOf(false));
            newResource.setRequireHardwareType(Boolean.valueOf(false));
            newResource.setComponentUrn(null);
            newResource.setDiskImage(null);
            newResource.setHardwareType(null);
            newResource.setResourceClassBuilder(res);
            newResource.setRspecElementName("node");
            newResource.setSliverType("unknown");
            newResource.setDefaultExclusive(Boolean.valueOf(true));
            newResource.setLayer3(Boolean.valueOf(true));
            return newResource;
        }).collect(Collectors.toList());
        res.setId((Object)"other-servers");
        res.setDraggableFromToolbox(Boolean.valueOf(true));
        res.setVisibleInToolbox(Boolean.valueOf(false));
        res.setWeight(Integer.valueOf(-10));
        res.setHrn("Other Servers");
        res.setImageId("other-servers");
        res.setResourceBuilders(otherServersResources);
        LOG.debug("Created other-servers ResourceClass with {} Resources", (Object)otherServersResources.size());
        return res.create();
    }

    @Nonnull
    private List<Server> getFullServers(@Nullable List<Server> in) {
        if (in != null) {
            ArrayList<Server> res = new ArrayList<Server>();
            for (Server minimizedServer : in) {
                assert (minimizedServer != null);
                assert (minimizedServer.getId() != null);
                Server fullServer = this.testbedInfoSource.getServerById((Integer)minimizedServer.getId());
                if (fullServer == null) {
                    LOG.error("Server " + minimizedServer.getId() + " that was in a jFedExperimenterGuiConfig list, was not found in testbedInfoSource");
                    continue;
                }
                assert (fullServer.getName() != null);
                assert (Objects.equals(fullServer.getId(), minimizedServer.getId()));
                assert (fullServer.getTestbed() != null);
                assert (fullServer.getTestbed().getId() != null);
                assert (fullServer.getTestbed().getServers() != null);
                assert (fullServer.getTestbed().getServers().contains(fullServer));
                assert (fullServer.getServices() != null);
                assert (fullServer.getServices().isEmpty() || ((Service)fullServer.getServices().get(0)).getServer() == fullServer);
                res.add(fullServer);
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    @Nonnull
    public ResourceClass getOtherServersResourceClass() {
        return this.otherServerResourceClass;
    }

    public boolean isOtherServersResourceClass(@Nonnull ResourceClass resourceClass) {
        return Objects.equals(resourceClass.getId(), this.getOtherServersResourceClass().getId());
    }

    @Nonnull
    private static Map<String, ResourceClass> link(@Nonnull TestbedInfoSource testbedInfoSource, @Nullable List<ResourceClass> resourceClasses) {
        HashMap<Integer, ResourceBuilder> rBuilders = new HashMap<Integer, ResourceBuilder>();
        HashMap<String, ResourceClass> res = new HashMap<String, ResourceClass>();
        if (resourceClasses != null) {
            for (ResourceClass sourceResourceClass : resourceClasses) {
                assert (sourceResourceClass.getId() != null);
                ResourceClassBuilder rcBuilder = new ResourceClassBuilder(sourceResourceClass);
                rcBuilder.setDefaultResource(null);
                rcBuilder.setResources(null);
                rcBuilder.setDefaultResourceBuilders(null);
                rcBuilder.setResourceBuilders(null);
                HashSet<Integer> seenServerIds = new HashSet<Integer>();
                ArrayList<ResourceBuilder> resourceBuilders = new ArrayList<ResourceBuilder>(sourceResourceClass.getResources().size());
                for (Resource sourceResource : sourceResourceClass.getResources()) {
                    assert (sourceResource.getServerId() != null);
                    if (seenServerIds.contains(sourceResource.getServerId())) {
                        LOG.warn("Found duplicate server {} in resouceClass {}. Ignoring Resource {}", new Object[]{sourceResource.getServerId(), sourceResourceClass.getId(), sourceResource.getId()});
                        continue;
                    }
                    seenServerIds.add(sourceResource.getServerId());
                    ResourceBuilder resourceBuilder = rBuilders.computeIfAbsent((Integer)sourceResource.getId(), key -> {
                        ResourceBuilder rb = new ResourceBuilder(sourceResource);
                        rb.setServer(null);
                        rb.setServerBuilder(null);
                        if (rb.getAllowDiskImage() == null) {
                            LOG.warn("null ad bool in resource " + rb.getId());
                            rb.setAllowDiskImage(Boolean.valueOf(true));
                        }
                        if (rb.getAllowFixedNodeAssignment() == null) {
                            LOG.warn("null af bool in resource " + rb.getId());
                            rb.setAllowFixedNodeAssignment(Boolean.valueOf(true));
                        }
                        if (rb.getLayer3() == null) {
                            LOG.warn("null l  bool in resource " + rb.getId());
                            rb.setLayer3(Boolean.valueOf(true));
                        }
                        if (rb.getDefaultExclusive() == null) {
                            LOG.warn("null ae bool in resource " + rb.getId());
                            rb.setDefaultExclusive(Boolean.valueOf(true));
                        }
                        if (rb.getAllowHardwareType() == null) {
                            LOG.warn("null ah bool in resource " + rb.getId());
                            rb.setAllowHardwareType(Boolean.valueOf(false));
                        }
                        if (rb.getAllowModifyExclusive() == null) {
                            LOG.warn("null am bool in resource " + rb.getId());
                            rb.setAllowModifyExclusive(Boolean.valueOf(false));
                        }
                        if (rb.getRequireFixedNodeAssignment() == null) {
                            LOG.warn("null rf bool in resource " + rb.getId());
                            rb.setRequireFixedNodeAssignment(Boolean.valueOf(false));
                        }
                        if (rb.getRequireDiskImage() == null) {
                            LOG.warn("null rd bool in resource " + rb.getId());
                            rb.setRequireDiskImage(Boolean.valueOf(false));
                        }
                        if (rb.getRequireHardwareType() == null) {
                            LOG.warn("null rh bool in resource " + rb.getId());
                            rb.setRequireHardwareType(Boolean.valueOf(false));
                        }
                        assert (sourceResource.getServerId() != null);
                        if (sourceResource.getServerId() != null) {
                            Server actualServer = testbedInfoSource.getServerById(sourceResource.getServerId());
                            if (actualServer != null) {
                                rb.setServer(actualServer);
                            } else {
                                LOG.error("Server " + sourceResource.getServerId() + " in Resource " + sourceResource.getId() + " not found in TestbedInfoSource");
                            }
                        }
                        rb.setResourceClass(null);
                        rb.setResourceClassBuilder(null);
                        return rb;
                    });
                    resourceBuilders.add(resourceBuilder);
                }
                rcBuilder.setResourceBuilders(resourceBuilders);
                if (sourceResourceClass.getDefaultResource() != null && !sourceResourceClass.getDefaultResource().isEmpty()) {
                    ArrayList<ResourceBuilder> defaultResource = new ArrayList<ResourceBuilder>(sourceResourceClass.getDefaultResource().size());
                    for (Resource sourceDefaultResource : sourceResourceClass.getDefaultResource()) {
                        ResourceBuilder defaultResourceBuilder = (ResourceBuilder)rBuilders.get(sourceDefaultResource.getId());
                        if (defaultResourceBuilder != null) {
                            defaultResource.add(defaultResourceBuilder);
                            continue;
                        }
                        LOG.warn("Default resource is NOT in getResourceBuilders(). Ignoring.");
                    }
                    rcBuilder.setDefaultResourceBuilders(defaultResource);
                } else {
                    rcBuilder.setDefaultResourceBuilders(Collections.emptyList());
                }
                try {
                    ResourceClass rc = rcBuilder.create();
                    res.put((String)rc.getId(), rc);
                }
                catch (IllegalStateException ex) {
                    LOG.error("Error while creating resourceClass {}. It will be IGNORED!", sourceResourceClass.getId(), (Object)ex);
                }
            }
        }
        return res;
    }

    @Override
    @Nullable
    public GtsConfig getGtsConfig() {
        return this.jFedExperimenterGuiConfig.getGtsConfig();
    }

    @Override
    public boolean hasFlag(@Nonnull String flagName) {
        return this.jFedExperimenterGuiConfig.getFlags() != null && this.jFedExperimenterGuiConfig.getFlags().containsKey(flagName);
    }

    @Override
    @Nullable
    public Boolean getBooleanFlag(@Nonnull String flagName) {
        if (this.jFedExperimenterGuiConfig.getFlags() == null) {
            return null;
        }
        Object flagVal = this.jFedExperimenterGuiConfig.getFlags().get(flagName);
        if (flagVal == null) {
            return null;
        }
        return TextUtil.objectToBoolean(flagVal);
    }

    @Override
    @Nullable
    public String getStringFlag(@Nonnull String flagName) {
        if (this.jFedExperimenterGuiConfig.getFlags() == null) {
            return null;
        }
        Object flagVal = this.jFedExperimenterGuiConfig.getFlags().get(flagName);
        if (flagVal == null) {
            return null;
        }
        return "" + flagVal;
    }

    @Override
    @Nullable
    public Integer getIntegerFlag(@Nonnull String flagName) {
        if (this.jFedExperimenterGuiConfig.getFlags() == null) {
            return null;
        }
        Object flagVal = this.jFedExperimenterGuiConfig.getFlags().get(flagName);
        if (flagVal == null) {
            return null;
        }
        try {
            return Integer.parseInt("" + flagVal);
        }
        catch (NumberFormatException e) {
            LOG.error("Flag \"" + flagName + "\" has non int value \"" + flagVal + "\" (falling back to null)", (Throwable)e);
            return null;
        }
    }

    @Override
    @Nullable
    public Long getLongFlag(@Nonnull String flagName) {
        if (this.jFedExperimenterGuiConfig.getFlags() == null) {
            return null;
        }
        Object flagVal = this.jFedExperimenterGuiConfig.getFlags().get(flagName);
        if (flagVal == null) {
            return null;
        }
        try {
            return Long.parseLong("" + flagVal);
        }
        catch (NumberFormatException e) {
            LOG.error("Flag \"" + flagName + "\" has non long value \"" + flagVal + "\" (falling back to null)", (Throwable)e);
            return null;
        }
    }

    @Override
    @Nullable
    public ResourceClass getResourceClass(@Nonnull String id) {
        return this.resourceClassById.get(id);
    }

    @Override
    @Nonnull
    public Collection<ResourceClass> getResourceClasses() {
        return this.resourceClassById.values();
    }

    @Override
    @Nonnull
    public List<TriggeredMessage> getTriggeredMessages() {
        return this.triggeredMessages;
    }

    @Override
    @Nonnull
    public JFedGuiConfig.ResourceType getResourceType(@Nonnull ResourceClass resourceClass) {
        if (resourceClass.getInstantiateAsId() != null && (resourceClass = this.resourceClassById.get(resourceClass.getInstantiateAsId())) == null) {
            LOG.warn("getResourceType resourceClass.getInstantiateAsId() points to non existing resource.");
            return JFedGuiConfig.ResourceType.OTHER;
        }
        if (resourceClass.getDefaultResource() == null) {
            return JFedGuiConfig.ResourceType.OTHER;
        }
        if (resourceClass.getDefaultResource().isEmpty()) {
            return JFedGuiConfig.ResourceType.OTHER;
        }
        Resource firstDefaultResource = (Resource)resourceClass.getDefaultResource().get(0);
        if (firstDefaultResource == null) {
            return JFedGuiConfig.ResourceType.OTHER;
        }
        if (firstDefaultResource.getSliverType() == null) {
            return JFedGuiConfig.ResourceType.OTHER;
        }
        if (firstDefaultResource.getSliverType().equalsIgnoreCase("raw-pc")) {
            return JFedGuiConfig.ResourceType.RAW_PC;
        }
        if (firstDefaultResource.getSliverType().equalsIgnoreCase("default-vm")) {
            return JFedGuiConfig.ResourceType.VM;
        }
        if (firstDefaultResource.getSliverType().equalsIgnoreCase("emulab-openvz")) {
            return JFedGuiConfig.ResourceType.VM;
        }
        if (firstDefaultResource.getSliverType().equalsIgnoreCase("emulab-xen")) {
            return JFedGuiConfig.ResourceType.VM;
        }
        return JFedGuiConfig.ResourceType.OTHER;
    }

    @Override
    @Nonnull
    public Collection<ResourceClass> getResourceClassesByType(@Nonnull JFedGuiConfig.ResourceType resourceType) {
        Collection res = this.resourceClassesByType.get((Object)resourceType);
        if (res == null) {
            return Collections.emptyList();
        }
        return res;
    }

    @Override
    @Nullable
    public ResourceClass getDefaultResourceClass() {
        assert (this.jFedExperimenterGuiConfig != null);
        if (this.jFedExperimenterGuiConfig.getResourceClasses() == null || this.jFedExperimenterGuiConfig.getResourceClasses().isEmpty()) {
            return null;
        }
        String id = (String)((ResourceClass)this.jFedExperimenterGuiConfig.getResourceClasses().get(0)).getId();
        assert (id != null);
        return this.resourceClassById.get(id);
    }

    @Override
    @Nonnull
    public List<Server> getBindableServers() {
        return this.bindableServers;
    }

    @Override
    @Nonnull
    public List<Server> getAllServersInVisibleResources() {
        return this.serversInVisibleResources;
    }

    @Override
    @Nonnull
    public List<Server> getHiddenServers() {
        return this.hiddenServers;
    }

    @Nonnull
    private List<String> findNodeHardwareTypes(@Nonnull RspecNode node, @Nonnull Server nodeServer) {
        if (node.getHardwareTypes() != null && !node.getHardwareTypes().isEmpty()) {
            return node.getHardwareTypes().stream().map(HardwareType::getName).collect(Collectors.toList());
        }
        if (node.getComponentId() != null) {
            ObservableList<JFedGuiConfig.ComponentInfo> componentInfos = this.getComponentInfo(nodeServer, JFedGuiConfig.Scope.ALL, null);
            for (JFedGuiConfig.ComponentInfo componentInfo : componentInfos) {
                if (componentInfo.getHardwareTypeNames() == null || componentInfo.getHardwareTypeNames().isEmpty() || !Objects.equals(componentInfo.getUrn(), node.getComponentId())) continue;
                return componentInfo.getHardwareTypeNames();
            }
            componentInfos = this.getComponentInfo(nodeServer, JFedGuiConfig.Scope.AVAILABLE_ONLY, null);
            for (JFedGuiConfig.ComponentInfo componentInfo : componentInfos) {
                if (componentInfo.getHardwareTypeNames() == null || componentInfo.getHardwareTypeNames().isEmpty() || !Objects.equals(componentInfo.getUrn(), node.getComponentId())) continue;
                return componentInfo.getHardwareTypeNames();
            }
        }
        return Collections.emptyList();
    }

    private int matchScore(@Nonnull Resource tested, @Nonnull RspecNode node) {
        List<String> nodeHardwareTypes;
        int score = 0;
        Server server = tested.getServer();
        assert (server != null);
        assert (server.getId() != null);
        assert (server.getDefaultComponentManagerAsGeniUrn() != null);
        if (!node.getSliverTypes().isEmpty()) {
            if (tested.getSliverType() == null) {
                score -= 15;
            } else if (node.getSliverTypes().stream().map(SliverType::getName).noneMatch(stn -> Objects.equals(stn, tested.getSliverType()))) {
                if (!Collections.disjoint(node.getSliverTypes(), tested.getAllowedSliverTypesNonNull())) {
                    if (!Objects.equals(tested.getSliverType(), "default-vm")) {
                        score -= 5;
                    }
                } else {
                    score -= 15;
                }
            }
        } else if (tested.getSliverType() != null) {
            score -= 15;
        }
        if (node.getComponentManagerId() != null) {
            if (server.getDefaultComponentManagerAsGeniUrn() == null) {
                score -= 20;
            } else if (!Objects.equals(node.getComponentManagerId(), tested.getServer().getDefaultComponentManagerAsGeniUrn())) {
                score -= 20;
            }
        }
        if (tested.getAutoFilterFixedNodesByHardwareTypeOrDefault() && !tested.getFilterFixedNodesByHardwareTypeOrDefault().isEmpty() && node.getComponentId() != null && !(nodeHardwareTypes = this.findNodeHardwareTypes(node, server)).isEmpty()) {
            score = tested.getFilterFixedNodesByHardwareTypeOrDefault().stream().anyMatch(nodeHardwareTypes::contains) ? (score += 5) : (score -= 2);
        }
        if (tested.getAutoFilterFixedNodesBySliverTypeOrDefault() && !tested.getFilterFixedNodesBySliverTypeOrDefault().isEmpty() && node.getSliverType() != null) {
            List filterFixedNodesBySliverType = tested.getFilterFixedNodesBySliverTypeOrDefault();
            score = node.getSliverTypes().stream().map(SliverType::getName).anyMatch(filterFixedNodesBySliverType::contains) ? ++score : --score;
        }
        if (node.getHardwareTypes() != null && !node.getHardwareTypes().isEmpty() && ((HardwareType)node.getHardwareTypes().get(0)).getName() != null) {
            String hwTypeName = ((HardwareType)node.getHardwareTypes().get(0)).getName();
            if (!tested.getAllowHardwareType().booleanValue()) {
                score -= 10;
            } else if (tested.getHardwareType() != null) {
                score = Objects.equals(tested.getHardwareType(), hwTypeName) ? (score += 4) : (score -= 10);
            }
        } else {
            nodeHardwareTypes = this.findNodeHardwareTypes(node, server);
            if (!nodeHardwareTypes.isEmpty()) {
                score = tested.getHardwareType() != null && nodeHardwareTypes.contains(tested.getHardwareType()) ? (score += 5) : (score -= 2);
            } else if (tested.getRequireHardwareType().booleanValue()) {
                score -= 10;
            } else if (tested.getAllowHardwareType().booleanValue() && tested.getHardwareType() != null) {
                score -= 5;
            }
        }
        if (node.getComponentManagerId() != null) {
            if (!tested.getAllowFixedNodeAssignment().booleanValue()) {
                score -= 10;
            } else if (tested.getComponentUrn() != null) {
                score = Objects.equals(tested.getComponentUrn(), node.getComponentManagerId().toString()) ? (score += 4) : (score -= 10);
            }
        } else if (tested.getRequireFixedNodeAssignment().booleanValue()) {
            score -= 10;
        } else if (tested.getAllowFixedNodeAssignment().booleanValue() && tested.getComponentUrn() != null) {
            score -= 5;
        }
        if (node.getSliverTypes() != null && !node.getSliverTypes().isEmpty() && ((SliverType)node.getSliverTypes().get(0)).getDiskImages() != null && !((SliverType)node.getSliverTypes().get(0)).getDiskImages().isEmpty()) {
            DiskImage diskImage = (DiskImage)((SliverType)node.getSliverTypes().get(0)).getDiskImages().get(0);
            if (!tested.getAllowDiskImage().booleanValue()) {
                score -= 10;
            } else if (tested.getDiskImage() != null) {
                boolean matchUrl;
                boolean matchName = diskImage.getName() != null && Objects.equals(diskImage.getName(), tested.getDiskImage());
                boolean bl = matchUrl = diskImage.getUrl() != null && Objects.equals(diskImage.getUrl(), tested.getDiskImage());
                score = matchName || matchUrl ? (score += 4) : (score -= 10);
            }
        } else if (tested.getRequireDiskImage().booleanValue()) {
            score -= 10;
        } else if (tested.getAllowDiskImage().booleanValue() && tested.getDiskImage() != null) {
            score -= 2;
        }
        if (node.getExclusive() != null && tested.getDefaultExclusive() != null) {
            score = tested.getDefaultExclusive() != node.getExclusive() ? (tested.getAllowModifyExclusive().booleanValue() ? (score += 0) : (score -= 10)) : ++score;
        } else if (tested.getDefaultExclusive() != null) {
            --score;
        }
        return score;
    }

    @Override
    @Nullable
    public ResourceClass findBestResourceClass(@Nonnull RspecNode node) {
        Resource bestResource = this.findBestResource(null, node, null);
        return bestResource != null ? bestResource.getResourceClass() : null;
    }

    @Override
    @Nonnull
    public List<ResourceClass> findAllPossibleResourceClasses(@Nonnull RspecNode node) {
        List<Resource> resources = this.findAllPossibleResources(null, node, null);
        HashSet<ResourceClass> res = new HashSet<ResourceClass>();
        for (Resource resource : resources) {
            res.add(resource.getResourceClass());
        }
        return new ArrayList<ResourceClass>(res);
    }

    @Override
    @Nullable
    public Resource findBestResource(@Nullable ResourceClass resourceClass, @Nonnull RspecNode node, @Nullable Server overrideComponentManager) {
        List<Resource> all = this.findAllPossibleResources(resourceClass, node, overrideComponentManager);
        if (all.isEmpty()) {
            return null;
        }
        Resource best = all.get(0);
        if (all.size() == 1) {
            return best;
        }
        int bestScore = this.matchScore(best, node);
        LOG.debug("score for resource " + best.getId() + " of (sliver_type=" + node.getSliverTypeName() + ") " + best.getResourceClassId() + " is " + bestScore);
        for (int i = 1; i < all.size(); ++i) {
            Resource cur = all.get(i);
            int curScore = this.matchScore(cur, node);
            LOG.debug("score for resource " + cur.getId() + " of (sliver_type=" + node.getSliverTypeName() + ") " + cur.getResourceClassId() + " is " + curScore);
            if (curScore <= bestScore && (curScore != bestScore || best.getResourceClassId() == null || !best.getResourceClassId().contains("generic"))) continue;
            bestScore = curScore;
            best = cur;
        }
        LOG.debug("  => chose " + best.getId() + " of " + best.getResourceClassId() + " with score " + bestScore);
        return best;
    }

    @Override
    @Nonnull
    public List<Resource> findAllPossibleResources(@Nonnull Server server) {
        assert (server.getId() != null);
        List<Resource> resources = this.resourcesByServerId.get(server.getId());
        if (resources == null) {
            return Collections.emptyList();
        }
        return resources;
    }

    @Override
    @Nonnull
    public List<ResourceClass> findAllPossibleResourceClasses(@Nonnull Server server) {
        List<Resource> resources = this.findAllPossibleResources(server);
        HashSet<ResourceClass> res = new HashSet<ResourceClass>();
        for (Resource resource : resources) {
            res.add(resource.getResourceClass());
        }
        return new ArrayList<ResourceClass>(res);
    }

    @Override
    @Nonnull
    public List<Resource> findAllPossibleResources(@Nullable ResourceClass resourceClass, @Nonnull RspecNode node, @Nullable Server overrideComponentManager) {
        GeniUrn componentManagerUrn;
        assert (overrideComponentManager == null || overrideComponentManager.getDefaultComponentManagerAsGeniUrn() != null);
        GeniUrn geniUrn = componentManagerUrn = overrideComponentManager != null ? overrideComponentManager.getDefaultComponentManagerAsGeniUrn() : node.getComponentManagerId();
        Server server = overrideComponentManager != null ? overrideComponentManager : (componentManagerUrn == null ? null : this.authorityFinder.findByUrn(componentManagerUrn, AuthorityFinder.Purpose.REQUEST_RSPEC));
        String sliverTypeName = null;
        for (SliverType sliverType : node.getSliverTypes()) {
            if (sliverType == null || sliverType.getName() == null) continue;
            sliverTypeName = sliverType.getName();
        }
        if (server != null) {
            List<Resource> resources;
            assert (server.getId() != null);
            if (sliverTypeName != null) {
                resources = this.resourcesByServerIdAndSliverName.get(new Pair((Object)((Integer)server.getId()), (Object)sliverTypeName));
                if (resources == null && (resources = this.resourcesByServerIdAndSliverName.get(new Pair((Object)((Integer)server.getId()), (Object)"default-vm"))) == null) {
                    resources = this.resourcesByServerId.get(server.getId());
                }
            } else {
                resources = this.resourcesByServerId.get(server.getId());
            }
            if (resources == null) {
                return Collections.emptyList();
            }
            ArrayList<Resource> res = new ArrayList<Resource>(resources.size());
            for (Resource candidate : resources) {
                if (resourceClass != null && !((String)candidate.getResourceClass().getId()).equals(resourceClass.getId())) continue;
                res.add(candidate);
            }
            return res;
        }
        if (componentManagerUrn == null) {
            assert (node.getComponentManagerId() == null);
            ArrayList<Resource> res = new ArrayList<Resource>(this.allResources.size());
            for (Resource candidate : this.allResources) {
                if (resourceClass != null && !((String)candidate.getResourceClass().getId()).equals(resourceClass.getId()) || sliverTypeName != null && candidate.getSliverType() != null && !Objects.equals(sliverTypeName, candidate.getSliverType())) continue;
                res.add(candidate);
            }
            return res;
        }
        LOG.warn("No server found for node with component_manager_id=" + componentManagerUrn);
        return Collections.emptyList();
    }

    public boolean isLeaf(ResourceClass resourceClass) {
        if (resourceClass.getInstantiateAsId() == null) {
            return true;
        }
        if (Objects.equals(resourceClass.getInstantiateAsId(), resourceClass.getId())) {
            LOG.warn("error in resourceClass InstantiateAs: " + (String)resourceClass.getId() + " InstantiateAs itself");
            return true;
        }
        return false;
    }

    public ResourceClass getLeaf(ResourceClass resourceClass) {
        if (this.isLeaf(resourceClass)) {
            LOG.warn("Called getLeaf on a leaf " + (String)resourceClass.getId());
            return resourceClass;
        }
        ResourceClass res = resourceClass;
        while (!this.isLeaf(res)) {
            assert (res.getInstantiateAsId() != null);
            if ((res = this.getResourceClass(res.getInstantiateAsId())) != null) continue;
            LOG.error("Error in resourceClass InstantiateAs. res = null");
            return null;
        }
        assert (!this.isLeaf(res));
        return res;
    }

    @Override
    public Resource getDefaultResource(ResourceClass resourceClass) {
        if ((resourceClass.getDefaultResource() == null || resourceClass.getDefaultResource().isEmpty()) && !this.isLeaf(resourceClass)) {
            ResourceClass parent = resourceClass;
            if ((resourceClass = this.getLeaf(resourceClass)) == null) {
                LOG.error("resourceClass {} has no leaf!", parent.getId());
                return null;
            }
        }
        if (resourceClass.getDefaultResource() == null || resourceClass.getDefaultResource().isEmpty()) {
            if (resourceClass.getResources() == null || resourceClass.getResources().isEmpty()) {
                return null;
            }
            return (Resource)resourceClass.getResources().get(0);
        }
        Integer randomIndex = this.randomByResourceClassId.get(resourceClass.getId());
        if (randomIndex != null) {
            assert (randomIndex >= 0);
            assert (randomIndex < resourceClass.getDefaultResource().size());
            return (Resource)resourceClass.getDefaultResource().get(randomIndex);
        }
        randomIndex = rand.nextInt(resourceClass.getDefaultResource().size());
        this.randomByResourceClassId.put((String)resourceClass.getId(), randomIndex);
        return (Resource)resourceClass.getDefaultResource().get(randomIndex);
    }

    @Override
    public Boolean getNodeExclusivity(GeniUrn componentManagerUrn, String sliverTypeName) {
        Server server = this.authorityFinder.findByUrn(componentManagerUrn, AuthorityFinder.Purpose.REQUEST_RSPEC);
        if (server == null) {
            return null;
        }
        List<Resource> resources = this.resourcesByServerIdAndSliverName.get(new Pair((Object)((Integer)server.getId()), (Object)sliverTypeName));
        if (resources == null || resources.isEmpty()) {
            return null;
        }
        Boolean res = null;
        for (Resource resource : resources) {
            if (resource.getDefaultExclusive() == null) continue;
            if (res == null) {
                res = resource.getDefaultExclusive();
                continue;
            }
            if (res == resource.getDefaultExclusive()) continue;
            LOG.warn("Conflicting node exclusivity for server=" + server.getId() + " sliverType=" + sliverTypeName + " all resource IDs: " + resources.stream().map(PrimaryIdObject::getId).collect(Collectors.toList()));
            return false;
        }
        return res;
    }

    @Override
    public boolean hasUpToDateComponentInfo(@Nonnull Server server, @Nonnull JFedGuiConfig.Scope scope) {
        int serverId = (Integer)server.getId();
        AdvertisementInfo allRspec = this.getAdvertisementInfo(serverId, AdvertisementInfoSourceType.AllAdvertisementRspec);
        AdvertisementInfo availableRspec = this.getAdvertisementInfo(serverId, AdvertisementInfoSourceType.FedmonNodeStatus);
        AdvertisementInfo serverGlimpse = this.getAdvertisementInfo(serverId, AdvertisementInfoSourceType.ServerGlimpse);
        boolean allRspecIsCandidate = allRspec.hasInfo() && !allRspec.olderThan(Duration.ofHours(1L));
        boolean availableRspecIsCandidate = availableRspec.hasInfo() && !availableRspec.olderThan(Duration.ofHours(1L));
        boolean serverGlimpseIsCandidate = serverGlimpse.hasInfo() && !serverGlimpse.olderThan(Duration.ofHours(1L));
        switch (scope) {
            case ALL: {
                return allRspecIsCandidate || serverGlimpseIsCandidate;
            }
            case AVAILABLE_ONLY: {
                return allRspecIsCandidate || serverGlimpseIsCandidate || availableRspecIsCandidate;
            }
        }
        throw new IllegalArgumentException("Invalid scope: " + scope);
    }

    @Override
    public ObservableList<JFedGuiConfig.ComponentInfo> getComponentInfo(@Nonnull Server server, @Nonnull JFedGuiConfig.Scope scope, @Nullable Resource resource) {
        AdvertisementProperties bestAdvertisementProperties = this.getBestAdvertisementProperties((Integer)server.getId());
        ListProperty<JFedGuiConfig.ComponentInfo> res = switch (scope) {
            case JFedGuiConfig.Scope.ALL -> bestAdvertisementProperties.allComponentInfos;
            case JFedGuiConfig.Scope.AVAILABLE_ONLY -> bestAdvertisementProperties.availableComponentInfos;
            default -> throw new IllegalArgumentException("Invalid scope: " + scope);
        };
        ArrayList<Predicate<JFedGuiConfig.ComponentInfo>> filters = new ArrayList<Predicate<JFedGuiConfig.ComponentInfo>>();
        if (resource != null && resource.getAutoFilterFixedNodesBySliverTypeOrDefault()) {
            List allowedSliverTypes = resource.getFilterFixedNodesBySliverTypeOrDefault();
            if (allowedSliverTypes.isEmpty()) {
                allowedSliverTypes = resource.getAllowedSliverTypesNonNull();
            }
            if (!allowedSliverTypes.isEmpty()) {
                List allowedSliverTypesFinal = allowedSliverTypes;
                filters.add(ci -> {
                    if (ci.getSliverTypeNames() == null) return true;
                    if (ci.getSliverTypeNames().isEmpty()) return true;
                    if (ci.getSliverTypeNames().stream().filter(Objects::nonNull).anyMatch(allowedSliverTypesFinal::contains)) return true;
                    if (!allowedSliverTypesFinal.contains("default-vm")) return false;
                    if (ci.getSliverTypeNames().isEmpty()) return false;
                    return true;
                });
            }
        }
        if (resource != null && resource.getAutoFilterFixedNodesByHardwareTypeOrDefault()) {
            List<String> allowedHardwareTypes = resource.getFilterFixedNodesByHardwareTypeOrDefault();
            if (allowedHardwareTypes.isEmpty() && resource.getHardwareType() != null && resource.getRequireHardwareType().booleanValue() && !resource.getAllowHardwareType().booleanValue()) {
                allowedHardwareTypes = Collections.singletonList(resource.getHardwareType());
            }
            if (!allowedHardwareTypes.isEmpty()) {
                List<String> allowedHardwareTypesFinal = allowedHardwareTypes;
                filters.add(ci -> {
                    if (ci.getHardwareTypeNames() == null) return true;
                    if (ci.getHardwareTypeNames().isEmpty()) return true;
                    if (!ci.getHardwareTypeNames().stream().filter(Objects::nonNull).anyMatch(allowedHardwareTypesFinal::contains)) return false;
                    return true;
                });
            }
        }
        if (!filters.isEmpty()) {
            if (filters.size() == 1) {
                return new FilteredList(res, (Predicate)filters.get(0));
            }
            Predicate<JFedGuiConfig.ComponentInfo> joined_filters = filters.stream().reduce(ci -> true, Predicate::and);
            return new FilteredList(res, joined_filters);
        }
        return res;
    }

    @Override
    public ObservableList<String> getSliverTypeNames(@Nonnull Server server) {
        return this.getBestAdvertisementProperties((Integer)((Integer)server.getId())).sliverTypeNames;
    }

    @Override
    public List<String> getAdvertisedSliverTypeNames(@Nonnull Server server) {
        Integer serverId = (Integer)server.getId();
        if (serverId == null) {
            return Collections.emptyList();
        }
        AdvertisementInfo allRspec = this.getAdvertisementInfo(serverId, AdvertisementInfoSourceType.AllAdvertisementRspec);
        AdvertisementInfo availableRspec = this.getAdvertisementInfo(serverId, AdvertisementInfoSourceType.AvailableAdvertisementRspec);
        AdvertisementInfo serverGlimpse = this.getAdvertisementInfo(serverId, AdvertisementInfoSourceType.ServerGlimpse);
        TreeSet<String> res = new TreeSet<String>();
        res.addAll(allRspec.sliverTypeNames);
        res.addAll(availableRspec.sliverTypeNames);
        res.addAll(serverGlimpse.sliverTypeNames);
        return new ArrayList<String>(res);
    }

    @Override
    public ObservableList<JFedGuiConfig.HardwareTypeInfo> getHardwareTypes(@Nonnull Server server, @Nonnull JFedGuiConfig.Scope scope, @Nullable Resource resource) {
        assert (Platform.isFxApplicationThread());
        AdvertisementProperties bestAdvertisementProperties = this.getBestAdvertisementProperties((Integer)server.getId());
        FilteredList res = switch (scope) {
            case JFedGuiConfig.Scope.ALL -> bestAdvertisementProperties.allHardwareTypes;
            case JFedGuiConfig.Scope.AVAILABLE_ONLY -> bestAdvertisementProperties.availableHardwareTypes;
            default -> throw new IllegalArgumentException("Invalid scope: " + scope);
        };
        if (resource != null && resource.getAllowedSliverTypes() != null && !resource.getAllowedSliverTypes().isEmpty()) {
            HashSet allowedHardwareTypes = new HashSet();
            for (String sliverTypeName : resource.getAllowedSliverTypes()) {
                Set hardwareTypes = (Set)((Map)bestAdvertisementProperties.sliverTypeNameToHardwareTypeName.get()).get(sliverTypeName);
                if (hardwareTypes == null) continue;
                allowedHardwareTypes.addAll(hardwareTypes);
            }
            res = new FilteredList(res, hti -> allowedHardwareTypes.contains(hti.getHardwareTypeName()));
        }
        return res;
    }

    @Override
    public ReadOnlyListProperty<DiskImage> getDiskImages(@Nonnull Server server, @Nullable String sliverTypeName) {
        if (sliverTypeName != null && sliverTypeName.equals("default-vm") && (server.isServerType("emulab") || server.isServerType("instageni"))) {
            sliverTypeName = "emulab-xen";
        }
        AdvertisementProperties bestAdvProp = this.getBestAdvertisementProperties((Integer)server.getId());
        if (sliverTypeName == null) {
            return bestAdvProp.diskImages;
        }
        return (ReadOnlyListProperty)bestAdvProp.diskImagesBySliverType.computeIfAbsent(sliverTypeName, key -> new SimpleListProperty(FXCollections.observableArrayList()));
    }

    @Override
    public ReadOnlyListProperty<String> getFlavors(@Nonnull Server server, @Nullable String sliverTypeName) {
        if (sliverTypeName != null && sliverTypeName.equals("default-vm") && (server.isServerType("emulab") || server.isServerType("instageni"))) {
            sliverTypeName = "emulab-xen";
        }
        AdvertisementProperties bestAdvProp = this.getBestAdvertisementProperties((Integer)server.getId());
        if (sliverTypeName == null) {
            LOG.debug("Returning {} flavors for server {}", (Object)bestAdvProp.flavors.size(), server.getId());
            return bestAdvProp.flavors;
        }
        ListProperty res = bestAdvProp.flavorsBySliverType.computeIfAbsent(sliverTypeName, key -> new SimpleListProperty(FXCollections.observableArrayList()));
        LOG.debug("Returning {} flavors for server {} sliverTypeName {}", new Object[]{res.size(), server.getId(), sliverTypeName});
        return res;
    }

    @Override
    @Nonnull
    public ObjectProperty<Integer> getServerReputation(@Nonnull Server server) {
        return this.getBestAdvertisementProperties((Integer)((Integer)server.getId())).reputation;
    }

    @Override
    @Nonnull
    public ObservableList<MaintenanceInfo> getServerMaintenance(@Nonnull Server server) {
        return this.getBestAdvertisementProperties((Integer)((Integer)server.getId())).maintenance;
    }

    @Override
    @Nonnull
    public ObservableList<TestbedSiteInfo> getTestbedSiteInfo(@Nonnull Server server) {
        return this.getBestAdvertisementProperties((Integer)((Integer)server.getId())).testbedSiteInfo;
    }

    @Override
    @Nonnull
    public ObjectProperty<ServerGlimpse.HealthInfo> getServerHealthInfo(@Nonnull Server server) {
        return this.getBestAdvertisementProperties((Integer)((Integer)server.getId())).healthInfo;
    }

    @Override
    @Nonnull
    public ObjectProperty<ServerGlimpse.AdvertisementInfo.HardwareTypeInfo> getHardwareTypeInfo(@Nonnull Server server) {
        return this.getBestAdvertisementProperties((Integer)((Integer)server.getId())).hardwareTypeInfo;
    }

    @Override
    @Nonnull
    public ReadOnlyObjectProperty<? extends AdvertisementCounts> getServerNodeCounts(@Nonnull Server server) {
        return this.getBestAdvertisementProperties((Integer)((Integer)server.getId())).counts;
    }

    @Override
    public ReadOnlyObjectProperty<AdvertisementRspecSource> getAdvertisement(Server server, @Nullable Boolean availableOnly) {
        if (availableOnly != null) {
            if (availableOnly.booleanValue()) {
                return (ReadOnlyObjectProperty)this.availableAdvertisementByServerId.computeIfAbsent((Integer)server.getId(), key -> new SimpleObjectProperty());
            }
            return (ReadOnlyObjectProperty)this.allAdvertisementByServerId.computeIfAbsent((Integer)server.getId(), key -> new SimpleObjectProperty());
        }
        return (ReadOnlyObjectProperty)this.anyAdvertisementByServerId.computeIfAbsent((Integer)server.getId(), key -> new SimpleObjectProperty());
    }

    @Override
    public JFedGuiConfig.NodesVisualization getNodesVisualization(Server server) {
        return this.imageMapByServerId.containsKey(server.getId()) ? JFedGuiConfig.NodesVisualization.IMAGE : JFedGuiConfig.NodesVisualization.MAP;
    }

    @Override
    public ImageMap<GeniUrn> getImageMap(Server server) {
        return this.imageMapByServerId.get(server.getId());
    }

    @Override
    public ServerGlimpse getServerGlimpse(Server server) {
        return this.serverGlimpseByServerId.get(server.getId());
    }

    @Override
    @Nonnull
    public Color getColor(Server server) {
        return server == null || server.getTestbed() == null ? Color.TRANSPARENT : this.getColor(server.getTestbed());
    }

    @Override
    @Nonnull
    public Color getColor(Testbed testbed) {
        return testbed == null || testbed.getColor() == null || testbed.getColor().trim().isEmpty() ? Color.TRANSPARENT : this.getColor(testbed.getColor());
    }

    @Override
    @Nonnull
    public Color getColor(String colorName) {
        if (colorName == null) {
            return Color.TRANSPARENT;
        }
        try {
            return Color.valueOf((String)colorName.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            LOG.warn("Cannot convert color \"{}\" to javafx.scene.paint.Color", (Object)colorName, (Object)ex);
            return Color.TRANSPARENT;
        }
    }

    private AdvertisementInfo getAdvertisementInfo(@Nonnull Server server, @Nonnull AdvertisementInfoSourceType type) {
        return this.getAdvertisementInfo((Integer)server.getId(), type);
    }

    private AdvertisementInfo getAdvertisementInfo(@Nonnull Integer serverId, @Nonnull AdvertisementInfoSourceType type) {
        return this.advertisementInfoById.computeIfAbsent(new AdvertisementInfoSourceId(serverId, type), AdvertisementInfo::new);
    }

    private AdvertisementProperties getBestAdvertisementProperties(@Nonnull Integer serverId) {
        assert (Platform.isFxApplicationThread());
        AdvertisementProperties res = this.advertisementPropertiesByServerId.get(serverId);
        if (res == null) {
            return this.updateBestAdvertisementInfo(serverId);
        }
        return res;
    }

    private AdvertisementProperties updateBestAdvertisementInfo(@Nonnull Integer serverId) {
        Server server;
        assert (Platform.isFxApplicationThread());
        AdvertisementInfo tmpAll = new AdvertisementInfo(serverId, AdvertisementInfoSourceType.Best);
        AdvertisementInfo tmpAvail = new AdvertisementInfo(serverId, AdvertisementInfoSourceType.Best);
        AdvertisementInfo allRspec = this.getAdvertisementInfo(serverId, AdvertisementInfoSourceType.AllAdvertisementRspec);
        AdvertisementInfo availableRspec = this.getAdvertisementInfo(serverId, AdvertisementInfoSourceType.AvailableAdvertisementRspec);
        AdvertisementInfo fedmonNodeStatus = this.getAdvertisementInfo(serverId, AdvertisementInfoSourceType.FedmonNodeStatus);
        AdvertisementInfo serverGlimpse = this.getAdvertisementInfo(serverId, AdvertisementInfoSourceType.ServerGlimpse);
        AdvertisementInfo resourceClass = this.getAdvertisementInfo(serverId, AdvertisementInfoSourceType.ResourceClass);
        AdvertisementInfo user = this.getAdvertisementInfo(serverId, AdvertisementInfoSourceType.User);
        boolean allRspecIsCandidate = allRspec.hasInfo() && !allRspec.olderThan(Duration.ofHours(1L));
        boolean availableRspecIsCandidate = availableRspec.hasInfo() && !availableRspec.olderThan(Duration.ofHours(1L));
        boolean serverGlimpseIsCandidate = serverGlimpse.hasInfo() && !serverGlimpse.olderThan(Duration.ofHours(1L));
        AdvertisementInfoSourceType preferenceAll = null;
        AdvertisementInfoSourceType preferenceAvail = null;
        if (!allRspecIsCandidate && !serverGlimpseIsCandidate && availableRspecIsCandidate) {
            preferenceAvail = AdvertisementInfoSourceType.AvailableAdvertisementRspec;
            preferenceAll = AdvertisementInfoSourceType.AvailableAdvertisementRspec;
        } else {
            if (allRspecIsCandidate && serverGlimpseIsCandidate) {
                preferenceAll = serverGlimpse.date != null && allRspec.date != null && allRspec.date.before(serverGlimpse.date) ? AdvertisementInfoSourceType.ServerGlimpse : AdvertisementInfoSourceType.AllAdvertisementRspec;
            } else {
                if (serverGlimpseIsCandidate) {
                    preferenceAll = AdvertisementInfoSourceType.ServerGlimpse;
                }
                if (allRspecIsCandidate) {
                    preferenceAll = AdvertisementInfoSourceType.AllAdvertisementRspec;
                }
            }
            if (allRspecIsCandidate && serverGlimpseIsCandidate && availableRspecIsCandidate) {
                preferenceAvail = serverGlimpse.date != null && allRspec.date != null && availableRspec.date != null ? (allRspec.date.before(serverGlimpse.date) && availableRspec.date.before(serverGlimpse.date) ? AdvertisementInfoSourceType.ServerGlimpse : (allRspec.date.after(serverGlimpse.date) && allRspec.date.after(availableRspec.date) ? AdvertisementInfoSourceType.AvailableAdvertisementRspec : AdvertisementInfoSourceType.AllAdvertisementRspec)) : AdvertisementInfoSourceType.AllAdvertisementRspec;
            } else {
                if (serverGlimpseIsCandidate) {
                    preferenceAvail = AdvertisementInfoSourceType.ServerGlimpse;
                }
                if (allRspecIsCandidate) {
                    preferenceAvail = AdvertisementInfoSourceType.AllAdvertisementRspec;
                }
                if (availableRspecIsCandidate) {
                    preferenceAvail = AdvertisementInfoSourceType.AvailableAdvertisementRspec;
                }
            }
        }
        if (preferenceAll != null) {
            switch (preferenceAll) {
                case AllAdvertisementRspec: {
                    tmpAll.set(allRspec);
                    break;
                }
                case AvailableAdvertisementRspec: {
                    tmpAll.set(availableRspec);
                    break;
                }
                case ServerGlimpse: {
                    tmpAll.set(serverGlimpse);
                    break;
                }
                default: {
                    throw new RuntimeException("Bad preferenceAll: bug in code. " + preferenceAll);
                }
            }
        }
        if (preferenceAvail != null) {
            switch (preferenceAvail) {
                case AllAdvertisementRspec: {
                    tmpAvail.set(allRspec);
                    break;
                }
                case AvailableAdvertisementRspec: {
                    tmpAvail.set(availableRspec);
                    break;
                }
                case ServerGlimpse: {
                    tmpAvail.set(serverGlimpse);
                    break;
                }
                default: {
                    throw new RuntimeException("Bad preferenceAvail: bug in code. " + preferenceAvail);
                }
            }
        }
        if (resourceClass.hasInfo()) {
            assert (resourceClass.diskImages.stream().allMatch(Objects::nonNull));
            assert (resourceClass.flavors.stream().allMatch(Objects::nonNull));
            tmpAll.addSliverTypeNames(resourceClass.sliverTypeNames);
            tmpAll.addHardwareTypes(resourceClass.hardwareTypes);
            tmpAll.addDiskImages(resourceClass.diskImages);
            tmpAll.addFlavors(resourceClass.flavors);
            tmpAll.addComponentInfos(resourceClass.componentInfos);
            tmpAvail.addSliverTypeNames(resourceClass.sliverTypeNames);
            tmpAvail.addHardwareTypes(resourceClass.hardwareTypes);
            tmpAvail.addDiskImages(resourceClass.diskImages);
            tmpAvail.addFlavors(resourceClass.flavors);
            tmpAvail.addComponentInfos(resourceClass.componentInfos);
        }
        if (fedmonNodeStatus.hasInfo()) {
            HashMap<GeniUrn, JFedGuiConfig.ComponentInfo> allComponentInfoByUrn = new HashMap<GeniUrn, JFedGuiConfig.ComponentInfo>();
            HashMap<GeniUrn, JFedGuiConfig.ComponentInfo> availComponentInfoByUrn = new HashMap<GeniUrn, JFedGuiConfig.ComponentInfo>();
            for (JFedGuiConfig.ComponentInfo ci : tmpAll.componentInfos) {
                if (ci.getUrn() == null) continue;
                allComponentInfoByUrn.put(ci.getUrn(), ci);
            }
            for (JFedGuiConfig.ComponentInfo ci : tmpAvail.componentInfos) {
                if (ci.getUrn() == null) continue;
                availComponentInfoByUrn.put(ci.getUrn(), ci);
            }
            int updatedAllCount = 0;
            int updatedAvailCount = 0;
            for (JFedGuiConfig.ComponentInfo fnsCi : fedmonNodeStatus.componentInfos) {
                JFedGuiConfig.ComponentInfo newCi;
                if (fnsCi.getUrn() == null) continue;
                JFedGuiConfig.ComponentInfo tmpAllCi = (JFedGuiConfig.ComponentInfo)allComponentInfoByUrn.get(fnsCi.getUrn());
                JFedGuiConfig.ComponentInfo tmpAvailCi = (JFedGuiConfig.ComponentInfo)allComponentInfoByUrn.get(fnsCi.getUrn());
                if (tmpAllCi != null) {
                    newCi = tmpAllCi.copyWithMergedExtraInfo(fnsCi);
                    allComponentInfoByUrn.put(fnsCi.getUrn(), newCi);
                    ++updatedAllCount;
                }
                if (tmpAvailCi == null) continue;
                newCi = tmpAvailCi.copyWithMergedExtraInfo(fnsCi);
                availComponentInfoByUrn.put(fnsCi.getUrn(), newCi);
                ++updatedAvailCount;
            }
            LOG.debug("Updated componentInfo using fedmonNodeInfo ({}): all_upd={} avail_upd={}", new Object[]{fedmonNodeStatus.componentInfos.size(), updatedAllCount, updatedAvailCount});
            tmpAll.componentInfos.clear();
            tmpAll.componentInfos.addAll(allComponentInfoByUrn.values());
            tmpAvail.componentInfos.clear();
            tmpAvail.componentInfos.addAll(availComponentInfoByUrn.values());
        }
        if ((server = this.testbedInfoSource.getServerById(serverId)) != null) {
            GeniUrn defaultComponentManagerId = server.getDefaultComponentManagerAsGeniUrn();
            if (defaultComponentManagerId != null && !tmpAll.componentManagerIds.contains(defaultComponentManagerId)) {
                tmpAll.componentManagerIds.add(defaultComponentManagerId);
            }
            if (defaultComponentManagerId != null && !tmpAvail.componentManagerIds.contains(defaultComponentManagerId)) {
                tmpAvail.componentManagerIds.add(defaultComponentManagerId);
            }
        }
        tmpAll.componentInfos.addAll(user.componentInfos);
        tmpAvail.componentInfos.addAll(user.componentInfos);
        AdvertisementProperties res = this.advertisementPropertiesByServerId.computeIfAbsent(serverId, si -> new AdvertisementProperties(serverId, server));
        res.set(tmpAll, tmpAvail, server != null ? this.getServerGlimpse(server) : null);
        res.updateTestbedSiteInfo();
        return res;
    }

    public static boolean isHardwareTypeToIgnore(HardwareType hardwareType) {
        String name = hardwareType.getName();
        if (name == null) {
            return true;
        }
        String lowerCaseName = name.toLowerCase();
        if (HARDWARE_TYPE_NAMES_BLACKLIST.contains((Object)lowerCaseName)) {
            return true;
        }
        return HARDWARE_TYPE_NAMES_SUBSTRING_BLACKLIST.stream().anyMatch(lowerCaseName::contains);
    }

    @Nullable
    public static AdvertisementCounts.CountedObject sliverTypeToObject(String sliverTypeName) {
        switch (sliverTypeName) {
            case "raw-pc": {
                return AdvertisementCounts.CountedObject.RAW_PC;
            }
        }
        return null;
    }

    @Override
    public void setAdvertisementRspec(Integer serverId, boolean availableAdvertisementRspec, ModelRspec modelRspec, Date fetchDate) {
        assert (Platform.isFxApplicationThread());
        AdvertisementInfo advInfo = availableAdvertisementRspec ? this.getAdvertisementInfo(serverId, AdvertisementInfoSourceType.AvailableAdvertisementRspec) : this.getAdvertisementInfo(serverId, AdvertisementInfoSourceType.AllAdvertisementRspec);
        AdvertisementCounts.CountScope countScope = availableAdvertisementRspec ? AdvertisementCounts.CountScope.AVAILABLE : AdvertisementCounts.CountScope.ALL;
        advInfo.clear();
        advInfo.date = fetchDate;
        for (RspecNode node : modelRspec.getNodes()) {
            HashSet<String> curHardwareTypeNames = new HashSet<String>();
            HashSet<String> curSliverTypeNames = new HashSet<String>();
            if (node.getHardwareTypes() != null) {
                for (HardwareType hardwareType : node.getHardwareTypes()) {
                    if (hardwareType.getName() == null || JFedGuiConfigImpl.isHardwareTypeToIgnore(hardwareType)) continue;
                    curHardwareTypeNames.add(hardwareType.getName());
                    advInfo.addHardwareTypeName(hardwareType.getName(), node.getAvailable() != null ? node.getAvailable() : (availableAdvertisementRspec ? Boolean.valueOf(true) : null));
                }
            }
            if (node.getComponentManagerId() != null) {
                advInfo.componentManagerIds.add(node.getComponentManagerId());
            }
            if (node.getSliverTypes() != null) {
                for (SliverType sliverType : node.getSliverTypes()) {
                    DiskImageList list;
                    String sliverTypeName = sliverType.getName();
                    if (sliverTypeName != null) {
                        advInfo.addSliverTypeName(sliverTypeName);
                        curSliverTypeNames.add(sliverTypeName);
                    } else {
                        LOG.warn("sliver_type without name attribute in advertisement RSpec. That should never occur.");
                    }
                    if (sliverType.getDiskImages() != null) {
                        for (DiskImage diskImage : sliverType.getDiskImages()) {
                            assert (diskImage != null);
                            advInfo.addDiskImage(diskImage);
                            if (sliverTypeName == null) continue;
                            advInfo.addDiskImage(sliverTypeName, diskImage);
                        }
                    }
                    for (String diskImageListRef : sliverType.getDiskImageListRefs()) {
                        list = modelRspec.getDiskImageList(diskImageListRef);
                        if (list != null) {
                            LOG.debug("Found disk image list matching ref {} with {} items and using it", (Object)diskImageListRef, (Object)list.getDiskImages().size());
                            advInfo.addDiskImages(sliverTypeName, list.getDiskImages());
                            advInfo.addDiskImages(list.getDiskImages());
                            continue;
                        }
                        LOG.debug("Did not find referenced disk image list {}", (Object)diskImageListRef);
                    }
                    if (sliverType.getFlavors() != null) {
                        for (String flavor : sliverType.getFlavors()) {
                            assert (flavor != null);
                            advInfo.addFlavor(flavor);
                            if (sliverTypeName == null) continue;
                            advInfo.addFlavor(sliverTypeName, flavor);
                        }
                    }
                    for (String flavorListRef : sliverType.getFlavorListRefs()) {
                        list = modelRspec.getFlavorList(flavorListRef);
                        if (list != null) {
                            LOG.debug("Found flavor list matching ref {} with {} items and using it", (Object)flavorListRef, (Object)list.getFlavors().size());
                            advInfo.addFlavors(sliverTypeName, list.getFlavors());
                            advInfo.addFlavors(list.getFlavors());
                            continue;
                        }
                        LOG.debug("Did not find referenced flavor list {}", (Object)flavorListRef);
                    }
                }
            }
            if (node.getComponentId() != null) {
                boolean nodesWithoutAvailableInfoAreAvailable = true;
                boolean available = node.getAvailable() != null ? node.getAvailable() : (availableAdvertisementRspec ? true : true);
                JFedGuiConfig.ComponentInfo componentInfo = new JFedGuiConfig.ComponentInfo(node.getComponentName(), node.getComponentId(), available, null, null, node.getLocation(), curHardwareTypeNames, curSliverTypeNames, node.getComponentManagerId(), RspecStatisticsMaker.extractSiteId((GeniUrn)node.getComponentId(), (GeniUrn)node.getComponentManagerId(), (RspecNode)node));
                advInfo.addComponentInfo(componentInfo);
            }
            if (curHardwareTypeNames.isEmpty() || curSliverTypeNames.isEmpty()) continue;
            for (String hw : curHardwareTypeNames) {
                for (String st : curSliverTypeNames) {
                    advInfo.addSliverHardwareTypeNameMapping(st, hw);
                }
            }
        }
        Server server = this.testbedInfoSource.getServerById(serverId);
        RspecStatisticsMaker rspecStatisticsMaker = new RspecStatisticsMaker();
        Pair res = rspecStatisticsMaker.make(modelRspec, availableAdvertisementRspec, server, new Timestamp(fetchDate.getTime()));
        RSpecStatistics stat = (RSpecStatistics)res.getKey();
        ServerGlimpse serverGlimpse = ((ServerGlimpseBuilder)res.getValue()).create();
        this.serverGlimpseByServerId.put(serverGlimpse.getServerId(), serverGlimpse);
        this.setServerGlimpse(serverGlimpse.getServerId(), serverGlimpse);
        LOG.debug("jFedGuiConfig is storing counts from advertisement " + countScope);
        AdvertisementCountsImpl curCounts = new AdvertisementCountsImpl();
        curCounts.setCountEntries(stat.getCountEntries());
        curCounts.setHwCountEntries(stat.getHwCountEntries());
        curCounts.setDate(fetchDate);
        advInfo.setCounts(curCounts);
        this.updateBestAdvertisementInfo(serverId);
    }

    @Override
    public void setServerGlimpse(@Nonnull Integer serverId, @Nonnull ServerGlimpse serverGlimpse) {
        assert (Platform.isFxApplicationThread());
        assert (serverGlimpse != null);
        AdvertisementInfo advInfo = this.getAdvertisementInfo(serverId, AdvertisementInfoSourceType.ServerGlimpse);
        assert (advInfo != null);
        ServerGlimpse.AdvertisementInfo sai = serverGlimpse.getAdvertisementInfo();
        if (sai != null) {
            advInfo.clear();
            advInfo.date = sai.getTimestamp();
            if (sai.getComponentManagerIds() != null) {
                assert (advInfo.componentManagerIds != null);
                advInfo.componentManagerIds.addAll(sai.getComponentManagerIds().stream().map(GeniUrn::parse).filter(Objects::nonNull).collect(Collectors.toList()));
            }
            if (sai.getDiskImages() != null) {
                assert (advInfo.diskImages != null);
                for (ServerGlimpse.AdvertisementInfo.DiskImage di : sai.getDiskImages()) {
                    if (di == null || di.getName() == null && di.getUrl() == null) continue;
                    DiskImage diskImage = new DiskImage(di.getName(), di.getUrl(), di.getOs(), di.getVersion(), di.getDescription(), Boolean.valueOf(false));
                    advInfo.diskImages.add(diskImage);
                    for (String sliverTypeName : di.getSliverTypes()) {
                        advInfo.addDiskImage(sliverTypeName, diskImage);
                    }
                }
            }
            if (sai.getSliverTypeInfo() != null) {
                for (ServerGlimpse.AdvertisementInfo.SliverTypeInfo st : sai.getSliverTypeInfo()) {
                    if (st == null || st.getSliverType() == null) continue;
                    advInfo.sliverTypeNames.add(st.getSliverType());
                    if (st.getHardwareTypes() != null) {
                        for (String hwt : st.getHardwareTypes()) {
                            if (hwt == null) continue;
                            advInfo.hardwareTypes.add(new JFedGuiConfig.HardwareTypeInfo(hwt));
                            advInfo.addSliverHardwareTypeNameMapping(st.getSliverType(), hwt);
                        }
                    }
                    if (st.getFlavors() == null) continue;
                    for (String flavor : st.getFlavors()) {
                        if (flavor == null) continue;
                        advInfo.flavors.add(flavor);
                        advInfo.addSliverFlavorMapping(st.getSliverType(), flavor);
                    }
                }
            }
            if (sai.getComponentDetails() != null) {
                for (ServerGlimpse.AdvertisementInfo.ComponentDetails comDet : sai.getComponentDetails()) {
                    GeniUrn componentUrn = GeniUrn.parse((String)comDet.getId());
                    if (componentUrn == null) continue;
                    NodeLocation nodeLocation = comDet.getLocation() == null ? null : new NodeLocation(comDet.getLocation().getCountry(), comDet.getLocation().getLatitude() == null ? null : comDet.getLocation().getLatitude().toString(), comDet.getLocation().getLongitude() == null ? null : comDet.getLocation().getLongitude().toString());
                    HashSet<String> sliverTypesMatchingHardwareTypes = new HashSet<String>();
                    for (String hw : comDet.getHardwareTypes()) {
                        Set<String> sliverTypes = advInfo.hardwareTypeNameToSliverTypeName.get(hw);
                        if (sliverTypes == null) continue;
                        sliverTypesMatchingHardwareTypes.addAll(sliverTypes);
                    }
                    advInfo.addComponentInfo(new JFedGuiConfig.ComponentInfo(componentUrn.getResourceName(), componentUrn, !Objects.equals(comDet.getAvailable(), Boolean.FALSE), null, null, nodeLocation, comDet.getHardwareTypes(), sliverTypesMatchingHardwareTypes, GeniUrn.parse((String)comDet.getComponentManagerId()), comDet.getSiteId()));
                }
            }
            advInfo.setCounts((AdvertisementCounts)sai);
        }
        this.updateBestAdvertisementInfo(serverId);
    }

    @Override
    public void setFedmonNodeTestInfo(Integer serverId, Map<GeniUrn, Result> fedmonResults) {
        assert (Platform.isFxApplicationThread());
        assert (serverId != null);
        assert (fedmonResults != null);
        assert (Platform.isFxApplicationThread());
        if (fedmonResults.isEmpty()) {
            return;
        }
        Result firstResult = fedmonResults.values().iterator().next();
        assert (firstResult != null);
        assert (firstResult.getTestDefinitionId() != null) : "Testdefinition ID is null for: " + fedmonResults.get(0);
        AdvertisementInfo advInfo = this.getAdvertisementInfo(serverId, AdvertisementInfoSourceType.FedmonNodeStatus);
        String string = firstResult.getTestDefinitionId();
        int n = -1;
        boolean bl = switch (string.hashCode()) {
            case 145095227 -> {
                if (!string.equals("autosensortest")) yield false;
            }
        };
        JFedGuiConfig.ComponentInfo.ExtraStatusInfoType statusInfoType = switch (bl) {
            case 0 -> JFedGuiConfig.ComponentInfo.ExtraStatusInfoType.SENSOR;
            default -> JFedGuiConfig.ComponentInfo.ExtraStatusInfoType.NODE_LOGIN;
        };
        advInfo.clear();
        for (Map.Entry entry : fedmonResults.entrySet()) {
            GeniUrn compId = (GeniUrn)entry.getKey();
            Result result = (Result)entry.getValue();
            JFedGuiConfig.ComponentInfo componentInfo = JFedGuiConfig.ComponentInfo.create(compId, statusInfoType == JFedGuiConfig.ComponentInfo.ExtraStatusInfoType.NODE_LOGIN ? result.getSummaryStatus() == Result.ResultStatus.SUCCESS : true, statusInfoType, result.getSummaryStatus() == Result.ResultStatus.SUCCESS, null, null, RspecStatisticsMaker.extractSiteId((GeniUrn)compId, null, null));
            advInfo.addComponentInfo(componentInfo);
        }
        this.updateBestAdvertisementInfo(serverId);
    }

    @Override
    @Nonnull
    public JFedGuiConfig.ComponentInfo addUserComponentInfo(Integer serverId, GeniUrn componentId) {
        assert (Platform.isFxApplicationThread());
        AdvertisementInfo advInfo = this.getAdvertisementInfo(serverId, AdvertisementInfoSourceType.User);
        JFedGuiConfig.ComponentInfo componentInfo = new JFedGuiConfig.ComponentInfo(componentId.getResourceName(), componentId, true, null, null, null, null, null, null, RspecStatisticsMaker.extractSiteId((GeniUrn)componentId, null, null));
        advInfo.addComponentInfo(componentInfo);
        this.updateBestAdvertisementInfo(serverId);
        return componentInfo;
    }

    @Override
    @Nonnull
    public JFedGuiConfig.HardwareTypeInfo addUserHardwareTypeInfo(Integer serverId, String hardwareTypeName, Boolean available) {
        assert (Platform.isFxApplicationThread());
        AdvertisementInfo advInfo = this.getAdvertisementInfo(serverId, AdvertisementInfoSourceType.User);
        JFedGuiConfig.HardwareTypeInfo hardwareTypeInfo = new JFedGuiConfig.HardwareTypeInfo(hardwareTypeName, available);
        advInfo.addHardwareType(hardwareTypeInfo);
        this.updateBestAdvertisementInfo(serverId);
        return hardwareTypeInfo;
    }

    @Override
    public void clearUserInfo(Integer serverId) {
        assert (Platform.isFxApplicationThread());
        AdvertisementInfo advInfo = this.getAdvertisementInfo(serverId, AdvertisementInfoSourceType.User);
        advInfo.clear();
        this.updateBestAdvertisementInfo(serverId);
    }

    @Override
    public void initResourceClassAdvertisementInfo() {
        for (Map.Entry<Integer, List<Resource>> e : this.resourcesByServerId.entrySet()) {
            Integer serverId = e.getKey();
            List<Resource> resources = e.getValue();
            AdvertisementInfo resourceClassAdvertisementInfo = this.getAdvertisementInfo(serverId, AdvertisementInfoSourceType.ResourceClass);
            for (Resource resource : resources) {
                if (resource.getSliverType() != null) {
                    resourceClassAdvertisementInfo.addSliverTypeName(resource.getSliverType());
                }
                if (resource.getHardwareType() != null) {
                    resourceClassAdvertisementInfo.addHardwareTypeName(resource.getHardwareType(), null);
                }
                if (resource.getDiskImage() != null) {
                    resourceClassAdvertisementInfo.addDiskImage(resource.getDiskImage());
                }
                if (resource.getComponentUrn() == null) continue;
                try {
                    resourceClassAdvertisementInfo.addComponentInfo(new GeniUrn(resource.getComponentUrn()), true);
                }
                catch (GeniUrn.GeniUrnParseException e1) {
                    LOG.error("Resource " + resource.getId() + " contained invalid component_urn", e);
                }
            }
        }
    }

    private static enum AdvertisementInfoSourceType {
        ServerGlimpse,
        AvailableAdvertisementRspec,
        AllAdvertisementRspec,
        FedmonNodeStatus,
        ResourceClass,
        Best,
        User;

    }

    private static class AdvertisementInfo {
        @Nonnull
        private final AdvertisementInfoSourceId sourceId;
        @Nullable
        private Date date;
        @Nonnull
        private final SortedSet<DiskImage> diskImages;
        @Nonnull
        private final Map<String, SortedSet<DiskImage>> diskImagesBySliverType;
        @Nonnull
        private final SortedSet<String> flavors;
        @Nonnull
        private final Map<String, SortedSet<String>> flavorsBySliverType;
        @Nonnull
        private final SortedSet<String> sliverTypeNames;
        @Nonnull
        private final SortedSet<JFedGuiConfig.HardwareTypeInfo> hardwareTypes;
        @Nonnull
        private final SortedSet<GeniUrn> componentManagerIds;
        @Nonnull
        private final SortedSet<JFedGuiConfig.ComponentInfo> componentInfos;
        @Nonnull
        private final Map<String, Set<String>> hardwareTypeNameToSliverTypeName;
        @Nonnull
        private final Map<String, Set<String>> sliverTypeNameToHardwareTypeName;
        @Nonnull
        private final AdvertisementCountsImpl counts;
        private static final Comparator<GeniUrn> geniUrnComparator = Comparator.comparing(ResourceUrn::getValue);
        private static final Comparator<DiskImage> diskImageComparator = (o1, o2) -> {
            String s2;
            if (o1.getName() != null && o2.getName() != null && Objects.equals(o1.getName(), o2.getName())) {
                return 0;
            }
            if (o1.getUrl() != null && o2.getUrl() != null && Objects.equals(o1.getUrl(), o2.getUrl())) {
                return 0;
            }
            String s1 = o1.getName() == null ? o1.getUrl() : o1.getName();
            String string = s2 = o2.getName() == null ? o2.getUrl() : o2.getName();
            assert (s1 != null);
            assert (s2 != null);
            return s1.compareTo(s2);
        };

        public AdvertisementInfo(Integer serverId, AdvertisementInfoSourceType type) {
            this(new AdvertisementInfoSourceId(serverId, type));
        }

        public AdvertisementInfo(@Nonnull AdvertisementInfoSourceId sourceId) {
            this.sourceId = sourceId;
            this.diskImages = new TreeSet<DiskImage>(diskImageComparator);
            this.diskImagesBySliverType = new HashMap<String, SortedSet<DiskImage>>();
            this.flavors = new TreeSet<String>();
            this.flavorsBySliverType = new HashMap<String, SortedSet<String>>();
            this.sliverTypeNames = new TreeSet<String>();
            this.hardwareTypes = new TreeSet<JFedGuiConfig.HardwareTypeInfo>();
            this.componentManagerIds = new TreeSet<GeniUrn>(geniUrnComparator);
            this.componentInfos = new TreeSet<JFedGuiConfig.ComponentInfo>();
            this.hardwareTypeNameToSliverTypeName = new HashMap<String, Set<String>>();
            this.sliverTypeNameToHardwareTypeName = new HashMap<String, Set<String>>();
            this.counts = new AdvertisementCountsImpl();
        }

        public SortedSet<DiskImage> getDiskImages(String sliverType) {
            return this.diskImagesBySliverType.computeIfAbsent(sliverType, key -> new TreeSet<DiskImage>(diskImageComparator));
        }

        public SortedSet<String> getFlavors(String sliverType) {
            return this.flavorsBySliverType.computeIfAbsent(sliverType, key -> new TreeSet());
        }

        public boolean hasInfo() {
            if (!this.diskImages.isEmpty()) {
                return true;
            }
            if (!this.flavors.isEmpty()) {
                return true;
            }
            if (!this.sliverTypeNames.isEmpty()) {
                return true;
            }
            if (!this.hardwareTypes.isEmpty()) {
                return true;
            }
            if (!this.componentManagerIds.isEmpty()) {
                return true;
            }
            if (!this.componentInfos.isEmpty()) {
                return true;
            }
            if (!this.sliverTypeNameToHardwareTypeName.isEmpty()) {
                return true;
            }
            return !this.hardwareTypeNameToSliverTypeName.isEmpty();
        }

        public boolean olderThan(Duration duration) {
            if (this.date == null) {
                return false;
            }
            Date now = new Date();
            Date comp = new Date(now.getTime() - duration.toMillis());
            return this.date.before(comp);
        }

        public void set(AdvertisementInfo other) {
            this.componentInfos.clear();
            this.componentManagerIds.clear();
            this.diskImages.clear();
            this.flavors.clear();
            this.hardwareTypes.clear();
            this.sliverTypeNames.clear();
            this.componentInfos.addAll(other.componentInfos);
            this.componentManagerIds.addAll(other.componentManagerIds);
            assert (other.diskImages.stream().allMatch(Objects::nonNull));
            this.diskImages.addAll(other.diskImages);
            assert (other.flavors.stream().allMatch(Objects::nonNull));
            this.flavors.addAll(other.flavors);
            this.hardwareTypes.addAll(other.hardwareTypes);
            this.sliverTypeNames.addAll(other.sliverTypeNames);
            this.sliverTypeNameToHardwareTypeName.clear();
            this.hardwareTypeNameToSliverTypeName.clear();
            for (Map.Entry<String, Set<String>> entry : other.sliverTypeNameToHardwareTypeName.entrySet()) {
                this.sliverTypeNameToHardwareTypeName.computeIfAbsent(entry.getKey(), key -> new HashSet()).addAll((Collection)entry.getValue());
            }
            for (Map.Entry<String, Set<String>> entry : other.hardwareTypeNameToSliverTypeName.entrySet()) {
                this.hardwareTypeNameToSliverTypeName.computeIfAbsent(entry.getKey(), key -> new HashSet()).addAll((Collection)entry.getValue());
            }
            HashSet<String> removedDIKeys = new HashSet<String>(this.diskImagesBySliverType.keySet());
            removedDIKeys.removeAll(other.diskImagesBySliverType.keySet());
            for (String key2 : removedDIKeys) {
                this.diskImagesBySliverType.remove(key2);
            }
            for (Map.Entry<String, SortedSet<DiskImage>> e : other.diskImagesBySliverType.entrySet()) {
                String string = e.getKey();
                SortedSet<DiskImage> target = e.getValue();
                SortedSet orig = this.diskImagesBySliverType.computeIfAbsent(string, k -> new TreeSet<DiskImage>(diskImageComparator));
                orig.clear();
                orig.addAll(target);
            }
            HashSet<String> hashSet = new HashSet<String>(this.flavorsBySliverType.keySet());
            hashSet.removeAll(other.flavorsBySliverType.keySet());
            for (String string : hashSet) {
                this.flavorsBySliverType.remove(string);
            }
            for (Map.Entry entry : other.flavorsBySliverType.entrySet()) {
                String sliverType = (String)entry.getKey();
                SortedSet target = (SortedSet)entry.getValue();
                SortedSet orig = this.flavorsBySliverType.computeIfAbsent(sliverType, k -> new TreeSet());
                orig.clear();
                orig.addAll(target);
            }
            this.counts.clear();
            this.counts.set(other.counts);
        }

        public void addSliverHardwareTypeNameMapping(@Nonnull String sliverTypeName, @Nonnull String hardwareTypeName) {
            this.sliverTypeNameToHardwareTypeName.computeIfAbsent(sliverTypeName, key -> new HashSet()).add(hardwareTypeName);
            this.hardwareTypeNameToSliverTypeName.computeIfAbsent(hardwareTypeName, key -> new HashSet()).add(sliverTypeName);
        }

        public void addSliverFlavorMapping(@Nonnull String sliverTypeName, @Nonnull String flavor) {
            this.flavorsBySliverType.computeIfAbsent(sliverTypeName, key -> new TreeSet()).add(flavor);
        }

        public void addSliverTypeNames(Collection<String> sliverTypeNames) {
            this.sliverTypeNames.addAll(sliverTypeNames);
        }

        public void addSliverTypeName(String sliverTypeName) {
            this.sliverTypeNames.add(sliverTypeName);
        }

        public void addHardwareTypeNames(Collection<String> hardwareTypeNames, Boolean available) {
            for (String hardwareTypeName : hardwareTypeNames) {
                this.addHardwareTypeName(hardwareTypeName, available);
            }
        }

        public void addHardwareTypes(Collection<JFedGuiConfig.HardwareTypeInfo> hardwareTypes) {
            this.hardwareTypes.addAll(hardwareTypes);
        }

        public void addHardwareTypeName(String hardwareTypeName, Boolean available) {
            this.hardwareTypes.add(new JFedGuiConfig.HardwareTypeInfo(hardwareTypeName, available));
        }

        public void addHardwareType(JFedGuiConfig.HardwareTypeInfo hardwareType) {
            this.hardwareTypes.add(hardwareType);
        }

        public void addDiskImages(Collection<DiskImage> diskImages) {
            assert (diskImages.stream().allMatch(Objects::nonNull));
            this.diskImages.addAll(diskImages);
        }

        public void addDiskImage(DiskImage diskImage) {
            assert (diskImage != null);
            this.diskImages.add(diskImage);
        }

        public void addDiskImage(String sliverType, DiskImage diskImage) {
            this.getDiskImages(sliverType).add(diskImage);
        }

        public void addDiskImages(String sliverType, Collection<DiskImage> diskImages) {
            this.getDiskImages(sliverType).addAll(diskImages);
        }

        public void addFlavors(Collection<String> flavors) {
            assert (flavors.stream().allMatch(Objects::nonNull));
            this.flavors.addAll(flavors);
        }

        public void addFlavor(String flavor) {
            assert (flavor != null);
            this.flavors.add(flavor);
        }

        public void addFlavor(String sliverType, String flavor) {
            this.getFlavors(sliverType).add(flavor);
        }

        public void addFlavors(String sliverType, Collection<String> flavors) {
            this.getFlavors(sliverType).addAll(flavors);
        }

        public void addComponentInfos(Collection<JFedGuiConfig.ComponentInfo> componentInfos) {
            this.componentInfos.addAll(componentInfos);
        }

        public void addComponentInfo(JFedGuiConfig.ComponentInfo componentInfo) {
            this.componentInfos.add(componentInfo);
        }

        public void addDiskImage(String diskImageId) {
            assert (diskImageId != null);
            DiskImage diskImage = diskImageId.startsWith("http") ? new DiskImage(null, diskImageId, null, null, null, null) : new DiskImage(diskImageId);
            this.addDiskImage(diskImage);
        }

        public void addComponentInfo(GeniUrn componentUrn, boolean available) {
            JFedGuiConfig.ComponentInfo componentInfo = new JFedGuiConfig.ComponentInfo(componentUrn.getResourceName(), componentUrn, available, null, null, null, null, null, null, RspecStatisticsMaker.extractSiteId((GeniUrn)componentUrn, null, null));
            this.addComponentInfo(componentInfo);
        }

        @Nonnull
        AdvertisementCountsImpl getCounts() {
            return this.counts;
        }

        void setCounts(@Nonnull AdvertisementCounts counts) {
            this.counts.set(counts);
        }

        public void clear() {
            this.componentInfos.clear();
            this.componentManagerIds.clear();
            this.diskImages.clear();
            this.flavors.clear();
            this.hardwareTypes.clear();
            this.sliverTypeNames.clear();
            this.diskImagesBySliverType.clear();
            this.flavorsBySliverType.clear();
            this.counts.clear();
            this.date = null;
        }
    }

    private static class AdvertisementProperties {
        private final int serverId;
        private final Server server;
        @Nonnull
        private final ListProperty<DiskImage> diskImages;
        @Nonnull
        private final ListProperty<String> flavors;
        @Nonnull
        private final Map<String, ListProperty<DiskImage>> diskImagesBySliverType;
        @Nonnull
        private final Map<String, ListProperty<String>> flavorsBySliverType;
        @Nonnull
        private final ListProperty<String> sliverTypeNames;
        @Nonnull
        private final ListProperty<JFedGuiConfig.HardwareTypeInfo> allHardwareTypes;
        @Nonnull
        private final ListProperty<JFedGuiConfig.HardwareTypeInfo> availableHardwareTypes;
        @Nonnull
        private final ListProperty<GeniUrn> componentManagerIds;
        @Nonnull
        private final ListProperty<JFedGuiConfig.ComponentInfo> allComponentInfos;
        @Nonnull
        private final ListProperty<JFedGuiConfig.ComponentInfo> availableComponentInfos;
        @Nonnull
        private final ObjectProperty<Map<String, Set<String>>> hardwareTypeNameToSliverTypeName;
        @Nonnull
        private final ObjectProperty<Map<String, Set<String>>> sliverTypeNameToHardwareTypeName;
        @Nonnull
        private final ObjectProperty<ServerGlimpse.HealthInfo> healthInfo;
        @Nonnull
        private final ObjectProperty<ServerGlimpse.AdvertisementInfo.HardwareTypeInfo> hardwareTypeInfo;
        @Nonnull
        private final ObjectProperty<Integer> reputation;
        @Nonnull
        private final ListProperty<MaintenanceInfo> maintenance;
        @Nonnull
        private final ListProperty<TestbedSiteInfo> testbedSiteInfo;
        @Nonnull
        private final ObjectProperty<AdvertisementCounts> counts;

        public AdvertisementProperties(int serverId, Server server) {
            this.serverId = serverId;
            this.server = server;
            this.diskImages = new SimpleListProperty(FXCollections.observableArrayList());
            this.diskImagesBySliverType = new HashMap<String, ListProperty<DiskImage>>();
            this.flavors = new SimpleListProperty(FXCollections.observableArrayList());
            this.flavorsBySliverType = new HashMap<String, ListProperty<String>>();
            this.sliverTypeNames = new SimpleListProperty(FXCollections.observableArrayList());
            this.allHardwareTypes = new SimpleListProperty(FXCollections.observableArrayList());
            this.availableHardwareTypes = new SimpleListProperty(FXCollections.observableArrayList());
            this.componentManagerIds = new SimpleListProperty(FXCollections.observableArrayList());
            this.allComponentInfos = new SimpleListProperty(FXCollections.observableArrayList());
            this.availableComponentInfos = new SimpleListProperty(FXCollections.observableArrayList());
            this.hardwareTypeNameToSliverTypeName = new SimpleObjectProperty(new HashMap());
            this.sliverTypeNameToHardwareTypeName = new SimpleObjectProperty(new HashMap());
            this.healthInfo = new SimpleObjectProperty();
            this.hardwareTypeInfo = new SimpleObjectProperty();
            this.reputation = new SimpleObjectProperty();
            this.maintenance = new SimpleListProperty(FXCollections.observableArrayList());
            this.testbedSiteInfo = new SimpleListProperty(FXCollections.observableArrayList());
            this.counts = new SimpleObjectProperty();
        }

        public void set(@Nonnull AdvertisementInfo infoAll, @Nonnull AdvertisementInfo infoAvail, @Nullable ServerGlimpse serverGlimpse) {
            assert (Platform.isFxApplicationThread());
            this.allComponentInfos.setAll(infoAll.componentInfos);
            this.availableComponentInfos.setAll((Collection)infoAvail.componentInfos.stream().filter(JFedGuiConfig.ComponentInfo::isAvailable).collect(Collectors.toList()));
            if (!infoAvail.componentManagerIds.isEmpty()) {
                this.componentManagerIds.setAll(infoAvail.componentManagerIds);
            } else {
                List newCompManIds = serverGlimpse == null || serverGlimpse.getAdvertisementInfo() == null ? null : serverGlimpse.getAdvertisementInfo().getComponentManagerUrns();
                this.componentManagerIds.setAll((Collection)(newCompManIds == null ? Collections.emptyList() : newCompManIds));
            }
            this.diskImages.setAll(infoAvail.diskImages);
            this.flavors.setAll(infoAvail.flavors);
            this.allHardwareTypes.setAll(infoAll.hardwareTypes);
            this.availableHardwareTypes.setAll((Collection)infoAvail.hardwareTypes.stream().filter(hti -> hti.isAvailable() != Boolean.FALSE).collect(Collectors.toList()));
            this.sliverTypeNames.setAll(infoAvail.sliverTypeNames);
            HashSet<String> removedDIKeys = new HashSet<String>(this.diskImagesBySliverType.keySet());
            removedDIKeys.removeAll(infoAvail.diskImagesBySliverType.keySet());
            for (String string : removedDIKeys) {
                ListProperty orig = this.diskImagesBySliverType.computeIfAbsent(string, k -> new SimpleListProperty(FXCollections.observableArrayList()));
                orig.clear();
            }
            for (Map.Entry entry : infoAvail.diskImagesBySliverType.entrySet()) {
                String sliverType = (String)entry.getKey();
                SortedSet target = (SortedSet)entry.getValue();
                ListProperty orig = this.diskImagesBySliverType.computeIfAbsent(sliverType, k -> new SimpleListProperty(FXCollections.observableArrayList()));
                orig.setAll((Collection)target);
            }
            HashSet<String> removedFlavorKeys = new HashSet<String>(this.flavorsBySliverType.keySet());
            removedFlavorKeys.removeAll(infoAvail.flavorsBySliverType.keySet());
            for (String sliverType : removedFlavorKeys) {
                ListProperty orig = this.flavorsBySliverType.computeIfAbsent(sliverType, k -> new SimpleListProperty(FXCollections.observableArrayList()));
                orig.clear();
            }
            for (Map.Entry<String, SortedSet<String>> e : infoAvail.flavorsBySliverType.entrySet()) {
                String sliverType = e.getKey();
                SortedSet<String> target = e.getValue();
                ListProperty orig = this.flavorsBySliverType.computeIfAbsent(sliverType, k -> new SimpleListProperty(FXCollections.observableArrayList()));
                orig.setAll(target);
            }
            HashMap<String, Set> hashMap = new HashMap<String, Set>();
            HashMap<String, Set> sliverTypeNameToHardwareTypeNameCopy = new HashMap<String, Set>();
            for (Map.Entry<String, Set<String>> e : infoAll.sliverTypeNameToHardwareTypeName.entrySet()) {
                sliverTypeNameToHardwareTypeNameCopy.computeIfAbsent(e.getKey(), key -> new HashSet()).addAll((Collection)e.getValue());
            }
            for (Map.Entry<String, Set<String>> e : infoAll.hardwareTypeNameToSliverTypeName.entrySet()) {
                hashMap.computeIfAbsent(e.getKey(), key -> new HashSet()).addAll((Collection)e.getValue());
            }
            this.hardwareTypeNameToSliverTypeName.set(hashMap);
            this.sliverTypeNameToHardwareTypeName.set(sliverTypeNameToHardwareTypeNameCopy);
            if (serverGlimpse != null) {
                if (serverGlimpse.getMaintenance() != null) {
                    this.maintenance.setAll((Collection)serverGlimpse.getMaintenance());
                } else {
                    this.maintenance.clear();
                }
                this.reputation.set((Object)serverGlimpse.getReputation());
                this.healthInfo.set((Object)serverGlimpse.getHealthInfo());
                if (serverGlimpse.getAdvertisementInfo() != null) {
                    this.hardwareTypeInfo.set((Object)serverGlimpse.getAdvertisementInfo().getHardwareTypeInfo());
                } else {
                    this.hardwareTypeInfo.set(null);
                }
            } else {
                this.maintenance.clear();
                this.reputation.set(null);
                this.healthInfo.set(null);
                this.hardwareTypeInfo.set(null);
            }
            if (infoAll.counts.getCountEntriesSize() > 0) {
                this.counts.set((Object)infoAll.counts.immutableCopy());
            } else if (infoAvail.counts.getCountEntriesSize() > 0) {
                this.counts.set((Object)infoAvail.counts.immutableCopy());
            }
        }

        public void updateTestbedSiteInfo() {
            ArrayList<TestbedSiteInfo> newSiteInfos = new ArrayList<TestbedSiteInfo>();
            if ((this.server == null || this.server.hasFlag(Server.Flag.featureSiteIncludeToplevelSite)) && !this.componentManagerIds.isEmpty()) {
                newSiteInfos.add(new TestbedSiteInfo(((GeniUrn)this.componentManagerIds.get(0)).replaceSubAuthority(null), "<auto>", -1, -1));
            }
            for (GeniUrn componentManagerUrn : this.componentManagerIds) {
                if (!componentManagerUrn.hasSubAuthority()) continue;
                String hrn = componentManagerUrn.getSubAuthName();
                newSiteInfos.add(new TestbedSiteInfo(componentManagerUrn, hrn, -1, -1));
            }
            this.testbedSiteInfo.setAll(newSiteInfos);
        }
    }

    private static class AdvertisementInfoSourceId {
        public final Integer serverId;
        public final AdvertisementInfoSourceType type;

        public AdvertisementInfoSourceId(Integer serverId, AdvertisementInfoSourceType type) {
            assert (serverId != null);
            assert (type != null);
            this.serverId = serverId;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AdvertisementInfoSourceId that = (AdvertisementInfoSourceId)o;
            if (!Objects.equals(this.serverId, that.serverId)) {
                return false;
            }
            return this.type == that.type;
        }

        public int hashCode() {
            int result = this.serverId.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }
    }

    public static class AdvertisementCountsImpl
    implements AdvertisementCounts {
        @Nonnull
        private final Map<Pair<AdvertisementCounts.CountedObject, AdvertisementCounts.CountScope>, Integer> counts;
        @Nonnull
        private final Map<Pair<String, AdvertisementCounts.CountScope>, Integer> hwCounts;
        private Date date;

        public AdvertisementCountsImpl() {
            this.counts = new HashMap<Pair<AdvertisementCounts.CountedObject, AdvertisementCounts.CountScope>, Integer>();
            this.hwCounts = new HashMap<Pair<String, AdvertisementCounts.CountScope>, Integer>();
        }

        public AdvertisementCountsImpl(@Nonnull Map<Pair<AdvertisementCounts.CountedObject, AdvertisementCounts.CountScope>, Integer> counts, @Nonnull Map<Pair<String, AdvertisementCounts.CountScope>, Integer> hwCounts, Date date) {
            this.counts = counts;
            this.hwCounts = hwCounts;
            this.date = date;
        }

        @Nullable
        public Integer getCount(@Nonnull AdvertisementCounts.CountedObject countedObject, @Nonnull AdvertisementCounts.CountScope countScope) {
            Integer res = this.counts.get(new Pair((Object)countedObject, (Object)countScope));
            return res;
        }

        @Nullable
        public Integer getHwCount(@Nonnull String s, @Nonnull AdvertisementCounts.CountScope countScope) {
            return this.hwCounts.get(new Pair((Object)s, (Object)countScope));
        }

        @Nonnull
        public Collection<AdvertisementCounts.AdvertisementCountEntry> getCountEntries() {
            return this.counts.entrySet().stream().map(e -> new AdvertisementCounts.AdvertisementCountEntry((AdvertisementCounts.CountedObject)((Pair)e.getKey()).getKey(), (AdvertisementCounts.CountScope)((Pair)e.getKey()).getValue(), ((Integer)e.getValue()).intValue())).collect(Collectors.toList());
        }

        public int getCountEntriesSize() {
            return this.counts.size();
        }

        @Nonnull
        public Collection<AdvertisementCounts.AdvertisementHwCountEntry> getHwCountEntries() {
            return this.hwCounts.entrySet().stream().map(e -> new AdvertisementCounts.AdvertisementHwCountEntry((String)((Pair)e.getKey()).getKey(), (AdvertisementCounts.CountScope)((Pair)e.getKey()).getValue(), ((Integer)e.getValue()).intValue())).collect(Collectors.toList());
        }

        public int getHwCountEntriesSize() {
            return this.hwCounts.size();
        }

        public List<String> getHwCountKeys() {
            return new ArrayList<String>(this.hwCounts.keySet().stream().map(Pair::getKey).collect(Collectors.toSet()));
        }

        @Nullable
        public Date getCountDate() {
            return this.date;
        }

        public void clear() {
            this.counts.clear();
            this.hwCounts.clear();
            this.date = null;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public void setCounts(@Nonnull Map<Pair<AdvertisementCounts.CountedObject, AdvertisementCounts.CountScope>, Integer> newCounts) {
            this.counts.clear();
            this.counts.putAll(newCounts);
        }

        public void setCount(@Nonnull AdvertisementCounts.CountedObject obj, @Nonnull AdvertisementCounts.CountScope scope, @Nullable Integer newCount) {
            this.counts.put((Pair<AdvertisementCounts.CountedObject, AdvertisementCounts.CountScope>)new Pair((Object)obj, (Object)scope), newCount);
        }

        public void incCount(@Nonnull AdvertisementCounts.CountedObject obj, @Nonnull AdvertisementCounts.CountScope scope, int extraCount) {
            this.counts.compute((Pair<AdvertisementCounts.CountedObject, AdvertisementCounts.CountScope>)new Pair((Object)obj, (Object)scope), (key, oldVal) -> (oldVal == null ? 0 : oldVal) + extraCount);
        }

        public void incCount(@Nonnull AdvertisementCounts.CountedObject obj, @Nonnull AdvertisementCounts.CountScope scope) {
            this.incCount(obj, scope, 1);
        }

        public AdvertisementCounts immutableCopy() {
            return new AdvertisementCountsImpl(Collections.unmodifiableMap(new HashMap<Pair<AdvertisementCounts.CountedObject, AdvertisementCounts.CountScope>, Integer>(this.counts)), Collections.unmodifiableMap(new HashMap<Pair<String, AdvertisementCounts.CountScope>, Integer>(this.hwCounts)), this.date);
        }

        public void set(@Nonnull AdvertisementCounts other) {
            this.counts.clear();
            for (AdvertisementCounts.AdvertisementCountEntry e : other.getCountEntries()) {
                this.counts.put((Pair<AdvertisementCounts.CountedObject, AdvertisementCounts.CountScope>)new Pair((Object)e.getObject(), (Object)e.getScope()), e.getCount());
            }
            this.hwCounts.clear();
            for (AdvertisementCounts.AdvertisementCountEntry e : other.getHwCountEntries()) {
                this.hwCounts.put((Pair<String, AdvertisementCounts.CountScope>)new Pair((Object)e.getHwType(), (Object)e.getScope()), e.getCount());
            }
            this.date = other.getCountDate();
        }

        public void setHwCountEntries(Collection<AdvertisementCounts.AdvertisementHwCountEntry> entries) {
            this.hwCounts.clear();
            for (AdvertisementCounts.AdvertisementHwCountEntry e : entries) {
                this.hwCounts.put((Pair<String, AdvertisementCounts.CountScope>)new Pair((Object)e.getHwType(), (Object)e.getScope()), e.getCount());
            }
        }

        public void setCountEntries(Collection<AdvertisementCounts.AdvertisementCountEntry> entries) {
            this.counts.clear();
            for (AdvertisementCounts.AdvertisementCountEntry e : entries) {
                this.counts.put((Pair<AdvertisementCounts.CountedObject, AdvertisementCounts.CountScope>)new Pair((Object)e.getObject(), (Object)e.getScope()), e.getCount());
            }
        }
    }
}

