/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.config;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserInfo;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserInfoBuilder;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.library.JFedVersionInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class UserInfoProvider {
    @Nonnull
    private final JFedVersionInfo jFedVersionInfo;
    @Nonnull
    private List<String> extraFlags;

    @Inject
    public UserInfoProvider(@Nonnull JFedVersionInfo jFedVersionInfo, @Nonnull JFedPreferences jFedPreferences) {
        this.jFedVersionInfo = jFedVersionInfo;
        this.extraFlags = Collections.unmodifiableList(jFedPreferences.getStringList((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_GUICONFIG_EXTRA_FLAGS).stream().filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public void addExtraFlags(String ... extraExtraFlags) {
        this.addExtraFlags(Arrays.asList(extraExtraFlags));
    }

    public void addExtraFlags(@Nonnull List<String> extraExtraFlags) {
        TreeSet<String> res = new TreeSet<String>(this.extraFlags);
        res.addAll(extraExtraFlags);
        this.extraFlags = Collections.unmodifiableList(new ArrayList<String>(res));
    }

    public UserInfo createUserInfo(@Nullable GeniUrn userUrn, String ... extraExtraFlags) {
        TreeSet<String> usedExtraFlags = new TreeSet<String>(this.extraFlags);
        if (extraExtraFlags != null) {
            Arrays.stream(extraExtraFlags).filter(Objects::nonNull).forEach(usedExtraFlags::add);
        }
        UserInfoBuilder userInfoBuilder = new UserInfoBuilder();
        userInfoBuilder.setUrn(userUrn);
        userInfoBuilder.setVersionJava(System.getProperty("java.version"));
        userInfoBuilder.setVersionJavaVendor(System.getProperty("java.vendor"));
        userInfoBuilder.setVersionJavaSpec(System.getProperty("java.specification.version"));
        userInfoBuilder.setVersionOs(System.getProperty("os.name") + " " + System.getProperty("os.version"));
        userInfoBuilder.setVersionArch(System.getProperty("os.arch"));
        userInfoBuilder.setVersionJFed(this.jFedVersionInfo.getFullVersionString());
        userInfoBuilder.setExtra(new ArrayList<String>(usedExtraFlags));
        return userInfoBuilder.create();
    }
}

