/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.config.util;

import be.iminds.ilabt.jfed.experimenter_gui.config.ImageMap;
import be.iminds.ilabt.jfed.experimenter_gui.config.util.TestbedNodesMapParseException;
import be.iminds.ilabt.jfed.experimenter_gui.config.util.TestbedNodesMapParser;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.lib.ConnectivityDetector;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestbedNodesMapsFetcher
implements Callable<Map<GeniUrn, ImageMap<GeniUrn>>> {
    private static final Logger LOG = LoggerFactory.getLogger(TestbedNodesMapsFetcher.class);
    private static final String DEFAULT_MAPS_LOCATION = "https://flsmonitor.fed4fire.eu/maps/testbed_nodes_maps.xml";
    private static final String NAMESPACE_TESTBED_NODES_MAPS = "http://jfed.iminds.be/testbeds_nodes_maps";
    private static final QName Q_TESTBED_NODES_MAPS = new QName("http://jfed.iminds.be/testbeds_nodes_maps", "testbed_nodes_maps");
    private static final QName Q_TESTBED_NODES_MAPS_MAP = new QName("http://jfed.iminds.be/testbeds_nodes_maps", "testbed_node_map");
    private static final QName Q_CM_ID = new QName("http://jfed.iminds.be/testbeds_nodes_maps", "component_manager_id");
    private static final QName Q_URL = new QName("http://jfed.iminds.be/testbeds_nodes_maps", "url");
    private final ConnectivityDetector connectivityDetector;

    @Inject
    public TestbedNodesMapsFetcher(ConnectivityDetector connectivityDetector) {
        this.connectivityDetector = connectivityDetector;
    }

    @Override
    public Map<GeniUrn, ImageMap<GeniUrn>> call() throws TestbedNodesMapParseException {
        if (this.connectivityDetector != null && this.connectivityDetector.isNoInternet()) {
            return Collections.emptyMap();
        }
        try {
            XMLInputFactory xif = XMLInputFactory.newFactory();
            StreamSource xml = new StreamSource(new URL(DEFAULT_MAPS_LOCATION).openStream());
            XMLEventReader eventReader = xif.createXMLEventReader(xml);
            XMLEvent e = eventReader.nextEvent();
            assert (e.isStartDocument());
            Map<GeniUrn, ImageMap<GeniUrn>> res = null;
            Object rspecType = null;
            while (eventReader.hasNext()) {
                e = eventReader.nextEvent();
                if (e.isStartElement() && Objects.equals(e.asStartElement().getName(), Q_TESTBED_NODES_MAPS)) {
                    res = this.readTestbedNodesMaps(e, eventReader);
                }
                if (!e.isEndDocument()) continue;
                return res;
            }
        }
        catch (IOException | XMLStreamException e) {
            throw new TestbedNodesMapParseException("Could not parse testbed_nodes_maps.xml", e);
        }
        throw new TestbedNodesMapParseException("Could not find end of document");
    }

    private Map<GeniUrn, ImageMap<GeniUrn>> readTestbedNodesMaps(XMLEvent e, XMLEventReader eventReader) throws XMLStreamException, TestbedNodesMapParseException {
        HashMap<GeniUrn, ImageMap<GeniUrn>> res = new HashMap<GeniUrn, ImageMap<GeniUrn>>();
        while (eventReader.hasNext()) {
            e = eventReader.nextEvent();
            if (e.isStartElement() && Objects.equals(e.asStartElement().getName(), Q_TESTBED_NODES_MAPS_MAP)) {
                this.readTestbedNodesMap(res, e, eventReader);
            }
            if (!e.isEndElement() || !Objects.equals(e.asEndElement().getName(), Q_TESTBED_NODES_MAPS)) continue;
            return res;
        }
        throw new TestbedNodesMapParseException("Could not find end element for testbed_nodes_maps");
    }

    private void readTestbedNodesMap(Map<GeniUrn, ImageMap<GeniUrn>> testbedsNodesMaps, XMLEvent e, XMLEventReader eventReader) throws XMLStreamException, TestbedNodesMapParseException {
        String url = null;
        GeniUrn cmId = null;
        while (eventReader.hasNext()) {
            e = eventReader.nextEvent();
            if (e.isStartElement()) {
                if (Objects.equals(e.asStartElement().getName(), Q_CM_ID)) {
                    try {
                        cmId = new GeniUrn(eventReader.getElementText());
                    }
                    catch (GeniUrn.GeniUrnParseException e1) {
                        throw new TestbedNodesMapParseException("Could not parse component_manager_id into a valid GeniURN");
                    }
                }
                if (Objects.equals(e.asStartElement().getName(), Q_URL)) {
                    url = eventReader.getElementText();
                }
            }
            if (!e.isEndElement() || !Objects.equals(e.asEndElement().getName(), Q_TESTBED_NODES_MAPS_MAP)) continue;
            if (cmId == null) {
                throw new TestbedNodesMapParseException("No component_manager_id for map");
            }
            if (url == null) {
                throw new TestbedNodesMapParseException("No url for map");
            }
            try {
                testbedsNodesMaps.put(cmId, (ImageMap<GeniUrn>)new TestbedNodesMapParser(new URL(DEFAULT_MAPS_LOCATION.substring(0, DEFAULT_MAPS_LOCATION.lastIndexOf(47) + 1) + url)).call());
                return;
            }
            catch (MalformedURLException e1) {
                throw new TestbedNodesMapParseException("Could not generate a valid URL with the provided mapUrl");
            }
        }
        throw new TestbedNodesMapParseException("Could not find end element for testbed_node_map");
    }
}

