/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.request.logging;

import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.ImmutableList;
import io.dropwizard.logging.AppenderFactory;
import io.dropwizard.logging.ConsoleAppenderFactory;
import io.dropwizard.logging.async.AsyncAppenderFactory;
import io.dropwizard.logging.filter.LevelFilterFactory;
import io.dropwizard.logging.filter.NullLevelFilterFactory;
import io.dropwizard.logging.layout.LayoutFactory;
import io.dropwizard.request.logging.LogbackAccessRequestLog;
import io.dropwizard.request.logging.RequestLogFactory;
import io.dropwizard.request.logging.async.AsyncAccessEventAppenderFactory;
import io.dropwizard.request.logging.layout.LogbackAccessRequestLayoutFactory;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.eclipse.jetty.server.RequestLog;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="logback-access")
public class LogbackAccessRequestLogFactory
implements RequestLogFactory {
    @Valid
    @NotNull
    private ImmutableList<AppenderFactory<IAccessEvent>> appenders = ImmutableList.of((Object)new ConsoleAppenderFactory());

    @JsonProperty
    public ImmutableList<AppenderFactory<IAccessEvent>> getAppenders() {
        return this.appenders;
    }

    @JsonProperty
    public void setAppenders(ImmutableList<AppenderFactory<IAccessEvent>> appenders) {
        this.appenders = appenders;
    }

    @Override
    @JsonIgnore
    public boolean isEnabled() {
        return !this.appenders.isEmpty();
    }

    public RequestLog build(String name) {
        Logger logger = (Logger)LoggerFactory.getLogger((String)"http.request");
        logger.setAdditive(false);
        LoggerContext context = logger.getLoggerContext();
        LogbackAccessRequestLog requestLog = new LogbackAccessRequestLog();
        NullLevelFilterFactory levelFilterFactory = new NullLevelFilterFactory();
        AsyncAccessEventAppenderFactory asyncAppenderFactory = new AsyncAccessEventAppenderFactory();
        LogbackAccessRequestLayoutFactory layoutFactory = new LogbackAccessRequestLayoutFactory();
        for (AppenderFactory output : this.appenders) {
            requestLog.addAppender(output.build(context, name, (LayoutFactory)layoutFactory, (LevelFilterFactory)levelFilterFactory, (AsyncAppenderFactory)asyncAppenderFactory));
        }
        return requestLog;
    }
}

