/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.espec.bundle;

import be.iminds.ilabt.jfed.espec.bundle.ESpecBundle;
import be.iminds.ilabt.jfed.espec.model.ExperimentSpecification;
import be.iminds.ilabt.jfed.espec.parser.ExperimentSpecificationParser;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractArchiveESpecBundle
implements ESpecBundle {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractArchiveESpecBundle.class);
    private final byte[] bytes;
    @Nonnull
    private final InputStreamSupplierThrowingIOException inputStreamSupplier;
    @Nonnull
    private final List<ArchiveEntry> archiveEntries;
    @Nonnull
    private final String eSpecYmlContent;
    private final boolean isCompressedArchive;
    @Nonnull
    private final CompressorStreamFactory compressorStreamFactory;
    @Nonnull
    private final ArchiveStreamFactory archiveStreamFactory;
    @Nonnull
    private final ExperimentSpecification eSpec;
    private Pattern inDir = Pattern.compile(".*/.+$");

    public AbstractArchiveESpecBundle(InputStream singleUseInputStream) throws ESpecBundle.ESpecBundleInitException {
        this(() -> singleUseInputStream, true);
    }

    @Nonnull
    private String normalizeArchiveFilename(@Nonnull String archiveFilename) {
        if (archiveFilename.startsWith("./")) {
            return archiveFilename.substring(2);
        }
        return archiveFilename;
    }

    AbstractArchiveESpecBundle(@Nonnull InputStreamSupplierThrowingIOException inputStreamSupplier, boolean onlyOnce) throws ESpecBundle.ESpecBundleInitException {
        boolean isCompressedArchive;
        if (onlyOnce) {
            try {
                this.bytes = IOUtils.streamToByteArray((InputStream)inputStreamSupplier.get());
            }
            catch (IOException e) {
                throw new ESpecBundle.ESpecBundleInitException("Error reading bundle from InputStream", e);
            }
        } else {
            this.bytes = null;
        }
        this.inputStreamSupplier = onlyOnce ? () -> new ByteArrayInputStream(this.bytes) : inputStreamSupplier;
        this.archiveEntries = new ArrayList<ArchiveEntry>();
        String foundESpecYmlContent = null;
        this.compressorStreamFactory = new CompressorStreamFactory();
        this.archiveStreamFactory = new ArchiveStreamFactory();
        try (InputStream inputStream = inputStreamSupplier.get();
             BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
             CompressorInputStream cis = this.compressorStreamFactory.createCompressorInputStream((InputStream)bufferedInputStream);){
            isCompressedArchive = true;
        }
        catch (IOException | CompressorException e) {
            isCompressedArchive = false;
        }
        this.isCompressedArchive = isCompressedArchive;
        LOG.debug("Inputstream was " + (isCompressedArchive ? "a" : "NOT a") + " compressed archive");
        ArrayList<String> foundFilenames = new ArrayList<String>();
        try (InputStream inputStream = inputStreamSupplier.get();
             BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
             ArchiveInputStream archiveInput = isCompressedArchive ? this.archiveStreamFactory.createArchiveInputStream((InputStream)new BufferedInputStream((InputStream)this.compressorStreamFactory.createCompressorInputStream((InputStream)bufferedInputStream))) : this.archiveStreamFactory.createArchiveInputStream((InputStream)bufferedInputStream);){
            ArchiveEntry archiveEntry = archiveInput.getNextEntry();
            while (archiveEntry != null) {
                this.archiveEntries.add(archiveEntry);
                foundFilenames.add(this.normalizeArchiveFilename(archiveEntry.getName()));
                if (ESpecBundle.isESpecDescriptionFilename(this.normalizeArchiveFilename(archiveEntry.getName()))) {
                    byte[] content = new byte[(int)archiveEntry.getSize()];
                    int offset = 0;
                    while ((long)offset < archiveEntry.getSize()) {
                        int read = archiveInput.read(content, offset, content.length - offset);
                        if (read == -1) {
                            throw new IOException("Unexpected end of stream");
                        }
                        assert ((long)(offset += read) <= archiveEntry.getSize()) : "Read to much from stream. This is unexpected. read=" + read + " offset=" + offset + " archiveEntry.getSize()=" + archiveEntry.getSize();
                    }
                    foundESpecYmlContent = new String(content, StandardCharsets.UTF_8);
                }
                archiveEntry = archiveInput.getNextEntry();
            }
            archiveInput.close();
        }
        catch (ArchiveException | CompressorException e) {
            throw new ESpecBundleInvalidArchiveException("Invalid ESpec archive", e);
        }
        catch (IOException e) {
            throw new ESpecBundle.ESpecBundleInitException("Failed to process ESpec archive", e);
        }
        if (foundESpecYmlContent == null) {
            throw new RuntimeException("Archive does not contain the required file \"experiment-specification.yaml\". Files in archive: " + foundFilenames);
        }
        this.eSpecYmlContent = foundESpecYmlContent;
        ExperimentSpecificationParser parser = new ExperimentSpecificationParser();
        try {
            this.eSpec = parser.parse(this.getExperimentSpecificationYml());
        }
        catch (ExperimentSpecificationParser.ExperimentSpecificationParseException e) {
            throw new IllegalArgumentException("Failed to parse ExperimentSpecification:" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read ExperimentSpecification", e);
        }
    }

    @Override
    @Nonnull
    public List<String> getFileNames() {
        return this.archiveEntries.stream().map(ArchiveEntry::getName).map(this::normalizeArchiveFilename).filter(name -> !this.inDir.matcher((CharSequence)name).matches()).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nonnull
    public byte[] getFileContent(@Nonnull String fileName) throws IOException {
        try {
            int read;
            ArchiveEntry archiveEntry;
            ArchiveInputStream archiveInput;
            block26: {
                InputStream inputStream = this.inputStreamSupplier.get();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                archiveInput = this.isCompressedArchive ? this.archiveStreamFactory.createArchiveInputStream((InputStream)new BufferedInputStream((InputStream)this.compressorStreamFactory.createCompressorInputStream((InputStream)bufferedInputStream))) : this.archiveStreamFactory.createArchiveInputStream((InputStream)bufferedInputStream);
                archiveEntry = archiveInput.getNextEntry();
                while (archiveEntry != null) {
                    if (!this.normalizeArchiveFilename(archiveEntry.getName()).equals(fileName)) {
                        archiveEntry = archiveInput.getNextEntry();
                        continue;
                    }
                    break block26;
                }
                archiveInput.close();
                throw new IOException("There is no file with name \"" + fileName + "\"");
                finally {
                    if (archiveInput != null) {
                        archiveInput.close();
                    }
                }
                finally {
                    bufferedInputStream.close();
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            byte[] content = new byte[(int)archiveEntry.getSize()];
            int offset = 0;
            while (true) {
                if ((long)offset >= archiveEntry.getSize()) {
                    byte[] byArray = content;
                    return byArray;
                }
                read = archiveInput.read(content, offset, content.length - offset);
                if (read != -1) continue;
                throw new IOException("Unexpected end of stream");
                assert ((long)(offset += read) <= archiveEntry.getSize()) : "Read to much from stream. This is unexpected. read=" + read + " offset=" + offset + " archiveEntry.getSize()=" + archiveEntry.getSize();
            }
        }
        catch (ArchiveException | CompressorException e) {
            throw new IOException("Failed to process ESpec archive", e);
        }
    }

    @Override
    public boolean isDir(@Nonnull String filename) throws IOException {
        String dirFilenameSlash = AbstractArchiveESpecBundle.assureEndWithSlash(filename);
        return this.archiveEntries.stream().filter(Objects::nonNull).filter(e -> Objects.equals(AbstractArchiveESpecBundle.assureEndWithSlash(this.normalizeArchiveFilename(e.getName())), dirFilenameSlash)).findAny().orElseThrow(() -> new FileNotFoundException("There is no file with name \"" + filename + "\"")).isDirectory();
    }

    @Override
    public List<String> getDirFiles(@Nonnull String dirFileName) throws IOException {
        if (!this.isDir(dirFileName)) {
            throw new IllegalArgumentException("file \"" + dirFileName + "\" in bundle is not a directory");
        }
        String dirFilenameSlash = AbstractArchiveESpecBundle.assureEndWithSlash(dirFileName);
        return this.archiveEntries.stream().filter(Objects::nonNull).map(ArchiveEntry::getName).map(this::normalizeArchiveFilename).filter(n -> n.length() > dirFilenameSlash.length()).filter(n -> n.startsWith(dirFilenameSlash)).filter(n -> {
            int slash = n.indexOf(47, dirFilenameSlash.length());
            return slash == -1 || slash == n.length() - 1;
        }).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public ExperimentSpecification getExperimentSpecification() {
        return this.eSpec;
    }

    @Nonnull
    private static String assureEndWithSlash(@Nonnull String p) {
        if (p.endsWith("/")) {
            return p;
        }
        return p + "/";
    }

    public static interface InputStreamSupplierThrowingIOException {
        public InputStream get() throws IOException;
    }

    public static class ESpecBundleInvalidArchiveException
    extends ESpecBundle.ESpecBundleInitException {
        public ESpecBundleInvalidArchiveException() {
        }

        public ESpecBundleInvalidArchiveException(String s) {
            super(s);
        }

        public ESpecBundleInvalidArchiveException(String s, Throwable throwable) {
            super(s, throwable);
        }

        public ESpecBundleInvalidArchiveException(Throwable throwable) {
            super(throwable);
        }

        public ESpecBundleInvalidArchiveException(String s, Throwable throwable, boolean b, boolean b1) {
            super(s, throwable, b, b1);
        }
    }
}

