/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.espec.bundle;

import be.iminds.ilabt.jfed.espec.bundle.ESpecBundle;
import be.iminds.ilabt.jfed.espec.bundle.InMemoryArchiveESpecBundle;
import be.iminds.ilabt.jfed.espec.bundle.InMemorySimpleESpecBundle;
import be.iminds.ilabt.jfed.espec.bundle.LocalArchiveESpecBundle;
import be.iminds.ilabt.jfed.espec.bundle.LocalDirESpecBundle;
import be.iminds.ilabt.jfed.git.GitAuthPreferences;
import be.iminds.ilabt.jfed.git.GitFetcher;
import be.iminds.ilabt.jfed.git.GitFetcherCommand;
import be.iminds.ilabt.jfed.git.GitFetcherCommandBuilder;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(BundleFetcher.class);

    private BundleFetcher() {
    }

    @Nonnull
    public static ESpecBundle fetchDir(@Nonnull String dirname) throws ESpecBundle.ESpecBundleInitException {
        return BundleFetcher.fetchDir(new File(dirname), true);
    }

    @Nonnull
    public static ESpecBundle fetchDir(@Nonnull String dirname, boolean testExperimentSpecificationPresence) throws ESpecBundle.ESpecBundleInitException {
        return BundleFetcher.fetchDir(new File(dirname), testExperimentSpecificationPresence);
    }

    @Nonnull
    public static ESpecBundle fetchDir(@Nonnull File dir) throws ESpecBundle.ESpecBundleInitException {
        return BundleFetcher.fetchDir(dir, true);
    }

    @Nonnull
    public static ESpecBundle fetchDir(@Nonnull File dir, boolean testExperimentSpecificationPresence) throws ESpecBundle.ESpecBundleInitException {
        LocalDirESpecBundle res = new LocalDirESpecBundle(dir);
        if (testExperimentSpecificationPresence && !res.isExperimentSpecificationPresent()) {
            throw new RuntimeException("experiment-specification.yaml is not present in bundle");
        }
        return res;
    }

    @Nonnull
    public static ESpecBundle fetchArchiveUrl(@Nonnull String url) throws ESpecBundle.ESpecBundleInitException, InterruptedException {
        return BundleFetcher.fetchArchiveUrl(url, true);
    }

    @Nonnull
    public static ESpecBundle fetchArchiveUrl(@Nonnull String url, boolean testExperimentSpecificationPresence) throws ESpecBundle.ESpecBundleInitException, InterruptedException {
        try {
            return BundleFetcher.fetchArchiveUrl(new URL(url), testExperimentSpecificationPresence);
        }
        catch (MalformedURLException e) {
            throw new ESpecBundle.ESpecBundleInitException("Invalid URL", e);
        }
    }

    @Nonnull
    public static ESpecBundle fetchArchiveUrl(@Nonnull URL url) throws ESpecBundle.ESpecBundleInitException, InterruptedException {
        return BundleFetcher.fetchArchiveUrl(url, true);
    }

    @Nonnull
    public static ESpecBundle fetchArchiveUrl(@Nonnull URL url, boolean testExperimentSpecificationPresence) throws ESpecBundle.ESpecBundleInitException, InterruptedException {
        try {
            File tmpFile = IOUtils.urlToTmpFile((URL)url);
            LOG.debug("Downloaded ESpecBundle to " + tmpFile.getPath());
            ESpecBundle res = BundleFetcher.fetchArchiveFile(tmpFile);
            if (testExperimentSpecificationPresence && !res.isExperimentSpecificationPresent()) {
                throw new RuntimeException("experiment-specification.yaml is not present in bundle");
            }
            return res;
        }
        catch (IOException e) {
            throw new ESpecBundle.ESpecBundleInitException("Error downloading ESpecBundle", e);
        }
    }

    @Nonnull
    public static ESpecBundle fetchGitRepoDir(@Nonnull String gitFetcherSpec) throws ESpecBundle.ESpecBundleInitException, InterruptedException {
        return BundleFetcher.fetchGitRepoDir(gitFetcherSpec, null, true);
    }

    @Nonnull
    public static ESpecBundle fetchGitRepoDir(@Nonnull String gitFetcherSpec, @Nullable GitAuthPreferences gitAuthPreferences) throws ESpecBundle.ESpecBundleInitException, InterruptedException {
        return BundleFetcher.fetchGitRepoDir(gitFetcherSpec, gitAuthPreferences, true);
    }

    @Nonnull
    public static ESpecBundle fetchGitRepoDir(@Nonnull String gitFetcherSpec, boolean testExperimentSpecificationPresence) throws ESpecBundle.ESpecBundleInitException, InterruptedException {
        return BundleFetcher.fetchGitRepoDir(gitFetcherSpec, null, testExperimentSpecificationPresence);
    }

    @Nonnull
    public static ESpecBundle fetchGitRepoDir(@Nonnull String gitFetcherSpec, @Nullable GitAuthPreferences gitAuthPreferences, boolean testExperimentSpecificationPresence) throws ESpecBundle.ESpecBundleInitException, InterruptedException {
        try {
            GitFetcherCommandBuilder c = (GitFetcherCommandBuilder)GitFetcherCommandBuilder.fromString((String)gitFetcherSpec).orElseThrow(() -> new IllegalArgumentException("gitFetcherSpec='" + gitFetcherSpec + "' is not a valid git source string"));
            c.setTargetDir(GitFetcherCommand.createTempDirectory());
            File gitRepoDir = new GitFetcher(gitAuthPreferences).fetch(c.build());
            IOUtils.deleteDirAtExit((File)gitRepoDir);
            LOG.debug("Downloaded ESpec From repo to " + gitRepoDir);
            ESpecBundle res = BundleFetcher.fetchDir(gitRepoDir);
            if (testExperimentSpecificationPresence && !res.isExperimentSpecificationPresent()) {
                throw new RuntimeException("experiment-specification.yaml is not present in bundle");
            }
            return res;
        }
        catch (Exception e) {
            throw new ESpecBundle.ESpecBundleInitException("Error downloading ESpecBundle from git repo '" + gitFetcherSpec + "'", e);
        }
    }

    @Nonnull
    public static ESpecBundle fetchArchiveFile(@Nonnull String filename) throws ESpecBundle.ESpecBundleInitException {
        return BundleFetcher.fetchArchiveFile(filename, true);
    }

    @Nonnull
    public static ESpecBundle fetchArchiveFile(@Nonnull File filename) throws ESpecBundle.ESpecBundleInitException {
        return BundleFetcher.fetchArchiveFile(filename, true);
    }

    @Nonnull
    public static ESpecBundle fetchArchive(@Nonnull InputStream inputStream) throws ESpecBundle.ESpecBundleInitException {
        return BundleFetcher.fetchArchive(inputStream, true);
    }

    @Nonnull
    public static ESpecBundle fetchArchive(@Nonnull byte[] bytes) throws ESpecBundle.ESpecBundleInitException {
        return BundleFetcher.fetchArchive(bytes, true);
    }

    @Nonnull
    public static ESpecBundle fetchArchiveFile(@Nonnull String filename, boolean testExperimentSpecificationPresence) throws ESpecBundle.ESpecBundleInitException {
        ESpecBundle res = BundleFetcher.fetchArchiveFile(new File(filename));
        if (testExperimentSpecificationPresence && !res.isExperimentSpecificationPresent()) {
            throw new RuntimeException("experiment-specification.yaml is not present in bundle");
        }
        return res;
    }

    @Nonnull
    public static ESpecBundle fetchArchiveFile(@Nonnull File filename, boolean testExperimentSpecificationPresence) throws ESpecBundle.ESpecBundleInitException {
        LocalArchiveESpecBundle res = new LocalArchiveESpecBundle(filename);
        if (testExperimentSpecificationPresence && !res.isExperimentSpecificationPresent()) {
            throw new RuntimeException("experiment-specification.yaml is not present in bundle");
        }
        return res;
    }

    @Nonnull
    public static ESpecBundle fetchArchive(@Nonnull InputStream inputStream, boolean testExperimentSpecificationPresence) throws ESpecBundle.ESpecBundleInitException {
        InMemoryArchiveESpecBundle res = new InMemoryArchiveESpecBundle(inputStream);
        if (testExperimentSpecificationPresence && !res.isExperimentSpecificationPresent()) {
            throw new RuntimeException("experiment-specification.yaml is not present in bundle");
        }
        return res;
    }

    @Nonnull
    public static ESpecBundle fetchArchive(@Nonnull byte[] bytes, boolean testExperimentSpecificationPresence) throws ESpecBundle.ESpecBundleInitException {
        InMemoryArchiveESpecBundle res = new InMemoryArchiveESpecBundle(bytes);
        if (testExperimentSpecificationPresence && !res.isExperimentSpecificationPresent()) {
            throw new RuntimeException("experiment-specification.yaml is not present in bundle");
        }
        return res;
    }

    @Nonnull
    public static ESpecBundle fromDirect(@Nonnull String experimentSpecificationContent) {
        return new InMemorySimpleESpecBundle(experimentSpecificationContent);
    }
}

