/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.espec.bundle;

import be.iminds.ilabt.jfed.espec.model.ExperimentSpecification;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

public interface ESpecBundle {
    public static final String ESPEC_DESCRIPTION_FILENAME = "experiment-specification.yaml";
    public static final String ESPEC_DESCRIPTION_FILENAME2 = "experiment-specification.yml";

    public static boolean isESpecDescriptionFilename(@Nonnull String filename) {
        return filename.equalsIgnoreCase(ESPEC_DESCRIPTION_FILENAME) || filename.equalsIgnoreCase(ESPEC_DESCRIPTION_FILENAME2);
    }

    public static boolean containsESpecDescriptionFilename(@Nonnull Collection<String> filenames) {
        return filenames.stream().anyMatch(ESpecBundle::isESpecDescriptionFilename);
    }

    @Nonnull
    public static String getESpecDescriptionFilename(@Nonnull Collection<String> filenames) {
        if (filenames.contains(ESPEC_DESCRIPTION_FILENAME)) {
            return ESPEC_DESCRIPTION_FILENAME;
        }
        return filenames.stream().filter(ESpecBundle::isESpecDescriptionFilename).findFirst().get();
    }

    @Nonnull
    public List<String> getFileNames();

    @Nonnull
    public byte[] getFileContent(@Nonnull String var1) throws IOException;

    public boolean isDir(@Nonnull String var1) throws IOException;

    public List<String> getDirFiles(@Nonnull String var1) throws IOException;

    default public boolean isExperimentSpecificationPresent() {
        return ESpecBundle.containsESpecDescriptionFilename(this.getFileNames());
    }

    @Nonnull
    default public String getExperimentSpecificationYml() throws IOException {
        if (!1.$assertionsDisabled && !ESpecBundle.containsESpecDescriptionFilename(this.getFileNames())) {
            throw new AssertionError();
        }
        return new String(this.getFileContent(ESpecBundle.getESpecDescriptionFilename(this.getFileNames())), StandardCharsets.UTF_8);
    }

    @Nonnull
    public ExperimentSpecification getExperimentSpecification();

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static class ESpecBundleInitException
    extends Exception {
        public ESpecBundleInitException() {
        }

        public ESpecBundleInitException(String s) {
            super(s);
        }

        public ESpecBundleInitException(String s, Throwable throwable) {
            super(s, throwable);
        }

        public ESpecBundleInitException(Throwable throwable) {
            super(throwable);
        }

        public ESpecBundleInitException(String s, Throwable throwable, boolean b, boolean b1) {
            super(s, throwable, b, b1);
        }
    }
}

