/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.espec.bundle;

import be.iminds.ilabt.jfed.espec.bundle.ESpecBundle;
import be.iminds.ilabt.jfed.espec.model.ExperimentSpecification;
import be.iminds.ilabt.jfed.espec.parser.ExperimentSpecificationParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class InMemorySimpleESpecBundle
implements ESpecBundle {
    @Nonnull
    private final String experimentSpecificationContent;
    @Nonnull
    private final ExperimentSpecification eSpec;

    public InMemorySimpleESpecBundle(@Nonnull String experimentSpecificationContent) {
        this.experimentSpecificationContent = experimentSpecificationContent;
        ExperimentSpecificationParser parser = new ExperimentSpecificationParser();
        try {
            this.eSpec = parser.parse(this.getExperimentSpecificationYml());
        }
        catch (ExperimentSpecificationParser.ExperimentSpecificationParseException e) {
            throw new IllegalArgumentException("Failed to parse ExperimentSpecification: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read ExperimentSpecification", e);
        }
    }

    @Override
    @Nonnull
    public List<String> getFileNames() {
        return Collections.singletonList("experiment-specification.yaml");
    }

    @Override
    @Nonnull
    public byte[] getFileContent(@Nonnull String fileName) throws IOException {
        if (ESpecBundle.isESpecDescriptionFilename(fileName)) {
            return this.experimentSpecificationContent.getBytes(StandardCharsets.UTF_8);
        }
        throw new FileNotFoundException("InMemorySimpleESpecBundle can never have file \"" + fileName + "\"");
    }

    @Override
    public boolean isDir(@Nonnull String fileName) throws IOException {
        return false;
    }

    @Override
    public List<String> getDirFiles(@Nonnull String dirFileName) throws IOException {
        throw new FileNotFoundException("InMemorySimpleESpecBundle can never have a dir at all (\"" + dirFileName + "\" requested)");
    }

    @Override
    public boolean isExperimentSpecificationPresent() {
        return true;
    }

    @Override
    @Nonnull
    public String getExperimentSpecificationYml() throws IOException {
        return this.experimentSpecificationContent;
    }

    @Override
    @Nonnull
    public ExperimentSpecification getExperimentSpecification() {
        return this.eSpec;
    }
}

