/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.espec.bundle;

import be.iminds.ilabt.jfed.espec.bundle.ESpecBundle;
import be.iminds.ilabt.jfed.espec.model.ExperimentSpecification;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SequenceWriter;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifiedESpecBundle
implements ESpecBundle {
    private static final Logger LOG = LoggerFactory.getLogger(ModifiedESpecBundle.class);
    @Nonnull
    private final ESpecBundle orig;
    @Nonnull
    private final ExperimentSpecification newExperimentSpecification;
    @Nonnull
    private final String newExperimentSpecificationYml;

    public ModifiedESpecBundle(@Nonnull ESpecBundle orig, @Nonnull ExperimentSpecification newExperimentSpecification) {
        this.orig = orig;
        this.newExperimentSpecification = newExperimentSpecification;
        YAMLFactory yf = new YAMLFactory();
        ObjectMapper mapper = new ObjectMapper((JsonFactory)yf);
        StringWriter stringWriter = new StringWriter();
        try {
            SequenceWriter seqWriter = mapper.writerWithDefaultPrettyPrinter().writeValues((Writer)stringWriter);
            seqWriter.write((Object)newExperimentSpecification);
            stringWriter.flush();
            this.newExperimentSpecificationYml = stringWriter.getBuffer().toString();
            LOG.debug("Updated experiment-specification.yaml is:\n" + this.newExperimentSpecificationYml);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write updated experiment-specification.yaml", e);
        }
    }

    @Override
    @Nonnull
    public List<String> getFileNames() {
        return this.orig.getFileNames();
    }

    @Override
    @Nonnull
    public byte[] getFileContent(@Nonnull String fileName) throws IOException {
        if (ESpecBundle.isESpecDescriptionFilename(fileName)) {
            return this.newExperimentSpecificationYml.getBytes(StandardCharsets.UTF_8);
        }
        return this.orig.getFileContent(fileName);
    }

    @Override
    public boolean isExperimentSpecificationPresent() {
        return true;
    }

    @Override
    @Nonnull
    public String getExperimentSpecificationYml() throws IOException {
        return this.newExperimentSpecificationYml;
    }

    @Override
    public boolean isDir(@Nonnull String fileName) throws IOException {
        return this.orig.isDir(fileName);
    }

    @Override
    public List<String> getDirFiles(@Nonnull String dirFileName) throws IOException {
        return this.orig.getDirFiles(dirFileName);
    }

    @Override
    @Nonnull
    public ExperimentSpecification getExperimentSpecification() {
        return this.newExperimentSpecification;
    }
}

