/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.espec.filefetcher;

import be.iminds.ilabt.jfed.espec.bundle.ESpecBundle;
import be.iminds.ilabt.jfed.espec.filefetcher.RandomDataGenerator;
import be.iminds.ilabt.jfed.espec.model.FileSource;
import be.iminds.ilabt.jfed.espec.model.GeneratedRSpecFileSource;
import be.iminds.ilabt.jfed.espec.model.GeneratedRandomFileSource;
import be.iminds.ilabt.jfed.espec.model.GeneratedStitchingTestRSpecFileSource;
import be.iminds.ilabt.jfed.espec.model.GitFileSource;
import be.iminds.ilabt.jfed.git.GitAuthPreferences;
import be.iminds.ilabt.jfed.git.GitFetcher;
import be.iminds.ilabt.jfed.git.GitFetcherCommand;
import be.iminds.ilabt.jfed.git.GitFetcherCommandBuilder;
import be.iminds.ilabt.jfed.rspec.generator.RSpecGenerator;
import be.iminds.ilabt.jfed.rspec.generator.RSpecGeneratorFactory;
import be.iminds.ilabt.jfed.rspec.generator.StitchingTestRSpecGenerator;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FileFetcher {
    @Nonnull
    private final FileSource fileSource;
    @Nonnull
    private final ESpecBundle bundle;
    @Nullable
    private final RSpecGeneratorFactory rSpecGeneratorFactory;
    @Nullable
    private GitAuthPreferences gitAuthPreferences;

    public FileFetcher(@Nonnull FileSource fileSource, @Nonnull ESpecBundle bundle, @Nullable RSpecGeneratorFactory rSpecGeneratorFactory, @Nullable GitAuthPreferences gitAuthPreferences) {
        this.fileSource = fileSource;
        this.bundle = bundle;
        this.rSpecGeneratorFactory = rSpecGeneratorFactory;
        this.gitAuthPreferences = gitAuthPreferences;
    }

    @Nonnull
    public FileSource getFileSource() {
        return this.fileSource;
    }

    @Nonnull
    public ESpecBundle getBundle() {
        return this.bundle;
    }

    public boolean isFast() {
        switch (this.fileSource.getType()) {
            case BUNDLED: {
                return true;
            }
            case DIRECT: {
                return true;
            }
            case DOWNLOAD: {
                return false;
            }
            case GIT: {
                return false;
            }
            case GITHUB: {
                return false;
            }
            case META: {
                return true;
            }
            case GENERATED: {
                return true;
            }
        }
        throw new IllegalStateException("Unsupported FileSource type: " + this.fileSource.getType().name());
    }

    public boolean isDir() throws IOException {
        switch (this.fileSource.getType()) {
            case BUNDLED: {
                return this.bundle.isDir(this.fileSource.getValue());
            }
            case GIT: 
            case GITHUB: {
                GitFileSource gitFileSource = (GitFileSource)this.fileSource;
                assert (gitFileSource.isDir() != gitFileSource.isFile());
                return gitFileSource.isDir();
            }
        }
        return false;
    }

    @Nonnull
    public byte[] fetchBytes() throws IOException {
        switch (this.fileSource.getType()) {
            case BUNDLED: {
                return this.fetchBundled();
            }
            case DIRECT: {
                return this.fetchDirect();
            }
            case DOWNLOAD: {
                return this.fetchDownload();
            }
            case GIT: {
                return this.fetchGitFile();
            }
            case GITHUB: {
                return this.fetchGithubFile();
            }
            case META: {
                throw new IllegalStateException("fetchBytes should not be called for META " + this.fileSource.getValue());
            }
            case GENERATED: {
                switch (this.fileSource.getValue().toLowerCase()) {
                    case "random": {
                        if (!(this.fileSource instanceof GeneratedRandomFileSource)) {
                            throw new IllegalStateException("Internal bug: random fileSource should be instance of GeneratedRandomFileSource, not " + this.fileSource.getClass().getName());
                        }
                        return FileFetcher.generateRandom((GeneratedRandomFileSource)this.fileSource);
                    }
                    case "rspec": {
                        if (!(this.fileSource instanceof GeneratedRSpecFileSource) && !(this.fileSource instanceof GeneratedStitchingTestRSpecFileSource)) {
                            throw new IllegalStateException("Internal bug: rspec fileSource should be instance of GeneratedRSpecFileSource or GeneratedStitchingTestRSpecFileSource, not " + this.fileSource.getClass().getName());
                        }
                        if (this.fileSource instanceof GeneratedRSpecFileSource) {
                            return this.generateRspec((GeneratedRSpecFileSource)this.fileSource);
                        }
                        return this.generateRspec((GeneratedStitchingTestRSpecFileSource)this.fileSource);
                    }
                }
                throw new IllegalStateException("fetchBytes should not be called for GENERATED " + this.fileSource.getValue());
            }
        }
        throw new IllegalStateException("Unsupported FileSource type: " + this.fileSource.getType().name());
    }

    public byte[] generateRspec(GeneratedRSpecFileSource fileSource) {
        if (this.rSpecGeneratorFactory == null) {
            throw new RuntimeException("Cannot generate RSpec: no rSpecGeneratorFactory registered");
        }
        RSpecGenerator gen = this.rSpecGeneratorFactory.createRSpecGenerator();
        gen.setAm(fileSource.getAm());
        gen.setNodeCount(fileSource.getNodeCount());
        if (!fileSource.getNodeNames().isEmpty()) {
            gen.setNodeNames(fileSource.getNodeNames());
        }
        if (!fileSource.getNodeNamePrefix().isEmpty()) {
            gen.setNodePrefix(fileSource.getNodeNamePrefix());
        }
        if (fileSource.getResourceClass() != null) {
            gen.setResourceClassIdPrefix(fileSource.getResourceClass());
        }
        if (fileSource.getDiskImage() != null) {
            gen.setDiskImage(fileSource.getDiskImage());
        }
        if (fileSource.getLink() != null) {
            gen.setLink(fileSource.getLink());
        }
        if (fileSource.getLinkStartIpIndex() != null) {
            gen.setLinkStartIpIndex(fileSource.getLinkStartIpIndex());
        }
        if (fileSource.getLinkSubnet() != null) {
            gen.setLinkSubnet(fileSource.getLinkSubnet());
        }
        String rspec = gen.generateRequest();
        return rspec.getBytes(StandardCharsets.UTF_8);
    }

    public byte[] generateRspec(GeneratedStitchingTestRSpecFileSource fileSource) {
        if (this.rSpecGeneratorFactory == null) {
            throw new RuntimeException("Cannot generate RSpec: no rSpecGeneratorFactory registered");
        }
        StitchingTestRSpecGenerator gen = this.rSpecGeneratorFactory.createStitchingTestRSpecGenerator();
        gen.setAms(fileSource.getAms());
        if (!fileSource.getNodeNames().isEmpty()) {
            gen.setNodeNames(fileSource.getNodeNames());
        }
        if (!fileSource.getNodeNamePrefix().isEmpty()) {
            gen.setNodePrefix(fileSource.getNodeNamePrefix());
        }
        if (fileSource.getResourceClasses() != null) {
            gen.setResourceClasses(fileSource.getResourceClasses());
        }
        String rspec = gen.generateRequest();
        return rspec.getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] generateRandom(GeneratedRandomFileSource fileSource) {
        String format = fileSource.getFormat();
        int len = fileSource.getLength();
        switch (format.trim().toLowerCase()) {
            case "password": {
                return RandomDataGenerator.generatePassword(len).getBytes(StandardCharsets.UTF_8);
            }
            case "binary": {
                return RandomDataGenerator.generateBinary(len);
            }
            case "base64": {
                return RandomDataGenerator.generateBase64(len).getBytes(StandardCharsets.UTF_8);
            }
            case "alphanum": {
                return RandomDataGenerator.generateAlphaNum(len).getBytes(StandardCharsets.UTF_8);
            }
        }
        throw new IllegalStateException("generate:random does not support format \"" + format + "\"");
    }

    @Nonnull
    private byte[] fetchBundled() throws IOException {
        return this.bundle.getFileContent(this.fileSource.getValue());
    }

    @Nonnull
    private byte[] fetchDirect() {
        return this.fileSource.getValue().getBytes(StandardCharsets.UTF_8);
    }

    @Nonnull
    private byte[] fetchDownload() {
        try {
            URL url = new URL(this.fileSource.getValue());
            return IOUtils.urlToByteArray((URL)url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid URL: " + this.fileSource.getValue(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading URL: " + this.fileSource.getValue(), e);
        }
    }

    @Nonnull
    private byte[] fetchGitFile() {
        GitFileSource gitFileSource = (GitFileSource)this.fileSource;
        assert (gitFileSource.isFile());
        assert (!gitFileSource.isDir());
        assert (gitFileSource.getFilename() != null);
        if (!gitFileSource.isFile() || gitFileSource.getFilename() == null) {
            throw new IllegalArgumentException("Cannot fetch bytes of a directory");
        }
        GitFetcherCommandBuilder commandBuilder = new GitFetcherCommandBuilder().setGitUrl(gitFileSource.getGitUrl()).setBranch(gitFileSource.getBranch()).setRepoSubDir(gitFileSource.getRepoSubDir()).setUsername(gitFileSource.getUsername()).setPassword(gitFileSource.getPassword()).setPrivateKeyPemFile(gitFileSource.getPrivateKeyPem());
        GitFetcherCommand command = commandBuilder.build();
        assert (gitFileSource.isFile());
        assert (!gitFileSource.isDir());
        assert (gitFileSource.getFilename() != null);
        GitFetcher fetcher = new GitFetcher(this.gitAuthPreferences);
        File localDir = fetcher.fetch(command);
        File localFile = new File(localDir, gitFileSource.getFilename());
        if (!localFile.exists()) {
            throw new RuntimeException("Target file does not exist in downloaded git repo");
        }
        try {
            return IOUtils.fileToByteArray((File)localFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading File downloaded from git", e);
        }
    }

    @Nonnull
    private byte[] fetchGithubFile() {
        return this.fetchGitFile();
    }
}

