/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.espec.model;

import be.iminds.ilabt.jfed.espec.model.AnsibleHostSpec;
import be.iminds.ilabt.jfed.espec.model.AnsibleSpec;
import be.iminds.ilabt.jfed.espec.model.DirSpec;
import be.iminds.ilabt.jfed.espec.model.ESpecConfig;
import be.iminds.ilabt.jfed.espec.model.ExecuteSpec;
import be.iminds.ilabt.jfed.espec.model.ExperimentInfoOutputSpec;
import be.iminds.ilabt.jfed.espec.model.ExperimentSpecification;
import be.iminds.ilabt.jfed.espec.model.ExperimentSpecificationBuilder;
import be.iminds.ilabt.jfed.espec.model.RspecSpec;
import be.iminds.ilabt.jfed.espec.model.UploadSpec;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BasicExperimentSpecificationBuilder
implements ExperimentSpecificationBuilder<BasicExperimentSpecificationBuilder> {
    @Nullable
    private String versionBase;
    @Nullable
    private ExperimentSpecification.Flavor versionFlavor;
    @Nonnull
    private List<String> extensions;
    @Nonnull
    private List<RspecSpec> rspecs;
    @Nonnull
    private List<DirSpec> dirs;
    @Nonnull
    private List<UploadSpec> uploads;
    @Nonnull
    private List<ExecuteSpec> executes;
    @Nullable
    private AnsibleSpec ansible;
    @Nonnull
    private List<ExperimentInfoOutputSpec> experimentInfoOutputs;

    public BasicExperimentSpecificationBuilder() {
        this.extensions = new ArrayList<String>();
        this.rspecs = new ArrayList<RspecSpec>();
        this.dirs = new ArrayList<DirSpec>();
        this.uploads = new ArrayList<UploadSpec>();
        this.executes = new ArrayList<ExecuteSpec>();
        this.ansible = null;
        this.experimentInfoOutputs = new ArrayList<ExperimentInfoOutputSpec>();
    }

    public BasicExperimentSpecificationBuilder(ExperimentSpecification orig) {
        this.versionBase = orig.getVersionBase();
        this.versionFlavor = orig.getVersionFlavor();
        this.extensions = new ArrayList<String>(orig.getExtensions());
        this.rspecs = new ArrayList<RspecSpec>(orig.getRspecs());
        this.dirs = new ArrayList<DirSpec>(orig.getDirs());
        this.uploads = new ArrayList<UploadSpec>(orig.getUploads());
        this.executes = new ArrayList<ExecuteSpec>(orig.getExecutes());
        this.ansible = orig.getAnsible();
        this.experimentInfoOutputs = new ArrayList<ExperimentInfoOutputSpec>(orig.getOutputs());
    }

    @Override
    @Nonnull
    public BasicExperimentSpecificationBuilder setVersion(@Nonnull String versionFull) {
        int versionDashIndex = versionFull.indexOf("-");
        if (versionDashIndex == -1) {
            throw new IllegalArgumentException("Experiment Specification version must be a String of the form <base>-<flavor>");
        }
        this.versionBase = versionFull.substring(0, versionDashIndex);
        String versionFlavorString = versionFull.substring(versionDashIndex + 1);
        String versionFlavorSearchString = versionFlavorString.trim().toUpperCase();
        try {
            this.versionFlavor = ExperimentSpecification.Flavor.valueOf(versionFlavorSearchString);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Experiment Specification version must be a String of the form <base>-<flavor>  but flavor \"" + versionFlavorString + "\" (internally \"" + versionFlavorSearchString + "\") is not known)");
        }
        return this;
    }

    @Override
    @Nonnull
    public BasicExperimentSpecificationBuilder setVersionBase(@Nonnull String versionBase) {
        this.versionBase = versionBase;
        return this;
    }

    @Override
    @Nonnull
    public BasicExperimentSpecificationBuilder setVersionFlavor(@Nonnull ExperimentSpecification.Flavor versionFlavor) {
        this.versionFlavor = versionFlavor;
        return this;
    }

    @Override
    @Nonnull
    public BasicExperimentSpecificationBuilder setExtensions(@Nonnull List<String> extensions) {
        this.extensions = extensions;
        return this;
    }

    @Override
    @Nonnull
    public BasicExperimentSpecificationBuilder setRspecs(@Nonnull List<RspecSpec> rspecs) {
        this.rspecs.clear();
        this.rspecs.addAll(rspecs);
        return this;
    }

    @Override
    @Nonnull
    public BasicExperimentSpecificationBuilder addRspecs(@Nonnull List<RspecSpec> rspecs) {
        this.rspecs.addAll(rspecs);
        return this;
    }

    @Override
    @Nonnull
    public BasicExperimentSpecificationBuilder setRspec(@Nonnull RspecSpec rspecs) {
        this.rspecs.clear();
        this.rspecs.add(rspecs);
        return this;
    }

    @Override
    @Nonnull
    public BasicExperimentSpecificationBuilder addRspec(@Nonnull RspecSpec rspecs) {
        this.rspecs.add(rspecs);
        return this;
    }

    @Override
    @Nonnull
    public BasicExperimentSpecificationBuilder setDirs(@Nonnull List<DirSpec> dirs) {
        this.dirs.clear();
        this.dirs.addAll(dirs);
        return this;
    }

    @Override
    @Nonnull
    public BasicExperimentSpecificationBuilder addDir(@Nonnull DirSpec dir) {
        this.dirs.add(dir);
        return this;
    }

    @Override
    @Nonnull
    public BasicExperimentSpecificationBuilder addDirs(@Nonnull List<DirSpec> dirs) {
        this.dirs.addAll(dirs);
        return this;
    }

    @Override
    @Nonnull
    public BasicExperimentSpecificationBuilder setUploads(@Nonnull List<UploadSpec> uploads) {
        this.uploads.clear();
        this.uploads.addAll(uploads);
        return this;
    }

    @Override
    @Nonnull
    public BasicExperimentSpecificationBuilder addUpload(@Nonnull UploadSpec upload) {
        this.uploads.add(upload);
        return this;
    }

    @Override
    @Nonnull
    public BasicExperimentSpecificationBuilder addUploads(@Nonnull List<UploadSpec> uploads) {
        this.uploads.addAll(uploads);
        return this;
    }

    @Override
    @Nonnull
    public BasicExperimentSpecificationBuilder setExecutes(@Nonnull List<ExecuteSpec> executes) {
        this.executes.clear();
        this.executes.addAll(executes);
        return this;
    }

    @Override
    @Nonnull
    public BasicExperimentSpecificationBuilder addExecute(@Nonnull ExecuteSpec execute) {
        this.executes.add(execute);
        return this;
    }

    @Override
    @Nonnull
    public BasicExperimentSpecificationBuilder addExecutes(@Nonnull List<ExecuteSpec> executes) {
        this.executes.addAll(executes);
        return this;
    }

    @Override
    @Nonnull
    public BasicExperimentSpecificationBuilder setAnsible(@Nullable AnsibleSpec ansible) {
        this.ansible = ansible;
        return this;
    }

    @Override
    @Nonnull
    public BasicExperimentSpecificationBuilder setExperimentInfoOutputs(@Nonnull List<ExperimentInfoOutputSpec> experimentInfoOutputs) {
        this.experimentInfoOutputs = experimentInfoOutputs;
        return this;
    }

    @Override
    @Nonnull
    public BasicExperimentSpecificationBuilder addExperimentInfoOutput(@Nonnull ExperimentInfoOutputSpec experimentInfoOutput) {
        this.experimentInfoOutputs.add(experimentInfoOutput);
        return this;
    }

    @Override
    @Nonnull
    public BasicExperimentSpecificationBuilder addExperimentInfoOutputs(@Nonnull List<ExperimentInfoOutputSpec> experimentInfoOutputs) {
        this.experimentInfoOutputs.addAll(experimentInfoOutputs);
        return this;
    }

    @Override
    @Nonnull
    public ExperimentSpecification create() {
        if (this.versionBase == null) {
            throw new IllegalStateException("You must set the ExperimentSpecification version (base and flavor)");
        }
        if (this.versionFlavor == null) {
            throw new IllegalStateException("You must set the ExperimentSpecification version (base and flavor)");
        }
        if (this.rspecs.isEmpty()) {
            throw new IllegalStateException("You must add at least one Rspec to the ExperimentSpecification");
        }
        boolean defaultIncludeAnsibleNodeInAllNodes = this.ansible != null && this.ansible.getAnsibleHostSpec().getHostType() == AnsibleHostSpec.HostType.EXISTING;
        ESpecConfig config = new ESpecConfig(false, null, true, true, defaultIncludeAnsibleNodeInAllNodes);
        return new ExperimentSpecification(this.versionBase, this.versionFlavor, config, this.extensions, this.rspecs, this.dirs, this.uploads, this.executes, this.ansible, this.experimentInfoOutputs);
    }

    @Nullable
    public String getVersionBase() {
        return this.versionBase;
    }

    @Nullable
    public ExperimentSpecification.Flavor getVersionFlavor() {
        return this.versionFlavor;
    }

    @Nonnull
    public List<String> getExtensions() {
        return this.extensions;
    }

    @Nonnull
    public List<RspecSpec> getRspecs() {
        return this.rspecs;
    }

    @Nonnull
    public List<DirSpec> getDirs() {
        return this.dirs;
    }

    @Nonnull
    public List<UploadSpec> getUploads() {
        return this.uploads;
    }

    @Nonnull
    public List<ExecuteSpec> getExecutes() {
        return this.executes;
    }

    @Override
    @Nullable
    public AnsibleSpec getAnsible() {
        return this.ansible;
    }

    @Nonnull
    public List<ExperimentInfoOutputSpec> getExperimentInfoOutputs() {
        return this.experimentInfoOutputs;
    }
}

