/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.espec.model;

import be.iminds.ilabt.jfed.espec.model.AnsibleSpec;
import be.iminds.ilabt.jfed.espec.model.DirSpec;
import be.iminds.ilabt.jfed.espec.model.ESpecConfig;
import be.iminds.ilabt.jfed.espec.model.ExecuteSpec;
import be.iminds.ilabt.jfed.espec.model.ExperimentInfoOutputSpec;
import be.iminds.ilabt.jfed.espec.model.RspecSpec;
import be.iminds.ilabt.jfed.espec.model.UploadSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExperimentSpecification {
    @Nonnull
    private final String versionBase;
    @Nonnull
    private final Flavor versionFlavor;
    @Nonnull
    private final List<String> extensions;
    @Nonnull
    private final ESpecConfig config;
    @Nonnull
    private final List<RspecSpec> rspecs;
    @Nonnull
    private final List<DirSpec> dirs;
    @Nonnull
    private final List<UploadSpec> uploads;
    @Nonnull
    private final List<ExecuteSpec> executes;
    @Nullable
    private final AnsibleSpec ansible;
    @Nonnull
    private final List<ExperimentInfoOutputSpec> outputs;

    public ExperimentSpecification(@Nonnull String versionBase, @Nonnull Flavor versionFlavor, @Nonnull ESpecConfig config, @Nonnull List<String> extensions, @Nonnull List<RspecSpec> rspecs, @Nonnull List<DirSpec> dirs, @Nonnull List<UploadSpec> uploads, @Nonnull List<ExecuteSpec> executes, @Nullable AnsibleSpec ansible, @Nonnull List<ExperimentInfoOutputSpec> outputs) {
        this.versionBase = versionBase;
        this.versionFlavor = versionFlavor;
        this.config = config;
        this.extensions = Collections.unmodifiableList(new ArrayList<String>(extensions));
        assert (rspecs.size() == 1);
        this.rspecs = Collections.unmodifiableList(new ArrayList<RspecSpec>(rspecs));
        this.dirs = Collections.unmodifiableList(new ArrayList<DirSpec>(dirs));
        this.uploads = Collections.unmodifiableList(new ArrayList<UploadSpec>(uploads));
        this.executes = Collections.unmodifiableList(new ArrayList<ExecuteSpec>(executes));
        this.ansible = ansible;
        this.outputs = Collections.unmodifiableList(new ArrayList<ExperimentInfoOutputSpec>(outputs));
    }

    @Nonnull
    public String getVersionFull() {
        return this.versionBase + "-" + this.versionFlavor.name().toLowerCase();
    }

    @Nonnull
    public String getVersionBase() {
        return this.versionBase;
    }

    @Nonnull
    public ESpecConfig getConfig() {
        return this.config;
    }

    @Nonnull
    public Flavor getVersionFlavor() {
        return this.versionFlavor;
    }

    @Nonnull
    public List<String> getExtensions() {
        return this.extensions;
    }

    @Nonnull
    public List<RspecSpec> getRspecs() {
        return this.rspecs;
    }

    @Nonnull
    public List<DirSpec> getDirs() {
        return this.dirs;
    }

    @Nonnull
    public List<UploadSpec> getUploads() {
        return this.uploads;
    }

    @Nonnull
    public List<ExecuteSpec> getExecutes() {
        return this.executes;
    }

    @Nullable
    public AnsibleSpec getAnsible() {
        return this.ansible;
    }

    @Nonnull
    public List<ExperimentInfoOutputSpec> getOutputs() {
        return this.outputs;
    }

    public static enum Flavor {
        BASIC,
        ADVANCED;

    }
}

