/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.espec.parser;

import be.iminds.ilabt.jfed.util.common.IOUtils;
import javax.annotation.Nonnull;

public class ESpecDefaults {
    public static final String ANSIBLE_INIT_SCRIPT_BASENAME = "install-ansible.sh";
    public static final String ANSIBLE_INIT_SCRIPT_PERMISSIONS = "u=rx";
    public static final String ANSIBLE_INIT_SCRIPT_URL = "https://raw.githubusercontent.com/imec-ilabt/ansible-init-script/master/install-ansible.sh";
    public static final String ENABLE_ILABT_INTERNET_BASENAME = "enable-internet.sh";
    public static final String ENABLE_ILABT_INTERNET_PERMISSIONS = "u=rx";
    public static final String ENABLE_ILABT_INTERNET_URL = "https://raw.githubusercontent.com/imec-ilabt/ilabt-scripts/master/enable-internet.sh";
    public static final String KEYPAIR_PRIVATE_KEY_BASENAME = "id_rsa";
    public static final String KEYPAIR_PRIVATE_KEY_PATH = "~/.ssh/id_rsa";
    public static final String KEYPAIR_PUBLIC_KEY_PATH = "~/.ssh/id_rsa.pub";
    public static final String KEYPAIR_PRIVATE_KEY_PERMISSIONS = "600";
    public static final String ANSIBLE_NODE_NAME = "ansible";
    public static final int ANSIBLE_DEBUG = 0;
    public static final String ANSIBLE_GALAXY_COMMAND = "ansible-galaxy";
    public static final String ANSIBLE_GALAXY_INSTALL_TEMPLATE = "%c collection install -r %r -p galaxy_collections";
    public static final String ANSIBLE_PLAYBOOK_COMMAND = "ansible-playbook";
    public static final String ANSIBLE_PLAYBOOK_RUN_TEMPLATE = "ANSIBLE_COLLECTIONS_PATH=galaxy_collections %c %x %p";
    public static final String RANDOM_TXT_BASENAME = "random.txt";
    public static final String RANDOM_BINARY_BASENAME = "random.dat";

    private ESpecDefaults() {
        throw new RuntimeException("no objects");
    }

    @Nonnull
    public static String deriveAutomaticLogFile(@Nonnull String remotePath) {
        int extDotIndex = remotePath.lastIndexOf(46);
        if (extDotIndex <= 0) {
            return remotePath + ".log";
        }
        String ext = remotePath.substring(extDotIndex + 1);
        String base = remotePath.substring(0, extDotIndex);
        if (ext.equals("sh")) {
            return base + ".log";
        }
        return remotePath + ".log";
    }

    public static String deriveAutomaticGalaxyLogFile(String remotePath) {
        IOUtils.PathParts pp = IOUtils.splitUnixPath((String)remotePath);
        return pp.dir + "galaxy-install-" + pp.fileBase + ".log";
    }

    public static String deriveAutomaticPlaybookLogFile(String remotePath) {
        IOUtils.PathParts pp = IOUtils.splitUnixPath((String)remotePath);
        return pp.dir + "playbook-exec-" + pp.fileBase + ".log";
    }

    public static String deriveAutomaticGalaxyScriptFile(String remotePath) {
        IOUtils.PathParts pp = IOUtils.splitUnixPath((String)remotePath);
        return pp.dir + "galaxy-install-" + pp.fileBase + ".sh";
    }

    public static String deriveAutomaticPlaybookScriptFile(String remotePath) {
        IOUtils.PathParts pp = IOUtils.splitUnixPath((String)remotePath);
        return pp.dir + "playbook-exec-" + pp.fileBase + ".sh";
    }
}

