/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.espec.parser;

import be.iminds.ilabt.jfed.espec.model.AnsibleGalaxySpec;
import be.iminds.ilabt.jfed.espec.model.AnsibleHostSpec;
import be.iminds.ilabt.jfed.espec.model.AnsiblePlaybookSpec;
import be.iminds.ilabt.jfed.espec.model.AnsibleSpec;
import be.iminds.ilabt.jfed.espec.model.BasicExperimentSpecificationBuilder;
import be.iminds.ilabt.jfed.espec.model.DirSpec;
import be.iminds.ilabt.jfed.espec.model.ExecuteSpec;
import be.iminds.ilabt.jfed.espec.model.ExperimentInfoOutputSpec;
import be.iminds.ilabt.jfed.espec.model.ExperimentSpecification;
import be.iminds.ilabt.jfed.espec.model.FileSource;
import be.iminds.ilabt.jfed.espec.model.GeneratedRSpecFileSource;
import be.iminds.ilabt.jfed.espec.model.GeneratedRandomFileSource;
import be.iminds.ilabt.jfed.espec.model.GeneratedStitchingTestRSpecFileSource;
import be.iminds.ilabt.jfed.espec.model.GitFileSource;
import be.iminds.ilabt.jfed.espec.model.RspecSpec;
import be.iminds.ilabt.jfed.espec.model.UploadSpec;
import be.iminds.ilabt.jfed.espec.parser.ESpecConstants;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Contract;

public class ExperimentSpecificationParser {
    private ObjectMapper mapper;
    private int directCount;

    public ExperimentSpecificationParser() {
        YAMLFactory yf = new YAMLFactory();
        this.mapper = new ObjectMapper((JsonFactory)yf);
    }

    public ExperimentSpecification parse(String input) throws ExperimentSpecificationParseException {
        Map root;
        this.directCount = 0;
        try {
            root = (Map)this.mapper.readValue(input, Map.class);
        }
        catch (IOException e) {
            throw new ExperimentSpecificationParseException("Failed to parse ExperimentSpecification yaml", e);
        }
        if (root == null) {
            throw new ExperimentSpecificationParseException("Failed to parse ExperimentSpecification yaml");
        }
        BasicExperimentSpecificationBuilder res = new BasicExperimentSpecificationBuilder();
        this.checkAllowedKeys("root", root, "version", "rspec", "dir", "upload", "execute", "ansible", "output");
        Object rawVersion = root.get("version");
        Object rawRspec = root.get("rspec");
        Object rawDir = root.get("dir");
        Object rawUpload = root.get("upload");
        Object rawExecute = root.get("execute");
        Object rawExperimentInfoOutputs = root.get("output");
        Object rawAnsible = root.get("ansible");
        if (rawVersion == null) {
            throw new ExperimentSpecificationParseException("Experiment Specification must contain version");
        }
        if (!(rawVersion instanceof String)) {
            throw new ExperimentSpecificationParseException("Experiment Specification version must be a String");
        }
        try {
            res.setVersion((String)rawVersion);
        }
        catch (IllegalArgumentException e) {
            throw new ExperimentSpecificationParseException("Experiment Specification version must be a String of the form <base>-<flavor>", e);
        }
        res.setRspec(this.extractRspecSpec(rawRspec));
        res.setAnsible(this.extractAnsibleSpec(rawAnsible));
        res.setDirs(this.addDefaultDirsIfNeeded(this.extractDirSpecs(rawDir), res.getAnsible() != null));
        res.setUploads(this.extractUploadSpecs(rawUpload));
        res.setExecutes(this.extractExecuteSpecs(rawExecute));
        res.setExperimentInfoOutputs(this.extractExperimentInfoOutputs(rawExperimentInfoOutputs));
        return res.create();
    }

    public static String makeValidDirPath(String dirPath) throws ExperimentSpecificationParseException {
        if (dirPath == null) {
            return "~";
        }
        if (dirPath.trim().isEmpty()) {
            return "~";
        }
        if (dirPath.startsWith("/")) {
            return dirPath;
        }
        if (dirPath.startsWith("~")) {
            if (dirPath.length() == 1) {
                return dirPath;
            }
            if (dirPath.charAt(1) != '/') {
                throw new ExperimentSpecificationParseException("Experiment Specification dir path \"" + dirPath + "\" is not valid (starts with '" + dirPath.substring(0, 2) + "')");
            }
            return dirPath;
        }
        throw new ExperimentSpecificationParseException("Experiment Specification dir path \"" + dirPath + "\" is not valid (does not start with / or ~)");
    }

    private List<DirSpec> addDefaultDirsIfNeeded(List<DirSpec> orig, boolean hasAnsible) {
        ArrayList<DirSpec> res = new ArrayList<DirSpec>(orig);
        int scriptDirCount = 0;
        int uploadDirCount = 0;
        int ansibleDirCount = 0;
        DirSpec uploadDir = null;
        DirSpec scriptDir = null;
        for (DirSpec dir : orig) {
            if (dir.isUploadContent()) {
                ++uploadDirCount;
                uploadDir = dir;
            }
            if (dir.isScriptContent()) {
                ++scriptDirCount;
                scriptDir = dir;
            }
            if (!dir.isAnsibleContent()) continue;
            ++ansibleDirCount;
        }
        if (uploadDirCount == 0) {
            uploadDir = new DirSpec("~", ESpecConstants.DIRSPEC_CONTENT_UPLOAD, "u=rwx", null);
            res.add(uploadDir);
        }
        assert (uploadDir != null);
        if (scriptDirCount == 0) {
            scriptDir = new DirSpec(uploadDir.getPath(), ESpecConstants.DIRSPEC_CONTENT_SCRIPT, "u=rwx", null);
            res.add(scriptDir);
        }
        assert (scriptDir != null);
        if (ansibleDirCount == 0 && hasAnsible) {
            res.add(new DirSpec(ExperimentSpecificationParser.ensureEndsWithSlash(scriptDir.getPath()) + "ansible/", ESpecConstants.DIRSPEC_CONTENT_ANSIBLE, "u=rwx", null));
        }
        return res;
    }

    @Nonnull
    private List<DirSpec> extractDirSpecs(@Nullable Object rawDir) throws ExperimentSpecificationParseException {
        if (rawDir == null) {
            return Collections.emptyList();
        }
        if (rawDir instanceof String) {
            return Collections.singletonList(new DirSpec(ExperimentSpecificationParser.makeValidDirPath((String)rawDir), null, null, null));
        }
        if (rawDir instanceof Map) {
            return Collections.singletonList(this.mapToDirSpec((Map)rawDir, "dir"));
        }
        if (rawDir instanceof List) {
            List list = (List)rawDir;
            ArrayList<DirSpec> res = new ArrayList<DirSpec>();
            for (int i = 0; i < list.size(); ++i) {
                Object listObj = list.get(i);
                if (listObj instanceof String) {
                    res.add(new DirSpec(ExperimentSpecificationParser.makeValidDirPath((String)listObj), null, null, null));
                    continue;
                }
                if (listObj instanceof Map) {
                    res.add(this.mapToDirSpec((Map)listObj, "dir[" + i + "]"));
                    continue;
                }
                throw new ExperimentSpecificationParseException("Experiment Specification dir list must not have item of type \"" + listObj.getClass().getName() + "\" (at index " + i + "))");
            }
            return res;
        }
        throw new ExperimentSpecificationParseException("Experiment Specification dir must not be of type \"" + rawDir.getClass().getName() + "\")");
    }

    @Nonnull
    private List<UploadSpec> extractUploadSpecs(@Nullable Object rawUpload) throws ExperimentSpecificationParseException {
        if (rawUpload == null) {
            return Collections.emptyList();
        }
        if (rawUpload instanceof String) {
            return Collections.singletonList(new UploadSpec(new FileSource(FileSource.SourceType.BUNDLED, (String)rawUpload, (String)rawUpload), null, null, null));
        }
        if (rawUpload instanceof Map) {
            return this.mapToUploadSpecs((Map)rawUpload, "upload");
        }
        if (rawUpload instanceof List) {
            List list = (List)rawUpload;
            ArrayList<UploadSpec> res = new ArrayList<UploadSpec>();
            for (int i = 0; i < list.size(); ++i) {
                Object listObj = list.get(i);
                if (listObj instanceof String) {
                    res.add(new UploadSpec(new FileSource(FileSource.SourceType.BUNDLED, (String)listObj, (String)listObj), null, null, null));
                    continue;
                }
                if (listObj instanceof Map) {
                    res.addAll(this.mapToUploadSpecs((Map)listObj, "upload[" + i + "]"));
                    continue;
                }
                throw new ExperimentSpecificationParseException("Experiment Specification upload list must not have item of type \"" + listObj.getClass().getName() + "\" (at index " + i + "))");
            }
            return res;
        }
        throw new ExperimentSpecificationParseException("Experiment Specification upload must not be of type \"" + rawUpload.getClass().getName() + "\")");
    }

    @Nonnull
    private List<ExecuteSpec> extractExecuteSpecs(@Nullable Object rawExecute) throws ExperimentSpecificationParseException {
        if (rawExecute == null) {
            return Collections.emptyList();
        }
        if (rawExecute instanceof String) {
            return Collections.singletonList(new ExecuteSpec(new FileSource(FileSource.SourceType.BUNDLED, (String)rawExecute, (String)rawExecute), null, null, null, false, null, null));
        }
        if (rawExecute instanceof Map) {
            return Collections.singletonList(this.mapToExecuteSpec((Map)rawExecute, "execute"));
        }
        if (rawExecute instanceof List) {
            List list = (List)rawExecute;
            ArrayList<ExecuteSpec> res = new ArrayList<ExecuteSpec>();
            for (int i = 0; i < list.size(); ++i) {
                Object listObj = list.get(i);
                if (listObj instanceof String) {
                    res.add(new ExecuteSpec(new FileSource(FileSource.SourceType.BUNDLED, (String)listObj, (String)listObj), null, null, null, false, null, null));
                    continue;
                }
                if (listObj instanceof Map) {
                    res.add(this.mapToExecuteSpec((Map)listObj, "execute[" + i + "]"));
                    continue;
                }
                throw new ExperimentSpecificationParseException("Experiment Specification execute list must not have item of type \"" + listObj.getClass().getName() + "\" (at index " + i + "))");
            }
            return res;
        }
        throw new ExperimentSpecificationParseException("Experiment Specification execute must not be of type \"" + rawExecute.getClass().getName() + "\")");
    }

    @Nonnull
    private List<ExperimentInfoOutputSpec> extractExperimentInfoOutputs(@Nullable Object rawOutputs) throws ExperimentSpecificationParseException {
        if (rawOutputs == null) {
            return Collections.emptyList();
        }
        if (rawOutputs instanceof Map) {
            return Collections.singletonList(this.mapToOutputSpec((Map)rawOutputs, "output"));
        }
        if (rawOutputs instanceof List) {
            List list = (List)rawOutputs;
            ArrayList<ExperimentInfoOutputSpec> res = new ArrayList<ExperimentInfoOutputSpec>();
            for (int i = 0; i < list.size(); ++i) {
                Object listObj = list.get(i);
                if (!(listObj instanceof Map)) {
                    throw new ExperimentSpecificationParseException("Experiment Specification output list must not have item of type \"" + listObj.getClass().getName() + "\" (at index " + i + "))");
                }
                res.add(this.mapToOutputSpec((Map)listObj, "output[" + i + "]"));
            }
            return res;
        }
        throw new ExperimentSpecificationParseException("Experiment Specification output must not be of type \"" + rawOutputs.getClass().getName() + "\")");
    }

    @Nullable
    private AnsibleSpec extractAnsibleSpec(@Nullable Object rawAnsible) throws ExperimentSpecificationParseException {
        if (rawAnsible == null) {
            return null;
        }
        if (rawAnsible instanceof String) {
            return this.ansiblePlaybooksToAnsibleSpec(Collections.singletonList(this.stringToAnsiblePlaybookSpec((String)rawAnsible, "ansible")));
        }
        if (rawAnsible instanceof Map) {
            return this.mapToAnsibleSpec((Map)rawAnsible);
        }
        if (rawAnsible instanceof List) {
            List list = (List)rawAnsible;
            List<AnsiblePlaybookSpec> res = this.listToAnsiblePlaybookSpecList(list, "ansible");
            return this.ansiblePlaybooksToAnsibleSpec(res);
        }
        throw new ExperimentSpecificationParseException("Experiment Specification execute must not be of type \"" + rawAnsible.getClass().getName() + "\")");
    }

    @Nonnull
    private DirSpec mapToDirSpec(@Nonnull Map in, @Nonnull String location) throws ExperimentSpecificationParseException {
        this.checkAllowedKeys(location, in, "path", "content", "permission", "nodes");
        String path = this.extractOptionalStringByKey(in, "path", location);
        String content = this.extractOptionalStringByKey(in, "content", location);
        String permissions = this.extractOptionalStringByKey(in, "permission", location);
        List<String> nodes = this.objectToNullableStringList(in.get("nodes"), location + ".nodes");
        return new DirSpec(ExperimentSpecificationParser.makeValidDirPath(path), content, permissions, nodes);
    }

    @Nonnull
    private List<UploadSpec> mapToUploadSpecs(@Nonnull Map in, @Nonnull String location) throws ExperimentSpecificationParseException {
        FileSource source = this.mapToFileSource(in, location, true);
        if (source.getType() == FileSource.SourceType.GIT || source.getType() == FileSource.SourceType.GITHUB) {
            this.checkAllowedKeysWithFileSource(location, in, "path", "permission", "nodes", "url", "dir", "file", "branch", "username", "password", "privateKey");
        } else {
            this.checkAllowedKeysWithFileSource(location, in, "path", "permission", "nodes");
        }
        String path = this.extractOptionalStringByKey(in, "path", location);
        String permissions = this.extractOptionalStringByKey(in, "permission", location);
        List<String> nodes = this.objectToNullableStringList(in.get("nodes"), location + ".nodes");
        if (source.getType() == FileSource.SourceType.GENERATED && source.isGeneratedKeyPair()) {
            if (path == null) {
                if (ESpecConstants.isKeyPair(source.getValue()) || ESpecConstants.isPrivateKey(source.getValue())) {
                    path = "~/.ssh/id_rsa";
                }
                if (ESpecConstants.isPublicKey(source.getValue())) {
                    path = "~/.ssh/id_rsa.pub";
                }
            }
            if (permissions == null) {
                permissions = "600";
            }
            if (ESpecConstants.isKeyPair(source.getValue())) {
                FileSource privateSource = new FileSource(FileSource.SourceType.GENERATED, "keypair.private", "~/.ssh/id_rsa");
                FileSource publicSource = new FileSource(FileSource.SourceType.GENERATED, "keypair.public", "~/.ssh/id_rsa.pub");
                return Arrays.asList(new UploadSpec(privateSource, path, permissions, nodes), new UploadSpec(publicSource, path + ".pub", permissions, nodes));
            }
        }
        return Collections.singletonList(new UploadSpec(source, path, permissions, nodes));
    }

    @Nonnull
    private AnsibleSpec mapToAnsibleSpec(@Nonnull Map in) throws ExperimentSpecificationParseException {
        Map<String, List<String>> groups;
        List<AnsibleGalaxySpec> ansibleGalaxySpecs;
        List<AnsiblePlaybookSpec> ansiblePlaybookSpecs;
        AnsibleHostSpec hostSpec;
        this.checkAllowedKeys("ansible", in, "host", "playbook", "galaxy", "group");
        Object rawHost = in.get("host");
        Object rawPlaybook = in.get("playbook");
        if (rawHost == null) {
            if (rawPlaybook == null) {
                throw new ExperimentSpecificationParseException("Experiment Specification does not allow empty ansible.host and ansible.playbook at the same time");
            }
            hostSpec = new AnsibleHostSpec(AnsibleHostSpec.HostType.ADD, "ansible", this.ensureKeyPairInAnsibleUploads(null), null, null, null, null, null);
        } else if (rawHost instanceof String) {
            AnsibleHostSpec.HostType ht = AnsibleHostSpec.HostType.valueOf(this.extractMandatoryStringByKey(in, "type", "ansible.host").toUpperCase());
            hostSpec = new AnsibleHostSpec(ht, "ansible", this.ensureKeyPairInAnsibleUploads(null), null, null, null, null, null);
        } else if (rawHost instanceof Map) {
            Map hostMap = (Map)rawHost;
            this.checkAllowedKeys("ansible.host", hostMap, "type", "name", "playbook-command", "galaxy-command", "upload", "execute");
            AnsibleHostSpec.HostType ht = AnsibleHostSpec.HostType.valueOf(this.extractOptionalStringByKey(hostMap, "type", "ansible.host", "ADD").toUpperCase());
            String nodeName = this.extractOptionalStringByKey(hostMap, "name", "ansible.host");
            String galaxyCommand = this.extractOptionalStringByKey(hostMap, "galaxy-command", "ansible.host");
            String galaxyInstallTemplate = this.extractOptionalStringByKey(hostMap, "galaxy-install-template", "ansible.host");
            String playbookCommand = this.extractOptionalStringByKey(hostMap, "playbook-command", "ansible.host");
            String playbookRunTemplate = this.extractOptionalStringByKey(hostMap, "playbook-run-template", "ansible.host");
            List<UploadSpec> uploadSpecs = hostMap.containsKey("upload") ? this.extractUploadSpecs(hostMap.get("upload")) : null;
            List<ExecuteSpec> executeSpecs = hostMap.containsKey("execute") ? this.extractExecuteSpecs(hostMap.get("execute")) : null;
            hostSpec = new AnsibleHostSpec(ht, nodeName == null ? "ansible" : nodeName, this.ensureKeyPairInAnsibleUploads(uploadSpecs), executeSpecs, galaxyCommand, galaxyInstallTemplate, playbookCommand, playbookRunTemplate);
        } else {
            throw new ExperimentSpecificationParseException("Experiment Specification does not expect type \"" + rawHost.getClass().getName() + "\" at ansible.host");
        }
        if (rawPlaybook == null) {
            ansiblePlaybookSpecs = Collections.emptyList();
        } else if (rawPlaybook instanceof Map) {
            ansiblePlaybookSpecs = Collections.singletonList(this.mapToAnsiblePlaybookSpec((Map)rawPlaybook, "ansible"));
        } else if (rawPlaybook instanceof List) {
            ansiblePlaybookSpecs = this.listToAnsiblePlaybookSpecList((List)rawPlaybook, "ansible");
        } else if (rawPlaybook instanceof String) {
            ansiblePlaybookSpecs = Collections.singletonList(this.stringToAnsiblePlaybookSpec((String)rawPlaybook, "ansible"));
        } else {
            throw new ExperimentSpecificationParseException("Experiment Specification does not allow ansible.playbook of type " + rawPlaybook.getClass().getName());
        }
        Object rawGalaxy = in.get("galaxy");
        if (rawGalaxy == null) {
            ansibleGalaxySpecs = Collections.emptyList();
        } else if (rawGalaxy instanceof List) {
            ansibleGalaxySpecs = this.listToAnsibleGalaxySpecList((List)rawGalaxy, "ansible");
        } else if (rawGalaxy instanceof String) {
            ansibleGalaxySpecs = Collections.singletonList(this.stringToAnsibleGalaxySpec((String)rawGalaxy, "ansible"));
        } else {
            throw new ExperimentSpecificationParseException("Experiment Specification does not allow ansible.playbook of type " + rawGalaxy.getClass().getName());
        }
        Object rawGroups = in.get("group");
        if (rawGroups != null) {
            if (!(rawGroups instanceof Map)) {
                throw new ExperimentSpecificationParseException("ansible.group should not be of type " + rawGroups.getClass().getName());
            }
            groups = this.checkGroups((Map)rawGroups);
        } else {
            groups = null;
        }
        return new AnsibleSpec(hostSpec, ansibleGalaxySpecs, ansiblePlaybookSpecs, groups);
    }

    private Map<String, List<String>> checkGroups(Map<?, ?> groups) throws ExperimentSpecificationParseException {
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        for (Map.Entry<?, ?> e : groups.entrySet()) {
            Object key = e.getKey();
            Object val = e.getValue();
            if (!(key instanceof String)) {
                throw new ExperimentSpecificationParseException("ansible.group contains an entry with a non String key (" + key.getClass().getName() + ")");
            }
            if (!(val instanceof List) && !(val instanceof String)) {
                throw new ExperimentSpecificationParseException("ansible.group contains an entry with a non String key (" + key.getClass().getName() + ")");
            }
            if (val instanceof List) {
                List nodeList = (List)val;
                for (Object nodeClientId : nodeList) {
                    if (nodeClientId instanceof String) continue;
                    throw new ExperimentSpecificationParseException("ansible.group[" + key + "] contains a list with a non String entry (" + key.getClass().getName() + ")");
                }
                res.put((String)key, nodeList);
                continue;
            }
            String nodeClientId = (String)val;
            res.put((String)key, Collections.singletonList(nodeClientId));
        }
        return res;
    }

    private List<UploadSpec> ensureKeyPairInAnsibleUploads(@Nullable List<UploadSpec> orig) {
        return orig;
    }

    private List<ExecuteSpec> addAnsibleInstallInAnsibleExecuteIfNeeded(@Nullable List<ExecuteSpec> orig) {
        ArrayList<Object> used = new ArrayList();
        used = orig != null ? new ArrayList<ExecuteSpec>(orig) : new ArrayList();
        if (orig == null || orig.isEmpty() || orig.size() != used.size()) {
            used.add(new ExecuteSpec(new FileSource(FileSource.SourceType.DOWNLOAD, "https://raw.githubusercontent.com/imec-ilabt/ansible-init-script/master/install-ansible.sh", "install-ansible.sh"), null, null, "u=rx", true, null, null));
        }
        return used;
    }

    @Nonnull
    private AnsibleSpec ansiblePlaybooksToAnsibleSpec(@Nonnull List<AnsiblePlaybookSpec> in) throws ExperimentSpecificationParseException {
        return new AnsibleSpec(new AnsibleHostSpec(AnsibleHostSpec.HostType.ADD, "ansible", this.ensureKeyPairInAnsibleUploads(null), null, null, null, null, null), null, in, null);
    }

    @Nonnull
    private List<AnsiblePlaybookSpec> listToAnsiblePlaybookSpecList(@Nonnull List in, @Nonnull String location) throws ExperimentSpecificationParseException {
        ArrayList<AnsiblePlaybookSpec> res = new ArrayList<AnsiblePlaybookSpec>();
        for (int i = 0; i < in.size(); ++i) {
            Object listObj = in.get(i);
            if (listObj instanceof String) {
                res.add(this.stringToAnsiblePlaybookSpec((String)listObj, location + "[" + i + "]"));
                continue;
            }
            if (listObj instanceof Map) {
                res.add(this.mapToAnsiblePlaybookSpec((Map)listObj, location + "[" + i + "]"));
                continue;
            }
            throw new ExperimentSpecificationParseException("Experiment Specification execute list must not have item of type \"" + listObj.getClass().getName() + "\" (" + location + " at index " + i + "))");
        }
        return res;
    }

    @Nonnull
    private AnsiblePlaybookSpec stringToAnsiblePlaybookSpec(@Nonnull String in, @Nonnull String location) throws ExperimentSpecificationParseException {
        return new AnsiblePlaybookSpec(new FileSource(FileSource.SourceType.BUNDLED, in, in), null, null, 0, null);
    }

    @Nonnull
    private List<AnsibleGalaxySpec> listToAnsibleGalaxySpecList(@Nonnull List in, @Nonnull String location) throws ExperimentSpecificationParseException {
        ArrayList<AnsibleGalaxySpec> res = new ArrayList<AnsibleGalaxySpec>();
        for (int i = 0; i < in.size(); ++i) {
            Object listObj = in.get(i);
            if (listObj instanceof String) {
                res.add(this.stringToAnsibleGalaxySpec((String)listObj, location + "[" + i + "]"));
                continue;
            }
            if (listObj instanceof Map) {
                res.add(this.mapToAnsibleGalaxySpec((Map)listObj, location + "[" + i + "]"));
                continue;
            }
            throw new ExperimentSpecificationParseException("Experiment Specification execute list must not have item of type \"" + listObj.getClass().getName() + "\" (" + location + " at index " + i + "))");
        }
        return res;
    }

    @Nonnull
    private AnsibleGalaxySpec stringToAnsibleGalaxySpec(@Nonnull String in, @Nonnull String location) throws ExperimentSpecificationParseException {
        return new AnsibleGalaxySpec(new FileSource(FileSource.SourceType.BUNDLED, in, in), null, null, null);
    }

    @Nonnull
    private AnsiblePlaybookSpec mapToAnsiblePlaybookSpec(@Nonnull Map in, @Nonnull String location) throws ExperimentSpecificationParseException {
        this.checkAllowedKeysWithFileSource(location, in, "path", "permission", "debug", "log", "extra-vars", "extra-vars-from");
        FileSource source = this.mapToFileSource(in, location, false);
        String path = this.extractOptionalStringByKey(in, "path", location);
        this.checkRequirePathOrSource(source, path, location);
        String permissions = this.extractOptionalStringByKey(in, "permission", location);
        int debug = this.extractOptionalBoundedIntByKey(in, "debug", 0, 0, 3, location);
        String log = this.extractOptionalStringByKey(in, "log", location);
        Object extraVars = in.get("extra-vars");
        Object extraVarsFrom = in.get("extra-vars-from");
        if (extraVars != null && extraVarsFrom != null) {
            throw new ExperimentSpecificationParseException("extra-vars and extra-vars-from may not be used together at " + location);
        }
        if (extraVars == null && extraVarsFrom == null) {
            return new AnsiblePlaybookSpec(source, path, permissions, debug, log);
        }
        if (extraVars != null) {
            if (extraVars instanceof Map) {
                return new AnsiblePlaybookSpec(source, path, permissions, (Integer)debug, log, (Map)extraVars);
            }
            if (extraVars instanceof String) {
                return new AnsiblePlaybookSpec(source, path, permissions, (Integer)debug, log, (String)extraVars);
            }
            throw new ExperimentSpecificationParseException("extra-vars should not be of type " + extraVars.getClass().getName() + " at " + location);
        }
        String extraVarsFromPath = this.extractOptionalStringByKey(in, "path", location);
        String extraVarsFromPermissions = this.extractOptionalStringByKey(in, "permission", location);
        if (extraVarsFrom instanceof Map) {
            return new AnsiblePlaybookSpec(source, path, permissions, (Integer)debug, log, new AnsiblePlaybookSpec.ExtraVarsJsonFileSpec(this.mapToFileSource((Map)extraVarsFrom, location, true), extraVarsFromPath, extraVarsFromPermissions, null));
        }
        if (extraVarsFrom instanceof String) {
            return new AnsiblePlaybookSpec(source, path, permissions, (Integer)debug, log, new AnsiblePlaybookSpec.ExtraVarsJsonFileSpec(new FileSource(FileSource.SourceType.BUNDLED, (String)extraVarsFrom, (String)extraVarsFrom), extraVarsFromPath, extraVarsFromPermissions, null));
        }
        throw new ExperimentSpecificationParseException("extra-vars-from should not be of type " + extraVarsFrom.getClass().getName() + " at " + location);
    }

    private void checkRequirePathOrSource(@Nullable FileSource source, @Nullable String path, @Nonnull String location) throws ExperimentSpecificationParseException {
        if (source == null && path == null) {
            throw new ExperimentSpecificationParseException("at " + location + " either a path or a source (or both) is required.");
        }
    }

    @Nonnull
    private AnsibleGalaxySpec mapToAnsibleGalaxySpec(@Nonnull Map in, @Nonnull String location) throws ExperimentSpecificationParseException {
        this.checkAllowedKeysWithFileSource(location, in, "path", "permission", "log");
        FileSource source = this.mapToFileSource(in, location, false);
        String path = this.extractOptionalStringByKey(in, "path", location);
        this.checkRequirePathOrSource(source, path, location);
        String permissions = this.extractOptionalStringByKey(in, "permission", location);
        String log = this.extractOptionalStringByKey(in, "log", location);
        return new AnsibleGalaxySpec(source, path, permissions, log);
    }

    @Nonnull
    private ExecuteSpec mapToExecuteSpec(@Nonnull Map in, @Nonnull String location) throws ExperimentSpecificationParseException {
        this.checkAllowedKeysWithFileSource(location, in, "path", "permission", "pwd", "nodes", "sudo", "log");
        FileSource source = this.mapToFileSource(in, location, false);
        String path = this.extractOptionalStringByKey(in, "path", location);
        this.checkRequirePathOrSource(source, path, location);
        String pwd = this.extractOptionalStringByKey(in, "pwd", location);
        String permissions = this.extractOptionalStringByKey(in, "permission", location);
        String log = this.extractOptionalStringByKey(in, "log", location);
        boolean sudo = this.extractOptionalBooleanByKey(in, "sudo", false, location);
        List<String> nodes = this.objectToNullableStringList(in.get("nodes"), location + ".nodes");
        return new ExecuteSpec(source, path, pwd, permissions, sudo, log, nodes);
    }

    @Nonnull
    private ExperimentInfoOutputSpec mapToOutputSpec(@Nonnull Map in, @Nonnull String location) throws ExperimentSpecificationParseException {
        ExperimentInfoOutputSpec.ExperimentInfoOutputDestination destination;
        this.checkAllowedKeys(location, in, "type", "destination");
        ExperimentInfoOutputSpec.ExperimentInfoOutputType type = ExperimentInfoOutputSpec.ExperimentInfoOutputType.valueOf(this.extractMandatoryStringByKey(in, "type", location + ".output").toUpperCase());
        String dest = this.extractMandatoryStringByKey(in, "destination", location);
        String destinationDetail = null;
        if (dest.equals("LOG_DEBUG") || dest.equals("DEBUG")) {
            destination = ExperimentInfoOutputSpec.ExperimentInfoOutputDestination.LOG_DEBUG;
        } else if (dest.equals("LOG_INFO") || dest.equals("INFO")) {
            destination = ExperimentInfoOutputSpec.ExperimentInfoOutputDestination.LOG_INFO;
        } else {
            destination = ExperimentInfoOutputSpec.ExperimentInfoOutputDestination.LOCAL_FILE;
            destinationDetail = dest;
        }
        return new ExperimentInfoOutputSpec(type, destination, destinationDetail);
    }

    @Nullable
    @Contract(value="null,_ -> null; !null,_ -> !null")
    private List<String> objectToNullableStringList(@Nullable Object in, @Nonnull String location) throws ExperimentSpecificationParseException {
        if (in == null) {
            return null;
        }
        if (in instanceof String) {
            return Collections.singletonList((String)in);
        }
        if (in instanceof List) {
            List list = (List)in;
            ArrayList<String> res = new ArrayList<String>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                Object listItemObj = list.get(i);
                if (!(listItemObj instanceof String)) {
                    throw new ExperimentSpecificationParseException("Experiment Specification expect type String instead of \"" + in.getClass().getName() + "\" at " + location + "[" + i + "]");
                }
                res.add((String)listItemObj);
            }
            return res;
        }
        throw new ExperimentSpecificationParseException("Experiment Specification did not expect type \"" + in.getClass().getName() + "\" at " + location);
    }

    @Nullable
    @Contract(value="_,_,_,!null -> !null")
    private String extractOptionalStringByKey(@Nonnull Map m, @Nonnull String key, @Nonnull String location, @Nullable String defaultVal) throws ExperimentSpecificationParseException {
        String res = this.extractOptionalStringByKey(m, key, location);
        if (res == null) {
            return defaultVal;
        }
        return res;
    }

    @Nullable
    private String extractOptionalStringByKey(@Nonnull Map m, @Nonnull String key, @Nonnull String location) throws ExperimentSpecificationParseException {
        Object in = m.get(key);
        if (in == null) {
            return null;
        }
        if (in instanceof String) {
            return (String)in;
        }
        throw new ExperimentSpecificationParseException("Experiment Specification did not expect type \"" + in.getClass().getName() + "\" at " + location + "." + key);
    }

    private boolean extractOptionalBooleanByKey(@Nonnull Map m, @Nonnull String key, boolean defaultVal, @Nonnull String location) throws ExperimentSpecificationParseException {
        Object in = m.get(key);
        if (in == null) {
            return defaultVal;
        }
        if (in instanceof Boolean) {
            return (Boolean)in;
        }
        if (in instanceof String) {
            Boolean parsed = TextUtil.objectToBoolean(in);
            if (parsed != null) {
                return parsed;
            }
            throw new ExperimentSpecificationParseException("Experiment Specification did not expect type \"" + in.getClass().getName() + "\" at " + location + "." + key);
        }
        throw new ExperimentSpecificationParseException("Experiment Specification did not expect type \"" + in.getClass().getName() + "\" at " + location + "." + key);
    }

    private int extractOptionalBoundedIntByKey(@Nonnull Map m, @Nonnull String key, int defaultVal, int minVal, int maxVal, @Nonnull String location) throws ExperimentSpecificationParseException {
        int res;
        Object in = m.get(key);
        if (in == null) {
            return defaultVal;
        }
        if (in instanceof Number) {
            res = ((Number)in).intValue();
        } else if (in instanceof String) {
            try {
                res = Integer.parseInt((String)in);
            }
            catch (NumberFormatException e) {
                throw new ExperimentSpecificationParseException("Experiment Specification did not expect String \"" + in + "\" at " + location + "." + key);
            }
        } else {
            throw new ExperimentSpecificationParseException("Experiment Specification did not expect type \"" + in.getClass().getName() + "\" at " + location + "." + key);
        }
        if (res < minVal || res > maxVal) {
            throw new ExperimentSpecificationParseException("Experiment Specification got  " + res + " but expected a value between " + minVal + " and " + maxVal + " at " + location + "." + key);
        }
        return res;
    }

    @Nonnull
    private String extractMandatoryStringByKey(@Nonnull Map m, @Nonnull String key, @Nonnull String location) throws ExperimentSpecificationParseException {
        Object in = m.get(key);
        if (in == null) {
            throw new ExperimentSpecificationParseException("Experiment Specification expected key \"" + key + "\" at " + location);
        }
        if (in instanceof String) {
            return (String)in;
        }
        throw new ExperimentSpecificationParseException("Experiment Specification did not expect type \"" + in.getClass().getName() + "\" at " + location + "." + key);
    }

    private long extractMandatoryLongByKey(@Nonnull Map m, @Nonnull String key, @Nonnull String location) throws ExperimentSpecificationParseException {
        Object in = m.get(key);
        if (in == null) {
            throw new ExperimentSpecificationParseException("Experiment Specification expected key \"" + key + "\" at " + location);
        }
        if (in instanceof Integer) {
            return ((Integer)in).longValue();
        }
        if (in instanceof Long) {
            return (Long)in;
        }
        throw new ExperimentSpecificationParseException("Experiment Specification did not expect type \"" + in.getClass().getName() + "\" at " + location + "." + key);
    }

    private int extractMandatoryIntByKey(@Nonnull Map m, @Nonnull String key, @Nonnull String location) throws ExperimentSpecificationParseException {
        Object in = m.get(key);
        if (in == null) {
            throw new ExperimentSpecificationParseException("Experiment Specification expected key \"" + key + "\" at " + location);
        }
        if (in instanceof Integer) {
            return (Integer)in;
        }
        if (in instanceof Long) {
            return ((Long)in).intValue();
        }
        throw new ExperimentSpecificationParseException("Experiment Specification did not expect type \"" + in.getClass().getName() + "\" at " + location + "." + key);
    }

    @Nullable
    @Contract(value="null,_ -> null; !null,_ -> !null")
    private String objectToString(@Nullable Object in, @Nonnull String location) throws ExperimentSpecificationParseException {
        if (in == null) {
            return null;
        }
        if (in instanceof String) {
            return (String)in;
        }
        throw new ExperimentSpecificationParseException("Experiment Specification did not expect type \"" + in.getClass().getName() + "\" at " + location);
    }

    @Nonnull
    private RspecSpec extractRspecSpec(@Nullable Object rawRspec) throws ExperimentSpecificationParseException {
        if (rawRspec == null) {
            throw new ExperimentSpecificationParseException("Experiment Specification must contain rspec");
        }
        if (rawRspec instanceof String) {
            return new RspecSpec(new FileSource(FileSource.SourceType.BUNDLED, (String)rawRspec, (String)rawRspec));
        }
        if (rawRspec instanceof Map) {
            return this.mapToRspecSpec((Map)rawRspec, "rspec");
        }
        if (rawRspec instanceof List) {
            List rspecList = (List)rawRspec;
            if (rspecList.size() != 1) {
                throw new ExperimentSpecificationParseException("Experiment Specification rspec must not be list of size 1, not of size " + rspecList.size());
            }
            Object listObj = rspecList.get(0);
            if (listObj instanceof String) {
                return new RspecSpec(new FileSource(FileSource.SourceType.BUNDLED, (String)listObj, (String)listObj));
            }
            if (listObj instanceof Map) {
                return this.mapToRspecSpec((Map)listObj, "rspec");
            }
            throw new ExperimentSpecificationParseException("Experiment Specification rspec list must not have item of type \"" + listObj.getClass().getName() + "\")");
        }
        throw new ExperimentSpecificationParseException("Experiment Specification rspec must not be of type \"" + rawRspec.getClass().getName() + "\")");
    }

    @Nonnull
    private RspecSpec mapToRspecSpec(@Nonnull Map in, String location) throws ExperimentSpecificationParseException {
        if (in.containsKey("path")) {
            throw new ExperimentSpecificationParseException("Experiment Specification rspec must not contain \"path\"");
        }
        this.checkAllowedKeysWithFileSource("rspec", in, new String[0]);
        return new RspecSpec(this.mapToFileSource(in, "rspec", true));
    }

    @Nullable
    @Contract(value="_,_,true->!null")
    private FileSource mapToFileSource(@Nonnull Map in, String location, boolean required) throws ExperimentSpecificationParseException {
        FileSource res = null;
        for (FileSource.SourceType sourceType : FileSource.SourceType.values()) {
            String key = sourceType.name().toLowerCase();
            Object val = in.get(key);
            if (val == null) continue;
            if (res != null) {
                throw new ExperimentSpecificationParseException("There are multiple file sources at " + location + " (at least " + key + " and " + res.getType().name().toLowerCase() + ")");
            }
            if (val instanceof String) {
                if (sourceType == FileSource.SourceType.GENERATED) {
                    if (ESpecConstants.isKeyPair((String)val)) {
                        res = new FileSource(sourceType, (String)val, "id_rsa");
                        continue;
                    }
                    if (ESpecConstants.isRandom((String)val)) {
                        throw new RuntimeException("generated: random requires an object as argument with fields 'method', 'format' and 'length'");
                    }
                    throw new ExperimentSpecificationParseException("Illegal GENERATED entry: " + key + ": " + val + "  at " + location);
                }
                if (sourceType == FileSource.SourceType.META && !ESpecConstants.isMetaValue((String)val)) {
                    throw new ExperimentSpecificationParseException("Illegal META entry: " + key + ": " + val + "  at " + location);
                }
                if (sourceType == FileSource.SourceType.GIT || sourceType == FileSource.SourceType.GITHUB) {
                    String gitUrl = (String)val;
                    res = this.extractGitFileSource(gitUrl, in, key, location);
                    continue;
                }
                res = new FileSource(sourceType, (String)val, this.getFileSourceBasename(sourceType, (String)val, location, in));
                continue;
            }
            if (val instanceof Map) {
                if (sourceType == FileSource.SourceType.GENERATED) {
                    Map subMap = (Map)val;
                    String method = this.extractMandatoryStringByKey(subMap, "method", location + "." + key);
                    if (ESpecConstants.isKeyPair(method)) {
                        res = new FileSource(sourceType, method, "id_rsa");
                        continue;
                    }
                    if (ESpecConstants.isRandom(method)) {
                        String format = this.extractMandatoryStringByKey(subMap, "format", location + "." + key);
                        String basename = ESpecConstants.isRandomFormat(format, "binary") ? "random.dat" : "random.txt";
                        res = new GeneratedRandomFileSource(sourceType, method, basename, format, this.extractMandatoryIntByKey(subMap, "length", location + "." + key), location);
                        continue;
                    }
                    if (ESpecConstants.isGeneratedRSpec(method)) {
                        List<Object> resourceClasses;
                        boolean multiAm;
                        List<Object> ams;
                        String basename = "generated_experiment.rspec";
                        Object amsObj = subMap.get("ams");
                        if (amsObj != null) {
                            if (amsObj instanceof String) {
                                String amsStr = (String)amsObj;
                                if (amsStr.trim().isEmpty()) {
                                    throw new ExperimentSpecificationParseException("Experiment Specification expected key \"ams\" to be a string (with space seperated entries), but it was an empty string at " + location + "." + key);
                                }
                                ams = Arrays.asList(amsStr.split(" "));
                            } else {
                                if (!(amsObj instanceof List)) {
                                    throw new ExperimentSpecificationParseException("Experiment Specification expected key \"ams\" to be a list of strings at " + location + "." + key);
                                }
                                ams = new ArrayList();
                                List amsL = (List)amsObj;
                                for (Object o : amsL) {
                                    if (o == null) continue;
                                    if (!(o instanceof String)) {
                                        throw new ExperimentSpecificationParseException("Experiment Specification found key \"ams\" which is a list containing a \"" + o.getClass().getName() + "\" at " + location + "." + key + "  (expected only strings in list)");
                                    }
                                    ams.add((String)o);
                                }
                            }
                            multiAm = true;
                        } else {
                            multiAm = false;
                            ams = null;
                        }
                        Object resourceClassesObj = subMap.get("resourceClasses");
                        if (resourceClassesObj != null) {
                            if (!multiAm) {
                                throw new ExperimentSpecificationParseException("Experiment Specification found key \"resourceClasses\" without key \"ams\" specified at " + location + "." + key);
                            }
                            if (resourceClassesObj instanceof String) {
                                String resourceClassesStr = (String)resourceClassesObj;
                                if (resourceClassesStr.trim().isEmpty()) {
                                    throw new ExperimentSpecificationParseException("Experiment Specification expected key \"resourceClasses\" to be a string (with space seperated entries), but it was an empty string at " + location + "." + key);
                                }
                                resourceClasses = Arrays.asList(resourceClassesStr.split(" "));
                            } else {
                                if (!(resourceClassesObj instanceof List)) {
                                    throw new ExperimentSpecificationParseException("Experiment Specification expected key \"resourceClasses\" to be a list of strings at " + location + "." + key);
                                }
                                resourceClasses = new ArrayList();
                                List resourceClassesL = (List)resourceClassesObj;
                                for (Object o : resourceClassesL) {
                                    if (o == null) continue;
                                    if (!(o instanceof String)) {
                                        throw new ExperimentSpecificationParseException("Experiment Specification found key \"resourceClasses\" which is a list containing a \"" + o.getClass().getName() + "\" at " + location + "." + key + "  (expected only strings in list)");
                                    }
                                    resourceClasses.add((String)o);
                                }
                            }
                        } else {
                            resourceClasses = null;
                        }
                        String nodeNamePrefix = this.extractOptionalStringByKey(subMap, "prefix", location + "." + key);
                        Object nodesObj = subMap.get("nodes");
                        List<String> nodeNames = null;
                        Integer nodeCount = null;
                        if (nodesObj != null) {
                            if (nodesObj instanceof Integer) {
                                nodeCount = (Integer)nodesObj;
                            } else if (nodesObj instanceof Long) {
                                nodeCount = ((Long)nodesObj).intValue();
                            } else if (nodesObj instanceof String) {
                                nodeNames = Collections.singletonList((String)nodesObj);
                            } else if (nodesObj instanceof List) {
                                List tmp = (List)nodesObj;
                                nodeNames = new ArrayList<String>(tmp.size());
                                for (Object o : tmp) {
                                    if (o == null) continue;
                                    if (!(o instanceof String)) {
                                        throw new ExperimentSpecificationParseException("Experiment Specification found key \"nodes\" which is a list containing a \"" + o.getClass().getName() + "\" at " + location + "." + key + "  (expected only strings in list)");
                                    }
                                    nodeNames.add((String)o);
                                }
                            } else {
                                throw new ExperimentSpecificationParseException("Experiment Specification found key \"nodes\" with unexpected type \"" + nodesObj.getClass().getName() + "\" at " + location + "." + key + "  (expected integer, string or list of strings)");
                            }
                            if (nodeNames == null && multiAm && ams.size() != nodeCount.intValue()) {
                                throw new ExperimentSpecificationParseException("Experiment Specification found key \"nodes\" which is the number " + nodeCount + " but this does not match the " + ams.size() + " ams specified at " + location + "." + key);
                            }
                            if (nodeNames != null && multiAm && ams.size() != nodeNames.size()) {
                                throw new ExperimentSpecificationParseException("Experiment Specification found key \"nodes\" which contains " + nodeNames.size() + " node names but this does not match the " + ams.size() + " ams specified at " + location + "." + key);
                            }
                        } else if (!multiAm) {
                            throw new ExperimentSpecificationParseException("Experiment Specification expected key \"nodes\" at " + location + "." + key);
                        }
                        if (multiAm) {
                            if (ams.size() <= 1 || ams.size() > 10) {
                                throw new ExperimentSpecificationParseException("Experiment Specification at " + location + "." + key + ".\"ams\" has in invalid AM count (min 2, max 9) (=" + ams.size() + ")");
                            }
                            if (resourceClasses != null && resourceClasses.size() != ams.size()) {
                                throw new ExperimentSpecificationParseException("Experiment Specification at " + location + "." + key + ".\"ams\" has mismatch: AM count (=" + ams.size() + ") != resourceClasses count (=" + resourceClasses.size() + ").They need to match, or resourceClasses needs to be omitted.");
                            }
                            res = new GeneratedStitchingTestRSpecFileSource(sourceType, method, basename, ams, resourceClasses, nodeNamePrefix, nodeNames);
                            continue;
                        }
                        assert (nodesObj != null);
                        if (nodeCount == null) {
                            assert (nodeNames != null);
                            nodeCount = nodeNames.size();
                        }
                        if (nodeCount <= 0 || nodeCount > 1000) {
                            throw new ExperimentSpecificationParseException("Experiment Specification at " + location + "." + key + ".\"nodes\" has in invalid node count (=" + nodeCount + ")");
                        }
                        String am = this.extractMandatoryStringByKey(subMap, "am", location + "." + key);
                        String resourceClass = this.extractOptionalStringByKey(subMap, "icon", location + "." + key);
                        String diskImage = this.extractOptionalStringByKey(subMap, "diskImage", location + "." + key);
                        Boolean link = this.extractOptionalBooleanByKey(subMap, "link", false, location + "." + key);
                        String linkSubnet = this.extractOptionalStringByKey(subMap, "linkSubnet", location + "." + key);
                        Integer linkStartIp = this.extractOptionalBoundedIntByKey(subMap, "linkStartIp", 1, 1, 254, location + "." + key);
                        res = new GeneratedRSpecFileSource(sourceType, method, basename, am, resourceClass, nodeCount, nodeNamePrefix, nodeNames, diskImage, link, linkSubnet, linkStartIp);
                        continue;
                    }
                    throw new ExperimentSpecificationParseException("Illegal GENERATED entry: " + key + ": val of type object = " + val);
                }
                if (sourceType == FileSource.SourceType.GIT || sourceType == FileSource.SourceType.GITHUB) {
                    res = this.extractGitFileSource(null, (Map)val, key, location);
                    continue;
                }
                throw new ExperimentSpecificationParseException("Illegal non-GENERATED entry: " + key + ": val of type object = " + val);
            }
            throw new ExperimentSpecificationParseException("Illegal entry: " + key + ": " + val.getClass().getName());
        }
        if (res != null) {
            return res;
        }
        if (required) {
            throw new ExperimentSpecificationParseException("No \"source\" (bundled, direct, ...) found in " + location + " (did find: " + in.keySet().stream().collect(Collectors.joining(",")) + ")");
        }
        return null;
    }

    @Nonnull
    private GitFileSource extractGitFileSource(@Nullable String defaultUrl, @Nonnull Map srcMap, @Nonnull String key, @Nonnull String location) throws ExperimentSpecificationParseException {
        String basename;
        String gitUrl;
        boolean mandatoryUrl = defaultUrl == null;
        String string = gitUrl = mandatoryUrl ? this.extractMandatoryStringByKey(srcMap, "url", location + "." + key) : this.extractOptionalStringByKey(srcMap, "url", location + "." + key);
        if (gitUrl == null) {
            gitUrl = defaultUrl;
        }
        String dir = this.extractOptionalStringByKey(srcMap, "dir", location + "." + key);
        String branch = this.extractOptionalStringByKey(srcMap, "branch", location + "." + key);
        String username = this.extractOptionalStringByKey(srcMap, "username", location + "." + key);
        String password = this.extractOptionalStringByKey(srcMap, "password", location + "." + key);
        String privateKey = this.extractOptionalStringByKey(srcMap, "privateKey", location + "." + key);
        Object filename = this.extractOptionalStringByKey(srcMap, "file", location + "." + key);
        String string2 = basename = filename == null ? "git-repo" : ((String)filename).replaceAll(".*/", "");
        if (dir != null && filename != null) {
            filename = dir + (dir.endsWith("/") ? "" : "/") + (String)filename;
            dir = null;
        }
        if (username != null != (password != null)) {
            throw new ExperimentSpecificationParseException("Experiment Specification at " + location + "." + key + ".\"git\" has only 1 of \"username\" \"password\", while both or none are required.");
        }
        if (username != null && privateKey != null) {
            throw new ExperimentSpecificationParseException("Experiment Specification at " + location + "." + key + ".\"git\" has both username and password auth, and private SSH key auth.");
        }
        return new GitFileSource(gitUrl, dir, branch, username, password, privateKey, (String)filename);
    }

    @Nonnull
    private String getFileSourceBasename(@Nonnull FileSource.SourceType sourceType, @Nonnull String value, @Nonnull String location, @Nonnull Map in) throws ExperimentSpecificationParseException {
        switch (sourceType) {
            case BUNDLED: {
                return value;
            }
            case META: {
                return value;
            }
            case DIRECT: {
                Object path = in.get("path");
                if (path != null && path instanceof String) {
                    return (String)path;
                }
                return location + (location.contains("execute") ? ".sh" : ".txt");
            }
            case DOWNLOAD: {
                try {
                    return new URL(value).getFile();
                }
                catch (MalformedURLException e) {
                    throw new ExperimentSpecificationParseException("Invalid URL \"" + value + "\"", e);
                }
            }
            case GIT: {
                throw new RuntimeException("not yet supported");
            }
            case GITHUB: {
                throw new RuntimeException("not yet supported");
            }
        }
        throw new ExperimentSpecificationParseException("Unsupported SourceType: " + sourceType.name());
    }

    @Nonnull
    private static String ensureEndsWithSlash(@Nonnull String p) {
        if (p.endsWith("/")) {
            return p;
        }
        return p + "/";
    }

    @Nonnull
    private static String ensureStartsWithSlash(@Nonnull String p) {
        if (p.startsWith("/")) {
            return p;
        }
        return "/" + p;
    }

    private void checkAllowedKeysWithFileSource(@Nonnull String location, @Nonnull Map<String, Object> map, String ... allowedKeys) throws ExperimentSpecificationParseException {
        ArrayList<String> allKeys = new ArrayList<String>(Arrays.asList(allowedKeys));
        allKeys.addAll(Arrays.asList(FileSource.SourceType.values()).stream().map(Object::toString).map(String::toLowerCase).collect(Collectors.toList()));
        this.checkAllowedKeys(location, map, allKeys.toArray(new String[0]));
    }

    private void checkAllowedKeys(@Nonnull String location, @Nonnull Map<String, Object> map, String ... allowedKeys) throws ExperimentSpecificationParseException {
        HashSet<String> allowedKeysSet = new HashSet<String>(Arrays.asList(allowedKeys));
        HashSet<String> unknownKeys = new HashSet<String>(map.keySet());
        unknownKeys.removeAll(allowedKeysSet);
        if (!unknownKeys.isEmpty()) {
            if (unknownKeys.size() == 1) {
                throw new ExperimentSpecificationParseException("Unknown key " + location + "." + (String)unknownKeys.iterator().next());
            }
            throw new ExperimentSpecificationParseException("Unknown keys at " + location + ": " + unknownKeys.stream().collect(Collectors.joining(",")));
        }
    }

    public static class ExperimentSpecificationParseException
    extends Exception {
        public ExperimentSpecificationParseException() {
        }

        public ExperimentSpecificationParseException(String s) {
            super(s);
        }

        public ExperimentSpecificationParseException(String s, Throwable throwable) {
            super(s, throwable);
        }

        public ExperimentSpecificationParseException(Throwable throwable) {
            super(throwable);
        }

        public ExperimentSpecificationParseException(String s, Throwable throwable, boolean b, boolean b1) {
            super(s, throwable, b, b1);
        }
    }
}

