/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.espec.util;

import be.iminds.ilabt.jfed.espec.model.AnsiblePlaybookSpec;
import be.iminds.ilabt.jfed.espec.model.DirSpec;
import be.iminds.ilabt.jfed.espec.model.ExecuteSpec;
import be.iminds.ilabt.jfed.espec.model.FileSource;
import be.iminds.ilabt.jfed.espec.model.RspecSpec;
import be.iminds.ilabt.jfed.espec.model.UploadLikeSpec;
import be.iminds.ilabt.jfed.espec.util.ESpecLogListener;
import be.iminds.ilabt.jfed.espec.util.LimitedLiveLog;
import be.iminds.ilabt.jfed.espec.util.UploadProgressTracker;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESpecLogger {
    private static final Logger LOG = LoggerFactory.getLogger(ESpecLogger.class);
    private final List<ESpecLogListener> listeners = new CopyOnWriteArrayList<ESpecLogListener>();
    private final AtomicInteger exceptionCount = new AtomicInteger(0);
    @Nullable
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private static final AtomicLong idGenerator = new AtomicLong(0L);

    public ESpecLogger() {
        this.uncaughtExceptionHandler = Thread.currentThread().getUncaughtExceptionHandler();
    }

    public ESpecLogger(@Nullable Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    public void addESpecLogListener(@Nonnull ESpecLogListener listener) {
        this.listeners.add(listener);
    }

    public void removeESpecLogListener(@Nonnull ESpecLogListener listener) {
        this.listeners.remove(listener);
    }

    public void firePreFileLoad() {
        this.executeSafeForAllListeners(l -> l.onPreFileLoad());
    }

    public void firePostFileLoadSuccess(@Nonnull FileSource fileSource, boolean isFast, long byteSize) {
        this.executeSafeForAllListeners(l -> l.onPostFileLoad(fileSource, isFast, byteSize, new ESpecLogListener.ESpecStepStatus(ESpecLogListener.ESpecStepStatus.Status.SUCCESS)));
    }

    public void firePostFileLoadFail(@Nonnull FileSource fileSource, boolean isFast, long byteSize, @Nullable String message, @Nullable Throwable throwable) {
        this.executeSafeForAllListeners(l -> l.onPostFileLoad(fileSource, isFast, byteSize, new ESpecLogListener.ESpecStepStatus(ESpecLogListener.ESpecStepStatus.Status.FAILURE, message, throwable)));
    }

    public void firePostFileLoadAll(boolean success) {
        this.executeSafeForAllListeners(l -> l.onPostFileLoadAll(success));
    }

    public void firePreRSpec() {
        this.executeSafeForAllListeners(l -> l.onPreRSpec());
    }

    public void fireRequestRSpecKnown(@Nonnull RspecSpec rspecSpec, @Nonnull String requestRSpec) {
        this.executeSafeForAllListeners(l -> l.onRequestRSpecKnown(rspecSpec, requestRSpec));
    }

    public void firePostRSpecSuccess(@Nonnull RspecSpec rspec) {
        this.executeSafeForAllListeners(l -> l.onPostRSpec(rspec, new ESpecLogListener.ESpecStepStatus(ESpecLogListener.ESpecStepStatus.Status.SUCCESS)));
    }

    public void firePostRSpecFail(@Nonnull RspecSpec rspec, @Nullable String message, @Nullable Throwable throwable) {
        this.executeSafeForAllListeners(l -> l.onPostRSpec(rspec, new ESpecLogListener.ESpecStepStatus(ESpecLogListener.ESpecStepStatus.Status.FAILURE, message, throwable)));
    }

    public void firePostRspecAll(boolean success, @Nonnull List<String> allNodeClientIds) {
        this.executeSafeForAllListeners(l -> l.onPostRspecAll(success, allNodeClientIds));
    }

    public void firePreDir() {
        this.executeSafeForAllListeners(l -> l.onPreDir());
    }

    public void firePreDir(@Nonnull String nodeClientId) {
        this.executeSafeForAllListeners(l -> l.onPreDirNode(nodeClientId));
    }

    public void firePreDir(long logEventId, @Nonnull DirSpec dir, @Nonnull String fullPath, @Nonnull String nodeClientId) {
        this.executeSafeForAllListeners(l -> l.onPreDir(logEventId, dir, fullPath, nodeClientId));
    }

    public void firePostDirSuccess(long logEventId, @Nonnull DirSpec dir, @Nonnull String fullPath, @Nonnull String nodeClientId) {
        this.executeSafeForAllListeners(l -> l.onPostDir(logEventId, dir, fullPath, nodeClientId, new ESpecLogListener.ESpecStepStatus(ESpecLogListener.ESpecStepStatus.Status.SUCCESS)));
    }

    public void firePostDirFail(long logEventId, @Nonnull DirSpec dir, @Nonnull String fullPath, @Nonnull String nodeClientId, @Nullable String message, @Nullable Throwable throwable) {
        this.executeSafeForAllListeners(l -> l.onPostDir(logEventId, dir, fullPath, nodeClientId, new ESpecLogListener.ESpecStepStatus(ESpecLogListener.ESpecStepStatus.Status.FAILURE, message, throwable)));
    }

    public void firePostDirNode(@Nonnull String nodeClientId, boolean success) {
        this.executeSafeForAllListeners(l -> l.onPostDirNode(nodeClientId, success));
    }

    public void firePostDirAll(boolean success) {
        this.executeSafeForAllListeners(l -> l.onPostDirAll(success));
    }

    public void firePreUpload() {
        this.executeSafeForAllListeners(l -> l.onPreUpload());
    }

    public void firePreUpload(@Nonnull String nodeClientId) {
        this.executeSafeForAllListeners(l -> l.onPreUploadNode(nodeClientId));
    }

    public void firePreUpload(long logEventId, @Nonnull UploadLikeSpec uploadSpec, @Nonnull String fullPath, @Nonnull String nodeClientId, UploadProgressTracker uploadProgressTracker) {
        this.executeSafeForAllListeners(l -> l.onPreUpload(logEventId, uploadSpec, fullPath, nodeClientId, uploadProgressTracker));
    }

    public void firePostUploadSuccess(long logEventId, @Nonnull UploadLikeSpec uploadSpec, @Nonnull String fullPath, @Nonnull String nodeClientId) {
        this.executeSafeForAllListeners(l -> l.onPostUpload(logEventId, uploadSpec, fullPath, nodeClientId, new ESpecLogListener.ESpecStepStatus(ESpecLogListener.ESpecStepStatus.Status.SUCCESS)));
    }

    public void firePostUploadFail(long logEventId, @Nonnull UploadLikeSpec uploadSpec, @Nonnull String fullPath, @Nonnull String nodeClientId, @Nullable String message, @Nullable Throwable throwable) {
        this.executeSafeForAllListeners(l -> l.onPostUpload(logEventId, uploadSpec, fullPath, nodeClientId, new ESpecLogListener.ESpecStepStatus(ESpecLogListener.ESpecStepStatus.Status.FAILURE, message, throwable)));
    }

    public void firePostUploadNode(@Nonnull String nodeClientId, boolean success) {
        this.executeSafeForAllListeners(l -> l.onPostUploadNode(nodeClientId, success));
    }

    public void firePostUploadAll(boolean success) {
        this.executeSafeForAllListeners(l -> l.onPostUploadAll(success));
    }

    public void firePreExecute() {
        this.executeSafeForAllListeners(l -> l.onPreExecute());
    }

    public void firePreExecute(long logEventId, ExecuteSpec executeSpec, String fullPath, String fullLogPath, String nodeClientId, LimitedLiveLog currentLog) {
        this.executeSafeForAllListeners(l -> l.onPreExecute(logEventId, executeSpec, fullPath, fullLogPath, nodeClientId, currentLog));
    }

    public void firePostExecuteSuccess(long logEventId, @Nonnull ExecuteSpec executeSpec, @Nonnull String fullPath, @Nullable String fullLogPath, @Nonnull String nodeClientId, int exitStatus) {
        this.executeSafeForAllListeners(l -> l.onPostExecute(logEventId, executeSpec, fullPath, fullLogPath, nodeClientId, exitStatus, new ESpecLogListener.ESpecStepStatus(ESpecLogListener.ESpecStepStatus.Status.SUCCESS)));
    }

    public void firePostExecuteFail(long logEventId, @Nonnull ExecuteSpec executeSpec, @Nonnull String fullPath, @Nullable String fullLogPath, @Nonnull String nodeClientId, int exitStatus, @Nullable String message, @Nullable Throwable throwable) {
        this.executeSafeForAllListeners(l -> l.onPostExecute(logEventId, executeSpec, fullPath, fullLogPath, nodeClientId, exitStatus, new ESpecLogListener.ESpecStepStatus(ESpecLogListener.ESpecStepStatus.Status.FAILURE, message, throwable)));
    }

    public void firePostExecuteStepAll(@Nonnull ExecuteSpec executeSpec, boolean success) {
        this.executeSafeForAllListeners(l -> l.onPostExecuteStepAll(executeSpec, success));
    }

    public void firePostExecuteAll(boolean success) {
        this.executeSafeForAllListeners(l -> l.onPostExecuteAll(success));
    }

    public void firePreAnsible() {
        this.executeSafeForAllListeners(l -> l.onPreAnsible());
    }

    public void firePreAnsiblePlaybook(long logEventId, @Nonnull AnsiblePlaybookSpec ansiblePlaybookSpec, @Nonnull String fullPath, @Nullable String fullLogPath, @Nonnull String nodeClientId, @Nonnull LimitedLiveLog limitedLiveLog) {
        this.executeSafeForAllListeners(l -> l.onPreAnsiblePlaybook(logEventId, ansiblePlaybookSpec, fullPath, fullLogPath, nodeClientId, limitedLiveLog));
    }

    public void firePostAnsiblePlaybookSuccess(long logEventId, @Nonnull AnsiblePlaybookSpec ansiblePlaybookSpec, @Nonnull String fullPath, @Nullable String fullLogPath, @Nonnull String nodeClientId) {
        this.executeSafeForAllListeners(l -> l.onPostAnsiblePlaybook(logEventId, ansiblePlaybookSpec, fullPath, fullLogPath, nodeClientId, new ESpecLogListener.ESpecStepStatus(ESpecLogListener.ESpecStepStatus.Status.SUCCESS)));
    }

    public void firePostAnsiblePlaybookFail(long logEventId, @Nonnull AnsiblePlaybookSpec ansiblePlaybookSpec, @Nonnull String fullPath, @Nullable String fullLogPath, @Nonnull String nodeClientId, @Nullable String message, @Nullable Throwable throwable) {
        this.executeSafeForAllListeners(l -> l.onPostAnsiblePlaybook(logEventId, ansiblePlaybookSpec, fullPath, fullLogPath, nodeClientId, new ESpecLogListener.ESpecStepStatus(ESpecLogListener.ESpecStepStatus.Status.FAILURE, message, throwable)));
    }

    public void firePostAnsibleAll(boolean success) {
        this.executeSafeForAllListeners(l -> l.onPostAnsibleAll(success));
    }

    private void executeSafeForAllListeners(Consumer<ESpecLogListener> c) {
        for (ESpecLogListener l : this.listeners) {
            try {
                c.accept(l);
            }
            catch (Exception e) {
                this.handleExceptionInListener(e);
            }
        }
    }

    private void handleExceptionInListener(Exception e) {
        int count = this.exceptionCount.getAndIncrement();
        if (count == 0 && this.uncaughtExceptionHandler != null) {
            try {
                this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), e);
            }
            catch (Exception e2) {
                LOG.error("Ignoring exception in uncaughtExceptionHandler", (Throwable)e2);
            }
        } else {
            LOG.error("Ignoring exception " + count + " in ESpecLogger listener", (Throwable)e);
        }
    }

    public static long getNextLogId() {
        return idGenerator.getAndIncrement();
    }
}

