/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.espec.util;

import be.iminds.ilabt.jfed.espec.util.LimitedLiveLog;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javax.annotation.Nonnull;

public class LimitedLiveLogImpl
implements LimitedLiveLog {
    private final List<LimitedLiveLog.ChangeListener> listeners = new ArrayList<LimitedLiveLog.ChangeListener>();
    @Nonnull
    private String head = "";
    @Nonnull
    private StringBuffer tail = new StringBuffer("");
    private int received = 0;
    private int limit;
    private int maxHeadLen;
    private int maxTailLen;
    private boolean endReached;

    public LimitedLiveLogImpl() {
        this(1000000);
    }

    public LimitedLiveLogImpl(int limit) {
        this.limit = limit;
        this.maxHeadLen = limit / 2;
        this.maxTailLen = limit - this.maxHeadLen;
        this.endReached = false;
    }

    @Override
    public void addChangeListener(@Nonnull LimitedLiveLog.ChangeListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeChangeListener(@Nonnull LimitedLiveLog.ChangeListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void appendText(@Nonnull String extraText) {
        this.received += extraText.length();
        if (this.tail.length() == 0) {
            if (this.head.length() + extraText.length() > this.limit) {
                String fullText = this.head + extraText;
                this.head = fullText.substring(0, this.maxHeadLen);
                this.tail.append(fullText.substring(this.maxHeadLen));
                if (this.tail.length() > this.maxTailLen) {
                    this.tail.delete(0, this.tail.length() - this.maxTailLen);
                }
            } else {
                this.head = this.head + extraText;
            }
        } else {
            this.tail.append(extraText);
            if (this.tail.length() > this.maxTailLen) {
                this.tail.delete(0, this.tail.length() - this.maxTailLen);
            }
        }
        this.fireChange(extraText);
    }

    private void fireChange(@Nonnull String extraText) {
        for (LimitedLiveLog.ChangeListener l : this.listeners) {
            l.onChanged(this, extraText);
        }
    }

    @Override
    public void setEndReached() {
        this.endReached = true;
        Platform.runLater(() -> {
            for (LimitedLiveLog.ChangeListener l : this.listeners) {
                l.onEndReached(this);
            }
        });
    }

    @Override
    @Nonnull
    public String getText() {
        if (this.tail.length() == 0) {
            return this.head;
        }
        return this.head + "\n...\n\n" + this.tail.toString();
    }

    @Override
    @Nonnull
    public String getHeadText() {
        return this.head;
    }

    @Override
    @Nonnull
    public String getTailText() {
        return this.tail.toString();
    }

    @Override
    public boolean isLimited() {
        return this.tail.length() > 0;
    }

    @Override
    public int getReceivedSize() {
        return this.received;
    }

    @Override
    public int getStoredSize() {
        return this.head.length() + this.tail.length();
    }

    @Override
    public int getSizeLimit() {
        return this.limit;
    }

    @Override
    public boolean isEndReached() {
        return this.endReached;
    }
}

