/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.espec.util;

import be.iminds.ilabt.jfed.espec.util.UploadProgressTracker;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class UploadProgressTrackerImpl
implements UploadProgressTracker {
    private final List<UploadProgressTracker.ChangeListener> listeners = new ArrayList<UploadProgressTracker.ChangeListener>();
    private int current = 0;
    private int total;

    public UploadProgressTrackerImpl() {
        this.total = -1;
    }

    public UploadProgressTrackerImpl(int total) {
        this.total = total;
    }

    @Override
    public void addChangeListener(@Nonnull UploadProgressTracker.ChangeListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeChangeListener(@Nonnull UploadProgressTracker.ChangeListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void setCurrentBytes(int current) {
        boolean changed;
        boolean bl = changed = this.current != current;
        if (changed) {
            this.current = current;
            this.fireChange();
        }
    }

    @Override
    public void setTotalBytes(int total) {
        boolean changed;
        boolean bl = changed = this.total != total;
        if (changed) {
            this.total = total;
            this.fireChange();
        }
    }

    private void fireChange() {
        for (UploadProgressTracker.ChangeListener l : this.listeners) {
            l.onChanged(this);
        }
    }

    @Override
    public int getCurrentBytes() {
        return this.current;
    }

    @Override
    public int getTotalBytes() {
        return this.total;
    }

    @Override
    public double getPercentProgress() {
        return (double)this.current * 100.0 / (double)this.total;
    }

    @Override
    public boolean isTotalBytesKnown() {
        return this.total >= 0;
    }

    @Override
    public boolean isFinished() {
        return this.total >= 0 && this.current >= this.total;
    }
}

