/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.origins_service;

import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class OriginsServiceCommandLine {
    public static final String USER_LOGIN_PEM_OPT = "pem";
    public static final String THREADS_OPT = "threads";
    public static final String MAX_RUNS_OPT = "max-runs";
    public static final String MAX_RUNS_TIME_S_OPT = "max-run-time-s";
    public static final String MAX_SCHEDULE_TIME_S_OPT = "max-schedule-time-s";
    public static final String FILTER_TI_NAME_OPT = "test-instance-name";
    public static final String FILTER_TD_NAME_OPT = "test-definition-name";
    public static final String FILTER_TI_ID_OPT = "test-instance-id";
    public static final String FILTER_TESTBED_NAME_OPT = "testbed";
    public static final String FILTER_VERSION_OPT = "version-name";
    public static final String DEBUG_OPT = "debug";
    public static final String DEBUG_TIMING_OPT = "debug-timing";
    public static final String DEBUG_TEST_OPT = "debugtest";
    public static final String CONFIG_FILE_OPT = "configfile";
    public static final String EXIT_WHEN_NO_INITIAL_TASKS_OPT = "exit-when-no-initial-tasks";
    public static final String EXIT_WHEN_IDLE_OPT = "exit-when-idle";
    private Options options = new Options();

    public OriginsServiceCommandLine() {
        OptionBuilder.withLongOpt((String)USER_LOGIN_PEM_OPT);
        OptionBuilder.withDescription((String)"If specified, the provided user will be used for setting up user authenticated SSL connections.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"PEM file containing user certificate and (unencrypted) private key");
        this.options.addOption(OptionBuilder.create((String)"n"));
        OptionBuilder.withLongOpt((String)THREADS_OPT);
        OptionBuilder.withDescription((String)"Amount of threads to use. Default is the number of availableProcessors.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"number of threads");
        this.options.addOption(OptionBuilder.create((String)"n"));
        OptionBuilder.withLongOpt((String)MAX_RUNS_OPT);
        OptionBuilder.withDescription((String)"Limit the maximum number of tests that can be run. (if specified, must be > 0)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"maximum number of tests");
        this.options.addOption(OptionBuilder.create((String)"m"));
        OptionBuilder.withLongOpt((String)MAX_RUNS_TIME_S_OPT);
        OptionBuilder.withDescription((String)"The maximum time to run Tasks. After this time, all tasks will be cancelled if possible and the application will stop (in seconds) (default is 2 hour)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"time in seconds");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)MAX_SCHEDULE_TIME_S_OPT);
        OptionBuilder.withDescription((String)"The maximum time to schedule new Tasks. After this time, now new Tasks will be scheduled. Running tasks will keep running. (in seconds) (default is 1 hour)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"time in seconds");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)FILTER_TI_NAME_OPT);
        OptionBuilder.withDescription((String)"Limit tests by name(s). Multiple values should be separated by ',' e.g. testname1,testname2.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"testname(s)");
        this.options.addOption(OptionBuilder.create((String)"tn"));
        OptionBuilder.withLongOpt((String)FILTER_TD_NAME_OPT);
        OptionBuilder.withDescription((String)"Limit tests by definitionname(s). Multiple values should be separated by ',' e.g. testtype1,testtype2.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"testdefinitionname(s)");
        this.options.addOption(OptionBuilder.create((String)"tdn"));
        OptionBuilder.withLongOpt((String)FILTER_TI_ID_OPT);
        OptionBuilder.withDescription((String)"Limit tests by instance id(s). Multiple values should be separated by ',' e.g. 17,31.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"testinstanceid");
        this.options.addOption(OptionBuilder.create((String)"tid"));
        OptionBuilder.withLongOpt((String)FILTER_TESTBED_NAME_OPT);
        OptionBuilder.withDescription((String)"Limit tests by testbed name(s). Multiple values should be separated by ',' e.g. vwall2,ple.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)FILTER_TESTBED_NAME_OPT);
        this.options.addOption(OptionBuilder.create((String)"tid"));
        OptionBuilder.withLongOpt((String)FILTER_VERSION_OPT);
        OptionBuilder.withDescription((String)"Name of this fedmon-origins version.','typically one of 'test' or 'prod'.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"versionname");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)EXIT_WHEN_NO_INITIAL_TASKS_OPT);
        OptionBuilder.withDescription((String)"exit if there are no initial tasks");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)EXIT_WHEN_IDLE_OPT);
        OptionBuilder.withDescription((String)"exit if there are no more tasks and no tasks are running");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"print help message");
        this.options.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.withLongOpt((String)DEBUG_OPT);
        OptionBuilder.withDescription((String)"print some debug info");
        this.options.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.withLongOpt((String)DEBUG_TIMING_OPT);
        OptionBuilder.withDescription((String)"print periodic timing debug info");
        this.options.addOption(OptionBuilder.create((String)"dt"));
        OptionBuilder.withLongOpt((String)DEBUG_TEST_OPT);
        OptionBuilder.withDescription((String)"do a debug test instead of anything else");
        this.options.addOption(OptionBuilder.create((String)"dt"));
        OptionBuilder.withLongOpt((String)CONFIG_FILE_OPT);
        OptionBuilder.withDescription((String)"location of the property file containing the configuration. Default ~/.jFed/config");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"conf"));
    }

    public CommandLine parse(String[] args) {
        BasicParser parser = new BasicParser();
        try {
            return parser.parse(this.options, args);
        }
        catch (ParseException ex) {
            System.err.println("Invalid command line: " + ex.getMessage());
            this.help();
            throw new RuntimeException("Error parsing command line parameters: " + ex.getMessage(), ex);
        }
    }

    public void help() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(150, "monitorService [options ... ]", "Options:", this.options, "");
        System.exit(0);
    }
}

