/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.origins_service;

import be.iminds.ilabt.jfed.fedmon.origins_service.BasicOriginsService;
import be.iminds.ilabt.jfed.fedmon.origins_service.testrunners.TestRunner;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Log;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.LogBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpseBuilder;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithUri;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultUploader {
    private static final Logger LOG = LoggerFactory.getLogger(ResultUploader.class);
    private final FedmonWebApiClient fedmonWebApiClient;
    private final BlockingDeque<TestRunner.TestCallCreatedObjects> sendQueue = new LinkedBlockingDeque<TestRunner.TestCallCreatedObjects>();
    private Boolean stopping = false;
    private Thread resultUploaderThread;
    private final BasicOriginsService originsService;

    public ResultUploader(BasicOriginsService originsService) {
        this.originsService = originsService;
        this.fedmonWebApiClient = originsService.getFedmonWebApiClient();
        this.resultUploaderThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ResultUploader.this.run();
            }
        });
        this.resultUploaderThread.start();
    }

    public synchronized void addToQueue(TestRunner.TestCallCreatedObjects r) {
        assert (r.getResultBuilder() != null) : "You should never add a TestCallCreatedObjects without a ResultBuilder";
        LOG.debug("addToQueue for ti " + r.getResultBuilder().getTestInstanceId());
        this.sendQueue.addLast(r);
    }

    public void waitUntilFinished(long timeOutMillis) {
        this.stopping = true;
        assert (this.resultUploaderThread != null);
        try {
            this.resultUploaderThread.join(timeOutMillis);
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted while waiting to join resultUploaderThread. Will stop waiting.", (Throwable)e);
        }
    }

    public void run() {
        if (this.fedmonWebApiClient == null) {
            throw new RuntimeException("implementation error: WebServiceAccess must be set first");
        }
        while (!this.stopping.booleanValue() || this.sendQueue.size() > 0) {
            try {
                TestRunner.TestCallCreatedObjects testCallCreatedObjects = this.sendQueue.pollFirst(100L, TimeUnit.MILLISECONDS);
                if (testCallCreatedObjects == null) continue;
                LOG.debug("ResultUploader got result to post from queue");
                List<Log> createdLogs = this.tryPostLogsStep1(testCallCreatedObjects);
                Result createdResult = this.tryPostResult(testCallCreatedObjects.getResultBuilder());
                if (createdResult != null) {
                    testCallCreatedObjects.fireOnResultIdKnownCallbacks(createdResult);
                    this.tryPostLogsStep2(createdLogs, (Long)createdResult.getId());
                }
                for (ServerGlimpseBuilder serverGlimpseBuilder : testCallCreatedObjects.getServerGlimpses()) {
                    assert (serverGlimpseBuilder.getServerId() != null) : "serverGlimpse has no serverId";
                    this.tryPostServerGlimpse(serverGlimpseBuilder);
                }
            }
            catch (InterruptedException ex) {
                LOG.info("ResultUploader InterruptedException", (Throwable)ex);
            }
        }
        LOG.debug("ResultUploader stopped.");
        assert (this.stopping.booleanValue());
    }

    private Result tryPostResult(ResultBuilder resultBuilder) throws InterruptedException {
        Result createdResult = null;
        try {
            try {
                createdResult = (Result)this.fedmonWebApiClient.create((JsonLdObjectWithUri)resultBuilder.create());
                LOG.debug("ResultUploader successfully posted result with ID " + createdResult.getId());
            }
            catch (Throwable e) {
                LOG.error("Something went wrong trying to upload result.", e);
                System.err.println("Something went wrong trying to upload result:");
                e.printStackTrace();
            }
        }
        catch (Throwable e) {
            LOG.error("Something went wrong trying to post Result.", e);
            System.err.println("Something went wrong trying to post Result:");
            e.printStackTrace();
        }
        return createdResult;
    }

    private List<Log> tryPostLogsStep1(TestRunner.TestCallCreatedObjects testCallCreatedObjects) throws InterruptedException {
        List<TestRunner.TestCallCreatedObjects.LogInfo> logInfos = testCallCreatedObjects.getLogs();
        ResultBuilder resultBuilder = testCallCreatedObjects.getResultBuilder();
        ArrayList<Log> createdLogs = new ArrayList<Log>();
        if (logInfos != null) {
            LOG.debug("ResultUploader tryPostLogsStep1 There are " + logInfos.size() + " logs");
            for (TestRunner.TestCallCreatedObjects.LogInfo logInfo : logInfos) {
                LOG.debug("  processing Log " + logInfo.getName());
                if (logInfo.getCreatedLog() != null) continue;
                LOG.debug("  will create and upload log");
                try {
                    LogBuilder logBuilder = logInfo.getLogBuilder();
                    Log createdLog = (Log)this.fedmonWebApiClient.create((JsonLdObjectWithUri)logBuilder.create());
                    if (createdLog == null) {
                        throw new NullPointerException("Something went wrong trying to create log: got null from server");
                    }
                    if (createdLog.getId() == null) {
                        throw new NullPointerException("Something went wrong trying to create log: got log without ID from server");
                    }
                    if (createdLog.getUri() == null) {
                        throw new NullPointerException("Something went wrong trying to create log: got log without URI from server");
                    }
                    if (createdLog.getContent() == null) {
                        throw new NullPointerException("Something went wrong trying to create log: got log without content URI from server");
                    }
                    LOG.debug("     created log " + createdLog.getId());
                    logInfo.setCreatedLog(createdLog);
                    createdLogs.add(createdLog);
                    if (logInfo.getSubResultName() != null) {
                        resultBuilder.setNestedSubResult((Object)createdLog.getContent().toASCIIString(), logInfo.getSubResultName().toArray(new String[logInfo.getSubResultName().size()]));
                        LOG.debug("     added subresult " + logInfo.getSubResultName());
                    }
                    if (logInfo.getContent() != null) {
                        this.fedmonWebApiClient.appendStringContent(createdLog, logInfo.getContent());
                        LOG.debug("     uploaded content");
                        try {
                            testCallCreatedObjects.firePostLogUploadCallbacks(createdLog);
                        }
                        catch (Exception e) {
                            LOG.error("Something went wrong in post Log upload callback for Log \"" + logInfo.getName() + "\" with id " + createdLog.getId() + ". (will ignore)", (Throwable)e);
                        }
                        continue;
                    }
                    LOG.debug("     no content to upload");
                }
                catch (Throwable e) {
                    LOG.error("Something went wrong trying to upload Log \"" + logInfo.getName() + "\".", e);
                    System.err.println("Something went wrong trying to upload Log \"" + logInfo.getName() + "\".:");
                    e.printStackTrace();
                }
            }
        } else {
            LOG.debug("ResultUploader tryPostLogsStep1 logs = null");
        }
        return createdLogs;
    }

    private void tryPostLogsStep2(List<Log> createdLogs, long resultId) throws InterruptedException {
        for (Log createdLog : createdLogs) {
            try {
                assert (createdLog.getId() != null) : "unexpected null ID in createdLog=" + createdLog;
                assert (createdLog.getUri() != null) : "unexpected null URI in createdLog=" + createdLog;
                assert (createdLog.getContent() != null) : "unexpected null content in createdLog=" + createdLog;
                if (createdLog == null) {
                    throw new NullPointerException("Something went wrong trying to set result in log: got null from server");
                }
                if (createdLog.getId() == null) {
                    throw new NullPointerException("Something went wrong trying to set result in log: got log without ID from server");
                }
                if (createdLog.getUri() == null) {
                    throw new NullPointerException("Something went wrong trying to set result in log: got log without URI from server");
                }
                if (createdLog.getContent() == null) {
                    throw new NullPointerException("Something went wrong trying to set result in log: got log without content URI from server");
                }
                LogBuilder updatedLog = new LogBuilder(createdLog);
                updatedLog.setLive(null);
                updatedLog.setStartTime(null);
                updatedLog.setStopTime(null);
                updatedLog.setMediaType((Log.LogMediaType)null);
                updatedLog.setName(null);
                updatedLog.setContent(null);
                updatedLog.setSize(null);
                updatedLog.setComplete(Boolean.valueOf(true));
                updatedLog.setResultId(Long.valueOf(resultId));
                this.fedmonWebApiClient.update((JsonLdObjectWithUri)updatedLog.create());
            }
            catch (Throwable e) {
                String createdLogName = createdLog == null ? "createdLog==null" : (createdLog.getName() == null ? "createdLog.getName() == null" : "\"" + createdLog.getName() + "\"");
                LOG.error("Something went wrong trying to update Log " + createdLogName + ".", e);
                System.err.println("Something went wrong trying to update Log " + createdLogName + ":");
                e.printStackTrace();
            }
        }
    }

    private void tryPostServerGlimpse(ServerGlimpseBuilder serverGlimpseBuilder) throws InterruptedException {
        try {
            assert (serverGlimpseBuilder.getServerId() != null) : "serverGlimpse has no serverId";
            this.fedmonWebApiClient.upsert(serverGlimpseBuilder.create());
            LOG.debug("ResultUploader successfully upserted ServerGlimpse");
        }
        catch (Throwable e) {
            LOG.error("Something went wrong trying to upsert ServerGlimpse.", e);
            System.err.println("Something went wrong trying to upsert ServerGlimpse:");
            e.printStackTrace();
            try {
                LOG.debug("ServerGlimpse that failed upsert is: " + serverGlimpseBuilder.create());
            }
            catch (Throwable e2) {
                LOG.error("Error trying to LOG.debug ServerGlimpse that caused error", e2);
            }
        }
    }

    public int queueSize() {
        return this.sendQueue.size();
    }
}

