/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.origins_service.debug_helper;

import be.iminds.ilabt.jfed.fedmon.origins_service.OriginsServiceConfigIface;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClientConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClientPropertiesConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.client.TestInstanceFilter;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.library.JFedTrustStore;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.security.PrivateKey;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DummyOriginsServiceConfig
implements OriginsServiceConfigIface {
    private static final Logger LOG = LoggerFactory.getLogger(DummyOriginsServiceConfig.class);
    private final int fixedTestInstance;
    private final FedmonWebApiClientConfig fedmonWebApiClientConfig;
    private final Properties originsServiceProperties;

    public DummyOriginsServiceConfig(int fixedTestInstance, String userLoginPemFilename) {
        PrivateKey userPrivateKey;
        List userCertificate;
        this.fixedTestInstance = fixedTestInstance;
        JFedTrustStore jFedTrustStore = new JFedTrustStore();
        if (userLoginPemFilename == null) {
            throw new RuntimeException("No user login specified: no write access to fedmon API.");
        }
        try {
            String pemContent = IOUtils.fileToString((String)userLoginPemFilename);
            if (pemContent.trim().isEmpty()) {
                throw new RuntimeException("empty PEM file \"" + userLoginPemFilename + "\"");
            }
            userCertificate = KeyUtil.pemToX509CertificateChain((String)pemContent);
            if (userCertificate == null) {
                throw new RuntimeException("No certificate found in PEM file \"" + userLoginPemFilename + "\"");
            }
            userPrivateKey = KeyUtil.pemToAnyPrivateKey((String)pemContent, null);
            if (userPrivateKey == null) {
                throw new RuntimeException("No unencrypted private key found in PEM file \"" + userLoginPemFilename + "\"");
            }
            LOG.debug("Using certificate and private SSH key from PEM file " + userLoginPemFilename + " for SSL connection client authentication.");
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading user PEM file", e);
        }
        this.originsServiceProperties = new Properties();
        this.originsServiceProperties.setProperty("webapi_client_url_read_base", "https://flsmonitor-api.fed4fire.eu/");
        this.originsServiceProperties.setProperty("webapi_client_url_write_base", "https://flsmonitor-api.fed4fire.eu:9443/");
        this.fedmonWebApiClientConfig = new FedmonWebApiClientPropertiesConfig(this.originsServiceProperties, jFedTrustStore, userCertificate, userPrivateKey, null);
    }

    @Override
    public boolean isDebug() {
        return true;
    }

    @Override
    public boolean isDebugTiming() {
        return false;
    }

    @Override
    public FedmonWebApiClientConfig getWebApiClientConfig() {
        return this.fedmonWebApiClientConfig;
    }

    @Override
    public String getProxyUsername() {
        return null;
    }

    @Override
    public String getProxyHostname() {
        return null;
    }

    @Override
    public String getProperty(@Nonnull String key) {
        return this.originsServiceProperties.getProperty(key);
    }

    @Override
    public String getProperty(@Nonnull String key, String defaultVal) {
        return this.originsServiceProperties.getProperty(key, defaultVal);
    }

    @Override
    public TestInstanceFilter getTestInstanceFilter() {
        return new TestInstanceFilter(null, null, null, Collections.singletonList(this.fixedTestInstance), null, null, null, null, Optional.of(false));
    }

    @Override
    public int getThreadCount() {
        return 1;
    }

    @Override
    public Integer getMaxRunCount() {
        return 1;
    }

    @Override
    public boolean isExitWhenIdle() {
        return true;
    }

    @Override
    public boolean isExitWhenNoInitialTasks() {
        return true;
    }

    @Override
    public Long getMaxRunTime() {
        return 30L;
    }

    @Override
    public TimeUnit getMaxRunTimeUnit() {
        return TimeUnit.MINUTES;
    }

    @Override
    public Long getMaxScheduleNewTime() {
        return 10L;
    }

    @Override
    public TimeUnit getMaxScheduleNewTimeUnit() {
        return TimeUnit.SECONDS;
    }
}

