/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.origins_service.debug_helper;

import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiCachedClient;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.client.TestInstanceFilter;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Admin;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Graph;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.JFedExperimenterGuiConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Log;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.LogBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceMapping;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserInfo;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithUri;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DummyWebApiClient
implements FedmonWebApiClient {
    private final FedmonWebApiClient fedmonWebApiClient;
    private static final Logger LOG = LoggerFactory.getLogger(FedmonWebApiCachedClient.class);
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();
    private static AtomicLong fakeLogId = new AtomicLong(123456L);
    private static AtomicLong fakeResultId = new AtomicLong(654321L);
    private final Map<Long, FakeLog> fakeLogsById = new HashMap<Long, FakeLog>();

    public DummyWebApiClient(FedmonWebApiClient fedmonWebApiClient) {
        this.fedmonWebApiClient = fedmonWebApiClient;
    }

    private FakeLog getFakeLog(long id) {
        return this.fakeLogsById.get(id);
    }

    @Nonnull
    public <T extends JsonLdObjectWithUri> Optional<T> getByUri(@Nonnull URI uri) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.fedmonWebApiClient.getByUri(uri);
    }

    @Nonnull
    public <I, T extends JsonLdObjectWithUri & JsonLdObjectWithId<I>> Optional<T> getById(@Nonnull Class<T> objectClass, @Nonnull I id, boolean withEmbeddedLinkObjects) throws FedmonWebApiClient.FedmonWebApiClientException {
        if (Objects.equals(objectClass, Log.class)) {
            return Optional.of(this.getFakeLog((Long)id).toLog());
        }
        return this.fedmonWebApiClient.getById(objectClass, id, withEmbeddedLinkObjects);
    }

    @Nonnull
    public <I, T extends JsonLdObjectWithUri & JsonLdObjectWithId<I>> List<T> search(@Nonnull FedmonWebApiClient.FedmonFilter<I, T> filter, boolean withEmbeddedLinkObjects) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.fedmonWebApiClient.search(filter, withEmbeddedLinkObjects);
    }

    @Nonnull
    public <I, T extends JsonLdObjectWithUri & JsonLdObjectWithId<I>> List<T> search(@Nonnull FedmonWebApiClient.FedmonFilter<I, T> filter, boolean b, boolean b1) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.fedmonWebApiClient.search(filter, b, b1);
    }

    @Nonnull
    public <I, T extends JsonLdObjectWithUri & JsonLdObjectWithId<I>> Map<I, T> getAllIndexedById(@Nonnull Class<T> objectClass, boolean withEmbeddedLinkObjects) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.fedmonWebApiClient.getAllIndexedById(objectClass, withEmbeddedLinkObjects);
    }

    @Nonnull
    public <T extends JsonLdObjectWithUri> List<T> getAll(@Nonnull Class<T> objectClass, boolean withEmbeddedLinkObjects) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.fedmonWebApiClient.getAll(objectClass, withEmbeddedLinkObjects);
    }

    @Nonnull
    public <T extends JsonLdObjectWithUri> T create(@Nonnull T object) throws FedmonWebApiClient.FedmonWebApiClientException {
        if (Objects.equals(object.getClass(), Log.class)) {
            Log log = (Log)object;
            FakeLog res = new FakeLog(log);
            this.fakeLogsById.put(res.id, res);
            return (T)res.toLog();
        }
        if (Objects.equals(object.getClass(), Result.class)) {
            Result r = (Result)object;
            ResultBuilder res = (ResultBuilder)new ResultBuilder(r).setId((Object)fakeResultId.getAndIncrement());
            return (T)res.create();
        }
        return object;
    }

    @Nonnull
    public <T extends JsonLdObjectWithUri> T update(@Nonnull T object) throws FedmonWebApiClient.FedmonWebApiClientException {
        return object;
    }

    public <T extends JsonLdObjectWithUri> void delete(@Nonnull T object) throws FedmonWebApiClient.FedmonWebApiClientException {
    }

    public <I, T extends JsonLdObjectWithUri & JsonLdObjectWithId<I>> void deleteById(@Nonnull Class<T> objectClass, @Nonnull I id) throws FedmonWebApiClient.FedmonWebApiClientException {
    }

    public void deleteByUri(@Nonnull URI uri) throws FedmonWebApiClient.FedmonWebApiClientException {
    }

    @Nonnull
    public Collection<Task> createTasks(int maxCount, @Nonnull String runInfo, TestInstanceFilter filter) throws FedmonWebApiClient.FedmonWebApiClientException {
        return Collections.emptyList();
    }

    @Nonnull
    public Collection<Task> createStressTestTasks(int stresstestCount, int testInstanceId, @Nonnull String runInfo) throws FedmonWebApiClient.FedmonWebApiClientException {
        return Collections.emptyList();
    }

    public Admin getAdminConfig() throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.fedmonWebApiClient.getAdminConfig();
    }

    @Nonnull
    public JFedExperimenterGuiConfig getJFedExperimenterGuiConfig(@Nonnull UserInfo userInfo) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.fedmonWebApiClient.getJFedExperimenterGuiConfig(userInfo);
    }

    public void changeAdminKeyValue(@Nonnull String key, boolean value) throws FedmonWebApiClient.FedmonWebApiClientException {
    }

    public void createResourceMapping(@Nonnull ResourceMapping mapping) throws FedmonWebApiClient.FedmonWebApiClientException {
    }

    public void deleteResourceMapping(@Nonnull ResourceMapping mapping) throws FedmonWebApiClient.FedmonWebApiClientException {
    }

    @Nonnull
    public Optional<ServerGlimpse> getServerGlimpseByServerId(@Nonnull Integer serverId) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.fedmonWebApiClient.getServerGlimpseByServerId(serverId);
    }

    @Nonnull
    public ServerGlimpse upsert(@Nonnull ServerGlimpse serverGlimpse) throws FedmonWebApiClient.FedmonWebApiClientException {
        return (ServerGlimpse)this.fedmonWebApiClient.getServerGlimpseByServerId(serverGlimpse.getServerId()).orElseThrow(() -> new FedmonWebApiClient.FedmonWebApiClientException("no such ServerGlimpse " + serverGlimpse.getServerId()));
    }

    @Nonnull
    public Optional<TestInstanceStatistics> getTestInstanceStatisticsByTestInstanceId(@Nonnull Integer testInstanceId) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.fedmonWebApiClient.getTestInstanceStatisticsByTestInstanceId(testInstanceId);
    }

    @Nonnull
    public List<TestInstanceStatistics> searchTestInstanceStatistics(@Nonnull TestInstanceFilter testInstanceFilter) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.fedmonWebApiClient.searchTestInstanceStatistics(testInstanceFilter);
    }

    @Nonnull
    public TestInstanceStatistics updateTestInstanceStatisticsNextRun(@Nonnull Integer testInstanceId, @Nonnull Timestamp nextRun) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.getTestInstanceStatisticsByTestInstanceId(testInstanceId).orElseThrow(() -> new FedmonWebApiClient.FedmonWebApiClientException("no such TestInstanceStatistics " + testInstanceId));
    }

    @Nonnull
    public TestInstanceStatistics setTestInstanceStatisticsRunNow(@Nonnull Integer testInstanceId) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.getTestInstanceStatisticsByTestInstanceId(testInstanceId).orElseThrow(() -> new FedmonWebApiClient.FedmonWebApiClientException("no such TestInstanceStatistics " + testInstanceId));
    }

    @Nonnull
    public String getStringContent(@Nonnull Log log) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.getFakeLog((long)((Long)log.getId()).longValue()).stringContent;
    }

    @Nonnull
    public byte[] getBinaryContent(@Nonnull Log log) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.getFakeLog((long)((Long)log.getId()).longValue()).byteContent;
    }

    public void appendStringContent(@Nonnull Log log, @Nonnull String content, boolean complete) throws FedmonWebApiClient.FedmonWebApiClientException {
        this.getFakeLog((long)((Long)log.getId()).longValue()).stringContent = this.getFakeLog((long)((Long)log.getId()).longValue()).stringContent + content;
    }

    public void appendBinaryContent(@Nonnull Log log, @Nonnull byte[] content, boolean complete) throws FedmonWebApiClient.FedmonWebApiClientException {
        if (this.getFakeLog((long)((Long)log.getId()).longValue()).byteContent.length == 0) {
            this.getFakeLog((long)((Long)log.getId()).longValue()).byteContent = content;
        } else {
            byte[] a = this.getFakeLog((long)((Long)log.getId()).longValue()).byteContent;
            byte[] b = content;
            int aLen = a.length;
            int bLen = content.length;
            byte[] res = new byte[aLen + bLen];
            System.arraycopy(a, 0, res, 0, aLen);
            System.arraycopy(b, 0, res, aLen, bLen);
            this.getFakeLog((long)((Long)log.getId()).longValue()).byteContent = res;
        }
    }

    @Nullable
    public byte[] getImageData(@Nonnull Graph graph) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.fedmonWebApiClient.getImageData(graph);
    }

    public void setImageData(@Nonnull Graph graph, byte[] imageData) throws FedmonWebApiClient.FedmonWebApiClientException {
    }

    private static class FakeLog {
        long id;
        Long taskId;
        String stringContent;
        byte[] byteContent;
        LogBuilder log;

        public FakeLog(@Nonnull Log log) {
            this.log = new LogBuilder(log);
            this.id = fakeLogId.getAndIncrement();
            this.taskId = log.getTaskId();
            this.stringContent = "";
            this.byteContent = new byte[0];
        }

        public Log toLog() {
            try {
                return ((LogBuilder)((LogBuilder)this.log.setId((Object)this.id)).setUri(new URI("http://localhost/log/" + this.id))).setContent(new URI("http://localhost/log/" + this.id + "/content")).create();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Should not happen");
            }
        }
    }
}

