/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.origins_service.testrunners;

import be.iminds.ilabt.jfed.fedmon.origins_service.BasicOriginsService;
import be.iminds.ilabt.jfed.fedmon.origins_service.testrunners.TestRunner;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Log;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.jfed.lib.CorePreferencesModule;
import be.iminds.ilabt.jfed.lib.KeyCertFileUserModule;
import be.iminds.ilabt.jfed.lib.PostLoginCoreModule;
import be.iminds.ilabt.jfed.lib.PreLoginCoreModule;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.module.BasicTestbedInfoModule;
import be.iminds.ilabt.jfed.module.JFedWebApiClientModule;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.ApiTestFactory;
import be.iminds.ilabt.jfed.testing.base.ApiTestResult;
import be.iminds.ilabt.jfed.testing.base.AutomatedTestModule;
import be.iminds.ilabt.jfed.testing.base.AutomatedTestRunner;
import be.iminds.ilabt.jfed.ui.commandline.ContextFile;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AutomatedTesterTestRunner
extends TestRunner {
    private static final Logger LOG = LoggerFactory.getLogger(AutomatedTesterTestRunner.class);
    private final List<String> prerequisiteMethods = new ArrayList<String>();
    private String contextFileContent;
    private String resultXmlOverviewString;

    public AutomatedTesterTestRunner(Task task, TestInstance test, Frequency testInstanceFrequency, TestInstanceStatistics testInstanceStatistics, TestDefinition testDefinition, BasicOriginsService originsService) {
        super(task, test, testInstanceFrequency, testInstanceStatistics, testDefinition, originsService);
    }

    @Override
    @Nonnull
    protected ResultBuilder initResult() {
        String fixedNode;
        ResultBuilder res = this.createBasicTestResult(null);
        if (this.resultXmlOverviewString != null) {
            boolean sawPreRequisiteFailure = false;
            boolean sawFailure = false;
            boolean sawWarning = false;
            String successMethod = this.testInstance.getStringParameterOrDefault("method_required_for_success", this.testDefinition);
            String warningMethod = this.testInstance.getStringParameterOrDefault("method_required_for_warning", this.testDefinition);
            String notEnoughFreeResourcesDetectionString = this.testInstance.getStringParameterOrDefault("not_enough_free_resources_detection_string", this.testDefinition);
            String notEnoughFreeResourcesDetectionMethod = this.testInstance.getStringParameterOrDefault("not_enough_free_resources_detection_method", this.testDefinition);
            boolean alternativeSummaryMethod = successMethod != null && warningMethod != null || successMethod != null;
            Boolean successMethodSuccessful = null;
            Boolean warningMethodSuccessful = null;
            boolean notEnoughResourcesDetected = false;
            boolean warningMethodSkippedSeen = false;
            ArrayList successMethodNames = successMethod == null ? new ArrayList() : Arrays.asList(successMethod.toLowerCase().split(","));
            ArrayList warningMethodNames = warningMethod == null ? new ArrayList() : Arrays.asList(warningMethod.toLowerCase().split(","));
            ArrayList methodStates = new ArrayList();
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(new InputSource(new StringReader(this.resultXmlOverviewString)));
                NodeList nList = doc.getElementsByTagName("method");
                for (int i = 0; i < nList.getLength(); ++i) {
                    boolean skippedNow;
                    String state;
                    String methodName;
                    Node n = nList.item(i);
                    if (n == null || n.getNodeType() != 1) continue;
                    Element el = (Element)n;
                    NodeList methodNameNL = el.getElementsByTagName("methodName");
                    if (methodNameNL == null || methodNameNL.getLength() == 0) {
                        if (el.hasAttribute("methodName")) {
                            methodName = el.getAttribute("methodName");
                        } else {
                            LOG.warn("Processed element has no methodName");
                            methodName = null;
                        }
                    } else {
                        assert (methodNameNL.item(0) != null);
                        methodName = methodNameNL.item(0).getTextContent();
                    }
                    NodeList stateNL = el.getElementsByTagName("state");
                    if (stateNL == null || stateNL.getLength() == 0) {
                        if (el.hasAttribute("state")) {
                            state = el.getAttribute("state");
                        } else {
                            LOG.warn("Processed element has no state. ");
                            state = null;
                        }
                    } else {
                        assert (stateNL.item(0) != null);
                        state = stateNL.item(0).getTextContent();
                    }
                    if (state == null || methodName == null) {
                        LOG.warn("Processed element has methodName==" + methodName + " and state=" + state + ". (Should both be non-null)");
                        continue;
                    }
                    TreeMap<String, String> methodInfoMap = new TreeMap<String, String>();
                    methodInfoMap.put("name", methodName);
                    methodInfoMap.put("state", state);
                    methodStates.add(methodInfoMap);
                    NodeList logLinesElNodeList = el.getElementsByTagName("loglines");
                    if (logLinesElNodeList == null) {
                        LOG.warn("Processed element has null logLinesElNodeList.");
                    } else if (logLinesElNodeList.getLength() > 0) {
                        NodeList logLineNodeList = ((Element)logLinesElNodeList.item(0)).getElementsByTagName("logline");
                        block15: for (int l = 0; l < logLineNodeList.getLength(); ++l) {
                            Pattern patternInfo;
                            Matcher matcherInfo;
                            Element logLine = (Element)logLineNodeList.item(l);
                            String text = logLine.getElementsByTagName("text").item(0).getTextContent();
                            if (!text.startsWith("RAW_INFO") || !(matcherInfo = (patternInfo = Pattern.compile("RAW_INFO BEGIN_([A-Za-z0-9_]*) (.*) END_([A-Za-z0-9_]*)")).matcher(text)).find()) continue;
                            String infoName = matcherInfo.group(1);
                            String infoValue = matcherInfo.group(2);
                            switch (infoName.toLowerCase()) {
                                case "slice_name": {
                                    res.setNestedSubResult((Object)infoValue, new String[]{"slice", "name"});
                                    continue block15;
                                }
                                case "slice_uuid": {
                                    res.setNestedSubResult((Object)infoValue, new String[]{"slice", "uuid"});
                                    continue block15;
                                }
                                case "slice_urn": {
                                    res.setNestedSubResult((Object)infoValue, new String[]{"slice", "urn"});
                                }
                            }
                        }
                    }
                    boolean failNow = state.equalsIgnoreCase("FAILED") || state.equalsIgnoreCase("FAIL") || state.equalsIgnoreCase("ERROR");
                    boolean warnNow = state.equalsIgnoreCase("WARN") || state.equalsIgnoreCase("WARNING");
                    boolean successNow = state.equalsIgnoreCase("SUCCESS") || state.equalsIgnoreCase("SUCCEEDED");
                    boolean bl = skippedNow = state.equalsIgnoreCase("SKIP") || state.equalsIgnoreCase("SKIPPED");
                    if (failNow) {
                        sawFailure = true;
                    }
                    if (warnNow) {
                        sawWarning = true;
                    }
                    if ((failNow || skippedNow) && this.prerequisiteMethods.contains(methodName.toLowerCase())) {
                        LOG.debug("saw prerequisiteMethods FAILURE for " + methodName + " state=" + state);
                        sawPreRequisiteFailure = true;
                    }
                    if (alternativeSummaryMethod && successMethodNames.contains(methodName.toLowerCase())) {
                        successMethodSuccessful = successMethodSuccessful == null ? successNow : successMethodSuccessful != false && successNow;
                        if (warnNow && warningMethodSuccessful == null) {
                            warningMethodSuccessful = true;
                        }
                    }
                    if (alternativeSummaryMethod && warningMethodNames.contains(methodName.toLowerCase())) {
                        if (skippedNow) {
                            warningMethodSkippedSeen = true;
                        } else {
                            warningMethodSuccessful = warningMethodSuccessful == null ? successNow || warnNow : warningMethodSuccessful != false && (successNow || warnNow);
                        }
                    }
                    if (notEnoughFreeResourcesDetectionMethod != null && notEnoughFreeResourcesDetectionString != null && methodName.trim().equals(notEnoughFreeResourcesDetectionMethod.trim()) && !failNow && logLinesElNodeList.getLength() > 0) {
                        NodeList logLineNodeList = ((Element)logLinesElNodeList.item(0)).getElementsByTagName("logline");
                        for (int l = 0; l < logLineNodeList.getLength(); ++l) {
                            Element logLine = (Element)logLineNodeList.item(l);
                            String text = logLine.getElementsByTagName("text").item(0).getTextContent();
                            if (!text.trim().toLowerCase().contains(notEnoughFreeResourcesDetectionString.trim().toLowerCase())) continue;
                            notEnoughResourcesDetected = true;
                        }
                    }
                    if (!methodName.equals("createSliver")) continue;
                    try {
                        NodeList logLinesNl = el.getElementsByTagName("loglines");
                        if (logLinesNl == null || logLinesNl.getLength() <= 0 || logLinesNl.item(0).getNodeType() != 1) continue;
                        Element logLines = (Element)logLinesNl.item(0);
                        NodeList logLinesList = logLines.getElementsByTagName("logline");
                        TreeMap<String, String> locationMap = new TreeMap<String, String>();
                        for (int ll = 0; ll < logLinesList.getLength(); ++ll) {
                            Element logLine = (Element)logLinesList.item(ll);
                            String type = logLine.getElementsByTagName("type").item(0).getTextContent();
                            String text = logLine.getElementsByTagName("text").item(0).getTextContent().trim();
                            if (!type.equalsIgnoreCase("NOTE") || !text.startsWith("NODE ")) continue;
                            if (text.startsWith("NODE COUNTRY: ")) {
                                locationMap.put("country", text.substring("NODE COUNTRY: ".length()));
                            }
                            if (text.startsWith("NODE LATITUDE: ")) {
                                locationMap.put("latitude", text.substring("NODE LATITUDE: ".length()));
                            }
                            if (!text.startsWith("NODE LONGITUDE: ")) continue;
                            locationMap.put("longitude", text.substring("NODE LONGITUDE: ".length()));
                        }
                        if (locationMap.isEmpty()) continue;
                        res.addSubResult("location", locationMap);
                        continue;
                    }
                    catch (Exception ex) {
                        LOG.error("Exception processing createSliver NODE location", (Throwable)ex);
                        AutomatedTesterTestRunner.addWarningToResult(res, "Exception processing createSliver NODE location:\n\n" + TextUtil.exceptionToString((Throwable)ex));
                    }
                }
                if (warningMethodSkippedSeen && warningMethodSuccessful == null) {
                    warningMethodSuccessful = false;
                }
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                LOG.error("Error handling results. (Will treat this test as a failure.)", (Throwable)ex);
                sawFailure = true;
            }
            res.addSubResult("steps", methodStates);
            if (alternativeSummaryMethod && (warningMethod != null && warningMethodSuccessful == null || successMethodSuccessful == null)) {
                LOG.warn("WARNING handling results. successMethod=" + successMethod + " warningMethod=" + warningMethod + " BUT warningMethodSuccessful=" + warningMethodSuccessful + " successMethodSuccessful=" + successMethodSuccessful);
                AutomatedTesterTestRunner.addWarningToResult(res, "At least one \"summary method\" not found. warn (" + warningMethod + ")=>" + warningMethodSuccessful + " success (" + successMethod + ")=>" + successMethodSuccessful);
            }
            if (sawPreRequisiteFailure) {
                LOG.debug("Handling prerequitiste failure");
                AutomatedTesterTestRunner.addNoteToResult(res, "Detected that prerequitiste method failed. No reliable status can be derived from this test result. Will set status to \"cancelled\"");
                res.setSummary(Result.ResultStatus.CANCELLED);
            } else if (notEnoughResourcesDetected) {
                AutomatedTesterTestRunner.addNoteToResult(res, "Detected that not enough free resources are available. Will force WARN.");
                res.setSummary(Result.ResultStatus.WARNING);
            } else if (alternativeSummaryMethod && successMethodSuccessful != null) {
                AutomatedTesterTestRunner.addNoteToResult(res, "successMethod=" + successMethod + " warningMethod=" + warningMethod + " warningMethodSuccessful=" + warningMethodSuccessful + " successMethodSuccessful=" + successMethodSuccessful);
                if (successMethodSuccessful != null && successMethodSuccessful.booleanValue()) {
                    res.setSummary(Result.ResultStatus.SUCCESS);
                } else if (warningMethodSuccessful != null) {
                    res.setSummary(warningMethodSuccessful != false ? Result.ResultStatus.WARNING : Result.ResultStatus.FAILURE);
                } else {
                    res.setSummary(Result.ResultStatus.FAILURE);
                }
            } else {
                if (alternativeSummaryMethod) {
                    LOG.warn("WARNING handling results. Falling back to default summary method");
                    AutomatedTesterTestRunner.addWarningToResult(res, "Falling back to default \"summary method\"");
                }
                res.setSummary(Result.ResultStatus.SUCCESS);
                if (sawWarning) {
                    res.setSummary(Result.ResultStatus.WARNING);
                }
                if (sawFailure) {
                    res.setSummary(Result.ResultStatus.FAILURE);
                }
            }
        }
        if ((fixedNode = this.testInstance.getStringParameter("fixed_node_urn")) != null) {
            res.addSubResult("fixed_node_urn", (Object)fixedNode);
            GeniUrn fixedNodeUrn = GeniUrn.parse((String)fixedNode);
            if (fixedNodeUrn != null) {
                res.addSubResult("fixed_node_name", (Object)fixedNodeUrn.getResourceName());
            }
        }
        return res;
    }

    @Override
    @Nonnull
    public TestRunner.TestCallCreatedObjects runTestCall(final Logger LOG, PrintWriter outputStream) {
        ApiTest test;
        Class<?> testClass;
        GeniUser user;
        LOG.info("Starting " + this.testInstance.getName() + " with id " + this.testInstance.getId() + " at " + new Date().getTime() + "\n");
        LOG.debug("Starting " + this.testInstance.getName() + " with id " + this.testInstance.getId() + " at " + new Date().getTime() + "\n");
        this.prerequisiteMethods.clear();
        String prerequisiteMethodsProp = this.testInstance.getStringParameterOrDefault("prerequisite_methods", this.testDefinition);
        if (prerequisiteMethodsProp != null && !prerequisiteMethodsProp.trim().isEmpty()) {
            for (String m : prerequisiteMethodsProp.trim().split(",")) {
                if (m.trim().isEmpty()) continue;
                this.prerequisiteMethods.add(m.trim().toLowerCase());
            }
        }
        LOG.debug("prerequisiteMethods=" + this.prerequisiteMethods);
        String testUserPem = AutomatedTesterTestRunner.getTestUserPem(this.originsService.getFedmonWebApiClient(), this.testInstance);
        KeyCertFileUserModule userModule = new KeyCertFileUserModule(testUserPem, null, null, null);
        boolean isFailure = false;
        String testClassName = this.testInstance.getStringParameterOrDefault("test_class", this.testDefinition);
        String testGroup = this.testInstance.getStringParameterOrDefault("test_group", this.testDefinition);
        if (testClassName == null || testClassName.trim().isEmpty()) {
            throw new RuntimeException("no test_class specified");
        }
        String contextFileContent = this.getVariableValue("context-file", false);
        if (contextFileContent == null) {
            throw new RuntimeException("No configuration specified in context-file (must at least be empty string)");
        }
        boolean showCredentials = false;
        BasicTestbedInfoModule authoritiesModule = new BasicTestbedInfoModule();
        String webapiReadBase = this.originsService.getConfig().getProperty("webapi_client_url_read_base");
        LOG.debug("Will make Automated tester read Testbed and Server info from \"" + webapiReadBase + "\"");
        CorePreferencesModule preferencesModule = new CorePreferencesModule(webapiReadBase);
        boolean hasTargetServer = this.testInstance.getServerIdParameter() != null;
        TestTargetFromTestInstanceModule testTargetFromServerModule = new TestTargetFromTestInstanceModule(this.testInstance);
        Injector injector = AutomatedTesterTestRunner.createInjector(LOG, (Module)userModule, (Module)preferencesModule, (Module)authoritiesModule, (Module)testTargetFromServerModule, new Module[]{new AutomatedTestModule()});
        assert (injector != null);
        TestbedInfoSource testbedInfoSource = (TestbedInfoSource)injector.getInstance(TestbedInfoSource.class);
        LOG.debug("Got info on " + testbedInfoSource.getServers().size() + " servers.");
        TargetAuthority targetAuthority = (TargetAuthority)injector.getInstance(TargetAuthority.class);
        if (targetAuthority == null) {
            throw new IllegalStateException("No target auth found");
        }
        if (hasTargetServer) {
            assert (targetAuthority != null);
            Server testedServerToConnect = targetAuthority.getServerToConnect();
            Server testedServerForRspec = targetAuthority.getServerForRspecComponentManager();
            assert (testedServerToConnect != null);
            assert (testedServerForRspec != null);
            LOG.debug("   Tested Server:" + testedServerToConnect.getName());
            LOG.debug("      URN (connect):" + testedServerToConnect.getDefaultComponentManagerUrn());
            LOG.debug("      URN (rspec):" + testedServerForRspec.getDefaultComponentManagerUrn());
            LOG.debug("      Hrn:" + testedServerToConnect.getName());
            LOG.debug("      Server certificates:" + testedServerToConnect.getCertificateChain());
            LOG.debug("      Allowed server certificate hostname alias:" + testedServerToConnect.getAllowedCertificateAlias());
        } else {
            LOG.debug("   No (single) tested Server");
        }
        be.iminds.ilabt.jfed.log.Logger callLogger = (be.iminds.ilabt.jfed.log.Logger)injector.getInstance(be.iminds.ilabt.jfed.log.Logger.class);
        if (testGroup == null || testGroup.equals("null") || testGroup.trim().isEmpty()) {
            testGroup = null;
        }
        if ((user = (GeniUser)injector.getInstance(GeniUser.class)) == null) {
            throw new RuntimeException("User PEM specified, but user is null");
        }
        if (!AutomatedTesterTestRunner.checkUser(user, LOG)) {
            throw new RuntimeException("Test user failed validity check");
        }
        LOG.debug("   User:" + user.getUserUrnString());
        LOG.debug("      Authority URN:" + (user.getUserAuthorityServer() == null ? "*null AUTH*" : user.getUserAuthorityServer().getDefaultComponentManagerUrn()));
        LOG.debug("  \"context-file\" content: \n" + contextFileContent + "\n");
        if (testClassName.equals("be.iminds.ilabt.jfed.lowlevel.api.test.StitchingTest") || testClassName.equals("be.iminds.ilabt.jfed.lowlevel.api.test.StitchingUsingWrapperTest") || testClassName.equals("be.iminds.ilabt.jfed.lowlevel.api.test.StitchingAmv2Test")) {
            testClassName = "be.iminds.ilabt.jfed.lowlevel.api.test.StitchingPingTest";
        }
        try {
            testClass = Class.forName(testClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Test init failed: class \"" + testClassName + "\" not found", e);
        }
        AutomatedTestRunner automatedTestRunner = (AutomatedTestRunner)injector.getInstance(AutomatedTestRunner.class);
        ApiTestFactory testFactory = (ApiTestFactory)injector.getInstance(ApiTestFactory.class);
        try {
            test = testFactory.createApiTest(callLogger, targetAuthority, testClass, contextFileContent);
        }
        catch (ApiTestFactory.InvalidApiTestException e) {
            LOG.error("InvalidApiTestException", (Throwable)e);
            throw new RuntimeException("Failed to create test", e);
        }
        assert (test != null);
        ApiTestResult result = null;
        try {
            result = automatedTestRunner.runTest(test, testGroup, new AutomatedTestRunner.TestListener(){

                public void onStart(String testname, int testNr, int testCount) {
                    LOG.debug("Running " + testname + "...");
                }

                public void onResult(ApiTestResult.ApiTestMethodResult result, int testNr, int testCount) {
                    LOG.debug("                               " + result.getState());
                }

                public void onAllTestDone(ApiTestResult result, int testCount) {
                }
            }, false);
        }
        catch (ThreadDeath ex) {
            isFailure = true;
            LOG.error("AutomatedTesterTestCall caught ThreadDeath while running test. Must have hanged! Will not retrow ThreadDeath but handle it as test FAILURE.", (Throwable)ex);
        }
        catch (Throwable t) {
            isFailure = true;
            LOG.error("An exception occured while running the Test. Will consider it a failure.", t);
        }
        this.resultXmlOverviewString = result == null ? null : AutomatedTesterTestRunner.resultToXmlOverviewString(result, false);
        ResultBuilder resultBuilder = this.initResult();
        if (isFailure) {
            resultBuilder.setSummary(Result.ResultStatus.FAILURE);
        }
        TestRunner.TestCallCreatedObjects testCallCreatedObjects = new TestRunner.TestCallCreatedObjects(resultBuilder);
        testCallCreatedObjects.addLog("contextFile", "context-file.properties", contextFileContent, Log.LogMediaType.TEXT, null);
        if (result != null) {
            LOG.debug("Saving detailed results as HTML Log");
            try {
                String htmlString = result.toHtmlString(false);
                if (htmlString != null) {
                    testCallCreatedObjects.addLog("resultHtml", "result.html", htmlString, Log.LogMediaType.HTML, null);
                }
            }
            catch (Exception e) {
                LOG.error("Failed to generate resultHtml Log");
            }
        }
        if (this.resultXmlOverviewString != null) {
            LOG.debug("Saving detailed results as XML Log");
            testCallCreatedObjects.addLog("resultXml", "result-overview.xml", this.resultXmlOverviewString, Log.LogMediaType.XML, null);
        }
        LOG.debug("AutomatedTesterTestCall finished");
        return testCallCreatedObjects;
    }

    private static String resultToXmlOverviewString(ApiTestResult result, boolean showSecurityRisks) {
        String string;
        StringWriter writer = new StringWriter();
        try {
            result.toXmlOverview((Writer)writer, showSecurityRisks);
            string = writer.getBuffer().toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.error("IOException writing to string", (Throwable)e);
                return null;
            }
        }
        writer.close();
        return string;
    }

    private static Injector createInjector(Logger LOG, Module userModule, Module preferencesModule, Module authoritiesModule, Module testTargetFromServerModule, Module ... extraModules) {
        ArrayList<Module> mods = new ArrayList<Module>();
        mods.addAll(Arrays.asList(extraModules));
        mods.addAll(Arrays.asList(userModule, authoritiesModule, testTargetFromServerModule, new PreLoginCoreModule(), new PostLoginCoreModule(), preferencesModule, new JFedWebApiClientModule()));
        String highLevelModuleClassname = "be.iminds.ilabt.jfed.highlevel.HighLevelModule";
        String sfaOnlyExperimentModuleClassname = "be.iminds.ilabt.jfed.highlevel.SfaOnlyExperimentModule";
        try {
            Class<?> highLevelModuleClass = Class.forName(highLevelModuleClassname);
            Module highLevelModule = (Module)highLevelModuleClass.newInstance();
            Class<?> sfaOnlyExperimentModuleClass = Class.forName(sfaOnlyExperimentModuleClassname);
            Module sfaOnlyExperimentModule = (Module)sfaOnlyExperimentModuleClass.newInstance();
            if (highLevelModule != null && sfaOnlyExperimentModule != null) {
                LOG.debug("Adding HighLevelModule to injector");
                mods.add(highLevelModule);
                LOG.debug("Adding SfaOnlyExperimentModule to injector");
                mods.add(sfaOnlyExperimentModule);
            }
        }
        catch (ClassNotFoundException e) {
            LOG.debug("HighLevelModule and/or SfaOnlyExperimentModule is not available: will not be added to injector");
        }
        catch (InstantiationException e) {
            LOG.warn("Unexpected exception while loading HighLevelModule or SfaOnlyExperimentModule. Will try to continue without them.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.warn("Unexpected exception while loading HighLevelModule or SfaOnlyExperimentModule. Will try to continue without them.", (Throwable)e);
        }
        try {
            Injector injector = Guice.createInjector(mods);
            return injector;
        }
        catch (AssertionError e) {
            LOG.error("Error creating injector", (Throwable)((Object)e));
            throw new RuntimeException("Error creating injector", (Throwable)((Object)e));
        }
        catch (Exception e) {
            LOG.error("Error creating injector", (Throwable)e);
            throw new RuntimeException("Error creating injector", e);
        }
    }

    private static class TestTargetFromTestInstanceModule
    extends AbstractModule {
        private final TestInstance testInstance;

        public TestTargetFromTestInstanceModule(TestInstance testInstance) {
            this.testInstance = testInstance;
        }

        protected void configure() {
        }

        @Provides
        public TargetAuthority provideTargetAuthority(TestbedInfoSource testbedInfoSource) throws ContextFile.ContextFileException {
            boolean hasTargetServer;
            boolean bl = hasTargetServer = this.testInstance.getServerIdParameter() != null;
            if (hasTargetServer) {
                Server targetServer = testbedInfoSource.getServerById(this.testInstance.getServerIdParameter());
                assert (targetServer != null);
                return new TargetAuthority(targetServer.getDefaultComponentManagerAsGeniUrn(), targetServer, targetServer);
            }
            String stitchedAuthoritiesRaw = this.testInstance.getStringParameter("stitchedAuthorities");
            if (stitchedAuthoritiesRaw == null) {
                throw new RuntimeException("TestInstance has neither \"server\" nor \"stitchedAuthorities\". At least one of these is required.");
            }
            List<String> stitchedAuthorities = Arrays.asList(stitchedAuthoritiesRaw.split(" "));
            if (stitchedAuthorities.isEmpty() || stitchedAuthorities.get(0).trim().isEmpty()) {
                throw new RuntimeException("TestInstance \"stitchedAuthorities\" is empty.");
            }
            GeniUrn serverUrn = GeniUrn.parse((String)stitchedAuthorities.get(0).trim());
            if (serverUrn == null) {
                throw new RuntimeException("TestInstance \"stitchedAuthorities\" has invalid URN: \"" + stitchedAuthorities.get(0) + "\".");
            }
            Server targetServer = testbedInfoSource.getServerByUrn(serverUrn, TestbedInfoSource.SubAuthMatchAllowed.ALLOW_ONLY_EXACT_SUBAUTHORITY, TestbedInfoSource.SubAuthMatchPreference.PREFER_EXACT_SUBAUTHORITY, false);
            if (targetServer == null) {
                throw new RuntimeException("TestInstance \"stitchedAuthorities\" has \"" + stitchedAuthorities.get(0) + "\" which does not match a known server.");
            }
            assert (targetServer != null);
            return new TargetAuthority(targetServer.getDefaultComponentManagerAsGeniUrn(), targetServer, targetServer);
        }
    }
}

