/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.origins_service.testrunners;

import be.iminds.ilabt.jfed.fedmon.origins_service.BasicOriginsService;
import be.iminds.ilabt.jfed.fedmon.origins_service.testrunners.TestRunner;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BashTestRunner
extends TestRunner {
    private static final Logger LOG = LoggerFactory.getLogger(BashTestRunner.class);
    private Integer exitValue = null;
    private static String cachedBashLocation = null;

    public BashTestRunner(Task task, TestInstance test, Frequency testInstanceFrequency, TestInstanceStatistics testInstanceStatistics, TestDefinition testDefinition, BasicOriginsService originsService) {
        super(task, test, testInstanceFrequency, testInstanceStatistics, testDefinition, originsService);
    }

    protected String getCommand() {
        String rawCommand = this.testInstance.getStringParameterOrDefault("command", this.testDefinition);
        assert (rawCommand != null);
        LOG.debug("Raw command: " + rawCommand);
        String parsedCommand = this.replaceVariables(rawCommand, false);
        LOG.debug("Processed command: " + parsedCommand);
        return parsedCommand;
    }

    @Override
    @Nonnull
    public TestRunner.TestCallCreatedObjects runTestCall(Logger LOG, PrintWriter outputStream) {
        ResultBuilder result;
        System.out.println("Starting " + this.testInstance.getName() + " with id" + this.testInstance.getId() + " at " + new Date().getTime());
        String parsedCommand = this.getCommand();
        LOG.debug("Starting command at: " + new Date());
        LOG.debug("Command: " + parsedCommand);
        StringBuilder commandOutput = new StringBuilder();
        ArrayList<String> commands = this.createFullCommand(parsedCommand);
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder(commands);
            pb.redirectErrorStream(true);
            Process p = pb.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            p.getOutputStream().close();
            String previous = null;
            while ((line = br.readLine()) != null) {
                if (line.equals(previous)) continue;
                if (previous != null) {
                    commandOutput.append('\n');
                }
                previous = line;
                commandOutput.append(line);
            }
            LOG.debug("Command output: " + commandOutput.toString());
            try {
                LOG.debug("Waiting for command to terminate at " + new Date());
                p.waitFor();
            }
            catch (InterruptedException e) {
                LOG.warn("Received InterruptedException. Will force command termination now. " + new Date());
                p.destroy();
            }
            LOG.debug("Command exited at: " + new Date());
            this.exitValue = p.exitValue();
            LOG.debug("Exit code: " + this.exitValue);
            result = this.initResult();
            result = this.handleCommandOutput(result, commandOutput.toString());
        }
        catch (IOException ex) {
            result = this.initResult();
            result.setSummary(Result.ResultStatus.FAILURE);
            LOG.error("IOEXception at: " + new Date(), (Throwable)ex);
        }
        return new TestRunner.TestCallCreatedObjects(result);
    }

    @Override
    @Nonnull
    protected ResultBuilder initResult() {
        return this.createBasicTestResult(this.exitValue);
    }

    private static String bashLocation() {
        if (cachedBashLocation == null) {
            List<String> candidates = Arrays.asList("/usr/bin/bash", "/bin/bash", "/usr/local/bin/", "/usr/bin/sh", "/bin/sh");
            for (String candidate : candidates) {
                if (cachedBashLocation != null) break;
                if (!new File(candidate).exists()) continue;
                cachedBashLocation = candidate;
            }
            if (cachedBashLocation == null) {
                cachedBashLocation = "bash";
                LOG.warn("Could not determine bash location! Using fallback \"" + cachedBashLocation + "\"");
            }
            LOG.debug("Using bash location: \"" + cachedBashLocation + "\"");
        }
        return cachedBashLocation;
    }

    protected ArrayList<String> createFullCommand(String parsedCommand) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(BashTestRunner.bashLocation());
        commands.add("-c");
        commands.add(parsedCommand);
        return commands;
    }

    public ResultBuilder handleCommandOutput(ResultBuilder result, String commandOutput) {
        return result;
    }
}

