/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.origins_service.testrunners;

import be.iminds.ilabt.jfed.fedmon.origins_service.BasicOriginsService;
import be.iminds.ilabt.jfed.fedmon.origins_service.testrunners.BashTestRunner;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.jfed.testing.shared.AutomatedTestExternalExecutableLocations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingTestRunner
extends BashTestRunner {
    private static final Logger LOG = LoggerFactory.getLogger(PingTestRunner.class);
    private final AutomatedTestExternalExecutableLocations automatedTestExternalExecutableLocations;

    public PingTestRunner(Task task, TestInstance test, Frequency testInstanceFrequency, TestInstanceStatistics testInstanceStatistics, TestDefinition testDefinition, BasicOriginsService originsService, AutomatedTestExternalExecutableLocations automatedTestExternalExecutableLocations) {
        super(task, test, testInstanceFrequency, testInstanceStatistics, testDefinition, originsService);
        this.automatedTestExternalExecutableLocations = automatedTestExternalExecutableLocations;
    }

    @Override
    protected String getCommand() {
        Object rawCommand;
        String overrideCommand = this.testInstance.getStringParameterOrDefault("override_command", this.testDefinition);
        Boolean useProxy = this.testInstance.getBooleanParameterOrDefault("use_proxy", this.testDefinition);
        Integer timeoutMs = this.testInstance.getIntegerParameterOrDefault("timeout_ms", this.testDefinition);
        if (timeoutMs == null || timeoutMs <= 0) {
            timeoutMs = 5000;
        }
        String fpingExe = this.automatedTestExternalExecutableLocations.getExe("fping").getAbsolutePath();
        if (overrideCommand == null) {
            if (useProxy == null || !useProxy.booleanValue()) {
                rawCommand = "(" + fpingExe + " -q -t " + timeoutMs + " -C 1 <testbed.ping_host> 2>&1) | mawk '{print $3}'";
            } else {
                String proxyUsername = this.originsService.getConfig().getProxyUsername();
                String proxyHostname = this.originsService.getConfig().getProxyHostname();
                rawCommand = "ssh " + proxyUsername + "@" + proxyHostname + " '(fping -q -t " + timeoutMs + " -C 1 <testbed.ping_host> 2>&1)' | mawk '{print $3}'";
            }
        } else {
            rawCommand = overrideCommand;
        }
        LOG.debug("Raw command: " + (String)rawCommand + "\n");
        String parsedCommand = this.replaceVariables((String)rawCommand, false);
        LOG.debug("Processed command: " + parsedCommand + "\n");
        return parsedCommand;
    }

    @Override
    public ResultBuilder handleCommandOutput(ResultBuilder res, String commandOutput) {
        String pingValue;
        Integer warningThresholdMs = this.testInstance.getIntegerParameterOrDefault("warning_threshold_ms", this.testDefinition);
        if (warningThresholdMs == null || warningThresholdMs <= 0) {
            warningThresholdMs = 1000;
        }
        if ((pingValue = commandOutput) != null) {
            try {
                Double d = Double.parseDouble(pingValue.trim());
                res.addSubResult("pingValue", (Object)d);
                res.setSummary(Result.ResultStatus.FAILURE);
                if (d > 0.0) {
                    res.setSummary(Result.ResultStatus.SUCCESS);
                }
                if (d > (double)warningThresholdMs.intValue()) {
                    res.setSummary(Result.ResultStatus.WARNING);
                }
                if (d == 0.0) {
                    res.setSummary(Result.ResultStatus.WARNING);
                }
            }
            catch (NumberFormatException e) {
                res.addSubResult("pingValue", (Object)pingValue);
                res.setSummary(Result.ResultStatus.FAILURE);
            }
        } else {
            res.setSummary(Result.ResultStatus.FAILURE);
        }
        return res;
    }
}

