/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.origins_service.testrunners;

import be.iminds.ilabt.jfed.fedmon.origins_service.BasicOriginsService;
import be.iminds.ilabt.jfed.fedmon.origins_service.BasicOriginsServiceConfigIface;
import be.iminds.ilabt.jfed.fedmon.origins_service.testrunners.TestRunner;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.client.LastResultFilter;
import be.iminds.ilabt.jfed.fedmon.webapi.client.TestInstanceFilter;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpseBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.dropwizard.jackson.Jackson;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultAggregatorTestRunner
extends TestRunner {
    private static Logger LOG = LoggerFactory.getLogger(ResultAggregatorTestRunner.class);
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();

    public ResultAggregatorTestRunner(Task task, TestInstance test, Frequency testInstanceFrequency, TestInstanceStatistics testInstanceStatistics, TestDefinition testDefinition, BasicOriginsService originsService) {
        super(task, test, testInstanceFrequency, testInstanceStatistics, testDefinition, originsService);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nonnull
    public TestRunner.TestCallCreatedObjects runTestCall(Logger LOG, PrintWriter outputStream) {
        void var20_33;
        Result.ResultStatus prevAggregateStatus;
        Date lastFail;
        Date lastOk;
        ServerGlimpseBuilder glimpse;
        TestInstance rti;
        List lastResults;
        Server server;
        ResultAggregatorTestRunner.LOG = LOG;
        LOG.debug("Starting " + this.testInstance.getName() + " with id" + this.testInstance.getId() + " at " + new Date().getTime());
        Integer serverId = this.testInstance.getServerIdParameter();
        if (serverId == null) {
            throw new IllegalStateException("testinstance with invalid server: " + serverId);
        }
        try {
            server = this.originsService.getFedmonWebApiClient().getById(Server.class, (Object)serverId).orElseGet(() -> {
                throw new RuntimeException("testinstance with unknown server \"" + serverId + "\"");
            });
            assert (server != null);
            String testbedId = server.getTestbedId();
            assert (testbedId != null);
            lastResults = this.fedmonWebApiClient.search((FedmonWebApiClient.FedmonFilter)new LastResultFilter(new TestInstanceFilter(null, null, Arrays.asList("ping", "getVersion2", "getVersion3", "anyGetVersion", "listResources", "aggregateTestbedStatus", "internalStatus", "nodelogin", "nodelogin2", "repl_sum_nodelogin"), null, null, null, Collections.singletonList(testbedId), null, Optional.of(false)), true, Optional.empty(), null));
        }
        catch (FedmonWebApiClient.FedmonWebApiClientException e) {
            ResultAggregatorTestRunner.LOG.error("Caught FedmonWebApiClientException: problem reaching fedmon. Will cancel test", (Throwable)e);
            LOG.debug("Caught FedmonWebApiClientException -> problem reaching fedmon -> cancelling test");
            ResultBuilder res = this.initResult();
            res.setSummary(Result.ResultStatus.CANCELLED);
            return new TestRunner.TestCallCreatedObjects(res);
        }
        HashMap<Result, TestInstance> lastResultToTestInstance = new HashMap<Result, TestInstance>();
        for (Result tr : lastResults) {
            boolean hasServer;
            assert (tr.getTestInstanceId() != null) : "Result " + tr.getId() + " has no TestInstance id. " + tr;
            try {
                rti = (TestInstance)this.fedmonWebApiClient.get(TestInstance.class, (Object)tr.getTestInstanceId()).orElseThrow(() -> new RuntimeException("TestInstance " + tr.getTestInstanceId() + " not found for Result " + tr.getId()));
                assert (rti != null) : "TestInstance " + tr.getTestInstanceId() + " not found for Result " + tr.getId();
                assert (((Integer)rti.getId()).equals(tr.getTestInstanceId()));
                lastResultToTestInstance.put(tr, rti);
            }
            catch (FedmonWebApiClient.FedmonWebApiClientException e) {
                ResultAggregatorTestRunner.LOG.error("Caught FedmonWebApiClientException: problem reaching fedmon. Will cancel test", (Throwable)e);
                LOG.debug("Caught FedmonWebApiClientException -> problem reaching fedmon -> cancelling test");
                ResultBuilder res = this.initResult();
                res.setSummary(Result.ResultStatus.CANCELLED);
                return new TestRunner.TestCallCreatedObjects(res);
            }
            boolean bl = hasServer = rti.getServerIdParameter() != null && rti.getServerIdParameter().equals(serverId);
            assert (hasServer) : "Result " + tr.getId() + " for TestInstance " + rti.getName() + " does not contain Server with id=\"" + serverId + "\"  (serverIdParameter=" + rti.getServerIdParameter() + ")";
        }
        LOG.debug("Result Aggregator - TestInstance " + this.testInstance.getId() + " for server " + serverId);
        LOG.debug("Result Aggregator - run at: " + new Date().getTime() + " results received: " + lastResults.size());
        for (Result r : lastResults) {
            rti = (TestInstance)lastResultToTestInstance.get(r);
            assert (rti != null);
            assert (((Integer)rti.getId()).equals(r.getTestInstanceId()));
            LOG.debug("   Result " + r.getId() + ": " + r.getSummary() + " test=" + rti.getName() + " (" + r.getTestInstanceId() + ") task=" + r.getTaskId());
        }
        if (lastResults == null || this.testInstance == null || lastResults.isEmpty()) {
            throw new IllegalStateException("Something went wrong with Result Aggregator prerequisites. " + (lastResults == null) + " " + (this.testInstance == null) + " " + (Serializable)(lastResults != null ? Boolean.valueOf(lastResults.isEmpty()) : "X"));
        }
        List lastTestbedResults = lastResults;
        if (lastTestbedResults == null || lastTestbedResults.isEmpty()) {
            throw new RuntimeException("server with no results, so nothing to aggregate: " + serverId);
        }
        SingleTestData ping = new SingleTestData("ping", this.testInstance.getLongParameterOrDefault("max_allowed_ping_failures", this.testDefinition));
        SingleTestData getVersion = new SingleTestData("getVersion", this.testInstance.getLongParameterOrDefault("max_allowed_getversion_failures", this.testDefinition));
        SingleTestData internalStatus = new SingleTestData("internalStatus", this.testInstance.getLongParameterOrDefault("max_allowed_internal_failures", this.testDefinition));
        SingleTestData listResources = new SingleTestData("listResources", this.testInstance.getLongParameterOrDefault("max_allowed_listresources_failures", this.testDefinition));
        SingleTestData nodeLogin = new SingleTestData("nodelogin", Long.MAX_VALUE);
        List<SingleTestData> allTestData = Arrays.asList(ping, getVersion, internalStatus, listResources, nodeLogin);
        if (server != null) {
            glimpse = new ServerGlimpseBuilder();
            glimpse.setHealthTimestamp(new Date());
            glimpse.setServer(server);
        } else {
            glimpse = null;
        }
        Result lastAggregateResult = null;
        for (Result lastRes : lastTestbedResults) {
            TestInstance rti2 = (TestInstance)lastResultToTestInstance.get(lastRes);
            assert (rti2 != null);
            assert (((Integer)rti2.getId()).equals(lastRes.getTestInstanceId()));
            if (rti2.getTestDefinitionId() == null) {
                LOG.error("Received a test result without test definition name (cannot do anything with this): " + lastRes);
                continue;
            }
            for (SingleTestData singleTestData : allTestData) {
                if (!singleTestData.matchesTestDef(rti2.getTestDefinitionId()) || singleTestData.curResult != null && !singleTestData.curResult.getCreated().before(lastRes.getCreated()) && (singleTestData.curResult == null || !singleTestData.curResultTestInstance.getTestDefinitionId().startsWith("nodelogin") || !rti2.getTestDefinitionId().equals("repl_sum_nodelogin"))) continue;
                singleTestData.setResult(lastRes, rti2);
            }
            if (!rti2.getTestDefinitionId().equalsIgnoreCase("aggregateTestbedStatus")) continue;
            if (lastAggregateResult != null) {
                LOG.error("Multiple LAST aggregateTestbedStatus for Server " + serverId);
            }
            lastAggregateResult = lastRes;
        }
        for (SingleTestData test : allTestData) {
            if (test.curResult == null) {
                LOG.debug("   -> No result for " + test.humanName());
            }
            if (test.ok == null) {
                test.ok = true;
            }
            if (test.warnOrOk != null) continue;
            test.warnOrOk = true;
        }
        boolean allOk = true;
        boolean allWarn = true;
        Object allOkDebug = "";
        Object allWarnDebug = "";
        for (SingleTestData test : allTestData) {
            if (test == nodeLogin) continue;
            if (test == internalStatus) {
                allOk = allOk && test.isOkIgnoringExpired();
                allWarn = allWarn && test.getWarnOrOkIgnoringExpired();
            } else {
                allOk = allOk && test.isOk();
                allWarn = allWarn && test.getWarnOrOk();
            }
            allOkDebug = (String)allOkDebug + "(" + test.name + " " + test.ok + " " + test.hasExpired() + " " + test.getExpire() + ")";
            allWarnDebug = (String)allWarnDebug + "(" + test.name + " " + test.warnOrOk + " " + test.hasExpired() + " " + test.getExpire() + ")";
        }
        LOG.debug("Result Aggregator -     OK= " + allOk + " = " + (String)allOkDebug);
        LOG.debug("Result Aggregator -   WARN= " + allWarn + " = " + (String)allWarnDebug);
        String string = "";
        int MAX_STORED_FAILURE_COUNT = 10;
        if (lastAggregateResult != null) {
            String string2;
            for (SingleTestData singleTestData : allTestData) {
                singleTestData.failCount = ResultAggregatorTestRunner.fallbackWhenNull(lastAggregateResult.getNestedLongSubResult(new String[]{"parts", singleTestData.name, "failCount"}), 0L);
                singleTestData.warnCount = ResultAggregatorTestRunner.fallbackWhenNull(lastAggregateResult.getNestedLongSubResult(new String[]{"parts", singleTestData.name, "warnCount"}), 0L);
                singleTestData.prevResultId = lastAggregateResult.getNestedLongSubResult(new String[]{"parts", singleTestData.name, "lastResultId"});
            }
            String lastOkString = lastAggregateResult.getStringSubResult("lastOkDate");
            if (lastOkString != null) {
                try {
                    lastOk = RFC3339Util.rfc3339StringToDate((String)lastOkString);
                }
                catch (ParseException parseException) {
                    LOG.error("Error parsing lastOkDate: " + lastOkString, (Throwable)parseException);
                    String string3 = string + "Error parsing lastOkDate: \"" + lastOkString + "\"  err_msg=" + parseException.getMessage();
                    lastOk = null;
                }
            } else {
                lastOk = null;
            }
            if ((string2 = lastAggregateResult.getStringSubResult("lastFailDate")) != null) {
                try {
                    lastFail = RFC3339Util.rfc3339StringToDate((String)string2);
                }
                catch (ParseException parseException) {
                    void var20_31;
                    LOG.error("Error parsing lastFailDate: " + string2, (Throwable)parseException);
                    String string4 = (String)var20_31 + "Error parsing lastFailDate: \"" + string2 + "\"  err_msg=" + parseException.getMessage();
                    lastFail = null;
                }
            } else {
                lastFail = null;
            }
            prevAggregateStatus = lastAggregateResult.getSummaryStatus();
        } else {
            for (SingleTestData singleTestData : allTestData) {
                singleTestData.failCount = 0L;
                singleTestData.warnCount = 0L;
                singleTestData.prevResultId = null;
            }
            lastOk = null;
            lastFail = null;
            prevAggregateStatus = allOk ? Result.ResultStatus.SUCCESS : Result.ResultStatus.FAILURE;
        }
        for (SingleTestData singleTestData : allTestData) {
            LOG.debug("Result Aggregator -     old failCount of " + singleTestData.name + " = " + singleTestData.failCount + "  (warnCount=" + singleTestData.warnCount + ")");
        }
        LOG.debug("Result Aggregator -      dates: ok=" + lastOk + " fail=" + lastFail);
        Result.ResultStatus aggregateStatus = prevAggregateStatus;
        if (allOk) {
            aggregateStatus = Result.ResultStatus.SUCCESS;
        }
        for (SingleTestData singleTestData : allTestData) {
            if (singleTestData.ok.booleanValue()) {
                singleTestData.failCount = 0L;
                singleTestData.warnCount = 0L;
            }
            if (singleTestData.warnOrOk.booleanValue()) {
                singleTestData.failCount = 0L;
            }
            if (singleTestData.isNew() && !singleTestData.ok.booleanValue() && !singleTestData.warnOrOk.booleanValue() && singleTestData.failCount < 10L) {
                ++singleTestData.failCount;
            }
            if (singleTestData.isNew() && !singleTestData.ok.booleanValue() && singleTestData.warnCount < 10L) {
                ++singleTestData.warnCount;
            }
            if (singleTestData == nodeLogin) continue;
            if (aggregateStatus != Result.ResultStatus.FAILURE && singleTestData.warnCount > singleTestData.maxFailures) {
                aggregateStatus = Result.ResultStatus.WARNING;
            }
            if (singleTestData.failCount > singleTestData.maxFailures) {
                aggregateStatus = Result.ResultStatus.FAILURE;
            }
            if (singleTestData == internalStatus && singleTestData.hasExpired()) {
                LOG.info("internalStatus test has expired => aggregateStatus WARNING");
                if (aggregateStatus != Result.ResultStatus.FAILURE) {
                    aggregateStatus = Result.ResultStatus.WARNING;
                }
            }
            if (singleTestData == internalStatus || !singleTestData.hasExpired()) continue;
            LOG.info(singleTestData.humanName() + " test has expired => ignoring this for aggregateStatus");
        }
        if (aggregateStatus == null && !allOk) {
            aggregateStatus = allWarn ? Result.ResultStatus.WARNING : Result.ResultStatus.FAILURE;
        }
        boolean bl = !prevAggregateStatus.equals((Object)aggregateStatus);
        for (SingleTestData singleTestData : allTestData) {
            LOG.debug("Result Aggregator -     new failCount of " + singleTestData.name + " = " + singleTestData.failCount + "   new warnCount = " + singleTestData.warnCount);
        }
        LOG.debug("Result Aggregator -      " + aggregateStatus + " new: " + bl + "    (prev=" + (lastAggregateResult == null ? "lastAggregateResult==null" : lastAggregateResult.getSummary()) + ")");
        if (aggregateStatus.equals((Object)Result.ResultStatus.FAILURE)) {
            lastFail = new Date();
        }
        if (aggregateStatus.equals((Object)Result.ResultStatus.SUCCESS)) {
            lastOk = new Date();
        }
        ResultBuilder resultBuilder = this.initResult();
        for (SingleTestData test : allTestData) {
            resultBuilder.setNestedSubResult((Object)test.hasExpired(), new String[]{"parts", test.name, "expired"});
            resultBuilder.setNestedSubResult((Object)test.failCount, new String[]{"parts", test.name, "failCount"});
            resultBuilder.setNestedSubResult((Object)test.warnCount, new String[]{"parts", test.name, "warnCount"});
        }
        resultBuilder.addSubResult("newAggregateStatus", (Object)bl);
        if (var20_33 != null && !var20_33.isEmpty()) {
            ResultAggregatorTestRunner.addWarningToResult(resultBuilder, (String)var20_33);
        }
        assert (aggregateStatus != null);
        resultBuilder.setSummary(aggregateStatus);
        if (glimpse != null) {
            glimpse.setHealthStatus(aggregateStatus.name());
        }
        boolean bl2 = this.checkPlannedMaintenance(serverId);
        if (lastOk != null) {
            resultBuilder.addSubResult("lastOkDate", (Object)RFC3339Util.dateToRFC3339String((Date)lastOk));
        }
        if (aggregateStatus == Result.ResultStatus.FAILURE && prevAggregateStatus != Result.ResultStatus.SUCCESS && lastAggregateResult != null) {
            long failTime = resultBuilder.getCreated().getTime() - lastAggregateResult.getCreated().getTime();
            if (bl2) {
                LOG.info("Ignoring failure ({} ms failTime), because testbed is in maintenance. (This is just a safety, the webapi should not save this data anyway, due to the maintenance)", (Object)failTime);
                failTime = 0L;
            } else {
                LOG.debug("thisFailTimeMs == ", (Object)failTime);
            }
            resultBuilder.addSubResult("thisFailTimeMs", (Object)failTime);
        } else {
            LOG.debug("thisFailTimeMs == 0 -> status=" + aggregateStatus + " prevStatus=" + prevAggregateStatus + " lastRes=" + (lastAggregateResult == null ? "null" : "non-null"));
            resultBuilder.addSubResult("thisFailTimeMs", (Object)0);
        }
        if (lastFail != null) {
            resultBuilder.addSubResult("lastFailDate", (Object)RFC3339Util.dateToRFC3339String((Date)lastFail));
            long okTimeMs = resultBuilder.getCreated().getTime() - lastFail.getTime();
            if (aggregateStatus == Result.ResultStatus.SUCCESS) {
                resultBuilder.addSubResult("okTimeMs", (Object)okTimeMs);
            }
        } else {
            resultBuilder.addSubResult("okTimeMs", (Object)1000);
        }
        if (aggregateStatus != Result.ResultStatus.SUCCESS) {
            resultBuilder.addSubResult("okTimeMs", (Object)0);
        }
        for (SingleTestData singleTestData : allTestData) {
            if (singleTestData.curResultId == null) continue;
            resultBuilder.setNestedSubResult((Object)singleTestData.curResultId, new String[]{"parts", singleTestData.name, "lastResultId"});
        }
        try {
            this.addHealth(resultBuilder, allTestData, aggregateStatus, glimpse);
        }
        catch (FedmonWebApiClient.FedmonWebApiClientException e) {
            ResultAggregatorTestRunner.LOG.error("Caught FedmonWebApiClientException: problem reaching fedmon. Will not add health.", (Throwable)e);
            LOG.debug("Caught FedmonWebApiClientException -> problem reaching fedmon ->  Will not add health.");
        }
        catch (Throwable t) {
            LOG.error("There was an error calculating the testbed health. Will not add any health.", t);
        }
        try {
            String extraEmailDetails = "Date: " + resultBuilder.getCreated() + "  (= " + RFC3339Util.dateToRFC3339String((Date)resultBuilder.getCreated()) + ")\n";
            for (SingleTestData test : allTestData) {
                if (test == nodeLogin) continue;
                extraEmailDetails = !test.hasExpired() ? (test.ok.booleanValue() ? extraEmailDetails + test.humanName() + " test: OK" : (test.warnOrOk.booleanValue() ? extraEmailDetails + test.humanName() + " test: WARNING " + test.warnCount + " consecutive warnings (and " + test.failCount + " consecutive failures)" : extraEmailDetails + test.humanName() + " test: FAIL " + test.failCount + " consecutive failures")) : extraEmailDetails + test.humanName() + " test: TIMEOUT = FAIL (there was no test result within the expected time, so considering this test a failure)";
                extraEmailDetails = extraEmailDetails + "\n";
                this.addCustomEmailContent(extraEmailDetails);
            }
        }
        catch (Throwable t) {
            LOG.error("Exception while preparing email body. (Will probably send only partial email body, but will certainly continue storing result) ", t);
        }
        TestRunner.TestCallCreatedObjects res = new TestRunner.TestCallCreatedObjects(resultBuilder);
        if (glimpse != null) {
            res.addServerGlimpse(glimpse);
            ServerGlimpseBuilder serverGlimpseBuilder = glimpse;
            res.addOnResultIdKnownCallback(result -> finalGlimpse.setHealthResult(result));
        }
        return res;
    }

    private static boolean mostlyTheSame(Result a, Result b) {
        if (Objects.equals(a, b)) {
            return true;
        }
        if (b == null || !Objects.equals(a.getClass(), b.getClass())) {
            return false;
        }
        SortedMap aRes = a.getResults();
        SortedMap bRes = b.getResults();
        if (aRes == null && bRes != null) {
            return false;
        }
        if (aRes != null) {
            ObjectNode bObjectNode;
            ObjectNode aObjectNode;
            HashMap aresults = new HashMap(aRes);
            HashMap bresults = new HashMap(bRes);
            aresults.remove("lastOkDate");
            aresults.remove("lastFailDate");
            bresults.remove("lastOkDate");
            bresults.remove("lastFailDate");
            try {
                String aJsonString = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(aresults);
                String bJsonString = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(bresults);
                aObjectNode = (ObjectNode)MAPPER.readValue(aJsonString, ObjectNode.class);
                bObjectNode = (ObjectNode)MAPPER.readValue(bJsonString, ObjectNode.class);
            }
            catch (IOException e) {
                throw new RuntimeException("failed to compare old result with new (should never happen, so probably bug in ResultAggregatorTestRunner.mostlyTheSame)", e);
            }
            if (!aObjectNode.equals((Object)bObjectNode)) {
                return false;
            }
        }
        return a.getSummary().equals(b.getSummary());
    }

    @Override
    @Nonnull
    protected ResultBuilder initResult() {
        return this.createBasicTestResult(null);
    }

    private static String makeTimesString(int times) {
        if (times <= 0) {
            return "never";
        }
        if (times == 1) {
            return "once";
        }
        if (times == 2) {
            return "twice";
        }
        return times + " times";
    }

    private void addHealth(ResultBuilder testResult, List<SingleTestData> allTestData, Result.ResultStatus aggregateStatus, ServerGlimpseBuilder glimpse) throws IOException, FedmonWebApiClient.FedmonWebApiClientException {
        TestInstanceStatistics.RrdStatistics testStatistics;
        String explanation;
        boolean aggStatusWarnNow;
        assert (aggregateStatus != null);
        HealthCalcSettings healthCalcSettings = new HealthCalcSettings(this.originsService.getConfig());
        int totalPercent = 100;
        LOG.debug("addHealth() init totalPercent=" + totalPercent);
        ArrayList<Object> explanationShort = new ArrayList<Object>();
        ArrayList<Object> explanationFull = new ArrayList<Object>();
        Result nodeLoginResult = null;
        TestInstance nodeLoginResultTestInstance = null;
        for (SingleTestData test : allTestData) {
            if (!test.humanName().equalsIgnoreCase("nodelogin") || test.curResult == null || test.curResult.getSummary() == null) continue;
            nodeLoginResult = test.curResult;
            assert (test.curResultTestInstance != null);
            nodeLoginResultTestInstance = test.curResultTestInstance;
        }
        boolean loginDownNow = nodeLoginResult != null && nodeLoginResult.getSummaryStatus() == Result.ResultStatus.FAILURE;
        boolean aggStatusDownNow = aggregateStatus == Result.ResultStatus.FAILURE;
        boolean bl = aggStatusWarnNow = aggregateStatus == Result.ResultStatus.WARNING;
        if (nodeLoginResult != null) {
            if (loginDownNow) {
                explanation = "The last login test failed.";
                explanationShort.add(explanation);
                explanationFull.add(explanation);
            } else {
                explanationFull.add("The last login test succeeded.");
            }
            if (loginDownNow && healthCalcSettings.loginNowDownMulti != -1) {
                totalPercent = totalPercent * healthCalcSettings.loginNowDownMulti / 100;
                LOG.debug("addHealth() post loginNowDownMulti totalPercent=" + totalPercent);
            }
            if (aggStatusDownNow && loginDownNow && healthCalcSettings.bothNowDownMulti != -1) {
                totalPercent = totalPercent * healthCalcSettings.bothNowDownMulti / 100;
                LOG.debug("addHealth() post bothNowDownMulti totalPercent=" + totalPercent);
            }
        }
        if (aggStatusDownNow) {
            explanation = "The AM is down right now.";
            explanationShort.add(explanation);
            explanationFull.add(explanation);
        } else if (aggStatusWarnNow) {
            explanation = "The AM is currently up, but the AM's internal monitoring has stopped reporting.";
            explanationShort.add(explanation);
            explanationFull.add(explanation);
        } else {
            explanationFull.add("The AM is currently up.");
        }
        if (aggStatusWarnNow && healthCalcSettings.aggNowWarnMulti != -1) {
            totalPercent = totalPercent * healthCalcSettings.aggNowWarnMulti / 100;
            LOG.debug("addHealth() post aggNowWarnMulti totalPercent=" + totalPercent);
        }
        if (aggStatusDownNow && healthCalcSettings.aggNowDownMulti != -1) {
            totalPercent = totalPercent * healthCalcSettings.aggNowDownMulti / 100;
            LOG.debug("addHealth() post aggNowDownMulti totalPercent=" + totalPercent);
        }
        Optional nodeLoginTestInstanceStatistics = Optional.empty();
        if (nodeLoginResult != null && nodeLoginResult.getTestInstanceId() != null && nodeLoginResult.getTestInstanceId() != null) {
            nodeLoginTestInstanceStatistics = this.fedmonWebApiClient.getTestInstanceStatisticsByTestInstanceId(nodeLoginResult.getTestInstanceId());
        }
        if (!nodeLoginTestInstanceStatistics.isPresent() || ((TestInstanceStatistics)nodeLoginTestInstanceStatistics.get()).getRrdStatistics() == null) {
            if (!nodeLoginTestInstanceStatistics.isPresent()) {
                if (nodeLoginResult == null) {
                    LOG.debug("No nodelogin found: will ignore nodelogin for health calculation");
                } else {
                    LOG.debug("No nodelogin TestInstance found (bug!): falling back to simple nodelogin health calculation");
                }
            } else {
                LOG.warn("RRD activated, but nodelogin TestInstance does not have testStatistics: falling back to simple nodelogin health calculation");
            }
            LOG.debug("RRD statistics not available for this nodelogin instance: falling back to simple nodelogin health calculation.");
            if (nodeLoginResult != null) {
                int loginPercent = switch (nodeLoginResult.getSummaryStatus()) {
                    case Result.ResultStatus.SUCCESS -> 100;
                    case Result.ResultStatus.WARNING -> 50;
                    default -> 0;
                };
                if (totalPercent != 0) {
                    totalPercent = loginPercent;
                }
                LOG.debug("addHealth() post { if (totalPercent != 0) totalPercent = loginPercent; }  totalPercent=" + totalPercent + "   loginPercent=" + loginPercent);
            }
        } else {
            String explanation2;
            TestInstanceStatistics testInstanceStatistics = (TestInstanceStatistics)nodeLoginTestInstanceStatistics.get();
            assert (Objects.equals(testInstanceStatistics.getTestInstanceId(), nodeLoginResult.getTestInstanceId())) : "TestInstance id mismatch -> " + testInstanceStatistics.getTestInstanceId() + " != " + nodeLoginResult.getTestInstanceId();
            testStatistics = testInstanceStatistics.getRrdStatistics();
            LOG.debug("addHealth() Got NodeLogin TestInstanceStatistics: " + testInstanceStatistics);
            double dayTotal = testStatistics.getDayTotal();
            if (loginDownNow && dayTotal == 0.0) {
                dayTotal = 1.0;
                LOG.debug("addHealth() login  loginDownNow && dayTotal == 0 -> dayTotal = 1");
            }
            LOG.debug("addHealth() login totalLoginDownTimesDay=" + dayTotal);
            LOG.debug("addHealth() login totalLoginDownTimesWeek=" + testStatistics.getWeekTotal());
            LOG.debug("addHealth() login totalLoginDownTimesMonth=" + testStatistics.getMonthTotal());
            boolean warnNow = nodeLoginResult != null && nodeLoginResult.getSummaryStatus() == Result.ResultStatus.WARNING;
            LOG.debug("addHealth() login loginDownNow=" + loginDownNow);
            LOG.debug("addHealth() login warnNow=" + warnNow);
            LOG.debug("addHealth() start totalPercent=" + totalPercent);
            if (healthCalcSettings.loginDayDownMulti != -1) {
                if (dayTotal > 0.0) {
                    totalPercent = totalPercent * healthCalcSettings.loginDayDownMulti / 100;
                    LOG.debug("addHealth() post loginDayDownMulti totalPercent=" + totalPercent);
                    String explanation22 = "The login test failed at least " + ResultAggregatorTestRunner.makeTimesString((int)Math.floor(dayTotal)) + " in the last 24 hour.";
                    explanationShort.add(explanation22);
                    explanationFull.add(explanation22);
                } else if (!loginDownNow) {
                    explanationFull.add("The login test has not failed in the last 24 hours.");
                }
            }
            if (healthCalcSettings.loginWeekDownMulti != -1) {
                if (testStatistics.getWeekTotal() > 0.0) {
                    totalPercent = totalPercent * healthCalcSettings.loginWeekDownMulti / 100;
                    LOG.debug("addHealth() post loginWeekDownMulti totalPercent=" + totalPercent);
                    explanation2 = "The login test failed at least " + ResultAggregatorTestRunner.makeTimesString((int)Math.floor(testStatistics.getWeekTotal())) + " in the last 7 days";
                    explanationShort.add(explanation2);
                    explanationFull.add(explanation2);
                } else if (dayTotal > 0.0 || loginDownNow) {
                    explanationFull.add("The login test did not fail in the last 7 days (excluding last 24 hours).");
                } else {
                    explanationFull.add("The login test did not fail in the last 7 days.");
                }
            }
            if (healthCalcSettings.loginMonthDownMulti != -1) {
                if (testStatistics.getMonthTotal() > 0.0) {
                    totalPercent = totalPercent * healthCalcSettings.loginMonthDownMulti / 100;
                    LOG.debug("addHealth() post loginMonthDownMulti totalPercent=" + totalPercent);
                    explanation2 = "The login test failed at least " + ResultAggregatorTestRunner.makeTimesString((int)Math.floor(testStatistics.getMonthTotal())) + " in the last 31 days";
                    explanationShort.add(explanation2);
                    explanationFull.add(explanation2);
                } else if (testStatistics.getWeekTotal() > 0.0 || dayTotal > 0.0 || loginDownNow) {
                    explanationFull.add("The login test did not fail (except as mentioned above) in the last 31 days.");
                } else {
                    explanationFull.add("The login test did not fail in the last 31 days.");
                }
            }
            LOG.debug("addHealth() login totalPercent=" + totalPercent);
            LOG.debug("addHealth() login explanationShort=" + explanationShort);
            LOG.debug("addHealth() login explanationFull=" + explanationFull);
        }
        Optional aggStatusTestInstanceStatistics = Optional.empty();
        if (this.testInstance.getId() != null) {
            aggStatusTestInstanceStatistics = this.fedmonWebApiClient.getTestInstanceStatisticsByTestInstanceId((Integer)this.testInstance.getId());
        }
        if (!aggStatusTestInstanceStatistics.isPresent() || ((TestInstanceStatistics)aggStatusTestInstanceStatistics.get()).getRrdStatistics() == null) {
            if (!aggStatusTestInstanceStatistics.isPresent()) {
                LOG.debug("test instance not found (bug!): falling back to simple aggregateStatus health calculation");
            } else {
                LOG.warn("RRD activated, but did not find statistics in TestInstance: falling back to simple aggregateStatus health calculation");
            }
            int aggPercent = aggregateStatus == Result.ResultStatus.SUCCESS ? 100 : 0;
            totalPercent = (aggPercent + totalPercent) / 2;
            LOG.debug("addHealth() post ((aggPercent + totalPercent) / 2)  totalPercent=" + totalPercent + "   aggPercent=" + aggPercent);
        } else {
            String explanation3;
            testStatistics = ((TestInstanceStatistics)aggStatusTestInstanceStatistics.get()).getRrdStatistics();
            LOG.debug("addHealth() Got aggStatus TestInstanceStatistics: " + this.testInstanceStatistics);
            double totalDownTimeDay = testStatistics.getDayTotal();
            double totalDownTimeWeek = testStatistics.getWeekTotal();
            double totalDownTimeMonth = testStatistics.getMonthTotal();
            LOG.debug("addHealth() agg totalAggStatusDownTimeDay=" + totalDownTimeDay);
            LOG.debug("addHealth() agg totalAggStatusDownTimeWeek=" + totalDownTimeWeek);
            LOG.debug("addHealth() agg totalAggStatusDownTimeMonth=" + totalDownTimeMonth);
            boolean downNow = aggregateStatus == Result.ResultStatus.FAILURE;
            LOG.debug("addHealth() agg aggStatusDownNow=" + downNow);
            if (healthCalcSettings.aggDayDownMulti != -1) {
                if (totalDownTimeDay > 0.0) {
                    totalPercent = totalPercent * healthCalcSettings.aggDayDownMulti / 100;
                    LOG.debug("addHealth() post aggDayDownMulti totalPercent=" + totalPercent);
                    String explanation32 = "The AM has been down in the last 24 hours for " + ResultAggregatorTestRunner.makeTimePrettyForUser(Math.round(totalDownTimeDay / 1000.0));
                    explanationShort.add(explanation32);
                    explanationFull.add(explanation32);
                } else if (downNow) {
                    explanationFull.add("In the last 24 hours, the AM was has not been down before.");
                } else {
                    explanationFull.add("The AM has not been down the last 24 hours.");
                }
            }
            if (healthCalcSettings.aggWeekDownMulti != -1) {
                if (totalDownTimeWeek > 0.0) {
                    totalPercent = totalPercent * healthCalcSettings.aggWeekDownMulti / 100;
                    LOG.debug("addHealth() post aggWeekDownMulti totalPercent=" + totalPercent);
                    explanation3 = "The AM has been down in the last 7 days for " + ResultAggregatorTestRunner.makeTimePrettyForUser(Math.round((totalDownTimeWeek + totalDownTimeDay) / 1000.0));
                    explanationShort.add(explanation3);
                    explanationFull.add(explanation3);
                } else if (totalDownTimeDay > 0.0 || downNow) {
                    explanationFull.add("The AM has not been down in the last 7 days (excluding last 24 hours).");
                } else {
                    explanationFull.add("The AM has not been down in the last 7 days.");
                }
            }
            if (healthCalcSettings.aggMonthDownMulti != -1) {
                if (totalDownTimeMonth > 0.0) {
                    totalPercent = totalPercent * healthCalcSettings.aggMonthDownMulti / 100;
                    LOG.debug("addHealth() post aggMonthDownMulti totalPercent=" + totalPercent);
                    explanation3 = "The AM has been down in the last 31 days for " + ResultAggregatorTestRunner.makeTimePrettyForUser(Math.round((totalDownTimeMonth + totalDownTimeWeek + totalDownTimeDay) / 1000.0));
                    explanationShort.add(explanation3);
                    explanationFull.add(explanation3);
                } else if (totalDownTimeWeek > 0.0 || totalDownTimeDay > 0.0 || downNow) {
                    explanationFull.add("The AM has not been down (except as mentioned above) in the last 31 days.");
                } else {
                    explanationFull.add("The AM has not been down in the last 31 days.");
                }
            }
            LOG.debug("addHealth() agg totalPercent=" + totalPercent);
            LOG.debug("addHealth() agg explanationShort=" + explanationShort);
            LOG.debug("addHealth() agg explanationFull=" + explanationFull);
        }
        LOG.debug("addHealth() FINAL totalPercent=" + totalPercent);
        testResult.setNestedSubResult((Object)totalPercent, new String[]{"testbedHealth", "percent"});
        if (glimpse != null) {
            glimpse.setHealth(Integer.valueOf(totalPercent));
        }
        if (!explanationFull.isEmpty()) {
            Object explanation4 = "";
            for (String string : explanationFull) {
                explanation4 = (String)explanation4 + string + "\n";
            }
            testResult.setNestedSubResult(explanation4, new String[]{"testbedHealth", "fullExplanation"});
            if (glimpse != null) {
                glimpse.setHealthExplanationFull((String)explanation4);
            }
        }
        if (!explanationShort.isEmpty()) {
            Object explanation5 = "";
            for (String string : explanationShort) {
                explanation5 = (String)explanation5 + string + "\n";
            }
            testResult.setNestedSubResult(explanation5, new String[]{"testbedHealth", "explanation"});
            if (glimpse != null) {
                glimpse.setHealthExplanation((String)explanation5);
            }
        }
    }

    public static String makeTimePrettyForUser(long timeS) {
        if (timeS == 60L) {
            return "1m";
        }
        if (timeS == 3600L) {
            return "1h";
        }
        if (timeS == 86400L) {
            return "1day";
        }
        if (timeS == 604800L) {
            return "1week";
        }
        if (timeS == 2678400L) {
            return "1month";
        }
        if (timeS == 31622400L) {
            return "1year";
        }
        if (timeS < 60L) {
            return String.format("%.2ds", timeS);
        }
        if (timeS < 3600L) {
            return String.format("%.2fm", (double)timeS / 60.0);
        }
        if (timeS < 86400L) {
            return String.format("%.2fh", (double)timeS / 3600.0);
        }
        if (timeS < 2678400L) {
            return String.format("%.2fdays", (double)timeS / 86400.0);
        }
        if (timeS < 31622400L) {
            return String.format("%.2fmonths", (double)timeS / 2678400.0);
        }
        return String.format("%.2fyears", (double)timeS / 3.16224E7);
    }

    private class SingleTestData {
        public final long maxFailures;
        @Nonnull
        public final String name;
        public Boolean ok = null;
        public Boolean warnOrOk = null;
        public Long curResultId = null;
        public Result curResult = null;
        public TestInstance curResultTestInstance = null;
        public Long prevResultId = null;
        long failCount = -1L;
        long warnCount = -1L;

        public SingleTestData(String name, long maxFailures) {
            this.name = name;
            this.maxFailures = maxFailures;
        }

        public boolean isNew() {
            return this.prevResultId == null || this.curResultId != null && !this.curResultId.equals(this.prevResultId);
        }

        public boolean hasExpired() {
            if (this.curResult == null) {
                return false;
            }
            if (this.curResult.getExpire() == null) {
                return false;
            }
            return this.curResult.getExpire().before(new Date());
        }

        public Date getExpire() {
            if (this.curResult == null) {
                return null;
            }
            return this.curResult.getExpire();
        }

        public boolean isOk() {
            return this.ok != false && !this.hasExpired();
        }

        public boolean isOkIgnoringExpired() {
            return this.ok;
        }

        public boolean getWarnOrOk() {
            return (this.ok != false || this.warnOrOk != false) && !this.hasExpired();
        }

        public boolean getWarnOrOkIgnoringExpired() {
            return this.ok != false || this.warnOrOk != false;
        }

        public String humanName() {
            if (this.name.length() == 0) {
                return this.name;
            }
            if (this.name.length() == 1) {
                return this.name.toUpperCase();
            }
            return Character.toUpperCase(this.name.charAt(0)) + this.name.substring(1);
        }

        public boolean matchesTestDef(@Nullable String testDefinitionName) {
            if (testDefinitionName == null) {
                return false;
            }
            assert (this.name != null);
            return testDefinitionName.toLowerCase().contains(this.name.toLowerCase());
        }

        public void setResult(Result lastRes, TestInstance lastResTestInstance) {
            assert (lastRes != null);
            assert (lastResTestInstance != null);
            assert (lastRes.getTestInstanceId().equals(lastResTestInstance.getId()));
            if (this.curResultTestInstance != null) {
                LOG.warn("a Result for TestDefinition " + this.name + " was already seen (ti.id=" + this.curResultTestInstance.getId() + "). Will ignore it and use this one (ti.id=" + lastResTestInstance.getId() + ").");
            }
            this.ok = lastRes.getSummaryStatus().equals((Object)Result.ResultStatus.SUCCESS);
            this.warnOrOk = lastRes.getSummaryStatus().equals((Object)Result.ResultStatus.SUCCESS) || lastRes.getSummaryStatus().equals((Object)Result.ResultStatus.WARNING);
            if (this.name.equalsIgnoreCase("ListResources") && this.warnOrOk.booleanValue() && !this.ok.booleanValue()) {
                this.ok = true;
            }
            this.curResultId = (Long)lastRes.getId();
            this.curResult = lastRes;
            this.curResultTestInstance = lastResTestInstance;
            assert (this.curResultTestInstance != null);
            assert (this.curResult.getTestInstanceId().equals(this.curResultTestInstance.getId()));
            LOG.debug("   - Result for " + this.humanName() + " is " + lastRes.getId() + " " + lastRes.getSummary() + "  ok=" + this.ok + " warn=" + this.warnOrOk);
        }
    }

    public class HealthCalcSettings {
        public final int aggNowDownMulti;
        public final int aggNowWarnMulti;
        public final int aggDayDownMulti;
        public final int aggWeekDownMulti;
        public final int aggMonthDownMulti;
        public final int loginNowDownMulti;
        public final int loginDayDownMulti;
        public final int loginWeekDownMulti;
        public final int loginMonthDownMulti;
        public final int bothNowDownMulti;
        private final BasicOriginsServiceConfigIface originsServiceConfig;

        public HealthCalcSettings(BasicOriginsServiceConfigIface originsServiceConfig) {
            this.originsServiceConfig = originsServiceConfig;
            this.aggNowDownMulti = this.helper(0, "aggNowDownMulti");
            this.aggNowWarnMulti = this.helper(95, "aggNowWarnMulti");
            this.aggDayDownMulti = this.helper(70, "aggDayDownMulti");
            this.aggWeekDownMulti = this.helper(-1, "aggWeekDownMulti");
            this.aggMonthDownMulti = this.helper(-1, "aggMonthDownMulti");
            this.loginNowDownMulti = this.helper(-1, "loginNowDownMulti");
            this.loginDayDownMulti = this.helper(60, "loginDayDownMulti");
            this.loginWeekDownMulti = this.helper(80, "loginWeekDownMulti");
            this.loginMonthDownMulti = this.helper(90, "loginMonthDownMulti");
            this.bothNowDownMulti = this.helper(-1, "bothNowDownMulti");
        }

        private int helper(int defaultValue, String propKey) {
            String propVal = this.originsServiceConfig.getProperty(propKey, null);
            if (propVal != null) {
                try {
                    return Integer.parseInt(propVal.trim());
                }
                catch (NumberFormatException e) {
                    LOG.error("Invalid int in properties: " + propKey + "=\"" + propVal + "\" (will fall back to default of " + defaultValue + ")");
                }
            }
            return defaultValue;
        }
    }
}

