/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.origins_service.testrunners;

import be.iminds.ilabt.jfed.fedmon.origins_service.BasicOriginsService;
import be.iminds.ilabt.jfed.fedmon.origins_service.testrunners.TestRunner;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.client.LastResultFilter;
import be.iminds.ilabt.jfed.fedmon.webapi.client.TestInstanceFilter;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Log;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.User;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserBuilder;
import be.iminds.ilabt.jfed.highlevel.call_log_output.CallReport;
import be.iminds.ilabt.jfed.highlevel.call_log_output.CallReportFactory;
import be.iminds.ilabt.jfed.highlevel.call_log_output.CallReportWriter;
import be.iminds.ilabt.jfed.log.ResultListener;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.util.common.Slf4jHelper;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithUri;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Address;

public class SelfTest
extends TestRunner {
    private static final Logger LOG = LoggerFactory.getLogger(SelfTest.class);
    private final TestbedInfoSource testbedInfoSource;
    private final AuthorityFinder authorityFinder;
    private final CallReportFactory callReportFactory;
    private final CallReportWriter callReportWriter;

    public SelfTest(Task task, TestInstance test, Frequency testInstanceFrequency, TestInstanceStatistics testInstanceStatistics, TestDefinition testDefinition, BasicOriginsService originsService, TestbedInfoSource testbedInfoSource, AuthorityFinder authorityFinder, CallReportFactory callReportFactory, CallReportWriter callReportWriter) {
        super(task, test, testInstanceFrequency, testInstanceStatistics, testDefinition, originsService);
        this.testbedInfoSource = testbedInfoSource;
        this.authorityFinder = authorityFinder;
        this.callReportFactory = callReportFactory;
        this.callReportWriter = callReportWriter;
    }

    @Override
    @Nonnull
    public TestRunner.TestCallCreatedObjects runTestCall(Logger testLog, PrintWriter outputStream) {
        Result.ResultStatus status;
        CallReport callReport = this.callReportFactory.createCallReport("SelfTest Details", "SelfTest");
        CallReport.State reportState = callReport.getCurState();
        Logger LOG = Slf4jHelper.createMultiplexLogger((Logger[])new Logger[]{testLog, reportState});
        LOG.debug("Starting SelfTest at " + new Date());
        try {
            be.iminds.ilabt.jfed.log.Logger logger = new be.iminds.ilabt.jfed.log.Logger();
            logger.addResultListener((ResultListener)reportState);
            List<String> resolveTargets = (List<String>)this.testInstance.getParameter("resolve_targets");
            Object pingTargets = (List)this.testInstance.getParameter("ping_targets");
            List<Integer> requiredTestInstanceIds = (List<Integer>)this.testInstance.getParameter("required_test_id");
            if (resolveTargets == null) {
                resolveTargets = Collections.emptyList();
            }
            if (pingTargets == null) {
                pingTargets = Collections.emptyList();
            }
            if (requiredTestInstanceIds == null) {
                requiredTestInstanceIds = Collections.emptyList();
            }
            status = Result.ResultStatus.SUCCESS;
            for (String resolveTarget : resolveTargets) {
                boolean resolveSuccess;
                String resolvedIp;
                resolveTarget = resolveTarget.trim();
                try {
                    InetAddress addr = Address.getByName((String)resolveTarget);
                    resolvedIp = addr == null ? null : addr.getHostAddress();
                    resolveSuccess = addr != null;
                }
                catch (UnknownHostException e) {
                    resolvedIp = null;
                    resolveSuccess = false;
                    LOG.warn("Host  '" + resolveTarget + "' failed to resolve", (Throwable)e);
                }
                if (resolveSuccess) {
                    LOG.info("Host  '" + resolveTarget + "' resolved to IP: " + resolvedIp);
                    continue;
                }
                LOG.error("Host  '" + resolveTarget + "' failed to resolve");
                status = Result.ResultStatus.FAILURE;
            }
            Iterator<String> iterator = pingTargets.iterator();
            while (iterator.hasNext()) {
                boolean pingResult;
                String pingTarget = iterator.next();
                pingTarget = pingTarget.trim();
                try {
                    InetAddress target = InetAddress.getByName(pingTarget);
                    pingResult = target.isReachable(2000);
                }
                catch (IOException e) {
                    pingResult = false;
                    LOG.warn("Host '" + pingTarget + "' ping encountered exception", (Throwable)e);
                }
                LOG.info("Host  '" + pingTarget + "' ping result: " + pingResult);
                if (pingResult) continue;
                status = Result.ResultStatus.FAILURE;
            }
            List lastResults = this.fedmonWebApiClient.search((FedmonWebApiClient.FedmonFilter)new LastResultFilter(new TestInstanceFilter(requiredTestInstanceIds), false, Optional.empty(), null));
            Map testResultsByInstanceId = lastResults.stream().collect(Collectors.toMap(Result::getTestInstanceId, Function.identity()));
            LOG.debug("Queried web service for " + requiredTestInstanceIds.size() + " results. Received " + lastResults.size() + " test results. Mapped to " + testResultsByInstanceId.size() + " results: " + testResultsByInstanceId.keySet());
            for (Integer testInstanceId : requiredTestInstanceIds) {
                boolean testSuccess;
                Result tr = (Result)testResultsByInstanceId.get(testInstanceId);
                if (tr == null) {
                    LOG.warn("No result for test " + testInstanceId);
                    continue;
                }
                boolean bl = testSuccess = !tr.getSummary().equalsIgnoreCase(Result.ResultStatus.FAILURE.name());
                if (testSuccess) {
                    LOG.info("Test " + testInstanceId + " test is ok: " + tr.getSummary());
                    continue;
                }
                LOG.error("Test " + testInstanceId + " test is NOT OK: " + tr.getSummary() + " expired=" + SelfTest.hasExpired(tr) + ")");
                status = Result.ResultStatus.FAILURE;
            }
            boolean checkExpired = true;
            if (checkExpired) {
                List expiredResults = this.fedmonWebApiClient.search((FedmonWebApiClient.FedmonFilter)new LastResultFilter(new TestInstanceFilter(Collections.singletonList("prod"), null, Arrays.asList("anyGetVersion", "getVersion2", "getVersion3", "listResources", "ping"), null, null, null, null, null, Optional.of(false)), false, Optional.of(true), null));
                boolean testSuccess = expiredResults.isEmpty();
                if (testSuccess) {
                    LOG.info("There are no expired tests.");
                } else {
                    if (expiredResults.size() == 1) {
                        LOG.warn("There is one expired test: result id=" + ((Result)expiredResults.get(0)).getId() + " ti=" + ((Result)expiredResults.get(0)).getTestInstanceId());
                    } else {
                        Object ids = "";
                        for (Result tr : expiredResults) {
                            ids = (String)ids + " " + tr.getId();
                        }
                        LOG.warn("There are " + expiredResults.size() + " expired tests (considering this a self test at least a WARNING): result_id's =" + (String)ids);
                    }
                    if (status != Result.ResultStatus.FAILURE) {
                        status = Result.ResultStatus.WARNING;
                    }
                }
            }
        }
        catch (FedmonWebApiClient.FedmonWebApiClientException e) {
            SelfTest.LOG.error("Caught FedmonWebApiClientException: problem reaching fedmon. Will cancel test", (Throwable)e);
            LOG.debug("Caught FedmonWebApiClientException -> problem reaching fedmon -> cancelling test");
            status = Result.ResultStatus.CANCELLED;
        }
        catch (Throwable e) {
            status = Result.ResultStatus.FAILURE;
            LOG.error("Caught unexpected \"" + e.getClass().getName() + "\":", e);
            SelfTest.LOG.error("Caught unexpected \"" + e.getClass().getName() + "\"", e);
        }
        LOG.debug("Finished Self Test at " + new Date());
        try {
            List<String> targetUserIds = (List<String>)this.testInstance.getParameter("target_users");
            if (targetUserIds == null) {
                targetUserIds = Collections.emptyList();
            }
            boolean selfTestHasFailed = status.equals((Object)Result.ResultStatus.FAILURE);
            for (String userId : targetUserIds) {
                Optional userOpt = this.fedmonWebApiClient.get(User.class, (Object)userId);
                User user = (User)userOpt.orElseThrow(() -> new RuntimeException("selftest config wrong: There is no user \"" + userId + "\""));
                if (user.getSelfTestFailed() != selfTestHasFailed) {
                    UserBuilder updatedUser = new UserBuilder(user);
                    updatedUser.setSelfTestFailed(Boolean.valueOf(selfTestHasFailed));
                    this.fedmonWebApiClient.update((JsonLdObjectWithUri)updatedUser.create());
                    LOG.info("Updated selfTestFailed to " + selfTestHasFailed + " for User \"" + userId + "\"");
                    continue;
                }
                LOG.info("Already correct selfTestFailed=" + selfTestHasFailed + " for User \"" + userId + "\"");
            }
            LOG.info("Checked selfTestFailed for " + targetUserIds.size() + " Users");
        }
        catch (FedmonWebApiClient.FedmonWebApiClientException e) {
            status = Result.ResultStatus.FAILURE;
            LOG.error("While updating user(s), caught unexpected \"" + ((Object)((Object)e)).getClass().getName() + "\":", (Throwable)e);
            SelfTest.LOG.error("While updating user(s), caught unexpected \"" + ((Object)((Object)e)).getClass().getName() + "\"", (Throwable)e);
        }
        this.addCustomEmailContent("Test log:\n\n" + reportState.getLogLines().stream().map(l -> l.getType() + (l.getType().toString().length() == 4 ? "   " : "  ") + l.getText()).collect(Collectors.joining("\n")));
        ResultBuilder testResult = this.initResult();
        testResult.setSummary(status);
        TestRunner.TestCallCreatedObjects testCallCreatedObjects = new TestRunner.TestCallCreatedObjects(testResult);
        try {
            String reportOutputHtml = callReport.toHtmlString(false);
            testCallCreatedObjects.addLog("htmlLogUrl", "selftest_log.html", reportOutputHtml, Log.LogMediaType.HTML, null);
        }
        catch (Throwable e) {
            LOG.error("Error writing HTML report", e);
        }
        try {
            String reportOutputXml = this.callReportWriter.writeCallReportToString(callReport, false);
            testCallCreatedObjects.addLog("xmlLogUrl", "selftest_log.xml", reportOutputXml, Log.LogMediaType.XML, null);
        }
        catch (Throwable e) {
            LOG.error("Error writing XML report", e);
        }
        return testCallCreatedObjects;
    }

    public static boolean hasExpired(Result tr) {
        if (tr == null) {
            return false;
        }
        if (tr.getExpire() == null) {
            return false;
        }
        return tr.getExpire().before(new Date());
    }

    @Override
    @Nonnull
    protected ResultBuilder initResult() {
        return this.createBasicTestResult(null);
    }
}

