/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.origins_service.testrunners;

import be.iminds.ilabt.jfed.fedmon.origins_service.BasicOriginsService;
import be.iminds.ilabt.jfed.fedmon.origins_service.OriginsServiceConfig;
import be.iminds.ilabt.jfed.fedmon.origins_service.OriginsServiceConfigIface;
import be.iminds.ilabt.jfed.fedmon.origins_service.ResultUploader;
import be.iminds.ilabt.jfed.fedmon.origins_service.TeeStreamPrintWriter;
import be.iminds.ilabt.jfed.fedmon.origins_service.time_debugging.TestCallTimingDebugger;
import be.iminds.ilabt.jfed.fedmon.origins_service.util.EmailSender;
import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.client.LastResultFilter;
import be.iminds.ilabt.jfed.fedmon.webapi.client.TestInstanceFilter;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Admin;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Log;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.LogBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.MaintenanceInfo;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Organisation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpseBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TaskBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestEmailConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestEmailConfigBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.User;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.jfed.util.common.Slf4jHelper;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import be.iminds.ilabt.jfed.util.common.ThreadFactoryUtil;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithUri;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.internet.AddressException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestRunner
implements Callable<ResultBuilder> {
    private static final Logger LOG = LoggerFactory.getLogger(TestRunner.class);
    @Nonnull
    protected final TaskBuilder task;
    @Nonnull
    protected final TestInstance testInstance;
    @Nullable
    protected final Frequency testInstanceFrequency;
    @Nonnull
    protected final TestInstanceStatistics testInstanceStatistics;
    @Nonnull
    protected final TestDefinition testDefinition;
    @Nonnull
    protected final BasicOriginsService originsService;
    @Nonnull
    protected final ResultUploader resultUploader;
    @Nonnull
    protected final FedmonWebApiClient fedmonWebApiClient;
    private TestCallTimingDebugger timingDebugger;
    private int seqNumber;
    private boolean seqNumberSet;
    private long startTime;
    private long stopTime;
    private boolean started = false;
    private boolean completed = false;
    private boolean expired = false;
    private Future<ResultBuilder> future = null;
    private final AtomicBoolean refusesToStop = new AtomicBoolean(false);
    private Logger both_log = LOG;
    private static final ScheduledExecutorService timeoutExecutor = Executors.newScheduledThreadPool(3, ThreadFactoryUtil.getFactory((String)"testrunner-timeout-pool"));
    private boolean finishedTaskSpecificPart = false;
    private static final String LOG_NAME = "console_log.txt";
    private Log consoleLog;
    @Nullable
    private StringWriter testConsoleWriter;
    @Nullable
    private PrintWriter testConsolePrintWriter;
    @Nullable
    private Logger testLogger;
    private final AtomicBoolean runTestCallReturned = new AtomicBoolean(false);
    private final AtomicBoolean finishedCall = new AtomicBoolean(false);
    @Nonnull
    private String emailCustomContent = "";
    private Boolean cachedInPlannedMaintenance = null;

    public TestRunner(@Nonnull Task task, @Nonnull TestInstance testInstance, @Nullable Frequency testInstanceFrequency, @Nonnull TestInstanceStatistics testInstanceStatistics, @Nonnull TestDefinition testDefinition, @Nonnull BasicOriginsService originsService) {
        assert (task != null);
        assert (testInstance != null);
        assert (testInstanceStatistics != null);
        assert (testDefinition != null);
        assert (originsService != null);
        this.task = new TaskBuilder(task);
        this.testInstance = testInstance;
        this.testInstanceFrequency = testInstanceFrequency;
        this.testInstanceStatistics = testInstanceStatistics;
        this.testDefinition = testDefinition;
        this.originsService = originsService;
        this.fedmonWebApiClient = originsService.getFedmonWebApiClient();
        this.resultUploader = originsService.getResultUploader();
        this.seqNumberSet = false;
        if (originsService.getConfig() instanceof OriginsServiceConfig && !((OriginsServiceConfigIface)originsService.getConfig()).getTestInstanceFilter().matchesVersion(testInstance.getTestVersion())) {
            throw new RuntimeException("Version mismatch bug! " + testInstance.getTestVersion());
        }
        assert (this.fedmonWebApiClient != null);
        assert (this.resultUploader != null);
        assert (testInstance.getId() != null) : "testInstance.getId() == null";
        assert (task.getTestInstanceId() != null) : "task.getTestInstanceId() == null";
        assert (task.getTestInstanceId().equals(testInstance.getId())) : task.getTestInstanceId() + " != " + testInstance.getId() + "   (task.getId()=" + task.getId() + ")";
        assert (testDefinition.getId() != null) : "testDefinition.getId() == null";
        assert (((String)testDefinition.getId()).equals(testInstance.getTestDefinitionId())) : (String)testDefinition.getId() + " != " + testInstance.getTestDefinitionId();
        assert (testInstanceFrequency == null || testInstanceFrequency.getId() != null) : "testInstanceFrequency.getId() == null";
        assert (testInstanceFrequency == null || ((Integer)testInstanceFrequency.getId()).equals(testInstance.getFrequencyId())) : "testInstanceFrequency.getId() (" + testInstanceFrequency.getId() + ") != testInstance.getFrequencyId() (" + testInstance.getFrequencyId() + ")";
        assert (testInstanceStatistics == null || testInstanceStatistics.getTestInstanceId() != null);
        assert (testInstanceStatistics == null || testInstanceStatistics.getTestInstanceId().equals(testInstance.getId())) : "testInstanceStatistics.getTestInstanceId() (" + testInstanceStatistics.getTestInstanceId() + ") != testInstance.getId() (" + testInstance.getId() + ")";
        String taskid = "" + task.getId();
    }

    public void setSeqNumber(int seqNumber) {
        this.seqNumber = seqNumber;
        this.seqNumberSet = true;
    }

    @Nonnull
    public Task getTask() {
        return this.task.create();
    }

    @Nonnull
    public TestInstance getTestInstance() {
        return this.testInstance;
    }

    @Nullable
    public Frequency getFrequency() {
        return this.testInstanceFrequency;
    }

    @Nonnull
    public TestInstanceStatistics getTestInstanceStatistics() {
        return this.testInstanceStatistics;
    }

    @Nonnull
    public TestDefinition getTestDefinition() {
        return this.testDefinition;
    }

    @Nonnull
    public FedmonWebApiClient getFedmonWebApiClient() {
        return this.fedmonWebApiClient;
    }

    @Nonnull
    public String getTestDefinitionName() {
        return this.testInstance.getTestDefinitionId();
    }

    public void setTimingDebugger(TestCallTimingDebugger timingDebugger) {
        this.timingDebugger = timingDebugger;
    }

    public String getTestDescription() {
        assert (this.testInstance != null);
        return "id=" + this.testInstance.getId() + " => name=\"" + this.testInstance.getName() + "\"";
    }

    public void cancelTask() {
        try {
            this.task.setState(Task.State.CANCELLED);
            if (this.task.getDeadline() == null) {
                this.task.setDeadline(Clock.nowDate());
            }
            this.task.setResult(null);
            this.task.setStop(Clock.nowDate());
            this.fedmonWebApiClient.update((JsonLdObjectWithUri)this.task.create());
        }
        catch (FedmonWebApiClient.FedmonWebApiClientException updateEx) {
            LOG.error("Failed to update Task to CANCELLED state", (Throwable)updateEx);
            try {
                this.fedmonWebApiClient.delete((JsonLdObjectWithUri)this.task.create());
            }
            catch (FedmonWebApiClient.FedmonWebApiClientException deleteEx) {
                LOG.error("Failed to delete Task", (Throwable)deleteEx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultBuilder call() {
        this.started = true;
        if (this.originsService.getConfig() instanceof OriginsServiceConfig && !((OriginsServiceConfigIface)this.originsService.getConfig()).getTestInstanceFilter().matchesVersion(this.testInstance.getTestVersion())) {
            this.completed = true;
            throw new RuntimeException("Version mismatch bug! " + this.testInstance.getTestVersion());
        }
        try {
            ResultBuilder testResult;
            boolean noResult;
            TestCallCreatedObjects testCallCreatedObjects;
            ScheduledFuture<?> scheduledTimeout;
            TimeoutTask timeoutTask;
            block85: {
                ResultBuilder e3;
                if (this.timingDebugger != null) {
                    this.timingDebugger.informStartTaskExecution();
                    this.timingDebugger.timeStartPhase(TestCallTimingDebugger.TestCallPhase.INIT);
                }
                this.startTime = System.currentTimeMillis();
                System.out.println("START      " + this.getClass().getName());
                assert (this.testDefinition != null);
                Instant start = Instant.now();
                long timeoutMs = this.testDefinition.getMaxTestDurationMs();
                long tryStopGraceTimeMs = 120000L;
                long totalTimeoutMs = tryStopGraceTimeMs + timeoutMs;
                Instant timeoutInstant = start.plus(totalTimeoutMs, ChronoUnit.MILLIS);
                if (Thread.interrupted()) {
                    LOG.warn("TestRunner Thread was interrupted before it really started. Will stop now.");
                    this.cancelTask();
                    ResultBuilder resultBuilder = null;
                    return resultBuilder;
                }
                if (timeoutMs > 0L) {
                    try {
                        if (this.timingDebugger != null) {
                            this.timingDebugger.informTimeoutTaskExecutionValue(timeoutMs, TimeUnit.MILLISECONDS);
                        }
                        timeoutTask = new TimeoutTask(Thread.currentThread(), this, this.refusesToStop, timeoutInstant);
                        ScheduledExecutorService scheduledExecutorService = timeoutExecutor;
                        synchronized (scheduledExecutorService) {
                            scheduledTimeout = timeoutExecutor.schedule(timeoutTask, timeoutMs, TimeUnit.MILLISECONDS);
                        }
                        LOG.debug("Scheduled TimeoutTask with deadline in {} ms", (Object)timeoutMs);
                    }
                    catch (Exception e2) {
                        LOG.error("Failed to schedule TimeoutTask", (Throwable)e2);
                        scheduledTimeout = null;
                        timeoutTask = null;
                    }
                } else {
                    scheduledTimeout = null;
                    timeoutTask = null;
                }
                if (Thread.interrupted()) {
                    LOG.warn("TestRunner Thread was interrupted before it really started. Will stop now.");
                    this.cancelTask();
                    if (scheduledTimeout != null) {
                        timeoutTask.cancelled = true;
                        try {
                            scheduledTimeout.cancel(false);
                        }
                        catch (Exception e3) {
                            this.both_log.error("Failed to cancel TimeoutTask", (Throwable)e3);
                        }
                    }
                    e3 = null;
                    return e3;
                }
                if (this.timingDebugger != null) {
                    this.timingDebugger.timeSwitchPhase(TestCallTimingDebugger.TestCallPhase.INIT, TestCallTimingDebugger.TestCallPhase.TASK_REGISTER);
                }
                try {
                    Log requestedLog = new LogBuilder().setName(LOG_NAME).setLive(Boolean.valueOf(false)).setMediaType(Log.LogMediaType.TEXT).setStartTime(Clock.nowTimestamp()).create();
                    this.consoleLog = (Log)this.fedmonWebApiClient.create((JsonLdObjectWithUri)requestedLog);
                    if (this.consoleLog != null && this.consoleLog.getContent() != null) {
                        this.testConsoleWriter = new StringWriter();
                        PrintWriter ps = new PrintWriter(this.testConsoleWriter);
                        String copyTestOutputToStdout = this.originsService.getConfig().getProperty("copyTestOutputToStdout");
                        if (copyTestOutputToStdout != null && copyTestOutputToStdout.equalsIgnoreCase("true")) {
                            TeeStreamPrintWriter tee = new TeeStreamPrintWriter(ps, System.out, "UTF-8");
                            this.testConsolePrintWriter = tee;
                        } else {
                            this.testConsolePrintWriter = ps;
                        }
                        assert (this.testConsoleWriter != null);
                        assert (this.testConsolePrintWriter != null);
                    } else {
                        LOG.error("Error creating console_log.txt Log on server. Will not make log!");
                        this.testLogger = LOG;
                        throw new RuntimeException("Error creating console_log.txt Log on server. Will give up test run.");
                    }
                    this.testLogger = Slf4jHelper.createPrintWriterLogger((PrintWriter)this.testConsolePrintWriter, (Slf4jHelper.Level)Slf4jHelper.Level.DEBUG);
                    this.task.setLog(this.consoleLog.getContent().toASCIIString());
                }
                catch (FedmonWebApiClient.FedmonWebApiClientException e4) {
                    this.both_log.error("Failure contacting fedmon to set up console log", (Throwable)e4);
                    throw e4;
                }
                catch (IOException e5) {
                    LOG.error("Error setting up test logging streams. Will abort", (Throwable)e5);
                    try {
                        if (this.testConsolePrintWriter != null) {
                            this.testConsolePrintWriter.close();
                        }
                        if (this.testConsoleWriter != null) {
                            this.testConsoleWriter.close();
                        }
                    }
                    catch (IOException e2) {
                        LOG.warn("Error closing file output stream. (ignored)", (Throwable)e2);
                    }
                    this.testConsoleWriter = null;
                    this.testConsolePrintWriter = null;
                    this.testLogger = null;
                    this.task.setLog("Error setting up logger");
                    throw e5;
                }
                this.both_log = Slf4jHelper.createMultiplexLogger((Logger[])new Logger[]{this.testLogger, LOG});
                if (Thread.interrupted()) {
                    LOG.warn("TestRunner Thread was interrupted before it really started. Will stop now.");
                    if (!this.finishedCall.get()) {
                        this.cancelTask();
                    }
                    if (scheduledTimeout != null) {
                        timeoutTask.cancelled = true;
                        try {
                            scheduledTimeout.cancel(false);
                        }
                        catch (Exception e6) {
                            this.both_log.error("Failed to cancel TimeoutTask", (Throwable)e6);
                        }
                    }
                    e3 = null;
                    return e3;
                }
                try {
                    this.task.setStart(Date.from(start));
                    this.task.setDeadline(Date.from(timeoutInstant));
                    this.task.setState(Task.State.RUNNING);
                    this.both_log.debug("Changing Task from CREATED to RUNNING, and setting timeout to " + TimeUnit.MILLISECONDS.toMinutes(totalTimeoutMs) + " minutes...");
                    this.fedmonWebApiClient.update((JsonLdObjectWithUri)this.task.create());
                }
                catch (FedmonWebApiClient.FedmonWebApiClientException e7) {
                    this.both_log.error("Failure updating task before start", (Throwable)e7);
                    throw new RuntimeException("Failure updating task before start. Will abort run.");
                }
                catch (Exception e8) {
                    this.both_log.error("Failure updating task before start", (Throwable)e8);
                    throw new RuntimeException("Failure updating task before start. Will abort run.");
                }
                if (this.timingDebugger != null) {
                    this.timingDebugger.timeSwitchPhase(TestCallTimingDebugger.TestCallPhase.TASK_REGISTER, TestCallTimingDebugger.TestCallPhase.TASK_SPECIFIC);
                }
                if (Thread.interrupted()) {
                    LOG.warn("TestRunner Thread was interrupted before it really started. Will stop now.");
                    if (!this.finishedCall.get()) {
                        this.cancelTask();
                    }
                    if (scheduledTimeout != null) {
                        timeoutTask.cancelled = true;
                        try {
                            scheduledTimeout.cancel(false);
                        }
                        catch (Exception e9) {
                            this.both_log.error("Failed to cancel TimeoutTask", (Throwable)e9);
                        }
                    }
                    e3 = null;
                    return e3;
                }
                testCallCreatedObjects = null;
                noResult = false;
                try {
                    this.both_log.debug("Calling runTestCall @ " + RFC3339Util.instantToRFC3339String((Instant)Instant.now()));
                    testCallCreatedObjects = this.runTestCall(this.testLogger, this.testConsolePrintWriter);
                    this.runTestCallReturned.set(true);
                    assert (testCallCreatedObjects != null);
                    testResult = testCallCreatedObjects.getResultBuilder();
                    this.both_log.debug("runTestCall returned @ " + RFC3339Util.instantToRFC3339String((Instant)Instant.now()));
                    boolean wasRefusingToStop = this.refusesToStop.getAndSet(false);
                    if (wasRefusingToStop) {
                        LOG.warn("This TestRunner WAS refusing to stop, but has stopped now! Will continue by handling it's result.");
                    }
                    if (testResult == null) {
                        if (this.testLogger != null) {
                            this.testLogger.error("Framework failure: runTestCall() returned null instead of Result.");
                        }
                        testResult = this.safeInitResult();
                        testResult.setSummary(Result.ResultStatus.FAILURE);
                    }
                    testResult = this.handleEmail(testResult);
                    if (this.consoleLog != null && this.consoleLog.getContent() != null && testResult.getLogUrl() == null) {
                        testResult.setLogUrl(this.consoleLog.getContent().toASCIIString());
                    }
                }
                catch (InterruptedException e10) {
                    this.both_log.error("An InterruptedException occured in runTestCall()", (Throwable)e10);
                    if (this.testLogger != null) {
                        this.testLogger.error("Framework failure: An InterruptedException occured in runTestCall()", (Throwable)e10);
                    }
                    testResult = this.safeInitResult();
                    testResult.setSummary(Result.ResultStatus.FAILURE);
                    if (this.consoleLog != null && this.consoleLog.getContent() != null && testResult.getLogUrl() == null) {
                        testResult.setLogUrl(this.consoleLog.getContent().toASCIIString());
                    }
                }
                catch (NoTestResult e11) {
                    this.both_log.info("A test threw a NoTestResult exception");
                    testResult = null;
                    noResult = true;
                }
                catch (ThreadDeath ex) {
                    LOG.error("A call() caught ThreadDeath in runTestCall(). runTestCall() must have hanged. Will not retrow ThreadDeath but handle this as a InterruptedException.", (Throwable)ex);
                    testResult = this.safeInitResult();
                    testResult.setSummary(Result.ResultStatus.FAILURE);
                    if (this.consoleLog != null && this.consoleLog.getContent() != null && testResult.getLogUrl() == null) {
                        testResult.setLogUrl(this.consoleLog.getContent().toASCIIString());
                    }
                }
                catch (Throwable t) {
                    this.both_log.error("An exception occured in runTestCall()", t);
                    if (this.testLogger != null) {
                        this.testLogger.error("Framework failure: An exception occured in runTestCall()", t);
                    }
                    testResult = this.safeInitResult();
                    testResult.setSummary(Result.ResultStatus.FAILURE);
                    if (this.consoleLog == null || this.consoleLog.getContent() == null || testResult.getLogUrl() != null) break block85;
                    testResult.setLogUrl(this.consoleLog.getContent().toASCIIString());
                }
            }
            this.completed = true;
            this.refusesToStop.set(false);
            ResultBuilder resultBuilder = this.finishCall(scheduledTimeout, timeoutTask, testResult, noResult, testCallCreatedObjects);
            return resultBuilder;
        }
        catch (Throwable t) {
            this.completed = true;
            this.both_log.error("Uncaught exception in TestRunner.call() Will cancel Task.", t);
            if (!this.finishedCall.get()) {
                try {
                    this.cancelTask();
                }
                catch (Exception e) {
                    this.both_log.error("Failure aborting task after uncaught exception in TestRunner. Will abort run.", (Throwable)e);
                    throw new RuntimeException("Failure aborting task after uncaught exception in TestRunner. Will abort run.", e);
                }
            }
            this.refusesToStop.set(false);
            throw new RuntimeException("Unhandled exception in TestRunner.call()", t);
        }
        finally {
            if (this.timingDebugger != null) {
                this.timingDebugger.timeStopPhase(TestCallTimingDebugger.TestCallPhase.FINISH);
                this.timingDebugger.informStopTaskExecution();
            }
            this.both_log.debug("TestRunner.call() finished.");
            try {
                if (this.testConsolePrintWriter != null) {
                    this.testConsolePrintWriter.close();
                    this.testConsolePrintWriter = null;
                }
                if (this.testConsoleWriter != null) {
                    this.testConsoleWriter.close();
                    this.testConsoleWriter = null;
                }
            }
            catch (IOException e) {
                this.both_log.warn("Error closing file output stream. (ignored)", (Throwable)e);
            }
            this.refusesToStop.set(false);
        }
    }

    @Nonnull
    private ResultBuilder finishExpiredCall() {
        if (this.finishedCall.get()) {
            this.both_log.error("The Task has expired. However, it seems to have finished now anyway, so we don't need to commit a FAILED result.");
        } else {
            this.both_log.error("The Task has expired. Commiting FAILED result.");
        }
        if (this.testLogger != null) {
            this.testLogger.error("The Task has expired. Commiting FAILED result.");
        }
        ResultBuilder testResult = this.safeInitResult();
        testResult.setSummary(Result.ResultStatus.FAILURE);
        if (this.consoleLog != null && this.consoleLog.getContent() != null && testResult.getLogUrl() == null) {
            testResult.setLogUrl(this.consoleLog.getContent().toASCIIString());
        }
        testResult = this.handleEmail(testResult);
        return this.finishCall(null, null, testResult, false, null);
    }

    @Nonnull
    private ResultBuilder finishCall(@Nullable ScheduledFuture<?> scheduledTimeout, @Nullable TimeoutTask timeoutTask, @Nonnull ResultBuilder testResult, boolean noResult, @Nullable TestCallCreatedObjects testCallCreatedObjects) {
        if (!this.finishedCall.compareAndSet(false, true)) {
            LOG.debug("finishCall() requested, but already ran. (from Thread " + Thread.currentThread().getName() + ")");
            throw new IllegalStateException("finishCall() requested, but already ran.");
        }
        LOG.debug("finishCall() called from Thread " + Thread.currentThread().getName());
        if (testCallCreatedObjects == null) {
            testCallCreatedObjects = new TestCallCreatedObjects(testResult);
        }
        assert (testResult != null || noResult);
        assert (testCallCreatedObjects != null || noResult);
        try {
            this.finishedTaskSpecificPart = true;
            if (this.timingDebugger != null) {
                this.timingDebugger.timeStopAnyPhase();
                this.timingDebugger.timeStartPhase(TestCallTimingDebugger.TestCallPhase.FINISH);
            }
            this.stopTime = System.currentTimeMillis();
            long durationMs = this.stopTime - this.startTime;
            testResult.setTask((Long)this.task.getId(), null);
            testResult.setNestedSubResult((Object)this.startTime, new String[]{"timing", "startTimeMsSinceEpoch"});
            testResult.setNestedSubResult((Object)this.stopTime, new String[]{"timing", "stopTimeMsSinceEpoch"});
            testResult.setNestedSubResult((Object)durationMs, new String[]{"timing", "durationMs"});
            testCallCreatedObjects.setTaskId((Long)this.task.getId());
            if (!noResult) {
                this.both_log.debug("Uploading Task Result...");
                this.getResultUploader().addToQueue(testCallCreatedObjects);
            } else {
                this.both_log.debug("NOT uploading Task Result. noResult=" + noResult + " testCallCreatedObjects==null -> " + (testCallCreatedObjects == null) + " testResult==null -> " + (testResult == null));
            }
            if (scheduledTimeout != null) {
                if (timeoutTask != null) {
                    timeoutTask.cancelled = true;
                }
                try {
                    scheduledTimeout.cancel(false);
                }
                catch (Exception e) {
                    this.both_log.error("Failed to cancel TimeoutTask", (Throwable)e);
                }
            }
            long durationPartMs = durationMs % 1000L;
            long durationPartS = durationMs / 1000L;
            long durationPartMin = durationPartS / 60L;
            String durationString = durationPartMin + " min " + (durationPartS %= 60L) + " s " + durationPartMs + " ms   (= " + durationMs + " ms)";
            if (!noResult) {
                this.both_log.info("Task FINISHED   " + this.getClass().getName() + " -> " + testResult.getSummary() + "    duration: " + durationString);
            } else {
                this.both_log.info("Task FINISHED (NO RESULT)  " + this.getClass().getName() + " -> " + testResult.getSummary() + "    duration: " + durationString);
            }
            try {
                if (this.testConsolePrintWriter != null) {
                    this.testConsolePrintWriter.flush();
                }
                if (this.testConsoleWriter != null) {
                    this.testConsoleWriter.flush();
                    if (this.consoleLog != null) {
                        try {
                            this.fedmonWebApiClient.appendStringContent(this.consoleLog, this.testConsoleWriter.toString());
                        }
                        catch (FedmonWebApiClient.FedmonWebApiClientException e) {
                            LOG.error("Failed to upload consoleLog using URI " + this.consoleLog.getContent() + " of log " + this.consoleLog.getUri(), (Throwable)e);
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Error trying to write console. Will ignore.");
            }
            ResultBuilder resultBuilder = testResult;
            return resultBuilder;
        }
        catch (Throwable t) {
            this.both_log.error("Uncaught exception in TestRunner.finishCall. Will cancel Task.", t);
            try {
                this.cancelTask();
            }
            catch (Exception e) {
                this.both_log.error("Failure aborting task after uncaught exception in TestRunner. Will abort run.", (Throwable)e);
                throw new RuntimeException("Failure aborting task after uncaught exception in TestRunner. Will abort run.", e);
            }
            throw new RuntimeException("Unhandled exception in TestRunner.call()", t);
        }
        finally {
            if (this.timingDebugger != null) {
                this.timingDebugger.timeStopPhase(TestCallTimingDebugger.TestCallPhase.FINISH);
                this.timingDebugger.informStopTaskExecution();
            }
            this.both_log.debug("TestRunner.call() finished.");
            try {
                if (this.testConsolePrintWriter != null) {
                    this.testConsolePrintWriter.close();
                    this.testConsolePrintWriter = null;
                }
                if (this.testConsoleWriter != null) {
                    this.testConsoleWriter.close();
                    this.testConsoleWriter = null;
                }
            }
            catch (IOException e) {
                this.both_log.warn("Error closing file output stream. (ignored)", (Throwable)e);
            }
        }
    }

    @Nonnull
    public abstract TestCallCreatedObjects runTestCall(Logger var1, PrintWriter var2) throws InterruptedException, NoTestResult;

    @Nullable
    public Boolean useAltEmailAddresses() {
        Admin adminConf;
        try {
            adminConf = this.fedmonWebApiClient.getAdminConfig();
        }
        catch (FedmonWebApiClient.FedmonWebApiClientException e) {
            this.both_log.error("Error getting admin config", (Throwable)e);
            return null;
        }
        if (adminConf == null) {
            this.both_log.error("Error getting admin config: adminConf=null");
            return null;
        }
        if (adminConf.getDisableEmails().booleanValue()) {
            this.both_log.debug("Admin option disable_emails set");
            return null;
        }
        boolean res = adminConf.getUseAltEmails();
        this.both_log.debug("Using alternative email addresses: " + res);
        return res;
    }

    public boolean isRefusingToStop() {
        return this.refusesToStop.get();
    }

    @Nonnull
    private ResultBuilder handleEmail(@Nonnull ResultBuilder r) {
        Boolean useAltEmailAddresses;
        try {
            useAltEmailAddresses = this.useAltEmailAddresses();
        }
        catch (Throwable t) {
            this.both_log.error("Exception while fetching admin config before handling email. Will ignore this. Mail might be disabled however.", t);
            r.setNestedSubResult((Object)("Exception while fetching admin config before handling email. Will ignore this. Mail might be disabled however.\n" + TextUtil.exceptionToString((Throwable)t)), new String[]{"mail", "initError"});
            useAltEmailAddresses = true;
        }
        if (useAltEmailAddresses == null) {
            this.both_log.warn("Could not determine \"useAltEmailAddresses\" -> Skipping sending emails.");
            return r;
        }
        try {
            List<String> emailAdressesList;
            Result.ResultStatus testStatus = r.getSummaryStatus();
            TestEmailConfig instanceTestEmailConfig = this.testInstance.getEmailParameter();
            TestEmailConfigBuilder emailConfigBuilder = instanceTestEmailConfig == null ? new TestEmailConfigBuilder() : new TestEmailConfigBuilder(instanceTestEmailConfig);
            if (this.getTestDefinition().getParameter("email") != null && this.getTestDefinition().getParameter("email").getDefaultValue() != null) {
                Object definitionEmailConfigObject = this.getTestDefinition().getParameter("email").getDefaultValue();
                if (definitionEmailConfigObject instanceof TestEmailConfig) {
                    TestEmailConfig definitionEmailConfig = (TestEmailConfig)definitionEmailConfigObject;
                    emailConfigBuilder.fillInDefaults(definitionEmailConfig);
                } else {
                    this.both_log.warn("TestDefinition parameter \"email\" is instance of class \"" + definitionEmailConfigObject.getClass().getName() + "\" instead of instance of TestEmailConfig -> Skipping sending emails.");
                    return r;
                }
            }
            emailConfigBuilder.fillInDefaults(new TestEmailConfigBuilder().setLimits(Integer.valueOf(24), Integer.valueOf(12)).setAddresses(Collections.singletonList("ADD_TESTBED_EMAILS")).create());
            TestEmailConfig testEmailConfig = emailConfigBuilder.create();
            Integer serverId = this.testInstance.getServerIdParameter();
            Testbed testbed = null;
            Organisation organisation = null;
            if (serverId != null) {
                try {
                    Server server = this.fedmonWebApiClient.get(Server.class, (Object)serverId).orElse(null);
                    testbed = server == null || server.getTestbedId() == null ? null : (Testbed)this.fedmonWebApiClient.get(Testbed.class, (Object)server.getTestbedId()).orElse(null);
                    organisation = testbed == null || testbed.getOrganisationId() == null ? null : (Organisation)this.fedmonWebApiClient.get(Organisation.class, (Object)testbed.getOrganisationId()).orElse(null);
                }
                catch (FedmonWebApiClient.FedmonWebApiClientException e) {
                    this.both_log.error("Error getting Testbed or Organisation for Server " + serverId + " -> will ignore", (Throwable)e);
                }
            }
            if ((emailAdressesList = useAltEmailAddresses != false ? this.completeEmailAddresses(testEmailConfig.getAltAddresses(), organisation, testbed) : this.completeEmailAddresses(testEmailConfig.getAddresses(), organisation, testbed)).isEmpty()) {
                this.both_log.warn("Will skip sending emails, because no emails specified: " + emailAdressesList);
                return r;
            }
            this.both_log.debug("Email settings: triggerCount=" + (Serializable)(testEmailConfig.getTriggers() == null ? "null" : Integer.valueOf(testEmailConfig.getTriggers().size())) + " emailAdressesList=" + emailAdressesList);
            List previousResults = null;
            Result.ResultStatus previousStatus = null;
            TestEmailConfig.Trigger activatedTrigger = null;
            if (testEmailConfig.getTriggers() != null && !testEmailConfig.getTriggers().isEmpty()) {
                boolean requiresPrevResultInfo = false;
                for (TestEmailConfig.Trigger trigger : testEmailConfig.getTriggers()) {
                    if (!trigger.getOnlyForFirstOrDefault()) continue;
                    requiresPrevResultInfo = true;
                    break;
                }
                if (requiresPrevResultInfo) {
                    try {
                        previousResults = this.fedmonWebApiClient.search((FedmonWebApiClient.FedmonFilter)new LastResultFilter(new TestInstanceFilter(((Integer)this.testInstance.getId()).intValue()), false, Optional.empty(), Arrays.asList("SUCCESS", "FAILURE")));
                        this.both_log.debug("Received " + previousResults.size() + " previous result of this test instance.");
                        assert (previousResults.size() <= 1);
                        for (Result tr : previousResults) {
                            assert (Objects.equals(tr.getTestInstanceId(), this.testInstance.getId()));
                            previousStatus = tr.getSummaryStatus();
                        }
                        this.both_log.debug("previousStatus=" + previousStatus);
                    }
                    catch (Throwable e) {
                        this.both_log.error("Failed to fetch previous test result. Cannot determine if this is a new state.", e);
                    }
                }
                boolean newStatus = previousStatus == null || !testStatus.equals(previousStatus);
                boolean newFailureOrSuccess = newStatus && (testStatus.equals((Object)Result.ResultStatus.FAILURE) || testStatus.equals((Object)Result.ResultStatus.SUCCESS));
                this.both_log.debug("requiresPrevResultInfo=" + requiresPrevResultInfo + "  newStatus=" + newStatus + "  newFailureOrSuccess=" + newFailureOrSuccess);
                for (TestEmailConfig.Trigger trigger : testEmailConfig.getTriggers()) {
                    assert (trigger.getRequiredStatus() != null);
                    if (TestRunner.sameStatus(testStatus, trigger.getRequiredStatus()) == trigger.getNegationOrDefault() || !newFailureOrSuccess && trigger.getOnlyForFirstOrDefault() || trigger.getOnlyForFirstOrDefault() && trigger.getNegationOrDefault() && (previousStatus == null || !TestRunner.sameStatus(previousStatus, trigger.getRequiredStatus()))) continue;
                    this.both_log.debug("    -> Trigger activated: " + trigger);
                    if (activatedTrigger != null && (!trigger.getOnlyForFirstOrDefault() && activatedTrigger.getOnlyForFirstOrDefault() || trigger.getNegationOrDefault() && !activatedTrigger.getNegationOrDefault())) continue;
                    activatedTrigger = trigger;
                }
            }
            this.both_log.debug(" sendEmails=" + (activatedTrigger != null) + " automatedTesterStatus=" + testStatus + "   activatedTrigger=" + activatedTrigger);
            if (activatedTrigger != null) {
                if (previousResults == null) {
                    previousResults = this.fedmonWebApiClient.search((FedmonWebApiClient.FedmonFilter)new LastResultFilter(new TestInstanceFilter(((Integer)this.testInstance.getId()).intValue()), true, Optional.empty(), null));
                }
                long emailCountDay = 0L;
                long emailCountHour = 0L;
                if (previousResults != null) {
                    String curHour;
                    String curDay;
                    SimpleDateFormat dayFormat = new SimpleDateFormat("yyyy-MM-dd");
                    SimpleDateFormat hourFormat = new SimpleDateFormat("yyyy-MM-dd HH:00:00");
                    String lastDay = null;
                    String lastHour = null;
                    for (Result tr : previousResults) {
                        emailCountDay = Math.max(TestRunner.fallbackWhenNull(tr.getNestedLongSubResult(new String[]{"email", "countDay"}), 0L), emailCountDay);
                        emailCountHour = Math.max(TestRunner.fallbackWhenNull(tr.getNestedLongSubResult(new String[]{"email", "countHour"}), 0L), emailCountHour);
                        lastDay = dayFormat.format(tr.getCreated());
                        lastHour = hourFormat.format(tr.getCreated());
                    }
                    Date now = new Date();
                    if (lastDay != null && !lastDay.equals(curDay = dayFormat.format(now))) {
                        emailCountDay = 0L;
                    }
                    if (lastHour != null && !lastHour.equals(curHour = hourFormat.format(now))) {
                        emailCountHour = 0L;
                    }
                }
                if (testEmailConfig.getLimits() == null || testEmailConfig.getLimits().getMaxPerHour() == null || testEmailConfig.getLimits().getMaxPerDay() == null) {
                    throw new RuntimeException("bug in TestRunner code: email limits should have been set");
                }
                int maxEmailsPerHour = testEmailConfig.getLimits().getMaxPerHour();
                int maxEmailsPerDay = testEmailConfig.getLimits().getMaxPerDay();
                boolean limitExceeded = false;
                boolean limitAlmostExceeded = false;
                if (maxEmailsPerHour > 0 && emailCountHour >= (long)maxEmailsPerHour) {
                    limitExceeded = true;
                }
                if (maxEmailsPerDay > 0 && emailCountDay >= (long)maxEmailsPerDay) {
                    limitExceeded = true;
                }
                if (maxEmailsPerHour > 0 && emailCountHour == (long)(maxEmailsPerHour - 1)) {
                    limitAlmostExceeded = true;
                }
                if (maxEmailsPerDay > 0 && emailCountDay == (long)(maxEmailsPerDay - 1)) {
                    limitAlmostExceeded = true;
                }
                if (!limitExceeded) {
                    ++emailCountHour;
                    ++emailCountDay;
                }
                Object details = "";
                if (limitAlmostExceeded || limitExceeded) {
                    details = (String)details + "\nNOTE: The number of emails alerts sent by this service is limited to " + maxEmailsPerHour + " per hour and " + maxEmailsPerDay + " per day. (0 means no limit)\nThis is email " + emailCountHour + " this hour, and email " + emailCountDay + " today.\nAs at least one of these limits has been reached, no further mails will be sent this hour and/or day.\n\n";
                }
                if (limitExceeded) {
                    this.both_log.debug("Did not send mail because limit exceeded: " + (String)details);
                } else {
                    if (emailCountDay != 0L) {
                        r.setNestedSubResult((Object)emailCountDay, new String[]{"email", "countDay"});
                    }
                    if (emailCountHour != 0L) {
                        r.setNestedSubResult((Object)emailCountHour, new String[]{"email", "countHour"});
                    }
                    String testId = (String)this.testDefinition.getId();
                    details = (String)details + "Date: " + r.getCreated() + "  (= " + RFC3339Util.dateToRFC3339String((Date)r.getCreated()) + ")\n";
                    String extraDetails = this.extraInfoForEmail();
                    if (!extraDetails.isEmpty()) {
                        details = (String)details + "\n" + extraDetails;
                    }
                    Object subject = activatedTrigger.getSubject();
                    Object body = activatedTrigger.getBody();
                    if (subject == null) {
                        subject = "[Federation Monitor *] " + testId + " FAILURE on <testbed.urn>";
                    }
                    if (body == null) {
                        body = "The Federation Monitor* detected a " + testStatus + " for " + testId + " on testbed <testbed.urn>.\n\n<details>\n";
                    }
                    body = ((String)body).replace("<detail>", (CharSequence)details);
                    body = ((String)body).replace("<details>", (CharSequence)details);
                    subject = ((String)subject).replace("<detail>", "ERR details in subject");
                    subject = ((String)subject).replace("<details>", "ERR details in subject");
                    subject = this.replaceVariables((String)subject, true);
                    body = this.replaceVariables((String)body, true);
                    TestRunner.sendMail(this.originsService, emailAdressesList, (String)subject, (String)body, this.both_log);
                }
            } else {
                this.both_log.debug("Skipping sending emails.");
            }
        }
        catch (Throwable t) {
            this.both_log.error("Exception while handling email. Will ignore this. Mail might not be sent.", t);
            r.setNestedSubResult((Object)("Exception while handling email. Will ignore this. Mail might not be sent.\n" + TextUtil.exceptionToString((Throwable)t)), new String[]{"mail", "error"});
        }
        return r;
    }

    private static boolean sameStatus(@Nullable Result.ResultStatus actualStatus, @Nullable TestEmailConfig.TestResultStatus expectedStatus) {
        if (actualStatus == null) {
            return false;
        }
        if (expectedStatus == null) {
            return false;
        }
        switch (actualStatus) {
            case FAILURE: {
                return expectedStatus == TestEmailConfig.TestResultStatus.FAILURE;
            }
            case WARNING: {
                return expectedStatus == TestEmailConfig.TestResultStatus.WARNING;
            }
            case SUCCESS: {
                return expectedStatus == TestEmailConfig.TestResultStatus.SUCCESS;
            }
        }
        return false;
    }

    @Nonnull
    public List<String> completeEmailAddresses(@Nullable List<String> base, @Nullable Organisation organisation, @Nullable Testbed testbed) {
        boolean addFedmonAdmin;
        List<String> testbedEmails;
        List organisationEmails = organisation == null ? Collections.emptyList() : organisation.getTechnicalContactEmails();
        List<String> list = testbedEmails = testbed == null ? Collections.emptyList() : testbed.getTechnicalContactEmails();
        if (base == null) {
            base = Collections.singletonList("ADD_TESTBED_EMAILS");
        }
        if (testbedEmails == null) {
            testbedEmails = Collections.singletonList("ADD_ORGANISATION_EMAILS");
        }
        if (organisationEmails == null) {
            organisationEmails = Collections.emptyList();
        }
        LOG.debug("completeEmailAddresses base=" + base + " testbedEmails=" + testbedEmails + " organisationEmails=" + organisationEmails);
        assert (base != null);
        assert (testbedEmails != null);
        assert (organisationEmails != null);
        HashSet<String> res = new HashSet<String>();
        res.addAll(base);
        if (res.remove("ADD_TESTBED_EMAIL") || res.remove("ADD_TESTBED_EMAILS")) {
            res.addAll(testbedEmails);
        }
        if (res.remove("ADD_ORGANISATION_EMAIL") || res.remove("ADD_ORGANISATION_EMAILS")) {
            res.addAll(organisationEmails);
        }
        boolean addFedmonSender = res.remove("ADD_FEDMON_SENDER_EMAIL") || res.remove("ADD_FEDMON_SENDER_EMAILS");
        boolean addFedmonSenderIfOtherEmails = res.remove("ADD_FEDMON_SENDER_EMAIL_IF_OTHER_EMAILS") || res.remove("ADD_FEDMON_SENDER_EMAILS_IF_OTHER_EMAILS");
        boolean bl = addFedmonAdmin = res.remove("ADD_FEDMON_ADMIN_EMAIL") || res.remove("ADD_FEDMON_ADMIN_EMAILS");
        if (this.originsService.getEmailSender().hasValidConfig()) {
            if (addFedmonSender) {
                assert (this.originsService.getEmailSender().getConfig().getRawFrom() != null);
                res.add(this.originsService.getEmailSender().getConfig().getRawFrom());
            }
            if (addFedmonAdmin) {
                assert (this.originsService.getEmailSender().getConfig().getRawAdminAddresses() != null);
                res.addAll(this.originsService.getEmailSender().getConfig().getRawAdminAddresses());
            }
            if (addFedmonSenderIfOtherEmails && !res.isEmpty()) {
                assert (this.originsService.getEmailSender().getConfig().getRawFrom() != null);
                res.add(this.originsService.getEmailSender().getConfig().getRawFrom());
            }
        }
        LOG.debug("completeEmailAddresses res=" + res);
        return new ArrayList<String>(res);
    }

    @Nonnull
    protected String extraInfoForEmail() {
        return this.emailCustomContent;
    }

    protected void addCustomEmailContent(@Nonnull String line) {
        this.emailCustomContent = this.emailCustomContent + (String)(line.endsWith("\n") ? line : line + "\n");
    }

    protected boolean getBooleanHelper(@Nullable String val, boolean defaultValue) {
        if (val == null) {
            return defaultValue;
        }
        Boolean res = TextUtil.objectToBoolean((Object)val);
        if (res == null) {
            return defaultValue;
        }
        return res;
    }

    protected boolean getBooleanPropHelper(@Nonnull String key, boolean defaultValue) {
        return this.getBooleanHelper(this.originsService.getConfig().getProperty(key), defaultValue);
    }

    protected int getIntegerPropHelper(@Nonnull String key, int defaultValue) {
        return TestRunner.getIntegerHelper(this.originsService.getConfig().getProperty(key), defaultValue);
    }

    protected static int getIntegerHelper(@Nullable String val, int defaultValue) {
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    protected long getLongPropHelper(@Nonnull String key, long defaultValue) {
        return TestRunner.getLongHelper(this.originsService.getConfig().getProperty(key), defaultValue);
    }

    protected static long getLongHelper(@Nullable Long val, long defaultValue) {
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    protected static long getLongHelper(@Nullable String val, long defaultValue) {
        if (val == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Nonnull
    public String replaceVariables(@Nonnull String text, boolean ignoreErrors) {
        Pattern p = Pattern.compile("<([^>]*)>");
        StringBuffer stibu = new StringBuffer();
        Matcher m = p.matcher(text);
        while (m.find()) {
            String var = m.group(1);
            if (var == null) {
                if (ignoreErrors) {
                    m.appendReplacement(stibu, "[[Parse error processing var " + m.group() + "]]");
                    continue;
                }
                throw new RuntimeException("Error processing var " + m.group() + " in \"" + text + "\"");
            }
            String repl = this.getVariableValue(var, ignoreErrors);
            assert (repl != null);
            if (repl == null) continue;
            m.appendReplacement(stibu, repl);
        }
        m.appendTail(stibu);
        return stibu.toString();
    }

    @Nonnull
    protected ResultBuilder createBasicTestResult(@Nullable Integer returnValue) {
        ResultBuilder resultBuilder = new ResultBuilder();
        Integer serverId = this.testInstance.getServerIdParameter();
        if (serverId != null) {
            try {
                Optional server = this.fedmonWebApiClient.get(Server.class, (Object)serverId);
                if (server.isPresent()) {
                    assert (((Server)server.get()).getUri() != null);
                    resultBuilder.addSubResult("server", (Object)((Server)server.get()).getUri());
                    boolean isInMaintenance = this.checkPlannedMaintenance(serverId);
                    resultBuilder.addSubResult("inMaintenanceDuringTest", (Object)isInMaintenance);
                    if (((Server)server.get()).getTestbed().getUri() != null) {
                        resultBuilder.addSubResult("testbed", (Object)((Server)server.get()).getTestbed().getUri());
                    }
                }
            }
            catch (FedmonWebApiClient.FedmonWebApiClientException e) {
                LOG.error("Failed to get Server to add to subresult for id=" + serverId);
            }
        }
        resultBuilder.setTask((Long)this.task.getId(), null);
        resultBuilder.setCreated(new Timestamp(System.currentTimeMillis()));
        if (this.consoleLog != null) {
            resultBuilder.setLogUrl(this.consoleLog.getContent().toASCIIString());
        }
        resultBuilder.setTestInstance(this.testInstance);
        if (returnValue != null) {
            resultBuilder.addSubResult("returnValue", (Object)returnValue);
        }
        return resultBuilder;
    }

    protected boolean checkPlannedMaintenance(int serverId) {
        if (this.cachedInPlannedMaintenance != null) {
            return this.cachedInPlannedMaintenance;
        }
        Date now = new Date();
        try {
            Optional<MaintenanceInfo> activeMaintenance = this.originsService.getFedmonWebApiClient().getServerGlimpseByServerId(Integer.valueOf(serverId)).map(Stream::of).orElse(Stream.empty()).map(ServerGlimpse::getMaintenance).filter(Objects::nonNull).flatMap(Collection::stream).filter(maintenance -> !Objects.equals(maintenance.getPlanned(), Boolean.FALSE)).filter(maintenance -> maintenance.getStart() != null && now.after(maintenance.getStart())).filter(maintenance -> maintenance.getEnd() == null || now.before(maintenance.getEnd())).findAny();
            this.cachedInPlannedMaintenance = activeMaintenance.isPresent();
            return this.cachedInPlannedMaintenance;
        }
        catch (FedmonWebApiClient.FedmonWebApiClientException e) {
            LOG.error("Failed to fetch ServerGlimpse for server.id=" + serverId, (Throwable)e);
            return false;
        }
    }

    @Nonnull
    protected abstract ResultBuilder initResult();

    @Nonnull
    private ResultBuilder safeInitResult() {
        try {
            ResultBuilder res = this.initResult();
            return res;
        }
        catch (Throwable t) {
            try {
                ResultBuilder fallback = this.createBasicTestResult(-1);
                LOG.error("An internal error occured in initResult(). Will use fallback.", t);
                fallback.addSubResult("error", (Object)"An internal error occured in initResult(). Result lost, and fallback used.");
                fallback.setSummary(Result.ResultStatus.FAILURE);
                return fallback;
            }
            catch (Throwable t2) {
                ResultBuilder fallback2 = new ResultBuilder();
                fallback2.setTestInstance(this.testInstance);
                LOG.error("An DOUBLE internal error occured in initResult(). Will use fallback.", t2);
                fallback2.addSubResult("error", (Object)"An DOUBLE internal error occured in initResult(). Result lost, and fallback used.");
                fallback2.setSummary(Result.ResultStatus.FAILURE);
                return fallback2;
            }
        }
    }

    @Nonnull
    public String getAmApiVersion() {
        String res = this.testInstance.getStringParameterOrDefault("am_api", this.testDefinition);
        if (res == null) {
            return "2";
        }
        return res;
    }

    @Nonnull
    private String errorInGetVariable(boolean ignoreErrors, @Nonnull String msg) {
        return this.errorInGetVariable(ignoreErrors, msg, null, "ERROR in variable");
    }

    @Nonnull
    private String errorInGetVariable(boolean ignoreErrors, @Nonnull String msg, @Nonnull String returnVal) {
        return this.errorInGetVariable(ignoreErrors, msg, null, returnVal);
    }

    @Nonnull
    private String errorInGetVariable(boolean ignoreErrors, @Nonnull String msg, Exception ex) {
        return this.errorInGetVariable(ignoreErrors, msg, ex, "ERROR in variable");
    }

    @Nonnull
    private String errorInGetVariable(boolean ignoreErrors, @Nonnull String msg, @Nullable Exception ex, @Nonnull String returnVal) {
        if (ignoreErrors) {
            this.both_log.error(msg, (Throwable)ex);
            return returnVal;
        }
        throw new RuntimeException(msg, ex);
    }

    @Nullable
    protected String getVariableValue(@Nonnull String propId, boolean ignoreErrors) {
        String paramType;
        assert (propId != null);
        String[] s = propId.split(Pattern.quote("."));
        String paramName = s[0];
        assert (paramName != null);
        boolean specialParameter = false;
        if (paramName.equals("now") || paramName.equals("testbed")) {
            specialParameter = true;
        }
        String string = paramType = specialParameter ? null : this.testDefinition.getParameterType(paramName);
        if (s.length > 1) {
            String paramSubName = s[1];
            if (specialParameter) {
                switch (paramName) {
                    case "now": {
                        switch (paramSubName) {
                            case "rfc3339": {
                                return RFC3339Util.dateToRFC3339String((Date)new Date(), (boolean)false);
                            }
                            case "rfc3339z": {
                                return RFC3339Util.dateToRFC3339String((Date)new Date(), (boolean)true);
                            }
                            case "iso8601": {
                                return String.format("%tFT%<tTZ", Calendar.getInstance(TimeZone.getTimeZone("Z")));
                            }
                            case "unsafe_utc": {
                                return String.format("%tF %<tT", Calendar.getInstance(TimeZone.getTimeZone("Z")));
                            }
                            case "java": {
                                return new Date().toString();
                            }
                            case "simplehuman": {
                                SimpleDateFormat dt1 = new SimpleDateFormat("EEE d MMM HH:mm z");
                                return dt1.format(new Date());
                            }
                            case "epoch_s": {
                                return "" + System.currentTimeMillis() / 1000L;
                            }
                            case "epoch_ms": {
                                return "" + System.currentTimeMillis();
                            }
                        }
                        return this.errorInGetVariable(ignoreErrors, "Unknown date format. Try rfc3339, rfc3339z, iso8601, epoch_s, epoch_ms or java", "[[Unknown date format processing var " + propId + "]]");
                    }
                    case "testbed[]": 
                    case "testbed": {
                        Testbed testbed;
                        String testbedName;
                        Server server;
                        assert ("testbed".equals(paramName));
                        Integer serverId = this.testInstance.getServerIdParameter();
                        if (serverId == null) {
                            return this.errorInGetVariable(ignoreErrors, "Test instance did not have a \"server\" parameter (and thus no \"testbed\") (error while processing " + propId + ")", "[[Error processing var " + propId + "]]");
                        }
                        try {
                            server = this.originsService.getFedmonWebApiClient().getById(Server.class, (Object)serverId).orElseGet(() -> null);
                        }
                        catch (FedmonWebApiClient.FedmonWebApiClientException e) {
                            this.both_log.error("Error while fetching server info", (Throwable)e);
                            return this.errorInGetVariable(ignoreErrors, "(paramName=\"" + paramName + "\") Server \"" + serverId + "\" not found due to error contacting web api.", "[[Error processing var " + propId + "]]");
                        }
                        String string2 = testbedName = server == null ? null : server.getTestbedId();
                        if (testbedName == null) {
                            return this.errorInGetVariable(ignoreErrors, "Test instance did not have a \"testbed\" parameter (error while processing " + propId + ")", "[[Error processing var " + propId + "]]");
                        }
                        try {
                            testbed = this.originsService.getFedmonWebApiClient().getById(Testbed.class, (Object)testbedName).orElseGet(() -> null);
                        }
                        catch (FedmonWebApiClient.FedmonWebApiClientException e) {
                            this.both_log.error("Error while fetching testbed info", (Throwable)e);
                            return this.errorInGetVariable(ignoreErrors, "(paramName=\"" + paramName + "\") Testbed \"" + testbedName + "\" not found due to error contacting web api.", "[[Error processing var " + propId + "]]");
                        }
                        if (testbed == null) {
                            return this.errorInGetVariable(ignoreErrors, "(paramName=\"" + paramName + "\") Testbed \"" + testbedName + "\" not found.", "[[Error processing var " + propId + "]]");
                        }
                        switch (paramSubName) {
                            case "url": {
                                String ret = testbed.getInterfaceUrl();
                                if (ret == null) {
                                    return this.errorInGetVariable(ignoreErrors, "\"" + testbedName + "\" not found.", "[[Error processing var " + propId + "]]");
                                }
                                if ("".equals(ret)) {
                                    return this.errorInGetVariable(ignoreErrors, "\"" + testbedName + "\" has empty URL", "[[Error processing var " + propId + "]]");
                                }
                                return ret;
                            }
                            case "urn": {
                                String ret = testbed.getDefaultComponentManagerUrn();
                                if (ret == null) {
                                    return this.errorInGetVariable(ignoreErrors, "\"" + testbedName + "\" has null urn.", "[[Error processing var " + propId + "]]");
                                }
                                if ("".equals(ret)) {
                                    return this.errorInGetVariable(ignoreErrors, "\"" + testbedName + "\" has empty URN", "[[Error processing var " + propId + "]]");
                                }
                                return ret;
                            }
                            case "ping_host": {
                                return testbed.getPingHost();
                            }
                            case "longname": {
                                return testbed.getLongName();
                            }
                            case "id": 
                            case "name": 
                            case "shortname": {
                                return (String)testbed.getId();
                            }
                            case "help_url": {
                                return testbed.getHelpUrl();
                            }
                            case "info_url": {
                                return testbed.getInfoUrl();
                            }
                            case "otrs_name": {
                                return testbed.getOtrsName();
                            }
                            case "organisation_id": {
                                return testbed.getOrganisation() == null ? "todo" : (String)testbed.getOrganisation().getId();
                            }
                            case "organisation_name": {
                                return testbed.getOrganisation() == null ? "todo" : testbed.getOrganisation().getName();
                            }
                            case "organisation_url": {
                                return testbed.getOrganisation() == null ? "todo" : testbed.getOrganisation().getSiteUrl();
                            }
                            case "description": {
                                return testbed.getDescription();
                            }
                        }
                        break;
                    }
                }
            } else {
                if (paramType != null) {
                    switch (paramType) {
                        case "user": {
                            Optional userOpt;
                            String username = this.testInstance.getUserIdParameter();
                            if (username == null) {
                                return this.errorInGetVariable(ignoreErrors, "no user configured for test", "[[no user configure for test]]");
                            }
                            try {
                                userOpt = this.originsService.getFedmonWebApiClient().getById(User.class, (Object)username);
                            }
                            catch (FedmonWebApiClient.FedmonWebApiClientException e) {
                                return this.errorInGetVariable(ignoreErrors, "configured user \"" + username + "\" not found due to web api exception", "[[configured user \"" + username + "\" not found due to web api exception]]");
                            }
                            assert (userOpt != null);
                            if (!userOpt.isPresent()) {
                                return this.errorInGetVariable(ignoreErrors, "configured user \"" + username + "\" not found", "[[configured user \"" + username + "\" not found]]");
                            }
                            User user = (User)userOpt.get();
                            switch (paramSubName) {
                                case "userauthorityurn": {
                                    return user.getAuthorityUrn();
                                }
                                case "pem": {
                                    return "ERROR: may not use pem in variable";
                                }
                                case "username": {
                                    return user.getUsername();
                                }
                                case "pemkeyandcertfilename": 
                                case "passwordfilename": {
                                    return "/dev/null";
                                }
                            }
                            return this.errorInGetVariable(ignoreErrors, "field \"" + paramSubName + "\" is not valid for \"user\"", "[[field \"" + paramSubName + "\" is not valid for \"user\"]]");
                        }
                    }
                }
                switch (paramName) {
                    case "testinstance": {
                        assert (this.testInstance != null);
                        switch (paramSubName) {
                            case "name": {
                                return this.testInstance.getName();
                            }
                            case "id": {
                                return "" + this.testInstance.getId();
                            }
                            case "frequency_desc": {
                                if (this.testInstance.getFrequencyId() == null) {
                                    return "No frequency for TestInstance " + this.testInstance.getId();
                                }
                                try {
                                    Optional frequency = this.fedmonWebApiClient.get(Frequency.class, (Object)this.testInstance.getFrequencyId());
                                    if (!frequency.isPresent()) {
                                        return "No Frequency with ID " + this.testInstance.getFrequencyId();
                                    }
                                    return ((Frequency)frequency.get()).getDescription();
                                }
                                catch (FedmonWebApiClient.FedmonWebApiClientException e) {
                                    return "Problem fetching frequency " + this.testInstance.getFrequencyId();
                                }
                            }
                            case "frequency_cron": {
                                if (this.testInstance.getFrequencyId() == null) {
                                    return "No frequency for TestInstance " + this.testInstance.getId();
                                }
                                try {
                                    Optional frequency = this.fedmonWebApiClient.get(Frequency.class, (Object)this.testInstance.getFrequencyId());
                                    if (!frequency.isPresent()) {
                                        return "No Frequency with ID " + this.testInstance.getFrequencyId();
                                    }
                                    return ((Frequency)frequency.get()).getCron();
                                }
                                catch (FedmonWebApiClient.FedmonWebApiClientException e) {
                                    return "Problem fetching frequency " + this.testInstance.getFrequencyId();
                                }
                            }
                            case "enabled": {
                                return "" + this.testInstance.isEnabled();
                            }
                            case "history_url": {
                                return "https://flsmonitor.fed4fire.eu/history/" + this.testInstance.getId();
                            }
                            case "json_url": {
                                return this.testInstance.getUri() == null ? null : this.testInstance.getUri().toASCIIString();
                            }
                        }
                        return this.errorInGetVariable(ignoreErrors, "variable \"" + propId + "\" not found for testinstance! (paramSubName=" + paramSubName + " paramType=" + paramType + " paramName=" + paramName + ")", "[[Unknown testinstance var " + propId + " (" + paramSubName + ")]]");
                    }
                }
            }
        } else {
            if (paramType != null) {
                switch (paramType) {
                    case "string_expandvars": 
                    case "multiline_string_expandvars": {
                        String content = this.testInstance.getStringParameterOrDefault(paramName, this.testDefinition);
                        if (content == null) {
                            return this.errorInGetVariable(ignoreErrors, "No default or overwritten file-content found for parameter \"" + paramName + "\"", "[[Error processing var " + propId + "]]");
                        }
                        content = this.replaceVariables(content, ignoreErrors);
                        return content;
                    }
                    case "email-content": {
                        String content = this.testInstance.getStringParameterOrDefault(paramName, this.testDefinition);
                        if (content == null) {
                            return this.errorInGetVariable(ignoreErrors, "No default or overwritten file-content found for parameter \"" + paramName + "\"", "[[Error processing var " + propId + "]]");
                        }
                        return this.replaceVariables(content, ignoreErrors);
                    }
                }
            }
            switch (paramName) {
                default: 
            }
            String paramVal = this.testInstance.getStringParameterOrDefault(paramName, this.testDefinition);
            if (paramVal == null) {
                this.both_log.error(propId + " not found! (paramType=" + paramType + " paramName=" + paramName + "). There is also no test instance parameter with this name.");
                return this.errorInGetVariable(ignoreErrors, "variable \"" + propId + "\" not found! (paramType=" + paramType + " paramName=" + paramName + ") There is also no test instance parameter with this name.", "[[Unknown var " + propId + " (paramName=" + paramName + ")]]");
            }
            return paramVal;
        }
        if (paramType == null && !specialParameter) {
            this.both_log.error("paramType not found for paramName=\"" + paramName + "\" (" + propId + ")");
            this.both_log.error("   all parameters in testDefinition \"" + (String)this.testDefinition.getId() + "\":" + this.testDefinition.getParameters());
            System.err.println("WARNING: paramType not found for paramName=\"" + paramName + "\" (" + propId + ")");
        }
        this.both_log.error("No substitution found for param=\"" + propId + "\"! (paramType=" + paramType + " paramName=" + paramName + ")");
        return this.errorInGetVariable(ignoreErrors, "variable \"" + propId + "\" not found! (paramType=" + paramType + " paramName=" + paramName + ")", "[[Unknown var " + propId + "]]");
    }

    protected static void addNoteToResult(@Nonnull ResultBuilder result, @Nonnull String note) {
        Object existing = result.getSubResult("note");
        ArrayList<String> target = existing == null ? new ArrayList<String>() : (ArrayList<String>)existing;
        target.add(note);
        result.addSubResult("note", target);
    }

    protected static void addWarningToResult(@Nonnull ResultBuilder result, @Nonnull String warning) {
        Object existing = result.getSubResult("warning");
        ArrayList<String> target = existing == null ? new ArrayList<String>() : (ArrayList<String>)existing;
        target.add(warning);
        result.addSubResult("warning", target);
    }

    protected static void addErrorToResult(@Nonnull ResultBuilder result, @Nonnull String error) {
        Object existing = result.getSubResult("error");
        ArrayList<String> target = existing == null ? new ArrayList<String>() : (ArrayList<String>)existing;
        target.add(error);
        result.addSubResult("error", target);
    }

    @Nonnull
    protected ResultUploader getResultUploader() {
        return this.resultUploader;
    }

    @Nonnull
    protected static String getTestUserPem(@Nonnull FedmonWebApiClient webApiClient, @Nonnull TestInstance testInstance) {
        try {
            String userId = testInstance.getUserIdParameter();
            if (userId != null) {
                User user = (User)webApiClient.get(User.class, (Object)userId).orElseThrow(() -> new RuntimeException("User \"" + userId + "\" is required by test, but was not found"));
                assert (user != null);
                String userPemContent = user.getPrivateKeyAndCertPem();
                if (userPemContent == null) {
                    throw new RuntimeException("User \"" + userId + "\" is required by test, and was found, but has no PEM content.");
                }
                return userPemContent;
            }
            throw new RuntimeException("User is required by test, but was not configured in test parameters.");
        }
        catch (Throwable ex) {
            LOG.error("AutomatedTesterTestCall caught exception while fetching user info. Will see this as failure.", ex);
            throw new RuntimeException("Caught exception while fetching user info for test user \"" + testInstance.getUserIdParameter() + "\" of TestInstance " + testInstance.getId(), ex);
        }
    }

    protected static boolean checkUser(@Nonnull GeniUser user, @Nonnull Logger LOG) {
        List clientCertificateChain = user.getClientCertificateChain();
        int i = 0;
        for (X509Certificate c : clientCertificateChain) {
            try {
                c.checkValidity(new Date());
            }
            catch (CertificateExpiredException e) {
                LOG.error("\nFATAL: Certificate " + i + " (of " + clientCertificateChain.size() + ") in the user certificate chain has expired. NotAfter=" + c.getNotAfter() + " now=" + new Date() + "\nCannot continue, exiting...");
                return false;
            }
            catch (CertificateNotYetValidException e) {
                LOG.error("\nFATAL: Certificate " + i + " (of " + clientCertificateChain.size() + ") in the user certificate chain is not yet valid. NotBefore=" + c.getNotBefore() + " now=" + new Date() + "\nCannot continue, exiting...");
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static void sendMail(@Nonnull BasicOriginsService basicOriginsService, @Nonnull String emailAddressTo, @Nonnull String subject, @Nonnull String body, @Nonnull Logger log) {
        TestRunner.sendMail(basicOriginsService, Collections.singletonList(emailAddressTo), subject, body, log);
    }

    protected static void sendMail(@Nonnull BasicOriginsService basicOriginsService, @Nonnull List<String> emailAddresses, @Nonnull String subject, @Nonnull String body, @Nonnull Logger log) {
        if (emailAddresses.isEmpty()) {
            log.warn("no email addresses to send to -> will not send email");
            return;
        }
        EmailSender emailSender = basicOriginsService.getEmailSender();
        if (!emailSender.hasValidConfig()) {
            log.warn(" !emailSender.hasValidConfig()  -> will not send email");
            return;
        }
        try {
            emailSender.sendTo(emailAddresses, subject, body);
            log.debug("Email queued for sending.");
        }
        catch (AddressException e) {
            log.error("AddressException when queuing mail for " + emailAddresses, (Throwable)e);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isCompleted() {
        if (this.future != null && this.future.isDone()) {
            return true;
        }
        return this.completed;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setFuture(@Nullable Future<ResultBuilder> future) {
        this.future = future;
    }

    @Nullable
    public Future<ResultBuilder> getFuture() {
        return this.future;
    }

    public static long fallbackWhenNull(@Nullable Long value, long fallback) {
        if (value == null) {
            return fallback;
        }
        return value;
    }

    @Nonnull
    public static Integer fallbackWhenNull(@Nullable Integer value, int fallback) {
        if (value == null) {
            return fallback;
        }
        return value;
    }

    @Nonnull
    public static String fallbackWhenNull(@Nullable String value, @Nonnull String fallback) {
        if (value == null) {
            return fallback;
        }
        return value;
    }

    private static class TimeoutTask
    implements Runnable {
        @Nonnull
        private final Thread thread;
        @Nonnull
        private final TestRunner testRunner;
        private boolean cancelled = false;
        @Nonnull
        private final AtomicBoolean refusesToStop;
        @Nonnull
        private final Instant timeoutInstant;

        public TimeoutTask(@Nonnull Thread thread, @Nonnull TestRunner testRunner, @Nonnull AtomicBoolean refusesToStop, @Nonnull Instant timeoutInstant) {
            this.thread = thread;
            this.testRunner = testRunner;
            this.refusesToStop = refusesToStop;
            this.timeoutInstant = timeoutInstant;
        }

        @Nonnull
        public static String threadToStacktraceString(@Nonnull Thread thread) {
            StackTraceElement[] stackTraceElements = thread.getStackTrace();
            Object res = "";
            for (StackTraceElement e : stackTraceElements) {
                res = (String)res + e + "\n";
            }
            return res;
        }

        @Override
        public void run() {
            block23: {
                try {
                    Instant now = Instant.now();
                    if (this.timeoutInstant.isAfter(now)) {
                        LOG.error("TimeoutTask.run was called BEFORE correct timeout! now=" + RFC3339Util.instantToRFC3339String((Instant)now) + " timeoutDate=" + RFC3339Util.instantToRFC3339String((Instant)this.timeoutInstant));
                        try {
                            throw new RuntimeException("tracing origin of early TimeoutTask.run() call");
                        }
                        catch (RuntimeException e) {
                            LOG.error("TimeoutTask.run was called BEFORE correct timeout! Stacktrace included to track culprit.", (Throwable)e);
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error("Problem checking if timeout is correct. Will ignore.", (Throwable)e);
                }
                try {
                    if (this.testRunner.timingDebugger != null) {
                        this.testRunner.timingDebugger.informTimeoutTaskExecutionOccured();
                    }
                    LOG.warn("The timeout for the test (" + this.testRunner.getTestDescription() + ") has been reached. (" + this.testRunner.testDefinition.getMaxTestDurationMs() + " ms)");
                    if (!this.cancelled) {
                        this.thread.interrupt();
                        try {
                            Thread.sleep(4000L);
                            if (!this.testRunner.runTestCallReturned.get()) {
                                String stackTraceString = TimeoutTask.threadToStacktraceString(this.thread);
                                this.testRunner.expired = true;
                                LOG.warn("Thread failed to cancel within 5 seconds! testCall.finishedTaskSpecificPart=" + this.testRunner.finishedTaskSpecificPart + " Thread stack trace:\n" + stackTraceString);
                                LOG.warn("Will try to cancel future. This probably won't work either.");
                                if (this.testRunner.future != null) {
                                    try {
                                        this.testRunner.future.cancel(true);
                                    }
                                    catch (Exception e) {
                                        LOG.error("Exception while trying to cancel using future", (Throwable)e);
                                    }
                                }
                                Thread.sleep(1000L);
                                if (!this.testRunner.runTestCallReturned.get()) {
                                    this.refusesToStop.set(true);
                                    LOG.warn("Considering this TaskRunner to be in state: \"refusesToStop\"");
                                    LOG.warn("Will try to force stop thread! (this is an unsafe procedure, which can theoretically cause serious bugs in the entire application! (but it probably won't in this case))");
                                    try {
                                        this.thread.stop();
                                    }
                                    catch (Throwable t) {
                                        LOG.error("thread.stop failed, will ignore and continue.", t);
                                    }
                                    Thread.sleep(2000L);
                                    if (!this.testRunner.runTestCallReturned.get()) {
                                        String stackTraceString2 = TimeoutTask.threadToStacktraceString(this.thread);
                                        LOG.warn("Thread failed to cancel within 2 seconds of the forced stop! testCall.finishedTaskSpecificPart=" + this.testRunner.finishedTaskSpecificPart + " Thread stack trace:\n" + stackTraceString2);
                                        LOG.warn("Will try to force stop thread again!");
                                        try {
                                            this.thread.stop();
                                        }
                                        catch (Throwable t) {
                                            LOG.error("thread.stop failed, will ignore and continue.", t);
                                        }
                                        Thread.sleep(2000L);
                                        if (!this.testRunner.runTestCallReturned.get()) {
                                            LOG.debug("Giving up. Thread won't stop. Uploading FAILED result.");
                                            this.testRunner.finishExpiredCall();
                                        } else {
                                            LOG.debug("Force thread stop was successful on the very last attempt.");
                                            this.refusesToStop.set(false);
                                        }
                                        break block23;
                                    }
                                    LOG.debug("Force thread stop was successful");
                                    this.refusesToStop.set(false);
                                    break block23;
                                }
                                LOG.debug("Future.cancel() was successful");
                                break block23;
                            }
                            LOG.debug("Slept 5 seconds and found that thread had died.");
                        }
                        catch (InterruptedException e) {
                            LOG.debug("TimeoutTask was interrupted. (This is probably a good thing! The thread has probably finished now and is cleaning up this timeout thread.)");
                        }
                        break block23;
                    }
                    LOG.warn("Not interrupting task because already cancelled");
                }
                catch (Throwable t) {
                    LOG.error("TimeoutTask failed", t);
                }
            }
            LOG.debug("TimeoutTask finished");
        }
    }

    public static class TestCallCreatedObjects {
        @Nonnull
        private final ResultBuilder resultBuilder;
        @Nonnull
        private final List<ServerGlimpseBuilder> serverGlimpses = new ArrayList<ServerGlimpseBuilder>();
        @Nonnull
        private final List<Consumer<Result>> onResultIdKnownCallbacks = new ArrayList<Consumer<Result>>();
        @Nonnull
        private final List<Consumer<Log>> onLogUploadedCallbacks = new ArrayList<Consumer<Log>>();
        @Nonnull
        private final List<LogInfo> logs = new ArrayList<LogInfo>();
        @Nullable
        private Long taskId;

        public TestCallCreatedObjects(@Nonnull ResultBuilder resultBuilder) {
            assert (resultBuilder != null) : "You should not make a TestCallCreatedObjects without a resultBuilder";
            this.resultBuilder = resultBuilder;
        }

        public void addLog(@Nonnull String subResultName, @Nonnull String name, @Nonnull String content, @Nonnull Log.LogMediaType mediaType, @Nullable Timestamp startTime) {
            LogBuilder logBuilder = new LogBuilder();
            logBuilder.setName(name);
            logBuilder.setMediaType(mediaType);
            logBuilder.setStartTime(startTime);
            logBuilder.setLive(Boolean.valueOf(false));
            this.logs.add(new LogInfo(logBuilder, subResultName, content));
        }

        public void addLog(@Nonnull List<String> subResultName, @Nonnull String name, @Nonnull String content, @Nonnull Log.LogMediaType mediaType, @Nullable Timestamp startTime) {
            LogBuilder logBuilder = new LogBuilder();
            logBuilder.setName(name);
            logBuilder.setMediaType(mediaType);
            logBuilder.setStartTime(startTime);
            logBuilder.setLive(Boolean.valueOf(false));
            this.logs.add(new LogInfo(logBuilder, subResultName, content));
        }

        public void setPostUploadCallback(@Nonnull Consumer<Log> callback) {
            this.onLogUploadedCallbacks.add(callback);
        }

        public void firePostLogUploadCallbacks(@Nonnull Log createdLog) {
            this.onLogUploadedCallbacks.stream().forEach(cb -> cb.accept(createdLog));
        }

        public void addCreatedLog(@Nonnull Log createdLog) {
            LogBuilder logBuilder = new LogBuilder(createdLog);
            LogInfo logInfo = new LogInfo(logBuilder);
            logInfo.setCreatedLog(createdLog);
            this.logs.add(logInfo);
        }

        @Nonnull
        public List<ServerGlimpseBuilder> getServerGlimpses() {
            return this.serverGlimpses;
        }

        public void addOnResultIdKnownCallback(@Nonnull Consumer<Result> r) {
            this.onResultIdKnownCallbacks.add(r);
        }

        public void fireOnResultIdKnownCallbacks(@Nonnull Result result) {
            this.onResultIdKnownCallbacks.stream().forEach(cb -> cb.accept(result));
        }

        public void addServerGlimpse(@Nonnull ServerGlimpseBuilder serverGlimpse) {
            assert (serverGlimpse != null);
            assert (serverGlimpse.getServerId() != null) : "serverGlimpse has no serverId";
            this.serverGlimpses.add(serverGlimpse);
        }

        @Nonnull
        public ResultBuilder getResultBuilder() {
            return this.resultBuilder;
        }

        public void setLogs(@Nonnull List<LogInfo> logs) {
            this.logs.clear();
            this.logs.addAll(logs);
        }

        @Nonnull
        public List<LogInfo> getLogs() {
            assert (this.logs != null);
            return this.logs;
        }

        @Nullable
        public Long getTaskId() {
            return this.taskId;
        }

        public void setTaskId(@Nullable Long taskId) {
            this.taskId = taskId;
        }

        public static class LogInfo {
            @Nonnull
            private final LogBuilder logBuilder;
            @Nullable
            private final List<String> subResultName;
            @Nullable
            private final String content;
            @Nullable
            private Log createdLog;

            public LogInfo(@Nonnull LogBuilder logBuilder, @Nonnull List<String> subResultName, @Nullable String content) {
                this.logBuilder = logBuilder;
                this.subResultName = subResultName;
                this.content = content;
            }

            public LogInfo(@Nonnull LogBuilder logBuilder, @Nonnull String subResultName, @Nullable String content) {
                this.logBuilder = logBuilder;
                this.subResultName = Collections.singletonList(subResultName);
                this.content = content;
            }

            public LogInfo(@Nonnull LogBuilder logBuilder) {
                this.logBuilder = logBuilder;
                this.subResultName = null;
                this.content = null;
            }

            @Nonnull
            public LogBuilder getLogBuilder() {
                return this.logBuilder;
            }

            public String getName() {
                return this.logBuilder.getName();
            }

            @Nullable
            public List<String> getSubResultName() {
                return this.subResultName;
            }

            @Nullable
            public String getContent() {
                return this.content;
            }

            @Nullable
            public Log getCreatedLog() {
                return this.createdLog;
            }

            public void setCreatedLog(@Nullable Log createdLog) {
                this.createdLog = createdLog;
            }
        }
    }

    public static class NoTestResult
    extends Exception {
    }
}

