/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.origins_service.testrunners;

import be.iminds.ilabt.jfed.fedmon.origins_service.BasicOriginsService;
import be.iminds.ilabt.jfed.fedmon.origins_service.testrunners.AutomatedTester2TestRunner;
import be.iminds.ilabt.jfed.fedmon.origins_service.testrunners.AutomatedTesterTestRunner;
import be.iminds.ilabt.jfed.fedmon.origins_service.testrunners.ListResourcesWrapper;
import be.iminds.ilabt.jfed.fedmon.origins_service.testrunners.PingTestRunner;
import be.iminds.ilabt.jfed.fedmon.origins_service.testrunners.ReplayAndSummarizeTestRunner;
import be.iminds.ilabt.jfed.fedmon.origins_service.testrunners.ResourcesToTestInstances;
import be.iminds.ilabt.jfed.fedmon.origins_service.testrunners.ResultAggregatorTestRunner;
import be.iminds.ilabt.jfed.fedmon.origins_service.testrunners.SelfTest;
import be.iminds.ilabt.jfed.fedmon.origins_service.testrunners.TestRunner;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.client.TestInstanceFilter;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.jfed.highlevel.call_log_output.CallReportFactory;
import be.iminds.ilabt.jfed.highlevel.call_log_output.CallReportWriter;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.testing.shared.AutomatedTestExternalExecutableLocations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class TestRunnerFactory {
    private final TestbedInfoSource testbedInfoSource;
    private final AuthorityFinder authorityFinder;
    private final CallReportFactory callReportFactory;
    private final CallReportWriter callReportWriter;
    private final FedmonWebApiClient fedmonWebApiClient;
    private final BasicOriginsService originsService;
    private final AutomatedTestExternalExecutableLocations automatedTestExternalExecutableLocations;

    public TestRunnerFactory(TestbedInfoSource testbedInfoSource, AuthorityFinder authorityFinder, CallReportFactory callReportFactory, CallReportWriter callReportWriter, BasicOriginsService originsService, AutomatedTestExternalExecutableLocations automatedTestExternalExecutableLocations) {
        this.testbedInfoSource = testbedInfoSource;
        this.authorityFinder = authorityFinder;
        this.callReportFactory = callReportFactory;
        this.callReportWriter = callReportWriter;
        this.fedmonWebApiClient = originsService.getFedmonWebApiClient();
        this.originsService = originsService;
        this.automatedTestExternalExecutableLocations = automatedTestExternalExecutableLocations;
    }

    private TestInstance verifyTestInstance(Task task) throws FedmonWebApiClient.FedmonWebApiClientException {
        Optional ti = this.fedmonWebApiClient.getById(TestInstance.class, (Object)task.getTestInstanceId());
        if (!ti.isPresent()) {
            throw new RuntimeException("Got task with TestInstance ID " + task.getTestInstanceId() + " but that test instance doesn't exist.");
        }
        return (TestInstance)ti.get();
    }

    private TestDefinition verifyTestDefinition(Task task, TestInstance ti) throws FedmonWebApiClient.FedmonWebApiClientException {
        Optional td = this.fedmonWebApiClient.getById(TestDefinition.class, (Object)ti.getTestDefinitionId());
        if (!td.isPresent()) {
            throw new RuntimeException("Got task with TestDefinition name " + ti.getTestDefinitionId() + " but that test definition doesn't exist.");
        }
        return (TestDefinition)td.get();
    }

    private Frequency verifyFrequency(Task task, TestInstance ti) throws FedmonWebApiClient.FedmonWebApiClientException {
        if (ti.getFrequencyId() != null) {
            Optional f = this.fedmonWebApiClient.getById(Frequency.class, (Object)ti.getFrequencyId());
            if (!f.isPresent()) {
                throw new RuntimeException("Got task with Frequency ID " + ti.getFrequencyId() + " but that Frequency doesn't exist.");
            }
            return (Frequency)f.get();
        }
        return null;
    }

    private TestInstanceStatistics verifyTestInstanceStatistics(Task task) throws FedmonWebApiClient.FedmonWebApiClientException {
        Optional tis = this.fedmonWebApiClient.getTestInstanceStatisticsByTestInstanceId(task.getTestInstanceId());
        if (!tis.isPresent()) {
            throw new RuntimeException("Got task with TestInstance ID " + task.getTestInstanceId() + " but a TestInstanceStatistics doesn't exist for that ID.");
        }
        return (TestInstanceStatistics)tis.get();
    }

    public List<TestRunner> requestTestRunners(int maxCount, String runInfo, TestInstanceFilter filter) throws FedmonWebApiClient.FedmonWebApiClientException {
        ArrayList<TestRunner> res = new ArrayList<TestRunner>();
        Collection tasks = this.fedmonWebApiClient.createTasks(maxCount, runInfo, filter);
        for (Task task : tasks) {
            TestInstance ti = this.verifyTestInstance(task);
            TestDefinition td = this.verifyTestDefinition(task, ti);
            Frequency usedFreq = this.verifyFrequency(task, ti);
            TestInstanceStatistics tis = this.verifyTestInstanceStatistics(task);
            TestRunner testRunner = this.makeTest(task, ti, usedFreq, tis, td);
            res.add(testRunner);
        }
        return res;
    }

    public List<TestRunner> createStressTestTestRunners(int testCount, Integer testInstanceId, String runInfo) throws FedmonWebApiClient.FedmonWebApiClientException {
        ArrayList<TestRunner> res = new ArrayList<TestRunner>();
        Collection tasks = this.fedmonWebApiClient.createStressTestTasks(testCount, testInstanceId.intValue(), runInfo);
        for (Task task : tasks) {
            TestInstance ti = this.verifyTestInstance(task);
            TestDefinition td = this.verifyTestDefinition(task, ti);
            Frequency usedFreq = this.verifyFrequency(task, ti);
            TestInstanceStatistics tis = this.verifyTestInstanceStatistics(task);
            TestRunner testRunner = this.makeTest(task, ti, usedFreq, tis, td);
            res.add(testRunner);
        }
        return res;
    }

    public TestRunner makeTest(Task task, TestInstance testInstance, Frequency testInstanceFrequency, TestInstanceStatistics testInstanceStatistics, TestDefinition testDefinition) {
        return this.makeTest(task, testInstance, testInstanceFrequency, testInstanceStatistics, testDefinition, this.originsService);
    }

    private TestRunner makeTest(Task task, TestInstance test, Frequency testInstanceFrequency, TestInstanceStatistics testInstanceStatistics, TestDefinition testDefinition, BasicOriginsService originsService) {
        TestRunner ret = switch (testDefinition.getType().toLowerCase()) {
            case "ping" -> new PingTestRunner(task, test, testInstanceFrequency, testInstanceStatistics, testDefinition, originsService, this.automatedTestExternalExecutableLocations);
            case "aggregatetestbedstatus" -> new ResultAggregatorTestRunner(task, test, testInstanceFrequency, testInstanceStatistics, testDefinition, originsService);
            case "resourcestotests" -> new ResourcesToTestInstances(task, test, testInstanceFrequency, testInstanceStatistics, testDefinition, originsService, this.testbedInfoSource, this.authorityFinder, this.callReportFactory, this.callReportWriter);
            case "replayandsummarize" -> new ReplayAndSummarizeTestRunner(task, test, testInstanceFrequency, testInstanceStatistics, testDefinition, originsService, this);
            case "parallelstitch" -> throw new RuntimeException("Unsupported test type \"" + testDefinition.getType() + "\" -> this test was removed from jFed");
            case "automatedtestertestcall" -> new AutomatedTesterTestRunner(task, test, testInstanceFrequency, testInstanceStatistics, testDefinition, originsService);
            case "automatedtester2testcall" -> new AutomatedTester2TestRunner(task, test, testInstanceFrequency, testInstanceStatistics, testDefinition, originsService, this.automatedTestExternalExecutableLocations);
            case "automatedtesterespectestcall" -> new AutomatedTester2TestRunner(task, test, testInstanceFrequency, testInstanceStatistics, testDefinition, originsService, this.automatedTestExternalExecutableLocations);
            case "listresources" -> new ListResourcesWrapper(task, test, testInstanceFrequency, testInstanceStatistics, testDefinition, originsService, this.testbedInfoSource, this.authorityFinder, this.callReportFactory, this.callReportWriter);
            case "selftest" -> new SelfTest(task, test, testInstanceFrequency, testInstanceStatistics, testDefinition, originsService, this.testbedInfoSource, this.authorityFinder, this.callReportFactory, this.callReportWriter);
            default -> throw new RuntimeException("Unsupported test type \"" + testDefinition.getType() + "\"");
        };
        assert (ret != null);
        return ret;
    }

    public TestRunner copyTest(TestRunner c) {
        return this.makeTest(c.getTask(), c.getTestInstance(), c.getFrequency(), c.getTestInstanceStatistics(), c.getTestDefinition(), this.originsService);
    }
}

