/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.origins_service.time_debugging;

import be.iminds.ilabt.jfed.fedmon.origins_service.time_debugging.PhaseTiming;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class PhaseTimer<T extends PhaseTiming.PhaseEnum> {
    private T initialPhase;
    private T phase;
    private Date phaseStart;
    private List<PhaseTiming<T>> phaseTimingList = new ArrayList<PhaseTiming<T>>();

    public PhaseTimer(T initialPhase) {
        this.initialPhase = initialPhase;
        this.phase = initialPhase;
        this.phaseStart = new Date();
    }

    public void timeStartPhase(T phase) {
        assert (Objects.equals(this.phase, this.initialPhase) || this.phase == null);
        Date now = new Date();
        if (this.phase != null) {
            this.phaseTimingList.add(new PhaseTiming<T>(this.phase, this.phaseStart, now));
        }
        this.phase = phase;
        this.phaseStart = now;
    }

    public void timeSwitchPhase(T fromPhase, T toPhase) {
        assert (Objects.equals(fromPhase, this.phase));
        Date now = new Date();
        this.phaseTimingList.add(new PhaseTiming<T>(fromPhase, this.phaseStart, now));
        this.phase = toPhase;
        this.phaseStart = now;
    }

    public void timeStopPhase(T phase) {
        Date now = new Date();
        this.phaseTimingList.add(new PhaseTiming<T>(this.phase, this.phaseStart, now));
        this.phase = null;
        this.phaseStart = now;
    }

    public void timeStopAnyPhase() {
        if (this.phase != null) {
            Date now = new Date();
            this.phaseTimingList.add(new PhaseTiming<T>(this.phase, this.phaseStart, now));
            this.phase = null;
            this.phaseStart = now;
        }
    }

    public String phaseTimingToString() {
        Object res = "";
        for (PhaseTiming<T> pt : this.phaseTimingList) {
            if (!((String)res).isEmpty()) {
                res = (String)res + " | ";
            }
            res = (String)res + pt;
        }
        if (this.phase != null) {
            PhaseTiming<T> current = new PhaseTiming<T>(this.phase, this.phaseStart, new Date());
            if (!((String)res).isEmpty()) {
                res = (String)res + " | ";
            }
            res = (String)res + current + " (STILL RUNNING)";
        }
        return res;
    }
}

