/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.origins_service.time_debugging;

import be.iminds.ilabt.jfed.fedmon.origins_service.testrunners.TestRunner;
import be.iminds.ilabt.jfed.fedmon.origins_service.time_debugging.PhaseTimer;
import be.iminds.ilabt.jfed.fedmon.origins_service.time_debugging.PhaseTiming;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class TestCallTimingDebugger
extends PhaseTimer<TestCallPhase> {
    private final TestRunner testRunner;
    private long timeout;
    private TimeUnit timeoutUnit;
    private Date timeoutDate;
    private boolean started = false;
    private boolean finished = false;
    private boolean timedOut = false;

    public TestCallTimingDebugger(TestRunner testRunner) {
        super(TestCallPhase.WAIT_FOR_RUN);
        this.testRunner = testRunner;
    }

    public void informTimeoutTaskExecutionOccured() {
        this.timeStopPhase(TestCallPhase.TASK_SPECIFIC);
        this.timeStartPhase(TestCallPhase.CANCELLING);
        this.timedOut = true;
    }

    public void informStopTaskExecution() {
        this.timeStartPhase(TestCallPhase.RAN);
        this.finished = true;
    }

    public void informTimeoutTaskExecutionValue(long timeout, TimeUnit timeoutUnit) {
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
        this.timeoutDate = new Date(System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(timeout, timeoutUnit));
    }

    public void informStartTaskExecution() {
        this.timeStopPhase(TestCallPhase.WAIT_FOR_RUN);
        this.started = true;
    }

    public String toString() {
        Object stateStr = "";
        if (!this.started) {
            stateStr = (String)stateStr + "SCHEDULED ";
        }
        if (this.started && !this.finished) {
            stateStr = (String)stateStr + "RUNNING ";
        }
        if (!this.finished && this.timeoutDate != null) {
            long diff = this.timeoutDate.getTime() - System.currentTimeMillis();
            stateStr = (String)stateStr + "TIMEOUT in " + diff + " ms ";
        }
        if (this.finished) {
            stateStr = (String)stateStr + "FINISHED ";
        }
        if (this.timedOut) {
            stateStr = (String)stateStr + "TIMED_OUT ";
        }
        return "TestCall \"" + this.testRunner.getTestDescription() + "\" " + (String)stateStr + "phases: " + this.phaseTimingToString();
    }

    public static enum TestCallPhase implements PhaseTiming.PhaseEnum
    {
        WAIT_FOR_RUN,
        INIT,
        TASK_REGISTER,
        TASK_SPECIFIC,
        CANCELLING,
        FINISH,
        RAN;

    }
}

