/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.origins_service.time_debugging;

import be.iminds.ilabt.jfed.fedmon.origins_service.ResultUploader;
import be.iminds.ilabt.jfed.fedmon.origins_service.testrunners.TestRunner;
import be.iminds.ilabt.jfed.fedmon.origins_service.time_debugging.PhaseTimer;
import be.iminds.ilabt.jfed.fedmon.origins_service.time_debugging.PhaseTiming;
import be.iminds.ilabt.jfed.fedmon.origins_service.time_debugging.TestCallTimingDebugger;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimingDebugger
extends PhaseTimer<OriginsServicePhase> {
    private static final Logger LOG = LoggerFactory.getLogger(TimingDebugger.class);
    private int threadCount = -1;
    private Queue<TestRunner> allTasks;
    private ResultUploader resultUploader;
    private final Map<TestRunner, TestCallTimingDebugger> testCallTimingDebuggers = new HashMap<TestRunner, TestCallTimingDebugger>();
    private boolean stopped = false;
    private Thread periodicReportingThread;

    public TimingDebugger() {
        super(OriginsServicePhase.INIT);
        Runnable periodicReportingRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    while (!TimingDebugger.this.stopped) {
                        TimingDebugger.this.report();
                        Thread.sleep(5000L);
                    }
                }
                catch (InterruptedException e) {
                    LOG.debug("Periodic reporting has been interrupted: Stopping periodic reporting.");
                }
                TimingDebugger.this.report();
            }
        };
        this.periodicReportingThread = new Thread(periodicReportingRunnable);
        if (LOG.isDebugEnabled()) {
            this.periodicReportingThread.start();
        }
    }

    public void stop() {
        this.stopped = true;
        this.periodicReportingThread.interrupt();
    }

    public void informSubmitTask(TestRunner test) {
        TestCallTimingDebugger testCallTimingDebugger = new TestCallTimingDebugger(test);
        test.setTimingDebugger(testCallTimingDebugger);
        this.testCallTimingDebuggers.put(test, testCallTimingDebugger);
    }

    public void setInfoThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public void setInfoAllTasks(Queue<TestRunner> allTasks) {
        this.allTasks = allTasks;
    }

    public void setInfoResultUploader(ResultUploader resultUploader) {
        this.resultUploader = resultUploader;
    }

    public void report() {
        try {
            LOG.debug(this.toString());
        }
        catch (Throwable t) {
            LOG.error("Error while doing periodic reporting", t);
        }
    }

    public String toString() {
        Object res = "Timing debug overview:\n";
        res = (String)res + "  phases: " + this.phaseTimingToString() + "\n";
        if (this.resultUploader != null) {
            res = (String)res + "resultUploader has queue of size: " + this.resultUploader.queueSize() + "\n";
        }
        if (this.threadCount >= 0) {
            res = (String)res + "threadCount: " + this.threadCount + "\n";
        }
        for (TestCallTimingDebugger tctd : this.testCallTimingDebuggers.values()) {
            res = (String)res + "    " + tctd + "\n";
        }
        return res;
    }

    public static enum OriginsServicePhase implements PhaseTiming.PhaseEnum
    {
        INIT,
        EXECUTE_TASKS,
        RESULT_UPLOAD,
        FINISH;

    }
}

