/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.rrd.impl;

import be.iminds.ilabt.jfed.fedmon.rrd.base.RrdConfig;
import be.iminds.ilabt.jfed.fedmon.rrd.base.TestInstanceRrd;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.ArcDef;
import org.rrd4j.core.Archive;
import org.rrd4j.core.Robin;
import org.rrd4j.core.RrdDb;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListResourcesRrd
extends TestInstanceRrd {
    private static final Logger LOG = LoggerFactory.getLogger(ListResourcesRrd.class);
    private RrdDb graphRrdDb = null;

    public ListResourcesRrd(TestInstance testInstance, Frequency testInstanceFrequency, TestDefinition testDefinition, RrdConfig rrdConfig) {
        super(testInstance, testInstanceFrequency, testDefinition, rrdConfig, "resrc");
    }

    public ListResourcesRrd(TestInstance testInstance, Frequency testInstanceFrequency, TestDefinition testDefinition, RrdConfig rrdConfig, File altFile) {
        super(testInstance, testInstanceFrequency, testDefinition, rrdConfig, "resrc", altFile);
    }

    private void helper(Result result, List<TestInstanceRrd.Val> res, String jsonName, String dsSubName) {
        try {
            Long countAvailable = result.getNestedLongSubResult(new String[]{"count", jsonName, "available"});
            if (countAvailable != null) {
                res.add(new TestInstanceRrd.Val("free_" + dsSubName, countAvailable.doubleValue()));
            }
        }
        catch (Exception e) {
            LOG.debug("Invalid number in result for count " + jsonName + " available", (Throwable)e);
        }
        try {
            Long countTotal = result.getNestedLongSubResult(new String[]{"count", jsonName, "total"});
            if (countTotal != null) {
                res.add(new TestInstanceRrd.Val("tota_" + dsSubName, countTotal.doubleValue()));
            }
        }
        catch (Exception e) {
            LOG.debug("Invalid number in result for count " + jsonName + " total", (Throwable)e);
        }
    }

    @Override
    public List<TestInstanceRrd.Val> getValues(@Nonnull Result result) {
        if (this.wasTestInPlannedMaintenance(result)) {
            return Collections.emptyList();
        }
        ArrayList<TestInstanceRrd.Val> res = new ArrayList<TestInstanceRrd.Val>();
        try {
            Long countSummary = result.getNestedLongSubResult(new String[]{"count", "summary", "available"});
            if (countSummary != null) {
                res.add(new TestInstanceRrd.Val("free_all", countSummary.doubleValue()));
            }
        }
        catch (Exception e) {
            LOG.debug("Invalid number in result for count summary available", (Throwable)e);
        }
        this.helper(result, res, "ipv4", "ip4");
        this.helper(result, res, "openflow", "oflw");
        this.helper(result, res, "raw", "raw");
        this.helper(result, res, "vm", "vm");
        return res;
    }

    @Override
    public TestInstanceStatistics.RrdStatistics getTestStatistics() {
        return null;
    }

    @Override
    public TestInstanceStatistics.Summation getSummation() {
        return null;
    }

    @Override
    public List<TestInstanceRrd.GraphInfo> getGraphInfo() {
        long now = System.currentTimeMillis() / 1000L;
        ArrayList<TestInstanceRrd.GraphInfo> res = new ArrayList<TestInstanceRrd.GraphInfo>();
        LOG.debug("stored graph start=" + this.rrdDef.getStartTime());
        for (ArcDef arcDef : this.rrdDef.getArcDefs()) {
            if (arcDef.getConsolFun() != ConsolFun.AVERAGE) continue;
            long periodS = (long)(arcDef.getRows() * arcDef.getSteps()) * this.rrdDef.getStep();
            long graphStart = now - (long)(arcDef.getRows() * arcDef.getSteps()) * this.rrdDef.getStep();
            LOG.debug("graph start=" + graphStart + " stop=" + now + " diff=" + (now - graphStart));
            String subType = "all";
            res.add(new TestInstanceRrd.GraphInfo(this.name, subType, periodS, "Available Resources", this.testInstance, this.testDefinition, graphStart, now, this.rrdDef, null, arcDef));
            subType = "detail";
            res.add(new TestInstanceRrd.GraphInfo(this.name, subType, periodS, "Resource Overview", this.testInstance, this.testDefinition, graphStart, now, this.rrdDef, null, arcDef));
        }
        return res;
    }

    @Override
    @Nonnull
    public List<TestInstanceRrd.RawDataInfo> getRawDataInfo(String baseUri) {
        ArrayList<TestInstanceRrd.RawDataInfo> res = new ArrayList<TestInstanceRrd.RawDataInfo>();
        for (ArcDef arcDef : this.rrdDef.getArcDefs()) {
            TestInstanceRrd.RawDataInfo rdi = new TestInstanceRrd.RawDataInfo(this, this.testInstance, this.testDefinition, this.rrdDef, Arrays.asList(this.rrdDef.getDsDefs()), arcDef, baseUri);
            res.add(rdi);
        }
        return res;
    }

    @Override
    public File makeGraph(TestInstanceRrd.GraphInfo graphInfo) throws IOException {
        File tmpFile = File.createTempFile(graphInfo.getId(), ".png");
        String subType = graphInfo.getSubType();
        RrdGraphDef gDef1 = new RrdGraphDef();
        gDef1.setWidth(500);
        gDef1.setHeight(300);
        gDef1.setFilename(tmpFile.getAbsolutePath());
        gDef1.setStartTime(graphInfo.getGraphStartTimeInSecondsSinceEpoch());
        gDef1.setEndTime(graphInfo.getGraphEndTimeInSecondsSinceEpoch());
        boolean knownSybType = false;
        if (subType.equals("all")) {
            knownSybType = true;
            gDef1.setUnitsExponent(0);
            gDef1.setAltAutoscale(true);
            gDef1.setVerticalLabel("available resources");
            String dsNickName = "free_all";
            gDef1.datasource(dsNickName + "_avg", this.rrdFile.getAbsolutePath(), this.makeDsName("free_all"), ConsolFun.AVERAGE);
            gDef1.datasource(dsNickName + "_min", this.rrdFile.getAbsolutePath(), this.makeDsName("free_all"), ConsolFun.MIN);
            gDef1.line(dsNickName + "_min", (Paint)ListResourcesRrd.colorByNr(0));
            gDef1.area(dsNickName + "_min", (Paint)new Color(0, 0, 0, 0));
            gDef1.datasource(dsNickName + "_max", this.rrdFile.getAbsolutePath(), this.makeDsName("free_all"), ConsolFun.MAX);
            gDef1.datasource(dsNickName + "_maxoff", dsNickName + "_max," + dsNickName + "_min,-");
            gDef1.stack(dsNickName + "_maxoff", (Paint)ListResourcesRrd.colorByNr(0), "Free Resources (min/max)");
            gDef1.line(dsNickName + "_avg", (Paint)ListResourcesRrd.brighterColorByNr(0), "Free Resources (average)");
        }
        if (subType.equals("detail")) {
            knownSybType = true;
            gDef1.setUnitsExponent(0);
            gDef1.setMinValue(0.0);
            List<String> dsDetailNames = Arrays.asList("raw", "vm", "ip4", "oflw");
            List<String> fullDetailNames = Arrays.asList("Raw Nodes", "VM Nodes", "IPv4 Addresses", "Openflow Controllers");
            if (this.graphRrdDb == null) {
                this.graphRrdDb = new RrdDb(this.rrdFile.getAbsolutePath(), true);
            }
            int nonZeroDetailCount = 0;
            for (int i = 0; i < dsDetailNames.size(); ++i) {
                String dsDetailName = dsDetailNames.get(i);
                String fullDetailName = fullDetailNames.get(i);
                int dsIndex = this.graphRrdDb.getDsIndex(this.makeDsName("tota_" + dsDetailName));
                Archive archive = this.graphRrdDb.getArchive(ConsolFun.MAX, graphInfo.getArcDef().getSteps());
                if (archive == null) {
                    throw new RuntimeException("Could not find RRA for MAX " + graphInfo.getArcDef().getSteps());
                }
                Robin robin = archive.getRobin(dsIndex);
                boolean hasNonZero = false;
                for (int r = 0; r < robin.getSize(); ++r) {
                    double v = robin.getValue(r);
                    if (v == Double.NaN || !(v > 0.0)) continue;
                    hasNonZero = true;
                    break;
                }
                if (!hasNonZero) continue;
                ++nonZeroDetailCount;
                gDef1.datasource("free_" + dsDetailName + "_avg", this.rrdFile.getAbsolutePath(), this.makeDsName("free_" + dsDetailName), ConsolFun.AVERAGE);
                gDef1.datasource("free_" + dsDetailName + "_min", this.rrdFile.getAbsolutePath(), this.makeDsName("free_" + dsDetailName), ConsolFun.MIN);
                gDef1.datasource("free_" + dsDetailName + "_max", this.rrdFile.getAbsolutePath(), this.makeDsName("free_" + dsDetailName), ConsolFun.MAX);
                gDef1.datasource("tota_" + dsDetailName, this.rrdFile.getAbsolutePath(), this.makeDsName("tota_" + dsDetailName), ConsolFun.MAX);
                gDef1.line("tota_" + dsDetailName, (Paint)ListResourcesRrd.darkerColorByNr(i), "Total " + fullDetailName);
                gDef1.datasource("free_" + dsDetailName + "_maxoff", "free_" + dsDetailName + "_max,free_" + dsDetailName + "_min,-");
                gDef1.area("free_" + dsDetailName + "_min", (Paint)new Color(0, 0, 0, 0), null);
                gDef1.stack("free_" + dsDetailName + "_maxoff", (Paint)ListResourcesRrd.colorByNr(i), "Free " + fullDetailName + " (min/max)");
                gDef1.line("free_" + dsDetailName + "_avg", (Paint)ListResourcesRrd.brighterColorByNr(i), "Free " + fullDetailName + " (average)");
            }
            if (nonZeroDetailCount == 0) {
                gDef1.comment("Note: There are no detailed statistics that have non zero data.");
            }
        }
        if (!knownSybType) {
            throw new RuntimeException("Unknown graph sub type: \"" + subType + "\" in graph of type \"" + graphInfo.getGraphDefinitionId() + "\"");
        }
        gDef1.setImageInfo("<img src='%s' width='%d' height='%d'>");
        gDef1.setImageFormat("png");
        LOG.debug("Rendering graph \"" + graphInfo.getId() + "\" to temp file \"" + tmpFile + "\"");
        RrdGraph graph1 = new RrdGraph(gDef1);
        LOG.debug("Rendered graph has size " + graph1.getRrdGraphInfo().getByteCount());
        return tmpFile;
    }
}

