/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.client;

import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClientConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClientDirect;
import be.iminds.ilabt.jfed.fedmon.webapi.client.TestInstanceFilter;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Admin;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Graph;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.JFedExperimenterGuiConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Log;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceMapping;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.User;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserInfo;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObject;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithUri;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.dropwizard.jackson.Jackson;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedmonWebApiCachedClient
implements FedmonWebApiClient {
    private static final Logger LOG = LoggerFactory.getLogger(FedmonWebApiCachedClient.class);
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();
    private final FedmonWebApiClientConfig config;
    private final FedmonWebApiClientDirect direct;
    Map<Class, LoadingCache<Object, Optional<? extends JsonLdObjectWithId>>> singleObjectCaches = new HashMap<Class, LoadingCache<Object, Optional<? extends JsonLdObjectWithId>>>();
    private LoadingCache<Integer, Optional<ServerGlimpse>> serverGlimpseCache = null;

    private <I, T extends JsonLdObjectWithUri & JsonLdObjectWithId<I>> LoadingCache<Object, Optional<? extends JsonLdObjectWithId>> getCache(final Class<T> objectClass) {
        LoadingCache cache = this.singleObjectCaches.get(objectClass);
        if (cache == null && this.useCache(objectClass)) {
            cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite((long)this.getCacheExpireTimeMinutes(objectClass), TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Object, Optional<? extends JsonLdObjectWithId>>(){

                public Optional<T> load(Object key) throws FedmonWebApiClient.FedmonWebApiClientException {
                    return FedmonWebApiCachedClient.this.direct.getById(objectClass, key);
                }
            });
        }
        return cache;
    }

    private <I, T extends JsonLdObjectWithId<I>> void clearCache(Class<T> objectClass) {
        LoadingCache<Object, Optional<? extends JsonLdObjectWithId>> cache = this.singleObjectCaches.get(objectClass);
        if (cache != null) {
            cache.invalidateAll();
        }
    }

    private LoadingCache<Integer, Optional<ServerGlimpse>> getServerGlimpseCache() {
        if (this.serverGlimpseCache == null) {
            this.serverGlimpseCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite((long)this.getCacheExpireTimeMinutes(ServerGlimpse.class), TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Integer, Optional<ServerGlimpse>>(){

                public Optional<ServerGlimpse> load(Integer serverId) throws FedmonWebApiClient.FedmonWebApiClientException {
                    return FedmonWebApiCachedClient.this.direct.getServerGlimpseByServerId(serverId);
                }
            });
        }
        return this.serverGlimpseCache;
    }

    private <I, T extends JsonLdObjectWithId<I>> boolean useCache(Class<T> objectClass) {
        if (objectClass.equals(TestInstance.class)) {
            return true;
        }
        if (objectClass.equals(TestDefinition.class)) {
            return true;
        }
        if (objectClass.equals(User.class)) {
            return true;
        }
        if (objectClass.equals(Testbed.class)) {
            return true;
        }
        if (objectClass.equals(Server.class)) {
            return true;
        }
        if (objectClass.equals(Service.class)) {
            return true;
        }
        if (objectClass.equals(Frequency.class)) {
            return true;
        }
        if (objectClass.equals(Result.class)) {
            return true;
        }
        if (objectClass.equals(ServerGlimpse.class)) {
            return true;
        }
        if (objectClass.equals(TestInstanceStatistics.class)) {
            return false;
        }
        return false;
    }

    private <T extends JsonLdObject> int getCacheExpireTimeMinutes(Class<T> objectClass) {
        if (objectClass.equals(TestInstance.class)) {
            return 30;
        }
        if (objectClass.equals(TestDefinition.class)) {
            return 30;
        }
        if (objectClass.equals(User.class)) {
            return 30;
        }
        if (objectClass.equals(Testbed.class)) {
            return 30;
        }
        if (objectClass.equals(Server.class)) {
            return 30;
        }
        if (objectClass.equals(Service.class)) {
            return 30;
        }
        if (objectClass.equals(Frequency.class)) {
            return 30;
        }
        if (objectClass.equals(Result.class)) {
            return 30;
        }
        if (objectClass.equals(ServerGlimpse.class)) {
            return 10;
        }
        if (objectClass.equals(TestInstanceStatistics.class)) {
            return 2;
        }
        throw new RuntimeException("Should not be cached!");
    }

    public FedmonWebApiCachedClient(FedmonWebApiClientConfig config) {
        this.config = config;
        this.direct = new FedmonWebApiClientDirect(config);
    }

    @Override
    @Nonnull
    public <T extends JsonLdObjectWithUri> Optional<T> getByUri(@Nonnull URI uri) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.direct.getByUri(uri);
    }

    public <I, T extends JsonLdObjectWithUri & JsonLdObjectWithId<I>> void invalidateCache(Class<T> objectClass) throws FedmonWebApiClient.FedmonWebApiClientException {
        LoadingCache<Object, Optional<JsonLdObjectWithId>> cache = this.getCache(objectClass);
        if (cache != null) {
            cache.invalidateAll();
        }
    }

    public <I, T extends JsonLdObjectWithUri & JsonLdObjectWithId<I>> void invalidateCacheForId(Class<T> objectClass, I id) throws FedmonWebApiClient.FedmonWebApiClientException {
        LoadingCache<Object, Optional<JsonLdObjectWithId>> cache = this.getCache(objectClass);
        if (cache != null) {
            cache.invalidate(id);
        }
    }

    @Override
    @Nonnull
    public <I, T extends JsonLdObjectWithUri & JsonLdObjectWithId<I>> Optional<T> getById(@Nonnull Class<T> objectClass, @Nonnull I id, boolean withEmbeddedLinkObjects) throws FedmonWebApiClient.FedmonWebApiClientException {
        try {
            LoadingCache<Object, Optional<JsonLdObjectWithId>> cache = this.getCache(objectClass);
            if (cache != null) {
                Optional res = (Optional)cache.get(id);
                if (!res.isPresent()) {
                    cache.invalidate(id);
                    return this.direct.getById(objectClass, id, withEmbeddedLinkObjects);
                }
                return res;
            }
            return this.direct.getById(objectClass, id, withEmbeddedLinkObjects);
        }
        catch (ExecutionException e) {
            throw new FedmonWebApiClient.FedmonWebApiClientException("Exception while cache fetched actual object", e);
        }
    }

    @Override
    @Nonnull
    public <I, T extends JsonLdObjectWithUri & JsonLdObjectWithId<I>> List<T> search(@Nonnull FedmonWebApiClient.FedmonFilter<I, T> filter, boolean withEmbeddedLinkObjects) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.search(filter, withEmbeddedLinkObjects, false);
    }

    @Override
    @Nonnull
    public <I, T extends JsonLdObjectWithUri & JsonLdObjectWithId<I>> List<T> search(@Nonnull FedmonWebApiClient.FedmonFilter<I, T> filter, boolean withEmbeddedLinkObjects, boolean full) throws FedmonWebApiClient.FedmonWebApiClientException {
        List<T> res = this.direct.search(filter, withEmbeddedLinkObjects, full);
        LoadingCache<Object, Optional<JsonLdObjectWithId>> cache = this.getCache(filter.getObjectClass());
        if (cache != null) {
            for (JsonLdObjectWithUri f : res) {
                cache.put(((JsonLdObjectWithId)f).getId(), Optional.of(f));
            }
        }
        return res;
    }

    @Override
    @Nonnull
    public <I, T extends JsonLdObjectWithUri & JsonLdObjectWithId<I>> Map<I, T> getAllIndexedById(@Nonnull Class<T> objectClass, boolean withEmbeddedLinkObjects) throws FedmonWebApiClient.FedmonWebApiClientException {
        Map res = this.direct.getAllIndexedById(objectClass, withEmbeddedLinkObjects);
        LoadingCache<Object, Optional<JsonLdObjectWithId>> cache = this.getCache(objectClass);
        if (cache != null) {
            for (JsonLdObjectWithUri i : res.values()) {
                cache.put(((JsonLdObjectWithId)i).getId(), Optional.of(i));
            }
        }
        return res;
    }

    @Override
    @Nonnull
    public <T extends JsonLdObjectWithUri> List<T> getAll(@Nonnull Class<T> objectClass, boolean withEmbeddedLinkObjects) throws FedmonWebApiClient.FedmonWebApiClientException {
        LoadingCache<Integer, Optional<ServerGlimpse>> cache;
        Class<T> fullObjectClass;
        LoadingCache<Object, Optional<JsonLdObjectWithId>> cache2;
        List<T> res = this.direct.getAll(objectClass, withEmbeddedLinkObjects);
        if (JsonLdObjectWithId.class.isAssignableFrom(objectClass) && (cache2 = this.getCache(fullObjectClass = objectClass)) != null) {
            for (JsonLdObjectWithUri i : res) {
                JsonLdObjectWithId f = (JsonLdObjectWithId)i;
                cache2.put(f.getId(), Optional.of(f));
            }
        }
        if (ServerGlimpse.class.equals(objectClass) && (cache = this.getServerGlimpseCache()) != null) {
            for (JsonLdObjectWithUri i : res) {
                ServerGlimpse f = (ServerGlimpse)i;
                cache.put((Object)f.getServerId(), Optional.of(f));
            }
        }
        return res;
    }

    @Override
    @Nonnull
    public <T extends JsonLdObjectWithUri> T create(@Nonnull T object) throws FedmonWebApiClient.FedmonWebApiClientException {
        LoadingCache<Object, Optional<JsonLdObjectWithId>> cache;
        JsonLdObjectWithId jsonLdObjectWithId;
        if (!(object instanceof JsonLdObjectWithId) && (jsonLdObjectWithId = (JsonLdObjectWithId)object).getId() != null && (cache = this.getCache(object.getClass())) != null) {
            cache.invalidate(jsonLdObjectWithId.getId());
        }
        return this.direct.create(object);
    }

    @Override
    @Nonnull
    public <T extends JsonLdObjectWithUri> T update(@Nonnull T object) throws FedmonWebApiClient.FedmonWebApiClientException {
        JsonLdObjectWithId jsonLdObjectWithId;
        LoadingCache<Object, Optional<JsonLdObjectWithId>> cache;
        if (!(object instanceof JsonLdObjectWithId) && (cache = this.getCache((jsonLdObjectWithId = (JsonLdObjectWithId)object).getClass())) != null) {
            cache.invalidate(jsonLdObjectWithId.getId());
        }
        return this.direct.update(object);
    }

    @Override
    public <T extends JsonLdObjectWithUri> void delete(@Nonnull T object) throws FedmonWebApiClient.FedmonWebApiClientException {
        JsonLdObjectWithId jsonLdObjectWithId;
        LoadingCache<Object, Optional<JsonLdObjectWithId>> cache;
        if (!(object instanceof JsonLdObjectWithId) && (cache = this.getCache((jsonLdObjectWithId = (JsonLdObjectWithId)object).getClass())) != null) {
            cache.invalidate(jsonLdObjectWithId.getId());
        }
        this.direct.delete(object);
    }

    @Override
    public <I, T extends JsonLdObjectWithUri & JsonLdObjectWithId<I>> void deleteById(@Nonnull Class<T> objectClass, @Nonnull I id) throws FedmonWebApiClient.FedmonWebApiClientException {
        LoadingCache<Object, Optional<JsonLdObjectWithId>> cache = this.getCache(objectClass);
        if (cache != null) {
            cache.invalidate(id);
        }
        this.direct.deleteById(objectClass, id);
    }

    @Override
    public void deleteByUri(@Nonnull URI uri) throws FedmonWebApiClient.FedmonWebApiClientException {
        this.direct.deleteByUri(uri);
    }

    @Override
    @Nonnull
    public Collection<Task> createTasks(int maxCount, @Nonnull String runInfo, TestInstanceFilter filter) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.direct.createTasks(maxCount, runInfo, filter);
    }

    @Override
    @Nonnull
    public Collection<Task> createStressTestTasks(int stresstestCount, int testInstanceId, @Nonnull String runInfo) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.direct.createStressTestTasks(stresstestCount, testInstanceId, runInfo);
    }

    @Override
    public Admin getAdminConfig() throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.direct.getAdminConfig();
    }

    @Override
    @Nonnull
    public JFedExperimenterGuiConfig getJFedExperimenterGuiConfig(@Nonnull UserInfo userInfo) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.direct.getJFedExperimenterGuiConfig(userInfo);
    }

    @Override
    public void changeAdminKeyValue(@Nonnull String key, boolean value) throws FedmonWebApiClient.FedmonWebApiClientException {
        this.direct.changeAdminKeyValue(key, value);
    }

    @Override
    public void createResourceMapping(@Nonnull ResourceMapping mapping) throws FedmonWebApiClient.FedmonWebApiClientException {
        this.direct.createResourceMapping(mapping);
    }

    @Override
    public void deleteResourceMapping(@Nonnull ResourceMapping mapping) throws FedmonWebApiClient.FedmonWebApiClientException {
        this.direct.deleteResourceMapping(mapping);
    }

    @Override
    @Nonnull
    public Optional<ServerGlimpse> getServerGlimpseByServerId(@Nonnull Integer serverId) throws FedmonWebApiClient.FedmonWebApiClientException {
        try {
            LoadingCache<Integer, Optional<ServerGlimpse>> cache = this.getServerGlimpseCache();
            if (cache != null) {
                Optional res = (Optional)cache.get((Object)serverId);
                if (!res.isPresent()) {
                    cache.invalidate((Object)serverId);
                    return this.direct.getServerGlimpseByServerId(serverId);
                }
                return res;
            }
            return this.direct.getServerGlimpseByServerId(serverId);
        }
        catch (ExecutionException e) {
            throw new FedmonWebApiClient.FedmonWebApiClientException("Exception while cache fetched ServerGlimpse", e);
        }
    }

    @Override
    @Nonnull
    public ServerGlimpse upsert(@Nonnull ServerGlimpse serverGlimpse) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.direct.upsert(serverGlimpse);
    }

    @Override
    @Nonnull
    public Optional<TestInstanceStatistics> getTestInstanceStatisticsByTestInstanceId(@Nonnull Integer testInstanceId) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.direct.getTestInstanceStatisticsByTestInstanceId(testInstanceId);
    }

    @Override
    @Nonnull
    public List<TestInstanceStatistics> searchTestInstanceStatistics(@Nonnull TestInstanceFilter testInstanceFilter) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.direct.searchTestInstanceStatistics(testInstanceFilter);
    }

    @Override
    @Nonnull
    public TestInstanceStatistics updateTestInstanceStatisticsNextRun(@Nonnull Integer testInstanceId, @Nonnull Timestamp nextRun) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.direct.updateTestInstanceStatisticsNextRun(testInstanceId, nextRun);
    }

    @Override
    @Nonnull
    public TestInstanceStatistics setTestInstanceStatisticsRunNow(@Nonnull Integer testInstanceId) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.direct.setTestInstanceStatisticsRunNow(testInstanceId);
    }

    @Override
    @Nonnull
    public String getStringContent(@Nonnull Log log) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.direct.getStringContent(log);
    }

    @Override
    @Nonnull
    public byte[] getBinaryContent(@Nonnull Log log) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.direct.getBinaryContent(log);
    }

    @Override
    public void appendStringContent(@Nonnull Log log, @Nonnull String content, boolean complete) throws FedmonWebApiClient.FedmonWebApiClientException {
        this.direct.appendStringContent(log, content, complete);
    }

    @Override
    public void appendBinaryContent(@Nonnull Log log, @Nonnull byte[] content, boolean complete) throws FedmonWebApiClient.FedmonWebApiClientException {
        this.direct.appendBinaryContent(log, content, complete);
    }

    @Override
    @Nullable
    public byte[] getImageData(@Nonnull Graph graph) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.direct.getImageData(graph);
    }

    @Override
    public void setImageData(@Nonnull Graph graph, byte[] imageData) throws FedmonWebApiClient.FedmonWebApiClientException {
        this.direct.setImageData(graph, imageData);
    }
}

