/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.client;

import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClientConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.client.MutableHttpCallDetails;
import be.iminds.ilabt.jfed.fedmon.webapi.client.TestInstanceFilter;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Admin;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Graph;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.JFedExperimenterGuiConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Log;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceMapping;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatisticsBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.User;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserInfo;
import be.iminds.ilabt.jfed.log.ApiCallDetails;
import be.iminds.ilabt.jfed.lowlevel.connection.ApiCallReply;
import be.iminds.ilabt.jfed.lowlevel.connection.BasicConnectionBuilderFactory;
import be.iminds.ilabt.jfed.lowlevel.connection.ConnectionBuilder;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.HttpCallDetails;
import be.iminds.ilabt.jfed.lowlevel.connection.HttpConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectBuilder;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithIdBuilder;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithUri;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithUriBuilder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.ByteStreams;
import io.dropwizard.jackson.Jackson;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedmonWebApiClientDirect
implements FedmonWebApiClient {
    private static final Logger LOG = LoggerFactory.getLogger(FedmonWebApiClientDirect.class);
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();
    private final JsonLdObjectsMetaData jsonLdObjectsMetaData;
    private final FedmonWebApiClientConfig config;
    private final BasicConnectionBuilderFactory connectionBuilderFactory = new BasicConnectionBuilderFactory("FedmonWebApiClient/2.0");

    public FedmonWebApiClientDirect(FedmonWebApiClientConfig config) {
        this.jsonLdObjectsMetaData = JsonLdObjectsMetaData.getInstance((String)Testbed.class.getPackage().getName());
        this.config = config;
    }

    @Override
    @Nonnull
    public <T extends JsonLdObjectWithUri> Optional<T> getByUri(@Nonnull URI uri) throws FedmonWebApiClient.FedmonWebApiClientException {
        Class objectClass = this.jsonLdObjectsMetaData.getObjectClassFromUri(uri);
        ServerResponse serverResponse = this.contactServer(uri, (HttpEntity)null, HttpMethod.GET, null, null);
        serverResponse.throwIfNotOkOr404();
        return FedmonWebApiClientDirect.processOptionalResultHelper(serverResponse, objectClass);
    }

    @Override
    @Nonnull
    public <I, T extends JsonLdObjectWithId<I> & JsonLdObjectWithUri> Optional<T> getById(@Nonnull Class<T> objectClass, @Nonnull I id, boolean withEmbeddedLinkObjects) throws FedmonWebApiClient.FedmonWebApiClientException {
        assert (objectClass != null);
        assert (id != null);
        boolean read = !objectClass.equals(User.class);
        URIBuilder builder = this.config.getUriBuilder(objectClass, "" + id, read);
        if (withEmbeddedLinkObjects) {
            builder.addParameter("embed", "true");
        }
        ServerResponse serverResponse = this.contactServer(builder, null, HttpMethod.GET);
        serverResponse.throwIfNotOkOr404();
        return FedmonWebApiClientDirect.processOptionalResultHelper(serverResponse, objectClass);
    }

    @Override
    @Nonnull
    public <I, T extends JsonLdObjectWithUri & JsonLdObjectWithId<I>> List<T> search(@Nonnull FedmonWebApiClient.FedmonFilter<I, T> filter, boolean withEmbeddedLinkObjects) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.search(filter, withEmbeddedLinkObjects, false);
    }

    @Override
    @Nonnull
    public <I, T extends JsonLdObjectWithUri & JsonLdObjectWithId<I>> List<T> search(@Nonnull FedmonWebApiClient.FedmonFilter<I, T> filter, boolean withEmbeddedLinkObjects, boolean full) throws FedmonWebApiClient.FedmonWebApiClientException {
        assert (filter != null);
        Class<T> objectClass = filter.getObjectClass();
        boolean read = !objectClass.equals(User.class);
        URIBuilder builder = this.config.getUriBuilder(objectClass, read);
        if (withEmbeddedLinkObjects) {
            builder.addParameter("embed", "true");
        }
        if (full) {
            builder.addParameter("full", "true");
        }
        builder = filter.addToUriParameters(builder);
        ServerResponse serverResponse = this.contactServer(builder, null, HttpMethod.GET);
        serverResponse.throwIfNoData();
        serverResponse.throwIf404();
        serverResponse.throwIfNotOk();
        return FedmonWebApiClientDirect.processListResultHelper(serverResponse, objectClass);
    }

    @Override
    @Nonnull
    public <I, T extends JsonLdObjectWithUri & JsonLdObjectWithId<I>> Map<I, T> getAllIndexedById(@Nonnull Class<T> objectClass, boolean withEmbeddedLinkObjects) throws FedmonWebApiClient.FedmonWebApiClientException {
        List<T> all = this.getAll(objectClass, withEmbeddedLinkObjects);
        HashMap<Object, JsonLdObjectWithUri> res = new HashMap<Object, JsonLdObjectWithUri>();
        for (JsonLdObjectWithUri r : all) {
            res.put(((JsonLdObjectWithId)r).getId(), r);
        }
        return res;
    }

    @Override
    @Nonnull
    public <T extends JsonLdObjectWithUri> List<T> getAll(@Nonnull Class<T> objectClass, boolean withEmbeddedLinkObjects) throws FedmonWebApiClient.FedmonWebApiClientException {
        boolean read = !objectClass.equals(User.class);
        URIBuilder builder = this.config.getUriBuilder(objectClass, read);
        if (withEmbeddedLinkObjects) {
            builder.addParameter("embed", "true");
        }
        ServerResponse serverResponse = this.contactServer(builder, null, HttpMethod.GET);
        serverResponse.throwIfNoData();
        serverResponse.throwIf404();
        serverResponse.throwIfNotOk();
        List<T> all = FedmonWebApiClientDirect.processListResultHelper(serverResponse, objectClass);
        return all;
    }

    @Override
    @Nonnull
    public <T extends JsonLdObjectWithUri> T create(@Nonnull T object) throws FedmonWebApiClient.FedmonWebApiClientException {
        String jsonData;
        assert (object != null);
        Class<?> objectClass = object.getClass();
        JsonLdObjectBuilder builder = JsonLdObjectsMetaData.createBuilderCopy(object);
        JsonLdObjectWithUri minimized = objectClass.equals(Testbed.class) ? (JsonLdObjectWithUri)builder.createMinimized(JsonLdObjectsMetaData.Minimization.FULL_EMBEDDING_PARENT_AND_CHILDREN_NOBACKLINK) : (objectClass.equals(Server.class) ? (JsonLdObjectWithUri)builder.createMinimized(JsonLdObjectsMetaData.Minimization.FULL_EMBED_CHILDREN_LINK_PARENT) : (JsonLdObjectWithUri)builder.createMinimized(JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS));
        try {
            jsonData = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)minimized);
        }
        catch (JsonProcessingException e) {
            throw new FedmonWebApiClient.FedmonWebApiClientException("Error converting testbed to JSON", e);
        }
        LOG.debug("Sending insert of: " + jsonData);
        ServerResponse serverResponse = this.contactServer(this.config.getUriBuilder(objectClass, false), jsonData, HttpMethod.POST);
        serverResponse.throwIfNotOk();
        if (serverResponse.isCreated()) {
            URI createdURI;
            LOG.debug("create() got 201 CREATED reply. msg=\"" + serverResponse.getJsonReply() + "\" location=\"" + serverResponse.getLocation() + "\"");
            if (serverResponse.getLocation() == null || serverResponse.getLocation().trim().isEmpty()) {
                throw new FedmonWebApiClient.FedmonWebApiClientException("HTTP create reply CREATED response unexpectedly contained no/empty \"Location\" header. code=" + serverResponse.getHttpCode() + " msg=\"" + serverResponse.getJsonReply() + "\" location=\"" + serverResponse.getLocation() + "\"");
            }
            try {
                createdURI = new URI(serverResponse.getLocation());
            }
            catch (URISyntaxException e) {
                throw new FedmonWebApiClient.FedmonWebApiClientException("Did not get expected URI. Got: \"" + serverResponse.getJsonReply() + "\"");
            }
            JsonLdObjectWithUriBuilder resBuilder = JsonLdObjectsMetaData.createJsonLdObjectWithUriBuilder(objectClass);
            resBuilder.setUri(createdURI);
            if (resBuilder instanceof JsonLdObjectWithIdBuilder) {
                JsonLdObjectWithIdBuilder jsonLdObjectWithIdBuilder = (JsonLdObjectWithIdBuilder)resBuilder;
                jsonLdObjectWithIdBuilder.setId(this.extractIdFromUri(createdURI));
            }
            return (T)((JsonLdObjectWithUri)resBuilder.createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY));
        }
        serverResponse.throwIfNoData();
        if (serverResponse.getJsonReply().trim().isEmpty()) {
            throw new FedmonWebApiClient.FedmonWebApiClientException("HTTP request unexpectedly returned empty data. code=" + serverResponse.getHttpCode() + " msg=\"" + serverResponse.getJsonReply() + "\"");
        }
        JsonLdObjectWithUri reply = (JsonLdObjectWithUri)FedmonWebApiClientDirect.processResultHelper(serverResponse, objectClass, true);
        if (reply == null) {
            throw new FedmonWebApiClient.FedmonWebApiClientException("Got no reply on POST Testbed");
        }
        return (T)reply;
    }

    private Object extractIdFromUri(@Nonnull URI uri) {
        assert (!uri.toASCIIString().trim().isEmpty());
        LOG.debug("extractIdFromUri(" + uri.toASCIIString() + ")");
        String idString = uri.toASCIIString().replaceAll(".*/", "");
        if (idString.trim().isEmpty()) {
            return null;
        }
        if (idString.matches("[0-9]*")) {
            return Integer.parseInt(idString);
        }
        return idString;
    }

    @Override
    @Nonnull
    public <T extends JsonLdObjectWithUri> T update(@Nonnull T object) throws FedmonWebApiClient.FedmonWebApiClientException {
        URIBuilder uriBuilder;
        String jsonData;
        assert (object != null);
        assert (!(object instanceof JsonLdObjectWithId) || ((JsonLdObjectWithId)object).getId() != null);
        Class<?> objectClass = object.getClass();
        JsonLdObjectBuilder builder = JsonLdObjectsMetaData.createBuilderCopy(object);
        JsonLdObjectWithUri minimized = objectClass.equals(Testbed.class) ? (JsonLdObjectWithUri)builder.createMinimized(JsonLdObjectsMetaData.Minimization.FULL_NO_CHILDREN_PARENT_ID_ONLY) : (JsonLdObjectWithUri)builder.createMinimized(JsonLdObjectsMetaData.Minimization.FULL_WITH_LINK_IDS);
        try {
            jsonData = MAPPER.writer().writeValueAsString((Object)minimized);
        }
        catch (JsonProcessingException e) {
            throw new FedmonWebApiClient.FedmonWebApiClientException("Error converting " + objectClass.getName() + " to JSON", e);
        }
        if (object instanceof JsonLdObjectWithId) {
            JsonLdObjectWithId jsonLdObjectWithId = (JsonLdObjectWithId)object;
            assert (jsonLdObjectWithId.getId() != null);
            uriBuilder = this.config.getUriBuilder(objectClass, "" + jsonLdObjectWithId.getId(), false);
        } else {
            assert (object.getUri() != null);
            try {
                uriBuilder = new URIBuilder(object.getUri().toASCIIString());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Object had invalid URI: \"" + object.getUri().toASCIIString() + "\"", e);
            }
        }
        ServerResponse serverResponse = this.contactServer(uriBuilder, jsonData, HttpMethod.PUT);
        serverResponse.throwIfNotOk();
        serverResponse.throwIfNoData();
        return (T)((JsonLdObjectWithUri)FedmonWebApiClientDirect.processResultHelper(serverResponse, objectClass, false));
    }

    @Override
    public <T extends JsonLdObjectWithUri> void delete(@Nonnull T object) throws FedmonWebApiClient.FedmonWebApiClientException {
        URIBuilder builder;
        assert (object != null);
        Class<?> objectClass = object.getClass();
        if (object instanceof JsonLdObjectWithId) {
            JsonLdObjectWithId jsonLdObjectWithId = (JsonLdObjectWithId)object;
            assert (jsonLdObjectWithId.getId() != null);
            builder = this.config.getUriBuilder(objectClass, "" + jsonLdObjectWithId.getId(), false);
        } else {
            assert (object.getUri() != null);
            try {
                builder = new URIBuilder(object.getUri().toASCIIString());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Object had invalid URI: \"" + object.getUri().toASCIIString() + "\"", e);
            }
        }
        ServerResponse serverResponse = this.contactServer(builder, null, HttpMethod.DELETE);
        serverResponse.throwIfNotOk();
        serverResponse.throwIfData();
    }

    @Override
    public <I, T extends JsonLdObjectWithUri & JsonLdObjectWithId<I>> void deleteById(@Nonnull Class<T> objectClass, @Nonnull I id) throws FedmonWebApiClient.FedmonWebApiClientException {
        URIBuilder builder = this.config.getUriBuilder(objectClass, "" + id, false);
        ServerResponse serverResponse = this.contactServer(builder, null, HttpMethod.DELETE);
        serverResponse.throwIfNotOk();
        serverResponse.throwIfData();
    }

    @Override
    public void deleteByUri(@Nonnull URI uri) throws FedmonWebApiClient.FedmonWebApiClientException {
        ServerResponse serverResponse = this.contactServer(uri, (HttpEntity)null, HttpMethod.DELETE, null, null);
        serverResponse.throwIfNotOk();
        serverResponse.throwIfData();
    }

    @Override
    @Nonnull
    public Collection<Task> createTasks(int maxCount, @Nonnull String runInfo, @Nullable TestInstanceFilter filter) throws FedmonWebApiClient.FedmonWebApiClientException {
        URIBuilder builder = this.config.getUriBuilder(Task.class, false);
        if (filter != null) {
            builder = filter.addToUriParameters(builder);
        }
        builder = builder.addParameter("maxCount", "" + maxCount);
        builder = builder.addParameter("runInfo", runInfo);
        ServerResponse serverResponse = this.contactServer(builder, null, HttpMethod.POST);
        serverResponse.throwIfNoData();
        serverResponse.throwIf404();
        serverResponse.throwIfNotOk();
        return FedmonWebApiClientDirect.processListResultHelper(serverResponse, Task.class);
    }

    @Override
    @Nonnull
    public Collection<Task> createStressTestTasks(int stresstestCount, int testInstanceId, @Nonnull String runInfo) throws FedmonWebApiClient.FedmonWebApiClientException {
        URIBuilder builder = this.config.getUriBuilder(Task.class, false);
        builder = builder.addParameter("testinstanceid", "" + testInstanceId);
        builder = builder.addParameter("stresstestCount", "" + stresstestCount);
        builder = builder.addParameter("runInfo", runInfo);
        ServerResponse serverResponse = this.contactServer(builder, null, HttpMethod.POST);
        serverResponse.throwIfNoData();
        serverResponse.throwIf404();
        serverResponse.throwIfNotOk();
        return FedmonWebApiClientDirect.processListResultHelper(serverResponse, Task.class);
    }

    @Override
    public Admin getAdminConfig() throws FedmonWebApiClient.FedmonWebApiClientException {
        URIBuilder builder = this.config.getUriBuilder(Admin.class, "", true);
        ServerResponse serverResponse = this.contactServer(builder, null, HttpMethod.GET);
        serverResponse.throwIfNotOk();
        return FedmonWebApiClientDirect.processResultHelper(serverResponse, Admin.class, false);
    }

    @Override
    @Nonnull
    public JFedExperimenterGuiConfig getJFedExperimenterGuiConfig(@Nonnull UserInfo userInfo) throws FedmonWebApiClient.FedmonWebApiClientException {
        Map queryParameters = userInfo.getQueryParameters();
        URIBuilder builder = this.config.getUriBuilder(JFedExperimenterGuiConfig.class, "", true);
        for (Map.Entry e : queryParameters.entrySet()) {
            builder.addParameter((String)e.getKey(), "" + e.getValue());
        }
        ServerResponse serverResponse = this.contactServer(builder, null, HttpMethod.GET);
        serverResponse.throwIfNotOk();
        return FedmonWebApiClientDirect.processResultHelper(serverResponse, JFedExperimenterGuiConfig.class, false);
    }

    @Override
    public void changeAdminKeyValue(@Nonnull String key, boolean value) throws FedmonWebApiClient.FedmonWebApiClientException {
        String jsonData = "{ \"" + key + "\" : " + value + " }";
        ServerResponse serverResponse = this.contactServer(this.config.getUriBuilder(Admin.class, false), jsonData, HttpMethod.PUT);
        serverResponse.throwIfNotOk();
        serverResponse.throwIfData();
    }

    @Override
    public void createResourceMapping(@Nonnull ResourceMapping mapping) throws FedmonWebApiClient.FedmonWebApiClientException {
        String jsonData;
        try {
            jsonData = MAPPER.writer().writeValueAsString((Object)mapping);
        }
        catch (JsonProcessingException e) {
            throw new FedmonWebApiClient.FedmonWebApiClientException("Error converting ResourceMapping to JSON", e);
        }
        ServerResponse serverResponse = this.contactServer(this.config.getUriBuilder(ResourceMapping.class, false), jsonData, HttpMethod.POST);
        serverResponse.throwIfNotOk();
        serverResponse.throwIfData();
    }

    @Override
    public void deleteResourceMapping(@Nonnull ResourceMapping mapping) throws FedmonWebApiClient.FedmonWebApiClientException {
        ServerResponse serverResponse = this.contactServer(this.config.getUriBuilder(ResourceMapping.class, mapping.getResourceId() + "/" + mapping.getResourceClassId() + "/" + mapping.getConfigSetId(), false), null, HttpMethod.DELETE);
        serverResponse.throwIfNotOk();
        serverResponse.throwIfData();
    }

    @Override
    @Nonnull
    public Optional<ServerGlimpse> getServerGlimpseByServerId(@Nonnull Integer serverId) throws FedmonWebApiClient.FedmonWebApiClientException {
        assert (serverId != null);
        URIBuilder builder = this.config.getUriBuilder(ServerGlimpse.class, "" + serverId, true);
        ServerResponse serverResponse = this.contactServer(builder, null, HttpMethod.GET);
        serverResponse.throwIfNotOkOr404();
        return FedmonWebApiClientDirect.processOptionalResultHelper(serverResponse, ServerGlimpse.class);
    }

    @Override
    @Nonnull
    public ServerGlimpse upsert(@Nonnull ServerGlimpse serverGlimpse) throws FedmonWebApiClient.FedmonWebApiClientException {
        String jsonData;
        assert (serverGlimpse != null) : "serverGlimpse is null";
        assert (serverGlimpse.getServerId() != null) : "serverGlimpse has no serverId";
        try {
            jsonData = MAPPER.writer().writeValueAsString((Object)serverGlimpse);
        }
        catch (JsonProcessingException e) {
            throw new FedmonWebApiClient.FedmonWebApiClientException("Error converting ServerGlimpse to JSON", e);
        }
        ServerResponse serverResponse = this.contactServer(this.config.getUriBuilder(ServerGlimpse.class, "" + serverGlimpse.getServerId(), false), jsonData, HttpMethod.PUT);
        serverResponse.throwIfNotOk();
        serverResponse.throwIfNoData();
        return FedmonWebApiClientDirect.processResultHelper(serverResponse, ServerGlimpse.class, false);
    }

    @Override
    @Nonnull
    public Optional<TestInstanceStatistics> getTestInstanceStatisticsByTestInstanceId(@Nonnull Integer testInstanceId) throws FedmonWebApiClient.FedmonWebApiClientException {
        assert (testInstanceId != null);
        URIBuilder builder = this.config.getUriBuilder(TestInstanceStatistics.class, "" + testInstanceId, true);
        ServerResponse serverResponse = this.contactServer(builder, null, HttpMethod.GET);
        serverResponse.throwIfNotOkOr404();
        return FedmonWebApiClientDirect.processOptionalResultHelper(serverResponse, TestInstanceStatistics.class);
    }

    @Override
    @Nonnull
    public List<TestInstanceStatistics> searchTestInstanceStatistics(@Nonnull TestInstanceFilter testInstanceFilter) throws FedmonWebApiClient.FedmonWebApiClientException {
        assert (testInstanceFilter != null);
        URIBuilder builder = this.config.getUriBuilder(TestInstanceStatistics.class, true);
        builder = testInstanceFilter.addToUriParameters(builder);
        ServerResponse serverResponse = this.contactServer(builder, null, HttpMethod.GET);
        serverResponse.throwIfNoData();
        serverResponse.throwIf404();
        serverResponse.throwIfNotOk();
        return FedmonWebApiClientDirect.processListResultHelper(serverResponse, TestInstanceStatistics.class);
    }

    @Override
    @Nonnull
    public TestInstanceStatistics updateTestInstanceStatisticsNextRun(@Nonnull Integer testInstanceId, @Nonnull Timestamp nextRun) throws FedmonWebApiClient.FedmonWebApiClientException {
        String jsonData;
        TestInstanceStatistics testInstanceStatistics = new TestInstanceStatisticsBuilder().setTestInstanceId(testInstanceId).setNextRun(nextRun).create();
        assert (testInstanceStatistics != null);
        Class<TestInstanceStatistics> objectClass = TestInstanceStatistics.class;
        try {
            jsonData = MAPPER.writer().writeValueAsString((Object)testInstanceStatistics);
        }
        catch (JsonProcessingException e) {
            throw new FedmonWebApiClient.FedmonWebApiClientException("Error converting testbed to JSON", e);
        }
        ServerResponse serverResponse = this.contactServer(this.config.getUriBuilder(objectClass, "" + testInstanceId, false), jsonData, HttpMethod.PUT);
        serverResponse.throwIfNotOk();
        serverResponse.throwIfNoData();
        return FedmonWebApiClientDirect.processResultHelper(serverResponse, objectClass, false);
    }

    @Override
    @Nonnull
    public TestInstanceStatistics setTestInstanceStatisticsRunNow(@Nonnull Integer testInstanceId) throws FedmonWebApiClient.FedmonWebApiClientException {
        return this.updateTestInstanceStatisticsNextRun(testInstanceId, new Timestamp(System.currentTimeMillis()));
    }

    @Nonnull
    private URI modifyUri(@Nonnull URI contentUri, boolean read) {
        try {
            URIBuilder uriBuilder = this.config.getUriBuilder(Log.class, "", read);
            uriBuilder.setPath(contentUri.getPath());
            URI res = uriBuilder.build();
            LOG.debug("modifyUri(" + contentUri.toASCIIString() + ", read=" + read + ") = " + res.toASCIIString());
            return res;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Bug: Unexpected internal error while building URI", e);
        }
    }

    @Override
    @Nonnull
    public String getStringContent(@Nonnull Log log) throws FedmonWebApiClient.FedmonWebApiClientException {
        URI contentUri = log.getContent();
        if (contentUri == null) {
            throw new IllegalArgumentException("The provided log does not have content URI information. The server should not have given you such Log.");
        }
        assert (!log.getMediaType().equals((Object)Log.LogMediaType.BINARY));
        contentUri = this.modifyUri(contentUri, true);
        ServerResponse serverResponse = this.contactServer(contentUri, (HttpEntity)null, HttpMethod.GET, null, log.getMediaType().getHttpMediaTypeString());
        serverResponse.throwIfNotOk();
        return serverResponse.getJsonReply();
    }

    @Override
    @Nonnull
    public byte[] getBinaryContent(@Nonnull Log log) throws FedmonWebApiClient.FedmonWebApiClientException {
        URI contentUri = log.getContent();
        if (contentUri == null) {
            throw new IllegalArgumentException("The provided log does not have content URI information. The server should not have given you such Log.");
        }
        assert (log.getMediaType().equals((Object)Log.LogMediaType.BINARY));
        BinaryResponseHandler binaryResponseHandler = new BinaryResponseHandler();
        contentUri = this.modifyUri(contentUri, true);
        ServerResponse serverResponse = this.contactServer(contentUri, (HttpEntity)null, HttpMethod.GET, (ResponseHandler)binaryResponseHandler, log.getMediaType().getHttpMediaTypeString());
        serverResponse.throwIfNotOk();
        serverResponse.throwIfNoData();
        return binaryResponseHandler.getData();
    }

    @Override
    public void appendStringContent(@Nonnull Log log, @Nonnull String content, boolean complete) throws FedmonWebApiClient.FedmonWebApiClientException {
        URI contentUri = log.getContent();
        if (contentUri == null) {
            throw new IllegalArgumentException("The provided log does not have content URI information. The server should not have given you such Log.");
        }
        if (log.getMediaType() == null) {
            throw new IllegalArgumentException("The provided log does not have content mediaType information. The server should not have given you such Log.");
        }
        if (log.getMediaType().equals((Object)Log.LogMediaType.BINARY)) {
            throw new IllegalArgumentException("You can not send String content to a binary Log");
        }
        StringEntity stringEntity = new StringEntity(content, ContentType.create((String)log.getMediaType().getHttpMediaTypeString(), (String)"UTF-8"));
        contentUri = this.modifyUri(contentUri, false);
        ServerResponse serverResponse = this.contactServer(contentUri, (HttpEntity)stringEntity, HttpMethod.POST, null, null);
        serverResponse.throwIfNotOk();
        serverResponse.throwIfData();
    }

    @Override
    public void appendBinaryContent(@Nonnull Log log, @Nonnull byte[] content, boolean complete) throws FedmonWebApiClient.FedmonWebApiClientException {
        URI contentUri = log.getContent();
        if (contentUri == null) {
            throw new IllegalArgumentException("The provided log does not have content URI information. The server should not have given you such Log.");
        }
        if (log.getMediaType() == null) {
            throw new IllegalArgumentException("The provided log does not have content mediaType information. The server should not have given you such Log.");
        }
        if (!log.getMediaType().equals((Object)Log.LogMediaType.BINARY)) {
            throw new IllegalArgumentException("You can not send binary content to a " + log.getMediaType() + " Log");
        }
        ByteArrayEntity binaryEntity = new ByteArrayEntity(content, ContentType.create((String)log.getMediaType().getHttpMediaTypeString()));
        contentUri = this.modifyUri(contentUri, false);
        ServerResponse serverResponse = this.contactServer(contentUri, (HttpEntity)binaryEntity, HttpMethod.POST, null, null);
        serverResponse.throwIfNotOk();
        serverResponse.throwIfData();
    }

    @Override
    @Nullable
    public byte[] getImageData(@Nonnull Graph graph) throws FedmonWebApiClient.FedmonWebApiClientException {
        URI imageDataUri = graph.getImageUri();
        if (imageDataUri == null) {
            throw new IllegalArgumentException("The provided Graph does not have image URI information. The server should not have given you such Graph.");
        }
        BinaryResponseHandler binaryResponseHandler = new BinaryResponseHandler();
        imageDataUri = this.modifyUri(imageDataUri, true);
        ServerResponse serverResponse = this.contactServer(imageDataUri, (HttpEntity)null, HttpMethod.GET, (ResponseHandler)binaryResponseHandler, "image/png");
        serverResponse.throwIfNotOk();
        if (serverResponse.hasNoData()) {
            return null;
        }
        return binaryResponseHandler.getData();
    }

    @Override
    public void setImageData(@Nonnull Graph graph, byte[] imageData) throws FedmonWebApiClient.FedmonWebApiClientException {
        URI imageDataUri = graph.getImageUri();
        if (imageDataUri == null) {
            throw new IllegalArgumentException("The provided Graph does not have image URI information. The server should not have given you such Graph.");
        }
        ByteArrayEntity binaryEntity = imageData == null ? null : new ByteArrayEntity(imageData, ContentType.create((String)"image/png"));
        imageDataUri = this.modifyUri(imageDataUri, false);
        ServerResponse serverResponse = this.contactServer(imageDataUri, (HttpEntity)binaryEntity, HttpMethod.PUT, null, null);
        serverResponse.throwIfNotOk();
        serverResponse.throwIfData();
    }

    private ServerResponse contactServer(URIBuilder builder, String jsonData, HttpMethod httpMethod) throws FedmonWebApiClient.FedmonWebApiClientException {
        try {
            URI uri = builder.build();
            return this.contactServer(uri, jsonData, httpMethod, null, null);
        }
        catch (URISyntaxException e) {
            throw new FedmonWebApiClient.FedmonWebApiClientException("Error constructing URI", e);
        }
    }

    public ServerResponse contactServer(URI uri, String jsonData, HttpMethod httpMethod, ResponseHandler alternateResponseHandler, String alternateAcceptHeader) throws FedmonWebApiClient.FedmonWebApiClientException {
        StringEntity myEntity = jsonData == null ? null : new StringEntity(jsonData, ContentType.create((String)"application/json", (String)"UTF-8"));
        return this.contactServer(uri, (HttpEntity)myEntity, httpMethod, alternateResponseHandler, alternateAcceptHeader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ServerResponse contactServer(URI uri, HttpEntity dataEntity, HttpMethod httpMethod, ResponseHandler alternateResponseHandler, String alternateAcceptHeader) throws FedmonWebApiClient.FedmonWebApiClientException {
        HttpDelete httpSend;
        HttpConnection con;
        MutableHttpCallDetails mutableHttpCallDetails = new MutableHttpCallDetails();
        assert (uri != null);
        assert (uri.toASCIIString() != null);
        assert (!uri.toASCIIString().trim().isEmpty());
        mutableHttpCallDetails.setServerUrl(uri.toASCIIString());
        LOG.debug("Building connection with URI \"" + uri.toASCIIString() + "\"");
        ConnectionBuilder connectionBuilder = this.connectionBuilderFactory.createConnectionBuilder();
        try {
            connectionBuilder.setUrl(uri.toURL());
            if (uri.getScheme().equals("http")) {
                connectionBuilder.useHttp();
                connectionBuilder.useNoAuthentication();
            } else if (uri.getScheme().equals("https")) {
                connectionBuilder.useHttps(this.config.getTrustStore(), null);
                if (this.config.getUserPrivateKey() != null && this.config.getUserCertificateChain() != null && !this.config.getUserCertificateChain().isEmpty()) {
                    connectionBuilder.useSslClientAuthentication(this.config.getUserCertificateChain(), this.config.getUserPrivateKey());
                } else {
                    connectionBuilder.useNoAuthentication();
                }
            } else {
                throw new FedmonWebApiClient.FedmonWebApiClientException("Unsupported scheme \"" + uri.getScheme() + "\" in URI \"" + uri.toASCIIString() + "\"");
            }
            connectionBuilder.setDebugInfo(JFedConnection.DebugInfo.createWithAllNull());
            connectionBuilder.setHackAllowAllServerCertificates(false);
            connectionBuilder.setProxy(null, false);
            con = connectionBuilder.buildHttpConnection();
            mutableHttpCallDetails.setConnection((JFedConnection)con);
            mutableHttpCallDetails.setConnectionConfig(con.getConnectionConfig());
            assert (con != null);
        }
        catch (JFedException e) {
            throw new FedmonWebApiClient.FedmonWebApiClientException("Problem creating connection", e);
        }
        catch (MalformedURLException e) {
            throw new FedmonWebApiClient.FedmonWebApiClientException("MalformedURLException for \"" + uri.toASCIIString() + "\"", e);
        }
        HttpClient httpClient = con.getHttpClient();
        switch (httpMethod) {
            case POST: {
                HttpPost httpPost = new HttpPost(uri);
                httpSend = httpPost;
                if (dataEntity == null) break;
                httpPost.setEntity(dataEntity);
                break;
            }
            case PUT: {
                HttpPut httpPut = new HttpPut(uri);
                httpSend = httpPut;
                if (dataEntity == null) break;
                httpPut.setEntity(dataEntity);
                break;
            }
            case DELETE: {
                httpSend = new HttpDelete(uri);
                break;
            }
            case GET: {
                httpSend = new HttpGet(uri);
                httpSend.addHeader("accept", alternateAcceptHeader != null ? alternateAcceptHeader : "application/json");
                break;
            }
            default: {
                throw new FedmonWebApiClient.FedmonWebApiClientException("Operation not supported: " + httpMethod);
            }
        }
        assert (httpSend != null);
        mutableHttpCallDetails.setRequestHttpHeaders(httpSend.getAllHeaders());
        mutableHttpCallDetails.setRequestHttpRequestLine(httpSend.getRequestLine());
        HttpResponse response = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("contactServer - " + httpMethod + " - " + (String)(dataEntity == null ? "no content" : dataEntity.getContentLength() + " bytes") + " - " + uri.toASCIIString());
            }
            mutableHttpCallDetails.setStartTime(new Date());
            con.markInUse();
            response = con.getHttpContext() != null ? httpClient.execute((HttpUriRequest)httpSend, con.getHttpContext()) : httpClient.execute((HttpUriRequest)httpSend);
            mutableHttpCallDetails.setStopTime(new Date());
            mutableHttpCallDetails.setRequestHttpContent(dataEntity);
            if (response == null) {
                throw new RuntimeException("Got unexpected null response from httpClient.execute");
            }
            mutableHttpCallDetails.setResultHttpHeaders(response.getAllHeaders());
            mutableHttpCallDetails.setResultHttpStatusLine(response.getStatusLine());
            if (response.getStatusLine() == null) {
                mutableHttpCallDetails.setResultHttpContent(response.getEntity());
                this.logFedmonReply(mutableHttpCallDetails, null, null, httpMethod.name(), (JFedConnection)con, null);
                throw new FedmonWebApiClient.FedmonWebApiClientException("HTTP error: no response StatusLine");
            }
            if (response.getStatusLine() != null && (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() >= 300)) {
                if (LOG.isDebugEnabled()) {
                    LOG.error("Call failed: Got HTTP " + response.getStatusLine().getStatusCode() + ": " + response.getStatusLine().getReasonPhrase());
                }
                mutableHttpCallDetails.setRequestHttpContent(dataEntity);
                mutableHttpCallDetails.setResultHttpContent(response.getEntity());
                this.logFedmonReply(mutableHttpCallDetails, null, null, httpMethod.name(), (JFedConnection)con, null);
                Header locationHeader = response.getFirstHeader("Location");
                ServerResponse serverResponse = new ServerResponse(response.getStatusLine().getStatusCode(), true, mutableHttpCallDetails.getResultHttpContent() != null ? mutableHttpCallDetails.getResultHttpContent() : response.getStatusLine().getReasonPhrase(), locationHeader == null ? null : locationHeader.getValue());
                return serverResponse;
            }
        }
        catch (SSLPeerUnverifiedException ex) {
            LOG.error("SSLPeerUnverifiedException exception.\nWill also call LogDebugInfoCallback to retrieve connection debug info.", (Throwable)ex);
            mutableHttpCallDetails.setStopTime(new Date());
            mutableHttpCallDetails.setRequestHttpContent(dataEntity);
            mutableHttpCallDetails.setResultHttpContent(response == null ? null : response.getEntity());
            this.logFedmonReply(mutableHttpCallDetails, null, null, httpMethod.name(), (JFedConnection)con, ex);
            throw new FedmonWebApiClient.FedmonWebApiClientException("The server certificate for '" + httpSend.getURI() + "' could not be verified. Error message \"" + ex.getMessage() + "\". Possible causes:\n  - The server's self-signed certificate is not in our trust store. \n  - The server's certificate \"CN\" field is not the server hostname or a known alias. \n  - The server is not accepting our client login certificate+key pair (perhaps is is not federated with our \"login provider\"). \n  - If the server's certificate is not self signed, we might not have the root certificate of the trust chain in our trust store.", ex);
        }
        catch (SSLException ex) {
            mutableHttpCallDetails.setStopTime(new Date());
            mutableHttpCallDetails.setRequestHttpContent(dataEntity);
            mutableHttpCallDetails.setResultHttpContent(response == null ? null : response.getEntity());
            this.logFedmonReply(mutableHttpCallDetails, null, null, httpMethod.name(), (JFedConnection)con, ex);
            throw new FedmonWebApiClient.FedmonWebApiClientException("SSLException for '" + httpSend.getURI() + "': " + ex.getMessage(), ex);
        }
        catch (ClientProtocolException ex) {
            mutableHttpCallDetails.setStopTime(new Date());
            mutableHttpCallDetails.setRequestHttpContent(dataEntity);
            mutableHttpCallDetails.setResultHttpContent(response == null ? null : response.getEntity());
            this.logFedmonReply(mutableHttpCallDetails, null, null, httpMethod.name(), (JFedConnection)con, (Exception)((Object)ex));
            throw new FedmonWebApiClient.FedmonWebApiClientException("ClientProtocolException for '" + httpSend.getURI() + "': " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            mutableHttpCallDetails.setStopTime(new Date());
            mutableHttpCallDetails.setRequestHttpContent(dataEntity);
            mutableHttpCallDetails.setResultHttpContent(response == null ? null : response.getEntity());
            this.logFedmonReply(mutableHttpCallDetails, null, null, httpMethod.name(), (JFedConnection)con, ex);
            throw new FedmonWebApiClient.FedmonWebApiClientException("IOException for '" + httpSend.getURI() + "': " + ex.getMessage(), ex);
        }
        finally {
            con.markNotInUse();
        }
        if (alternateResponseHandler != null) {
            ServerResponse res = alternateResponseHandler.handleOkResponse(response);
            this.logFedmonReply(mutableHttpCallDetails, res.getJsonReply(), null, httpMethod.name(), (JFedConnection)con, null);
            return res;
        }
        assert (response != null);
        try {
            InputStream replyContent;
            String replyString = null;
            HttpEntity entity = response.getEntity();
            if (entity != null && (replyContent = entity.getContent()) != null) {
                try {
                    replyString = IOUtils.streamToString((InputStream)replyContent, (String)"UTF-8");
                }
                finally {
                    try {
                        replyContent.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            mutableHttpCallDetails.setResultHttpContent(replyString);
            this.logFedmonReply(mutableHttpCallDetails, replyString, null, httpMethod.name(), (JFedConnection)con, null);
            Header locationHeader = response.getFirstHeader("Location");
            return new ServerResponse(response.getStatusLine().getStatusCode(), replyString == null, replyString, locationHeader == null ? null : locationHeader.getValue());
        }
        catch (IOException e) {
            LOG.error("Error consuming reply content");
            mutableHttpCallDetails.setResultHttpContent(response.getEntity());
            this.logFedmonReply(mutableHttpCallDetails, null, null, httpMethod.name(), (JFedConnection)con, e);
            throw new FedmonWebApiClient.FedmonWebApiClientException("IOException while consuming " + response.getStatusLine().getStatusCode() + " reply content", e);
        }
    }

    @Nullable
    @Contract(value="_, _, false -> !null")
    private static <T> T processResultHelper(ServerResponse serverResponse, Class<T> resClass, boolean nullOn404) throws FedmonWebApiClient.FedmonWebApiClientException {
        if (serverResponse.is404()) {
            if (nullOn404) {
                return null;
            }
            throw new FedmonWebApiClient.FedmonWebApiClientException("Not found");
        }
        try {
            Object res = MAPPER.readValue(serverResponse.getJsonReply(), resClass);
            return (T)res;
        }
        catch (IOException ex) {
            throw new FedmonWebApiClient.FedmonWebApiClientException("Json parse exception fetching " + resClass.getName() + ". reply: " + serverResponse.getJsonReply(), ex);
        }
    }

    private static <T> Optional<T> processOptionalResultHelper(ServerResponse serverResponse, Class<T> resClass) throws FedmonWebApiClient.FedmonWebApiClientException {
        if (serverResponse.is404()) {
            return Optional.empty();
        }
        try {
            String jsonReply = serverResponse.getJsonReply();
            assert (jsonReply != null) : "JSON reply is unexpectedly null. code=" + serverResponse.getHttpCode() + " nodata=" + serverResponse.hasNoData();
            Object res = MAPPER.readValue(jsonReply, resClass);
            return Optional.of(res);
        }
        catch (IOException ex) {
            throw new FedmonWebApiClient.FedmonWebApiClientException("Json parse exception fetching " + resClass.getName() + ". reply: " + serverResponse.getJsonReply(), ex);
        }
    }

    private static <T> List<T> processListResultHelper(ServerResponse serverResponse, Class<T> resClass) throws FedmonWebApiClient.FedmonWebApiClientException {
        try {
            List res = (List)MAPPER.readValue(serverResponse.getJsonReply(), (JavaType)MAPPER.getTypeFactory().constructCollectionType(List.class, resClass));
            return res;
        }
        catch (IOException ex) {
            throw new FedmonWebApiClient.FedmonWebApiClientException("Json parse exception fetching List of " + resClass.getName() + ". reply: " + serverResponse.getJsonReply(), ex);
        }
    }

    protected void logFedmonReply(HttpCallDetails httpCallDetails, String replyValue, String javaMethodName, String apiMethodName, JFedConnection con, Exception exception) {
        if (this.config.getLogger() == null) {
            return;
        }
        JFedConnection.DebugInfo debugInfo = con.getDebugInfo();
        String apiName = "Fedmon REST API";
        ApiCallDetails res = new ApiCallDetails(debugInfo == null ? null : debugInfo.getServiceId(), debugInfo == null ? null : debugInfo.getServerId(), debugInfo == null ? null : debugInfo.getServerName(), debugInfo == null ? null : debugInfo.getServerUrn(), debugInfo == null ? null : debugInfo.getTestbedId(), con.getConnectionConfig(), httpCallDetails != null ? httpCallDetails.getServerUrl() : con.getConnectionConfig().getServerUrlString(), "" + con.getConnectionId(), apiName, javaMethodName, apiMethodName, replyValue == null ? null : new FedmonReply<String>(httpCallDetails, replyValue), httpCallDetails == null ? null : httpCallDetails.getRequestHttpRequestLine(), httpCallDetails == null ? null : httpCallDetails.getRequestHttpHeaders(), httpCallDetails == null ? null : httpCallDetails.getRequestHttpContent(), httpCallDetails == null ? null : httpCallDetails.getResultHttpStatusLine(), httpCallDetails == null ? null : httpCallDetails.getResultHttpHeaders(), httpCallDetails == null ? null : httpCallDetails.getResultHttpContent(), null, null, null, httpCallDetails == null ? null : httpCallDetails.getStartTime(), httpCallDetails == null ? null : httpCallDetails.getStopTime(), (Throwable)exception);
        this.config.getLogger().fireResult(res);
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static enum HttpMethod {
        GET,
        DELETE,
        POST,
        PUT;

    }

    private static interface ResponseHandler {
        public ServerResponse handleOkResponse(HttpResponse var1);
    }

    private static class ServerResponse {
        private final int httpCode;
        private final String jsonReplyOrErrorMessage;
        private final String location;
        private final boolean noData;

        public ServerResponse(int httpCode, boolean noData, String jsonReplyOrErrorMessage, String location) {
            this.httpCode = httpCode;
            this.jsonReplyOrErrorMessage = jsonReplyOrErrorMessage;
            this.noData = noData;
            this.location = location;
        }

        public int getHttpCode() {
            return this.httpCode;
        }

        public boolean is404() {
            return this.httpCode == 404;
        }

        public boolean isOk() {
            return this.httpCode >= 200 && this.httpCode < 300;
        }

        public boolean isCreated() {
            return this.httpCode == 201;
        }

        public String getLocation() {
            return this.location;
        }

        public boolean hasData() {
            return !this.noData;
        }

        public boolean hasNoData() {
            return this.noData;
        }

        public String getJsonReply() {
            return this.jsonReplyOrErrorMessage;
        }

        public void throwIfData() throws FedmonWebApiClient.FedmonWebApiClientException {
            if (this.hasData()) {
                throw new FedmonWebApiClient.FedmonWebApiClientException("HTTP request unexpectedly returned data");
            }
        }

        public void throwIfNoData() throws FedmonWebApiClient.FedmonWebApiClientException {
            if (this.hasNoData()) {
                throw new FedmonWebApiClient.FedmonWebApiClientException("HTTP request unexpectedly returned no data. code=" + this.httpCode + (String)(this.jsonReplyOrErrorMessage == null ? "" : " msg=" + this.jsonReplyOrErrorMessage));
            }
        }

        public void throwIf404() throws FedmonWebApiClient.FedmonWebApiClientException {
            if (this.is404()) {
                throw new FedmonWebApiClient.FedmonWebApiClientException("HTTP request returned unexpected 404 (" + this.httpCode + ") code=" + this.httpCode + (String)(this.jsonReplyOrErrorMessage == null ? "" : " msg=" + this.jsonReplyOrErrorMessage));
            }
        }

        public void throwIfNotOk() throws FedmonWebApiClient.FedmonWebApiClientException {
            if (!this.isOk()) {
                throw new FedmonWebApiClient.FedmonWebApiClientException("HTTP request returned unexpected code. code=" + this.httpCode + (String)(this.jsonReplyOrErrorMessage != null ? " message=" + this.jsonReplyOrErrorMessage : ""));
            }
        }

        public void throwIfNotOkOr404() throws FedmonWebApiClient.FedmonWebApiClientException {
            if (!this.is404() && !this.isOk()) {
                throw new FedmonWebApiClient.FedmonWebApiClientException("HTTP request returned unexpected code.  code=" + this.httpCode + (String)(this.jsonReplyOrErrorMessage == null ? "" : " msg=" + this.jsonReplyOrErrorMessage));
            }
        }
    }

    private static class BinaryResponseHandler
    implements ResponseHandler {
        private byte[] data = null;

        private BinaryResponseHandler() {
        }

        @Override
        public ServerResponse handleOkResponse(HttpResponse response) {
            assert (response != null);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                try (InputStream replyContent = entity.getContent();){
                    this.data = ByteStreams.toByteArray((InputStream)replyContent);
                }
                catch (IOException e) {
                    this.data = null;
                    LOG.error("Error reading server response", (Throwable)e);
                }
            } else {
                LOG.debug("No response entity -> no data");
                this.data = null;
            }
            Header locationHeader = response.getFirstHeader("Location");
            return new ServerResponse(response.getStatusLine().getStatusCode(), this.data == null || this.data.length == 0, null, locationHeader == null ? null : locationHeader.getValue());
        }

        public byte[] getData() {
            return this.data;
        }
    }

    public static class FedmonReply<T>
    implements ApiCallReply<T> {
        private T value;
        private HttpCallDetails httpCallDetails;
        private int httpCode;
        private String httpCodeDescription;

        public FedmonReply(HttpCallDetails httpCallDetails, T value) {
            this.httpCallDetails = httpCallDetails;
            this.httpCode = httpCallDetails.getResultHttpStatusCode();
            this.httpCodeDescription = httpCallDetails.getResultHttpStatusLine();
            this.value = value;
        }

        @Nonnull
        public GeniResponseCode getGeniResponseCode() {
            return new GeniResponseCode(){

                public boolean isSuccess() {
                    return httpCode >= 200 && httpCode < 300;
                }

                public boolean isBusy() {
                    return httpCode == 503;
                }

                public int getCode() {
                    return httpCode;
                }

                public String getDescription() {
                    return httpCodeDescription;
                }
            };
        }

        public T getValue() {
            return this.value;
        }

        public String getOutput() {
            return null;
        }

        public Object getRawResult() {
            return null;
        }

        public HttpCallDetails getHttpCallDetails() {
            return this.httpCallDetails;
        }

        public String toString() {
            return "RestReply{value=" + this.value + ", httpCallDetails=" + this.httpCallDetails + ", httpCode=" + this.httpCode + ", httpCodeDescription='" + this.httpCodeDescription + "'}";
        }
    }
}

