/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.client;

import be.iminds.ilabt.jfed.lowlevel.connection.ConnectionConfig;
import be.iminds.ilabt.jfed.lowlevel.connection.HttpCallDetails;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableHttpCallDetails
implements HttpCallDetails {
    private static final Logger LOG = LoggerFactory.getLogger(MutableHttpCallDetails.class);
    private ConnectionConfig connectionConfig;
    private String serverUrl;
    private String requestHttpRequestLine;
    private String requestHttpHeaders;
    private String requestHttpContent;
    private StatusLine resultHttpStatusLine;
    private String resultHttpHeaders;
    private String resultHttpContent;
    private Date startTime;
    private Date stopTime;
    private Throwable exception;
    private JFedConnection connection;

    public void setConnectionConfig(ConnectionConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setRequestHttpRequestLine(String requestHttpRequestLine) {
        this.requestHttpRequestLine = requestHttpRequestLine;
    }

    public void setRequestHttpRequestLine(RequestLine requestLine) {
        this.setRequestHttpRequestLine(requestLine == null ? null : requestLine.toString());
    }

    public void setRequestHttpHeaders(String requestHttpHeaders) {
        this.requestHttpHeaders = requestHttpHeaders;
    }

    public void setRequestHttpContent(HttpEntity requestHttpEntity) {
        if (requestHttpEntity != null) {
            String requestHttpContentHelper;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                requestHttpEntity.writeTo((OutputStream)baos);
                baos.close();
                requestHttpContentHelper = baos.toString("UTF-8");
            }
            catch (IOException e) {
                LOG.warn("Error writing requestHttpEntity for logging.", (Throwable)e);
                requestHttpContentHelper = null;
            }
            this.requestHttpContent = requestHttpContentHelper;
        }
    }

    public void setRequestHttpContent(String requestHttpContent) {
        this.requestHttpContent = requestHttpContent;
    }

    public void setResultHttpStatusLine(StatusLine resultHttpStatusLine) {
        this.resultHttpStatusLine = resultHttpStatusLine;
    }

    public void setResultHttpHeaders(String resultHttpHeaders) {
        this.resultHttpHeaders = resultHttpHeaders;
    }

    public void setResultHttpContent(String resultHttpContent) {
        this.resultHttpContent = resultHttpContent;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setStopTime(Date stopTime) {
        this.stopTime = stopTime;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public void setConnection(JFedConnection connection) {
        this.connection = connection;
    }

    public ConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getRequestHttpRequestLine() {
        return this.requestHttpRequestLine;
    }

    public String getRequestHttpHeaders() {
        return this.requestHttpHeaders;
    }

    public String getRequestHttpContent() {
        return this.requestHttpContent;
    }

    public int getResultHttpStatusCode() {
        return this.resultHttpStatusLine == null ? -1 : this.resultHttpStatusLine.getStatusCode();
    }

    public String getResultHttpStatusReasonPhrase() {
        return this.resultHttpStatusLine == null ? null : this.resultHttpStatusLine.getReasonPhrase();
    }

    public String getResultHttpStatusLine() {
        return this.resultHttpStatusLine == null ? null : this.resultHttpStatusLine.toString();
    }

    public StatusLine getResultHttpStatusLineObject() {
        return this.resultHttpStatusLine;
    }

    public String getResultHttpHeaders() {
        return this.resultHttpHeaders;
    }

    public String getResultHttpContent() {
        return this.resultHttpContent;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getStopTime() {
        return this.stopTime;
    }

    public Throwable getException() {
        return this.exception;
    }

    public JFedConnection getLastConnection() {
        return this.connection;
    }

    public JFedConnection getConnection() {
        return this.connection;
    }

    public void setResultHttpContent(HttpEntity entity) {
        if (entity == null) {
            this.resultHttpContent = null;
        } else if (entity.getContentLength() > 1000000L) {
            this.setResultHttpContent("Result content is too long to log. Size is " + entity.getContentLength() + " bytes.");
        } else {
            try {
                this.setResultHttpContent(IOUtils.streamToString((InputStream)entity.getContent(), (String)"UTF-8"));
            }
            catch (Exception e) {
                LOG.error("Error logging result content", (Throwable)e);
                this.setResultHttpContent("Error logging result content of size " + entity.getContentLength() + " bytes. error=" + e.getMessage());
            }
        }
    }

    public void setResultHttpHeaders(Header[] allHeaders) {
        if (allHeaders == null) {
            this.resultHttpHeaders = null;
        } else {
            Object httpResponseHeaders = "";
            for (Header header : allHeaders) {
                httpResponseHeaders = (String)httpResponseHeaders + header + "\n";
            }
            httpResponseHeaders = (String)httpResponseHeaders + "\n";
            this.setResultHttpHeaders((String)httpResponseHeaders);
        }
    }

    public void setRequestHttpHeaders(Header[] allHeaders) {
        if (allHeaders == null) {
            this.requestHttpHeaders = null;
        } else {
            Object httpRequestHeaders = "";
            for (Header header : allHeaders) {
                httpRequestHeaders = (String)httpRequestHeaders + header + "\n";
            }
            httpRequestHeaders = (String)httpRequestHeaders + "\n";
            this.setRequestHttpHeaders((String)httpRequestHeaders);
        }
    }
}

